/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.services.iam.;
import software.amazon.awscdk.services.kms.;
import software.amazon.awscdk.services.lambda.;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.ses.;
import software.amazon.awscdk.services.sns.;
import software.amazon.jsii.JsiiModule;
import software.constructs.;

public final class $Module
extends JsiiModule {
    private static final Map<String, String> MODULE_TYPES = $Module.load();
    private final Map<String, Class<?>> cache = new HashMap();

    private static Map<String, String> load() {
        HashMap<String, String> result = new HashMap<String, String>();
        ClassLoader cl = $Module.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream("software/amazon/awscdk/services/ses/actions/$Module.txt");
             InputStreamReader rd = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(rd);){
            br.lines().filter(line -> !line.trim().isEmpty()).forEach(line -> {
                String[] parts = line.split("=", 2);
                String fqn = parts[0];
                String className = parts[1];
                result.put(fqn, className);
            });
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        return result;
    }

    public $Module() {
        super("@aws-cdk/aws-ses-actions", "1.178.0", $Module.class, "aws-ses-actions@1.178.0.jsii.tgz");
    }

    public List<Class<? extends JsiiModule>> getDependencies() {
        return Arrays.asList(.Module.class, .Module.class, .Module.class, .Module.class, .Module.class, .Module.class, .Module.class, .Module.class);
    }

    protected Class<?> resolveClass(String fqn) throws ClassNotFoundException {
        if (!MODULE_TYPES.containsKey(fqn)) {
            throw new ClassNotFoundException("Unknown JSII type: " + fqn);
        }
        String className = MODULE_TYPES.get(fqn);
        if (!this.cache.containsKey(className)) {
            this.cache.put(className, this.findClass(className));
        }
        return this.cache.get(className);
    }

    private Class<?> findClass(String binaryName) {
        try {
            return Class.forName(binaryName);
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }
}

