package software.amazon.awscdk.services.servicediscovery;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.801Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicediscovery.$Module.class, fqn = "@aws-cdk/aws-servicediscovery.ServiceProps")
@software.amazon.jsii.Jsii.Proxy(ServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.servicediscovery.DnsServiceProps {

    /**
     * The namespace that you want to use for DNS configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.INamespace getNamespace();

    /**
     * @return a {@link Builder} of {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceProps> {
        private software.amazon.awscdk.services.servicediscovery.INamespace namespace;
        private software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType;
        private software.amazon.awscdk.core.Duration dnsTtl;
        private java.lang.Boolean loadBalancer;
        private software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy;
        private software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck;
        private java.lang.String description;
        private software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck;
        private java.lang.String name;

        /**
         * Sets the value of {@link ServiceProps#getNamespace}
         * @param namespace The namespace that you want to use for DNS configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(software.amazon.awscdk.services.servicediscovery.INamespace namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getDnsRecordType}
         * @param dnsRecordType The DNS type of the record that you want AWS Cloud Map to create.
         *                      Supported record types
         *                      include A, AAAA, A and AAAA (A_AAAA), CNAME, and SRV.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsRecordType(software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType) {
            this.dnsRecordType = dnsRecordType;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getDnsTtl}
         * @param dnsTtl The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsTtl(software.amazon.awscdk.core.Duration dnsTtl) {
            this.dnsTtl = dnsTtl;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getLoadBalancer}
         * @param loadBalancer Whether or not this service will have an Elastic LoadBalancer registered to it as an AliasTargetInstance.
         *                     Setting this to <code>true</code> correctly configures the <code>routingPolicy</code>
         *                     and performs some additional validation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(java.lang.Boolean loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getRoutingPolicy}
         * @param routingPolicy The routing policy that you want to apply to all DNS records that AWS Cloud Map creates when you register an instance and specify this service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingPolicy(software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy) {
            this.routingPolicy = routingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getCustomHealthCheck}
         * @param customHealthCheck Structure containing failure threshold for a custom health checker.
         *                          Only one of healthCheckConfig or healthCheckCustomConfig can be specified.
         *                          See: https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHealthCheck(software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck) {
            this.customHealthCheck = customHealthCheck;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getDescription}
         * @param description A description of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getHealthCheck}
         * @param healthCheck Settings for an optional health check.
         *                    If you specify health check settings, AWS Cloud Map associates the health
         *                    check with the records that you specify in DnsConfig. Only one of healthCheckConfig or healthCheckCustomConfig can
         *                    be specified. Not valid for PrivateDnsNamespaces. If you use healthCheck, you can only register IP instances to
         *                    this service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getName}
         * @param name A name for the Service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceProps build() {
            return new Jsii$Proxy(namespace, dnsRecordType, dnsTtl, loadBalancer, routingPolicy, customHealthCheck, description, healthCheck, name);
        }
    }

    /**
     * An implementation for {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceProps {
        private final software.amazon.awscdk.services.servicediscovery.INamespace namespace;
        private final software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType;
        private final software.amazon.awscdk.core.Duration dnsTtl;
        private final java.lang.Boolean loadBalancer;
        private final software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy;
        private final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.namespace = this.jsiiGet("namespace", software.amazon.awscdk.services.servicediscovery.INamespace.class);
            this.dnsRecordType = this.jsiiGet("dnsRecordType", software.amazon.awscdk.services.servicediscovery.DnsRecordType.class);
            this.dnsTtl = this.jsiiGet("dnsTtl", software.amazon.awscdk.core.Duration.class);
            this.loadBalancer = this.jsiiGet("loadBalancer", java.lang.Boolean.class);
            this.routingPolicy = this.jsiiGet("routingPolicy", software.amazon.awscdk.services.servicediscovery.RoutingPolicy.class);
            this.customHealthCheck = this.jsiiGet("customHealthCheck", software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.healthCheck = this.jsiiGet("healthCheck", software.amazon.awscdk.services.servicediscovery.HealthCheckConfig.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.servicediscovery.INamespace namespace, final software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType, final software.amazon.awscdk.core.Duration dnsTtl, final java.lang.Boolean loadBalancer, final software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy, final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck, final java.lang.String description, final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck, final java.lang.String name) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.namespace = java.util.Objects.requireNonNull(namespace, "namespace is required");
            this.dnsRecordType = dnsRecordType;
            this.dnsTtl = dnsTtl;
            this.loadBalancer = loadBalancer;
            this.routingPolicy = routingPolicy;
            this.customHealthCheck = customHealthCheck;
            this.description = description;
            this.healthCheck = healthCheck;
            this.name = name;
        }

        @Override
        public software.amazon.awscdk.services.servicediscovery.INamespace getNamespace() {
            return this.namespace;
        }

        @Override
        public software.amazon.awscdk.services.servicediscovery.DnsRecordType getDnsRecordType() {
            return this.dnsRecordType;
        }

        @Override
        public software.amazon.awscdk.core.Duration getDnsTtl() {
            return this.dnsTtl;
        }

        @Override
        public java.lang.Boolean getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public software.amazon.awscdk.services.servicediscovery.RoutingPolicy getRoutingPolicy() {
            return this.routingPolicy;
        }

        @Override
        public software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig getCustomHealthCheck() {
            return this.customHealthCheck;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public software.amazon.awscdk.services.servicediscovery.HealthCheckConfig getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("namespace", om.valueToTree(this.getNamespace()));
            if (this.getDnsRecordType() != null) {
                data.set("dnsRecordType", om.valueToTree(this.getDnsRecordType()));
            }
            if (this.getDnsTtl() != null) {
                data.set("dnsTtl", om.valueToTree(this.getDnsTtl()));
            }
            if (this.getLoadBalancer() != null) {
                data.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
            }
            if (this.getRoutingPolicy() != null) {
                data.set("routingPolicy", om.valueToTree(this.getRoutingPolicy()));
            }
            if (this.getCustomHealthCheck() != null) {
                data.set("customHealthCheck", om.valueToTree(this.getCustomHealthCheck()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicediscovery.ServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceProps.Jsii$Proxy that = (ServiceProps.Jsii$Proxy) o;

            if (!namespace.equals(that.namespace)) return false;
            if (this.dnsRecordType != null ? !this.dnsRecordType.equals(that.dnsRecordType) : that.dnsRecordType != null) return false;
            if (this.dnsTtl != null ? !this.dnsTtl.equals(that.dnsTtl) : that.dnsTtl != null) return false;
            if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) return false;
            if (this.routingPolicy != null ? !this.routingPolicy.equals(that.routingPolicy) : that.routingPolicy != null) return false;
            if (this.customHealthCheck != null ? !this.customHealthCheck.equals(that.customHealthCheck) : that.customHealthCheck != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + (this.dnsRecordType != null ? this.dnsRecordType.hashCode() : 0);
            result = 31 * result + (this.dnsTtl != null ? this.dnsTtl.hashCode() : 0);
            result = 31 * result + (this.loadBalancer != null ? this.loadBalancer.hashCode() : 0);
            result = 31 * result + (this.routingPolicy != null ? this.routingPolicy.hashCode() : 0);
            result = 31 * result + (this.customHealthCheck != null ? this.customHealthCheck.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
