package software.amazon.awscdk.services.servicediscovery;

/**
 * Instance that is accessible using an IP address.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.798Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicediscovery.$Module.class, fqn = "@aws-cdk/aws-servicediscovery.IpInstance")
public class IpInstance extends software.amazon.awscdk.services.servicediscovery.InstanceBase {

    protected IpInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IpInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public IpInstance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IpInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The Id of the instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceId() {
        return this.jsiiGet("instanceId", java.lang.String.class);
    }

    /**
     * The Ipv4 address of the instance, or blank string if none available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIpv4() {
        return this.jsiiGet("ipv4", java.lang.String.class);
    }

    /**
     * The Ipv6 address of the instance, or blank string if none available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIpv6() {
        return this.jsiiGet("ipv6", java.lang.String.class);
    }

    /**
     * The exposed port of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPort() {
        return this.jsiiGet("port", java.lang.Number.class);
    }

    /**
     * The Cloudmap service to which the instance is registered.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService getService() {
        return this.jsiiGet("service", software.amazon.awscdk.services.servicediscovery.IService.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicediscovery.IpInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicediscovery.IpInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicediscovery.IpInstanceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicediscovery.IpInstanceProps.Builder();
        }

        /**
         * Custom attributes of the instance.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param customAttributes Custom attributes of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAttributes(final java.util.Map<java.lang.String, java.lang.String> customAttributes) {
            this.props.customAttributes(customAttributes);
            return this;
        }

        /**
         * The id of the instance resource.
         * <p>
         * Default: Automatically generated name
         * <p>
         * @return {@code this}
         * @param instanceId The id of the instance resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(final java.lang.String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        /**
         * If the service that you specify contains a template for an A record, the IPv4 address that you want AWS Cloud Map to use for the value of the A record.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param ipv4 If the service that you specify contains a template for an A record, the IPv4 address that you want AWS Cloud Map to use for the value of the A record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4(final java.lang.String ipv4) {
            this.props.ipv4(ipv4);
            return this;
        }

        /**
         * If the service that you specify contains a template for an AAAA record, the IPv6 address that you want AWS Cloud Map to use for the value of the AAAA record.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param ipv6 If the service that you specify contains a template for an AAAA record, the IPv6 address that you want AWS Cloud Map to use for the value of the AAAA record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6(final java.lang.String ipv6) {
            this.props.ipv6(ipv6);
            return this;
        }

        /**
         * The port on the endpoint that you want AWS Cloud Map to perform health checks on.
         * <p>
         * This value is also used for
         * the port value in an SRV record if the service that you specify includes an SRV record. You can also specify a
         * default port that is applied to all instances in the Service configuration.
         * <p>
         * Default: 80
         * <p>
         * @return {@code this}
         * @param port The port on the endpoint that you want AWS Cloud Map to perform health checks on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * The Cloudmap service this resource is registered to.
         * <p>
         * @return {@code this}
         * @param service The Cloudmap service this resource is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final software.amazon.awscdk.services.servicediscovery.IService service) {
            this.props.service(service);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicediscovery.IpInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicediscovery.IpInstance build() {
            return new software.amazon.awscdk.services.servicediscovery.IpInstance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
