package software.amazon.awscdk.services.servicediscovery;

/**
 * Properties for defining a `AWS::ServiceDiscovery::Instance`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.788Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicediscovery.$Module.class, fqn = "@aws-cdk/aws-servicediscovery.CfnInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ServiceDiscovery::Instance.InstanceAttributes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceattributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInstanceAttributes();

    /**
     * `AWS::ServiceDiscovery::Instance.ServiceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-serviceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceId();

    /**
     * `AWS::ServiceDiscovery::Instance.InstanceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-instance.html#cfn-servicediscovery-instance-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceProps> {
        private java.lang.Object instanceAttributes;
        private java.lang.String serviceId;
        private java.lang.String instanceId;

        /**
         * Sets the value of {@link CfnInstanceProps#getInstanceAttributes}
         * @param instanceAttributes `AWS::ServiceDiscovery::Instance.InstanceAttributes`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceAttributes(java.lang.Object instanceAttributes) {
            this.instanceAttributes = instanceAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getServiceId}
         * @param serviceId `AWS::ServiceDiscovery::Instance.ServiceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceId(java.lang.String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getInstanceId}
         * @param instanceId `AWS::ServiceDiscovery::Instance.InstanceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceProps build() {
            return new Jsii$Proxy(instanceAttributes, serviceId, instanceId);
        }
    }

    /**
     * An implementation for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceProps {
        private final java.lang.Object instanceAttributes;
        private final java.lang.String serviceId;
        private final java.lang.String instanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceAttributes = this.jsiiGet("instanceAttributes", java.lang.Object.class);
            this.serviceId = this.jsiiGet("serviceId", java.lang.String.class);
            this.instanceId = this.jsiiGet("instanceId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Object instanceAttributes, final java.lang.String serviceId, final java.lang.String instanceId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceAttributes = java.util.Objects.requireNonNull(instanceAttributes, "instanceAttributes is required");
            this.serviceId = java.util.Objects.requireNonNull(serviceId, "serviceId is required");
            this.instanceId = instanceId;
        }

        @Override
        public java.lang.Object getInstanceAttributes() {
            return this.instanceAttributes;
        }

        @Override
        public java.lang.String getServiceId() {
            return this.serviceId;
        }

        @Override
        public java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceAttributes", om.valueToTree(this.getInstanceAttributes()));
            data.set("serviceId", om.valueToTree(this.getServiceId()));
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicediscovery.CfnInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceProps.Jsii$Proxy that = (CfnInstanceProps.Jsii$Proxy) o;

            if (!instanceAttributes.equals(that.instanceAttributes)) return false;
            if (!serviceId.equals(that.serviceId)) return false;
            return this.instanceId != null ? this.instanceId.equals(that.instanceId) : that.instanceId == null;
        }

        @Override
        public int hashCode() {
            int result = this.instanceAttributes.hashCode();
            result = 31 * result + (this.serviceId.hashCode());
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            return result;
        }
    }
}
