package software.amazon.awscdk.services.servicediscovery;

/**
 * Basic props needed to create a service in a given namespace.
 * <p>
 * Used by HttpNamespace.createService
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.787Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicediscovery.$Module.class, fqn = "@aws-cdk/aws-servicediscovery.BaseServiceProps")
@software.amazon.jsii.Jsii.Proxy(BaseServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseServiceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Structure containing failure threshold for a custom health checker.
     * <p>
     * Only one of healthCheckConfig or healthCheckCustomConfig can be specified.
     * See: https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig getCustomHealthCheck() {
        return null;
    }

    /**
     * A description of the service.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Settings for an optional health check.
     * <p>
     * If you specify health check settings, AWS Cloud Map associates the health
     * check with the records that you specify in DnsConfig. Only one of healthCheckConfig or healthCheckCustomConfig can
     * be specified. Not valid for PrivateDnsNamespaces. If you use healthCheck, you can only register IP instances to
     * this service.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.HealthCheckConfig getHealthCheck() {
        return null;
    }

    /**
     * A name for the Service.
     * <p>
     * Default: CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseServiceProps> {
        private software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck;
        private java.lang.String description;
        private software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck;
        private java.lang.String name;

        /**
         * Sets the value of {@link BaseServiceProps#getCustomHealthCheck}
         * @param customHealthCheck Structure containing failure threshold for a custom health checker.
         *                          Only one of healthCheckConfig or healthCheckCustomConfig can be specified.
         *                          See: https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHealthCheck(software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck) {
            this.customHealthCheck = customHealthCheck;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceProps#getDescription}
         * @param description A description of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceProps#getHealthCheck}
         * @param healthCheck Settings for an optional health check.
         *                    If you specify health check settings, AWS Cloud Map associates the health
         *                    check with the records that you specify in DnsConfig. Only one of healthCheckConfig or healthCheckCustomConfig can
         *                    be specified. Not valid for PrivateDnsNamespaces. If you use healthCheck, you can only register IP instances to
         *                    this service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceProps#getName}
         * @param name A name for the Service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseServiceProps build() {
            return new Jsii$Proxy(customHealthCheck, description, healthCheck, name);
        }
    }

    /**
     * An implementation for {@link BaseServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseServiceProps {
        private final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customHealthCheck = this.jsiiGet("customHealthCheck", software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.healthCheck = this.jsiiGet("healthCheck", software.amazon.awscdk.services.servicediscovery.HealthCheckConfig.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck, final java.lang.String description, final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck, final java.lang.String name) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customHealthCheck = customHealthCheck;
            this.description = description;
            this.healthCheck = healthCheck;
            this.name = name;
        }

        @Override
        public software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig getCustomHealthCheck() {
            return this.customHealthCheck;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public software.amazon.awscdk.services.servicediscovery.HealthCheckConfig getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCustomHealthCheck() != null) {
                data.set("customHealthCheck", om.valueToTree(this.getCustomHealthCheck()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicediscovery.BaseServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseServiceProps.Jsii$Proxy that = (BaseServiceProps.Jsii$Proxy) o;

            if (this.customHealthCheck != null ? !this.customHealthCheck.equals(that.customHealthCheck) : that.customHealthCheck != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public int hashCode() {
            int result = this.customHealthCheck != null ? this.customHealthCheck.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
