/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.servicediscovery;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2;
import software.amazon.awscdk.services.servicediscovery.;
import software.amazon.awscdk.services.servicediscovery.CnameInstanceBaseProps;
import software.amazon.awscdk.services.servicediscovery.DnsRecordType;
import software.amazon.awscdk.services.servicediscovery.HealthCheckConfig;
import software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig;
import software.amazon.awscdk.services.servicediscovery.IInstance;
import software.amazon.awscdk.services.servicediscovery.INamespace;
import software.amazon.awscdk.services.servicediscovery.IService;
import software.amazon.awscdk.services.servicediscovery.IpInstanceBaseProps;
import software.amazon.awscdk.services.servicediscovery.NonIpInstanceBaseProps;
import software.amazon.awscdk.services.servicediscovery.RoutingPolicy;
import software.amazon.awscdk.services.servicediscovery.ServiceAttributes;
import software.amazon.awscdk.services.servicediscovery.ServiceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-servicediscovery.Service")
public class Service
extends Resource
implements IService {
    protected Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Service(@NotNull Construct scope, @NotNull String id, @NotNull ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IService fromServiceAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ServiceAttributes attrs) {
        return (IService)JsiiObject.jsiiStaticCall(Service.class, (String)"fromServiceAttributes", IService.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public IInstance registerCnameInstance(@NotNull String id, @NotNull CnameInstanceBaseProps props) {
        return (IInstance)this.jsiiCall("registerCnameInstance", IInstance.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IInstance registerIpInstance(@NotNull String id, @NotNull IpInstanceBaseProps props) {
        return (IInstance)this.jsiiCall("registerIpInstance", IInstance.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IInstance registerLoadBalancer(@NotNull String id, @NotNull ILoadBalancerV2 loadBalancer, @Nullable Map<String, String> customAttributes) {
        return (IInstance)this.jsiiCall("registerLoadBalancer", IInstance.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(loadBalancer, "loadBalancer is required"), customAttributes});
    }

    @NotNull
    public IInstance registerLoadBalancer(@NotNull String id, @NotNull ILoadBalancerV2 loadBalancer) {
        return (IInstance)this.jsiiCall("registerLoadBalancer", IInstance.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(loadBalancer, "loadBalancer is required")});
    }

    @NotNull
    public IInstance registerNonIpInstance(@NotNull String id, @NotNull NonIpInstanceBaseProps props) {
        return (IInstance)this.jsiiCall("registerNonIpInstance", IInstance.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public DnsRecordType getDnsRecordType() {
        return (DnsRecordType)((Object)this.jsiiGet("dnsRecordType", DnsRecordType.class));
    }

    @Override
    @NotNull
    public INamespace getNamespace() {
        return (INamespace)this.jsiiGet("namespace", INamespace.class);
    }

    @Override
    @NotNull
    public RoutingPolicy getRoutingPolicy() {
        return (RoutingPolicy)((Object)this.jsiiGet("routingPolicy", RoutingPolicy.class));
    }

    @Override
    @NotNull
    public String getServiceArn() {
        return (String)this.jsiiGet("serviceArn", String.class);
    }

    @Override
    @NotNull
    public String getServiceId() {
        return (String)this.jsiiGet("serviceId", String.class);
    }

    @Override
    @NotNull
    public String getServiceName() {
        return (String)this.jsiiGet("serviceName", String.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ServiceProps.Builder();
        }

        public Builder customHealthCheck(HealthCheckCustomConfig customHealthCheck) {
            this.props.customHealthCheck(customHealthCheck);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder healthCheck(HealthCheckConfig healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder dnsRecordType(DnsRecordType dnsRecordType) {
            this.props.dnsRecordType(dnsRecordType);
            return this;
        }

        public Builder dnsTtl(Duration dnsTtl) {
            this.props.dnsTtl(dnsTtl);
            return this;
        }

        public Builder loadBalancer(Boolean loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        public Builder routingPolicy(RoutingPolicy routingPolicy) {
            this.props.routingPolicy(routingPolicy);
            return this;
        }

        public Builder namespace(INamespace namespace) {
            this.props.namespace(namespace);
            return this;
        }

        public Service build() {
            return new Service(this.scope, this.id, this.props.build());
        }
    }
}

