/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.servicediscovery;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.servicediscovery.BaseServiceProps;
import software.amazon.awscdk.services.servicediscovery.DnsRecordType;
import software.amazon.awscdk.services.servicediscovery.HealthCheckConfig;
import software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig;
import software.amazon.awscdk.services.servicediscovery.RoutingPolicy;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface DnsServiceProps
extends JsiiSerializable,
BaseServiceProps {
    public DnsRecordType getDnsRecordType();

    public Number getDnsTtlSec();

    public Boolean getLoadBalancer();

    public RoutingPolicy getRoutingPolicy();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private DnsRecordType _dnsRecordType;
        @Nullable
        private Number _dnsTtlSec;
        @Nullable
        private Boolean _loadBalancer;
        @Nullable
        private RoutingPolicy _routingPolicy;
        @Nullable
        private HealthCheckCustomConfig _customHealthCheck;
        @Nullable
        private String _description;
        @Nullable
        private HealthCheckConfig _healthCheck;
        @Nullable
        private String _name;

        public Builder withDnsRecordType(@Nullable DnsRecordType value) {
            this._dnsRecordType = value;
            return this;
        }

        public Builder withDnsTtlSec(@Nullable Number value) {
            this._dnsTtlSec = value;
            return this;
        }

        public Builder withLoadBalancer(@Nullable Boolean value) {
            this._loadBalancer = value;
            return this;
        }

        public Builder withRoutingPolicy(@Nullable RoutingPolicy value) {
            this._routingPolicy = value;
            return this;
        }

        public Builder withCustomHealthCheck(@Nullable HealthCheckCustomConfig value) {
            this._customHealthCheck = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheckConfig value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public DnsServiceProps build() {
            return new DnsServiceProps(){
                @Nullable
                private final DnsRecordType $dnsRecordType;
                @Nullable
                private final Number $dnsTtlSec;
                @Nullable
                private final Boolean $loadBalancer;
                @Nullable
                private final RoutingPolicy $routingPolicy;
                @Nullable
                private final HealthCheckCustomConfig $customHealthCheck;
                @Nullable
                private final String $description;
                @Nullable
                private final HealthCheckConfig $healthCheck;
                @Nullable
                private final String $name;
                {
                    this.$dnsRecordType = _dnsRecordType;
                    this.$dnsTtlSec = _dnsTtlSec;
                    this.$loadBalancer = _loadBalancer;
                    this.$routingPolicy = _routingPolicy;
                    this.$customHealthCheck = _customHealthCheck;
                    this.$description = _description;
                    this.$healthCheck = _healthCheck;
                    this.$name = _name;
                }

                @Override
                public DnsRecordType getDnsRecordType() {
                    return this.$dnsRecordType;
                }

                @Override
                public Number getDnsTtlSec() {
                    return this.$dnsTtlSec;
                }

                @Override
                public Boolean getLoadBalancer() {
                    return this.$loadBalancer;
                }

                @Override
                public RoutingPolicy getRoutingPolicy() {
                    return this.$routingPolicy;
                }

                @Override
                public HealthCheckCustomConfig getCustomHealthCheck() {
                    return this.$customHealthCheck;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public HealthCheckConfig getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getDnsRecordType() != null) {
                        obj.set("dnsRecordType", om.valueToTree((Object)this.getDnsRecordType()));
                    }
                    if (this.getDnsTtlSec() != null) {
                        obj.set("dnsTtlSec", om.valueToTree((Object)this.getDnsTtlSec()));
                    }
                    if (this.getLoadBalancer() != null) {
                        obj.set("loadBalancer", om.valueToTree((Object)this.getLoadBalancer()));
                    }
                    if (this.getRoutingPolicy() != null) {
                        obj.set("routingPolicy", om.valueToTree((Object)this.getRoutingPolicy()));
                    }
                    if (this.getCustomHealthCheck() != null) {
                        obj.set("customHealthCheck", om.valueToTree((Object)this.getCustomHealthCheck()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getHealthCheck() != null) {
                        obj.set("healthCheck", om.valueToTree((Object)this.getHealthCheck()));
                    }
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree((Object)this.getName()));
                    }
                    return obj;
                }
            };
        }
    }
}

