/**
 * <h2>AWS Secrets Manager Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.secretsmanager.*;
 * </pre></blockquote>
 * <p>
 * <h3>Create a new Secret in a Stack</h3>
 * <p>
 * In order to have SecretsManager generate a new secret value automatically,
 * you can get started with the following:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * // Default secret
 * Secret secret = new Secret(this, "Secret");
 * secret.grantRead(role);
 * 
 * new User(this, "User", new UserProps()
 *         .password(secret.getSecretValue()));
 * 
 * // Templated secret
 * Secret templatedSecret = new Secret(this, "TemplatedSecret", new SecretProps()
 *         .generateSecretString(new SecretStringGenerator()
 *                 .secretStringTemplate(JSON.stringify(Map.of("username", "user")))
 *                 .generateStringKey("password")));
 * 
 * new User(this, "OtherUser", new UserProps()
 *         .userName(templatedSecret.secretValueFromJson('username').toString())
 *         .password(templatedSecret.secretValueFromJson("password")));
 * </pre></blockquote>
 * <p>
 * The <code>Secret</code> construct does not allow specifying the <code>SecretString</code> property
 * of the <code>AWS::SecretsManager::Secret</code> resource (as this will almost always
 * lead to the secret being surfaced in plain text and possibly committed to
 * your source control).
 * <p>
 * If you need to use a pre-existing secret, the recommended way is to manually
 * provision the secret in <em>AWS SecretsManager</em> and use the <code>Secret.fromSecretArn</code>
 * or <code>Secret.fromSecretAttributes</code> method to make it available in your CDK Application:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var secret = secretsmanager.Secret.fromSecretAttributes(scope, "ImportedSecret", Map.of(
 *         "secretArn", "arn:aws:secretsmanager:&lt;region&gt;:&lt;account-id-number&gt;:secret:&lt;secret-name&gt;-&lt;random-6-characters&gt;",
 *         // If the secret is encrypted using a KMS-hosted CMK, either import or reference that key:
 *         "encryptionKey", encryptionKey));
 * </pre></blockquote>
 * <p>
 * SecretsManager secret values can only be used in select set of properties. For the
 * list of properties, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html">the CloudFormation Dynamic References documentation</a>.
 * <p>
 * A secret can set <code>RemovalPolicy</code>. If it set to <code>RETAIN</code>, that removing a secret will fail.
 * <p>
 * <h3>Grant permission to use the secret to a role</h3>
 * <p>
 * You must grant permission to a resource for that resource to be allowed to
 * use a secret. This can be achieved with the <code>Secret.grantRead</code> and/or <code>Secret.grantUpdate</code>
 * method, depending on your need:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var role = Role.Builder.create(stack, "SomeRole").assumedBy(new AccountRootPrincipal()).build();
 * var secret = new Secret(stack, "Secret");
 * secret.grantRead(role);
 * secret.grantWrite(role);
 * </pre></blockquote>
 * <p>
 * If, as in the following example, your secret was created with a KMS key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var key = new Key(stack, "KMS");
 * var secret = Secret.Builder.create(stack, "Secret").encryptionKey(key).build();
 * secret.grantRead(role);
 * secret.grantWrite(role);
 * </pre></blockquote>
 * <p>
 * then <code>Secret.grantRead</code> and <code>Secret.grantWrite</code> will also grant the role the
 * relevant encrypt and decrypt permissions to the KMS key through the
 * SecretsManager service principal.
 * <p>
 * <h3>Rotating a Secret with a custom Lambda function</h3>
 * <p>
 * A rotation schedule can be added to a Secret using a custom Lambda function:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fn = new Function(...);
 * var secret = new Secret(this, "Secret");
 * 
 * secret.addRotationSchedule("RotationSchedule", Map.of(
 *         "rotationLambda", fn,
 *         "automaticallyAfter", Duration.days(15)));
 * </pre></blockquote>
 * <p>
 * See <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets-lambda-function-overview.html">Overview of the Lambda Rotation Function</a> on how to implement a Lambda Rotation Function.
 * <p>
 * <h3>Rotating database credentials</h3>
 * <p>
 * Define a <code>SecretRotation</code> to rotate database credentials:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * SecretRotation.Builder.create(this, "SecretRotation")
 *         .application(SecretRotationApplication.getMYSQL_ROTATION_SINGLE_USER())// MySQL single user scheme
 *         .secret(mySecret)
 *         .target(myDatabase)// a Connectable
 *         .vpc(myVpc)
 *         .build();
 * </pre></blockquote>
 * <p>
 * The secret must be a JSON string with the following format:
 * <p>
 * <blockquote><pre>
 * {
 *   "engine": "&lt;required: database engine&gt;",
 *   "host": "&lt;required: instance host name&gt;",
 *   "username": "&lt;required: username&gt;",
 *   "password": "&lt;required: password&gt;",
 *   "dbname": "&lt;optional: database name&gt;",
 *   "port": "&lt;optional: if not specified, default port will be used&gt;",
 *   "masterarn": "&lt;required for multi user rotation: the arn of the master secret which will be used to create users/change passwords&gt;"
 * }
 * </pre></blockquote>
 * <p>
 * For the multi user scheme, a <code>masterSecret</code> must be specified:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * SecretRotation.Builder.create(stack, "SecretRotation")
 *         .application(SecretRotationApplication.getMYSQL_ROTATION_MULTI_USER())
 *         .secret(myUserSecret)// The secret that will be rotated
 *         .masterSecret(myMasterSecret)// The secret used for the rotation
 *         .target(myDatabase)
 *         .vpc(myVpc)
 *         .build();
 * </pre></blockquote>
 * <p>
 * See also <a href="https://github.com/aws/aws-cdk/blob/master/packages/%40aws-cdk/aws-rds/README.md">aws-rds</a> where
 * credentials generation and rotation is integrated.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.secretsmanager;
