package software.amazon.awscdk.services.secretsmanager;

/**
 * Creates a new secret in AWS SecretsManager.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.437Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.secretsmanager.$Module.class, fqn = "@aws-cdk/aws-secretsmanager.Secret")
public class Secret extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.secretsmanager.ISecret {

    protected Secret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Secret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Secret(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.SecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Secret(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secretArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretArn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String secretArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretArn", software.amazon.awscdk.services.secretsmanager.ISecret.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secretArn, "secretArn is required") });
    }

    /**
     * Import an existing secret into the Stack.
     * <p>
     * @param scope the scope of the import. This parameter is required.
     * @param id the ID of the imported Secret in the construct tree. This parameter is required.
     * @param attrs the attributes of the imported secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretAttributes", software.amazon.awscdk.services.secretsmanager.ISecret.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds a rotation schedule to the secret.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationSchedule addRotationSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationScheduleOptions options) {
        return this.jsiiCall("addRotationSchedule", software.amazon.awscdk.services.secretsmanager.RotationSchedule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a target attachment to the secret.
     * <p>
     * @return an AttachedSecret
     * @deprecated use `attach()` instead
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment addTargetAttachment(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.AttachedSecretOptions options) {
        return this.jsiiCall("addTargetAttachment", software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a statement to the IAM resource policy associated with this secret.
     * <p>
     * If this secret was created in this stack, a resource policy will be
     * automatically created upon the first call to <code>addToResourcePolicy</code>. If
     * the secret is imported, then this is a no-op.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToResourcePolicy", software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Attach a target to this secret.
     * <p>
     * @return An attached secret
     * @param target The target to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret attach(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget target) {
        return this.jsiiCall("attach", software.amazon.awscdk.services.secretsmanager.ISecret.class, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Denies the `DeleteSecret` action to all principals within the current account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void denyAccountRootDelete() {
        this.jsiiCall("denyAccountRootDelete", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Grants reading the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     * @param versionStages
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> versionStages) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), versionStages });
    }

    /**
     * Grants reading the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants writing and updating the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Interpret the secret as a JSON object and return a field's value from it as a `SecretValue`.
     * <p>
     * @param jsonField This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue secretValueFromJson(final @org.jetbrains.annotations.NotNull java.lang.String jsonField) {
        return this.jsiiCall("secretValueFromJson", software.amazon.awscdk.core.SecretValue.class, new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required") });
    }

    /**
     * Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getAutoCreatePolicy() {
        return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
    }

    /**
     * The ARN of the secret in AWS Secrets Manager.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretArn() {
        return this.jsiiGet("secretArn", java.lang.String.class);
    }

    /**
     * Retrieve the value of the stored secret as a `SecretValue`.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue getSecretValue() {
        return this.jsiiGet("secretValue", software.amazon.awscdk.core.SecretValue.class);
    }

    /**
     * The customer-managed encryption key that is used to encrypt this secret, if any.
     * <p>
     * When not specified, the default
     * KMS key for the account and region is being used.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.Secret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.Secret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.secretsmanager.SecretProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An optional, human-friendly description of the secret.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description An optional, human-friendly description of the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The customer-managed encryption key to use for encrypting the secret value.
         * <p>
         * Default: - A default KMS key for the account and region is used.
         * <p>
         * @return {@code this}
         * @param encryptionKey The customer-managed encryption key to use for encrypting the secret value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Configuration for how to generate a secret value.
         * <p>
         * Default: - 32 characters with upper-case letters, lower-case letters, punctuation and numbers (at least one from each
         * category), per the default values of ``SecretStringGenerator``.
         * <p>
         * @return {@code this}
         * @param generateSecretString Configuration for how to generate a secret value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecretString(final software.amazon.awscdk.services.secretsmanager.SecretStringGenerator generateSecretString) {
            this.props().generateSecretString(generateSecretString);
            return this;
        }

        /**
         * Policy to apply when the secret is removed from this stack.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the secret is removed from this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * A name for the secret.
         * <p>
         * Note that deleting secrets from SecretsManager does not happen immediately, but after a 7 to
         * 30 days blackout period. During that period, it is not possible to create another secret that shares the same name.
         * <p>
         * Default: - A name is generated by CloudFormation.
         * <p>
         * @return {@code this}
         * @param secretName A name for the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretName(final java.lang.String secretName) {
            this.props().secretName(secretName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.Secret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.Secret build() {
            return new software.amazon.awscdk.services.secretsmanager.Secret(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.secretsmanager.SecretProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.secretsmanager.SecretProps.Builder();
            }
            return this.props;
        }
    }
}
