package software.amazon.awscdk.services.secretsmanager;

/**
 * Options to add a rotation schedule to a secret.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.437Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.secretsmanager.$Module.class, fqn = "@aws-cdk/aws-secretsmanager.RotationScheduleOptions")
@software.amazon.jsii.Jsii.Proxy(RotationScheduleOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RotationScheduleOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Lambda function that can rotate the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getRotationLambda();

    /**
     * Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     * <p>
     * Default: Duration.days(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getAutomaticallyAfter() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RotationScheduleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RotationScheduleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RotationScheduleOptions> {
        private software.amazon.awscdk.services.lambda.IFunction rotationLambda;
        private software.amazon.awscdk.core.Duration automaticallyAfter;

        /**
         * Sets the value of {@link RotationScheduleOptions#getRotationLambda}
         * @param rotationLambda The Lambda function that can rotate the secret. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambda(software.amazon.awscdk.services.lambda.IFunction rotationLambda) {
            this.rotationLambda = rotationLambda;
            return this;
        }

        /**
         * Sets the value of {@link RotationScheduleOptions#getAutomaticallyAfter}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(software.amazon.awscdk.core.Duration automaticallyAfter) {
            this.automaticallyAfter = automaticallyAfter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RotationScheduleOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RotationScheduleOptions build() {
            return new Jsii$Proxy(rotationLambda, automaticallyAfter);
        }
    }

    /**
     * An implementation for {@link RotationScheduleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RotationScheduleOptions {
        private final software.amazon.awscdk.services.lambda.IFunction rotationLambda;
        private final software.amazon.awscdk.core.Duration automaticallyAfter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.rotationLambda = this.jsiiGet("rotationLambda", software.amazon.awscdk.services.lambda.IFunction.class);
            this.automaticallyAfter = this.jsiiGet("automaticallyAfter", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.lambda.IFunction rotationLambda, final software.amazon.awscdk.core.Duration automaticallyAfter) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.rotationLambda = java.util.Objects.requireNonNull(rotationLambda, "rotationLambda is required");
            this.automaticallyAfter = automaticallyAfter;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getRotationLambda() {
            return this.rotationLambda;
        }

        @Override
        public software.amazon.awscdk.core.Duration getAutomaticallyAfter() {
            return this.automaticallyAfter;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("rotationLambda", om.valueToTree(this.getRotationLambda()));
            if (this.getAutomaticallyAfter() != null) {
                data.set("automaticallyAfter", om.valueToTree(this.getAutomaticallyAfter()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-secretsmanager.RotationScheduleOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RotationScheduleOptions.Jsii$Proxy that = (RotationScheduleOptions.Jsii$Proxy) o;

            if (!rotationLambda.equals(that.rotationLambda)) return false;
            return this.automaticallyAfter != null ? this.automaticallyAfter.equals(that.automaticallyAfter) : that.automaticallyAfter == null;
        }

        @Override
        public int hashCode() {
            int result = this.rotationLambda.hashCode();
            result = 31 * result + (this.automaticallyAfter != null ? this.automaticallyAfter.hashCode() : 0);
            return result;
        }
    }
}
