package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sam.*;
 * Object definition;
 * CfnStateMachine cfnStateMachine = CfnStateMachine.Builder.create(this, "MyCfnStateMachine")
 *         .definition(definition)
 *         .definitionSubstitutions(Map.of(
 *                 "definitionSubstitutionsKey", "definitionSubstitutions"))
 *         .definitionUri("definitionUri")
 *         .events(Map.of(
 *                 "eventsKey", EventSourceProperty.builder()
 *                         .properties(CloudWatchEventEventProperty.builder()
 *                                 .method("method")
 *                                 .path("path")
 *                                 // the properties below are optional
 *                                 .restApiId("restApiId")
 *                                 .build())
 *                         .type("type")
 *                         .build()))
 *         .logging(LoggingConfigurationProperty.builder()
 *                 .destinations(List.of(LogDestinationProperty.builder()
 *                         .cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty.builder()
 *                                 .logGroupArn("logGroupArn")
 *                                 .build())
 *                         .build()))
 *                 .includeExecutionData(false)
 *                 .level("level")
 *                 .build())
 *         .name("name")
 *         .permissionsBoundaries("permissionsBoundaries")
 *         .policies("policies")
 *         .role("role")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .tracing(TracingConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:35.783Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine")
public class CfnStateMachine extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnStateMachine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStateMachine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnStateMachine.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnStateMachine.class, "REQUIRED_TRANSFORM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Serverless::StateMachine`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStateMachine(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnStateMachineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Serverless::StateMachine`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStateMachine(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The `Transform` a template must use in order to use this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REQUIRED_TRANSFORM;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Serverless::StateMachine.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * `AWS::Serverless::StateMachine.Definition`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefinition() {
        return software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::StateMachine.Definition`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * `AWS::Serverless::StateMachine.DefinitionSubstitutions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionSubstitutions() {
        return software.amazon.jsii.Kernel.get(this, "definitionSubstitutions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::StateMachine.DefinitionSubstitutions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionSubstitutions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definitionSubstitutions", value);
    }

    /**
     * `AWS::Serverless::StateMachine.DefinitionSubstitutions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionSubstitutions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "definitionSubstitutions", value);
    }

    /**
     * `AWS::Serverless::StateMachine.DefinitionUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionUri() {
        return software.amazon.jsii.Kernel.get(this, "definitionUri", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::StateMachine.DefinitionUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "definitionUri", value);
    }

    /**
     * `AWS::Serverless::StateMachine.DefinitionUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definitionUri", value);
    }

    /**
     * `AWS::Serverless::StateMachine.DefinitionUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnStateMachine.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "definitionUri", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Events`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
        return software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::StateMachine.Events`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "events", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Events`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvents(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sam.CfnStateMachine.EventSourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.sam.CfnStateMachine.EventSourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "events", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Logging`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
        return software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::StateMachine.Logging`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logging", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Logging`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnStateMachine.LoggingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "logging", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::StateMachine.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * `AWS::Serverless::StateMachine.PermissionsBoundaries`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPermissionsBoundaries() {
        return software.amazon.jsii.Kernel.get(this, "permissionsBoundaries", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::StateMachine.PermissionsBoundaries`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionsBoundaries(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "permissionsBoundaries", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPolicies() {
        return software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::StateMachine.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnStateMachine.IAMPolicyDocumentProperty value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof java.lang.String)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sam.CfnStateMachine.IAMPolicyDocumentProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sam.CfnStateMachine.SAMPolicyTemplateProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: java.lang.String, software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.sam.CfnStateMachine.IAMPolicyDocumentProperty, software.amazon.awscdk.services.sam.CfnStateMachine.SAMPolicyTemplateProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Role`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::StateMachine.Role`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "role", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Tracing`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTracing() {
        return software.amazon.jsii.Kernel.get(this, "tracing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::StateMachine.Tracing`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTracing(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tracing", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Tracing`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTracing(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnStateMachine.TracingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "tracing", value);
    }

    /**
     * `AWS::Serverless::StateMachine.Type`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::StateMachine.Type`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * ApiEventProperty apiEventProperty = ApiEventProperty.builder()
     *         .method("method")
     *         .path("path")
     *         // the properties below are optional
     *         .restApiId("restApiId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.ApiEventProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.ApiEventProperty.Method`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMethod();

        /**
         * `CfnStateMachine.ApiEventProperty.Path`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * `CfnStateMachine.ApiEventProperty.RestApiId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRestApiId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiEventProperty> {
            java.lang.String method;
            java.lang.String path;
            java.lang.String restApiId;

            /**
             * Sets the value of {@link ApiEventProperty#getMethod}
             * @param method `CfnStateMachine.ApiEventProperty.Method`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.String method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getPath}
             * @param path `CfnStateMachine.ApiEventProperty.Path`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getRestApiId}
             * @param restApiId `CfnStateMachine.ApiEventProperty.RestApiId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restApiId(java.lang.String restApiId) {
                this.restApiId = restApiId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiEventProperty {
            private final java.lang.String method;
            private final java.lang.String path;
            private final java.lang.String restApiId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.method = java.util.Objects.requireNonNull(builder.method, "method is required");
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.restApiId = builder.restApiId;
            }

            @Override
            public final java.lang.String getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getRestApiId() {
                return this.restApiId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("method", om.valueToTree(this.getMethod()));
                data.set("path", om.valueToTree(this.getPath()));
                if (this.getRestApiId() != null) {
                    data.set("restApiId", om.valueToTree(this.getRestApiId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.ApiEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiEventProperty.Jsii$Proxy that = (ApiEventProperty.Jsii$Proxy) o;

                if (!method.equals(that.method)) return false;
                if (!path.equals(that.path)) return false;
                return this.restApiId != null ? this.restApiId.equals(that.restApiId) : that.restApiId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.method.hashCode();
                result = 31 * result + (this.path.hashCode());
                result = 31 * result + (this.restApiId != null ? this.restApiId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object pattern;
     * CloudWatchEventEventProperty cloudWatchEventEventProperty = CloudWatchEventEventProperty.builder()
     *         .pattern(pattern)
     *         // the properties below are optional
     *         .eventBusName("eventBusName")
     *         .input("input")
     *         .inputPath("inputPath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.CloudWatchEventEventProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchEventEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchEventEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.Pattern`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPattern();

        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.EventBusName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventBusName() {
            return null;
        }

        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.Input`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.InputPath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchEventEventProperty> {
            java.lang.Object pattern;
            java.lang.String eventBusName;
            java.lang.String input;
            java.lang.String inputPath;

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getPattern}
             * @param pattern `CfnStateMachine.CloudWatchEventEventProperty.Pattern`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.Object pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getEventBusName}
             * @param eventBusName `CfnStateMachine.CloudWatchEventEventProperty.EventBusName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBusName(java.lang.String eventBusName) {
                this.eventBusName = eventBusName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getInput}
             * @param input `CfnStateMachine.CloudWatchEventEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getInputPath}
             * @param inputPath `CfnStateMachine.CloudWatchEventEventProperty.InputPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPath(java.lang.String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchEventEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchEventEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchEventEventProperty {
            private final java.lang.Object pattern;
            private final java.lang.String eventBusName;
            private final java.lang.String input;
            private final java.lang.String inputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.eventBusName = builder.eventBusName;
                this.input = builder.input;
                this.inputPath = builder.inputPath;
            }

            @Override
            public final java.lang.Object getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getEventBusName() {
                return this.eventBusName;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getInputPath() {
                return this.inputPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));
                if (this.getEventBusName() != null) {
                    data.set("eventBusName", om.valueToTree(this.getEventBusName()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getInputPath() != null) {
                    data.set("inputPath", om.valueToTree(this.getInputPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.CloudWatchEventEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchEventEventProperty.Jsii$Proxy that = (CloudWatchEventEventProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (this.eventBusName != null ? !this.eventBusName.equals(that.eventBusName) : that.eventBusName != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.inputPath != null ? this.inputPath.equals(that.inputPath) : that.inputPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.eventBusName != null ? this.eventBusName.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * CloudWatchLogsLogGroupProperty cloudWatchLogsLogGroupProperty = CloudWatchLogsLogGroupProperty.builder()
     *         .logGroupArn("logGroupArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.CloudWatchLogsLogGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsLogGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsLogGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.CloudWatchLogsLogGroupProperty.LogGroupArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupArn();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsLogGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsLogGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsLogGroupProperty> {
            java.lang.String logGroupArn;

            /**
             * Sets the value of {@link CloudWatchLogsLogGroupProperty#getLogGroupArn}
             * @param logGroupArn `CfnStateMachine.CloudWatchLogsLogGroupProperty.LogGroupArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupArn(java.lang.String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsLogGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsLogGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsLogGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsLogGroupProperty {
            private final java.lang.String logGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroupArn = software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupArn = java.util.Objects.requireNonNull(builder.logGroupArn, "logGroupArn is required");
            }

            @Override
            public final java.lang.String getLogGroupArn() {
                return this.logGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroupArn", om.valueToTree(this.getLogGroupArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.CloudWatchLogsLogGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsLogGroupProperty.Jsii$Proxy that = (CloudWatchLogsLogGroupProperty.Jsii$Proxy) o;

                return this.logGroupArn.equals(that.logGroupArn);
            }

            @Override
            public final int hashCode() {
                int result = this.logGroupArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object pattern;
     * EventBridgeRuleEventProperty eventBridgeRuleEventProperty = EventBridgeRuleEventProperty.builder()
     *         .pattern(pattern)
     *         // the properties below are optional
     *         .eventBusName("eventBusName")
     *         .input("input")
     *         .inputPath("inputPath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.EventBridgeRuleEventProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeRuleEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeRuleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.Pattern`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPattern();

        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.EventBusName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventBusName() {
            return null;
        }

        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.Input`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.InputPath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventBridgeRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeRuleEventProperty> {
            java.lang.Object pattern;
            java.lang.String eventBusName;
            java.lang.String input;
            java.lang.String inputPath;

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getPattern}
             * @param pattern `CfnStateMachine.EventBridgeRuleEventProperty.Pattern`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.Object pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getEventBusName}
             * @param eventBusName `CfnStateMachine.EventBridgeRuleEventProperty.EventBusName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBusName(java.lang.String eventBusName) {
                this.eventBusName = eventBusName;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getInput}
             * @param input `CfnStateMachine.EventBridgeRuleEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getInputPath}
             * @param inputPath `CfnStateMachine.EventBridgeRuleEventProperty.InputPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPath(java.lang.String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeRuleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeRuleEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeRuleEventProperty {
            private final java.lang.Object pattern;
            private final java.lang.String eventBusName;
            private final java.lang.String input;
            private final java.lang.String inputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.eventBusName = builder.eventBusName;
                this.input = builder.input;
                this.inputPath = builder.inputPath;
            }

            @Override
            public final java.lang.Object getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getEventBusName() {
                return this.eventBusName;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getInputPath() {
                return this.inputPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));
                if (this.getEventBusName() != null) {
                    data.set("eventBusName", om.valueToTree(this.getEventBusName()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getInputPath() != null) {
                    data.set("inputPath", om.valueToTree(this.getInputPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.EventBridgeRuleEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeRuleEventProperty.Jsii$Proxy that = (EventBridgeRuleEventProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (this.eventBusName != null ? !this.eventBusName.equals(that.eventBusName) : that.eventBusName != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.inputPath != null ? this.inputPath.equals(that.inputPath) : that.inputPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.eventBusName != null ? this.eventBusName.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EventSourceProperty eventSourceProperty = EventSourceProperty.builder()
     *         .properties(CloudWatchEventEventProperty.builder()
     *                 .method("method")
     *                 .path("path")
     *                 // the properties below are optional
     *                 .restApiId("restApiId")
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.EventSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(EventSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.EventSourceProperty.Properties`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProperties();

        /**
         * `CfnStateMachine.EventSourceProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventSourceProperty> {
            java.lang.Object properties;
            java.lang.String type;

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnStateMachine.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.core.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnStateMachine.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnStateMachine.ApiEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnStateMachine.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnStateMachine.CloudWatchEventEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnStateMachine.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnStateMachine.EventBridgeRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnStateMachine.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnStateMachine.ScheduleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getType}
             * @param type `CfnStateMachine.EventSourceProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceProperty {
            private final java.lang.Object properties;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.properties = java.util.Objects.requireNonNull(builder.properties, "properties is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("properties", om.valueToTree(this.getProperties()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.EventSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventSourceProperty.Jsii$Proxy that = (EventSourceProperty.Jsii$Proxy) o;

                if (!properties.equals(that.properties)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.properties.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * FunctionSAMPTProperty functionSAMPTProperty = FunctionSAMPTProperty.builder()
     *         .functionName("functionName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.FunctionSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.FunctionSAMPTProperty.FunctionName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

        /**
         * @return a {@link Builder} of {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionSAMPTProperty> {
            java.lang.String functionName;

            /**
             * Sets the value of {@link FunctionSAMPTProperty#getFunctionName}
             * @param functionName `CfnStateMachine.FunctionSAMPTProperty.FunctionName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionName(java.lang.String functionName) {
                this.functionName = functionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionSAMPTProperty {
            private final java.lang.String functionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            }

            @Override
            public final java.lang.String getFunctionName() {
                return this.functionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionName", om.valueToTree(this.getFunctionName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.FunctionSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionSAMPTProperty.Jsii$Proxy that = (FunctionSAMPTProperty.Jsii$Proxy) o;

                return this.functionName.equals(that.functionName);
            }

            @Override
            public final int hashCode() {
                int result = this.functionName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object statement;
     * IAMPolicyDocumentProperty iAMPolicyDocumentProperty = Map.of(
     *         "statement", statement,
     *         "version", "version");
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.IAMPolicyDocumentProperty")
    @software.amazon.jsii.Jsii.Proxy(IAMPolicyDocumentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IAMPolicyDocumentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.IAMPolicyDocumentProperty.Statement`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatement();

        /**
         * `CfnStateMachine.IAMPolicyDocumentProperty.Version`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link IAMPolicyDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IAMPolicyDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IAMPolicyDocumentProperty> {
            java.lang.Object statement;
            java.lang.String version;

            /**
             * Sets the value of {@link IAMPolicyDocumentProperty#getStatement}
             * @param statement `CfnStateMachine.IAMPolicyDocumentProperty.Statement`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(java.lang.Object statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Sets the value of {@link IAMPolicyDocumentProperty#getVersion}
             * @param version `CfnStateMachine.IAMPolicyDocumentProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IAMPolicyDocumentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IAMPolicyDocumentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IAMPolicyDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IAMPolicyDocumentProperty {
            private final java.lang.Object statement;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statement = java.util.Objects.requireNonNull(builder.statement, "statement is required");
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            }

            @Override
            public final java.lang.Object getStatement() {
                return this.statement;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statement", om.valueToTree(this.getStatement()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.IAMPolicyDocumentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IAMPolicyDocumentProperty.Jsii$Proxy that = (IAMPolicyDocumentProperty.Jsii$Proxy) o;

                if (!statement.equals(that.statement)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public final int hashCode() {
                int result = this.statement.hashCode();
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * LogDestinationProperty logDestinationProperty = LogDestinationProperty.builder()
     *         .cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty.builder()
     *                 .logGroupArn("logGroupArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.LogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(LogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.LogDestinationProperty.CloudWatchLogsLogGroup`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCloudWatchLogsLogGroup();

        /**
         * @return a {@link Builder} of {@link LogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogDestinationProperty> {
            java.lang.Object cloudWatchLogsLogGroup;

            /**
             * Sets the value of {@link LogDestinationProperty#getCloudWatchLogsLogGroup}
             * @param cloudWatchLogsLogGroup `CfnStateMachine.LogDestinationProperty.CloudWatchLogsLogGroup`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsLogGroup(software.amazon.awscdk.core.IResolvable cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            /**
             * Sets the value of {@link LogDestinationProperty#getCloudWatchLogsLogGroup}
             * @param cloudWatchLogsLogGroup `CfnStateMachine.LogDestinationProperty.CloudWatchLogsLogGroup`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsLogGroup(software.amazon.awscdk.services.sam.CfnStateMachine.CloudWatchLogsLogGroupProperty cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogDestinationProperty {
            private final java.lang.Object cloudWatchLogsLogGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsLogGroup = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsLogGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsLogGroup = java.util.Objects.requireNonNull(builder.cloudWatchLogsLogGroup, "cloudWatchLogsLogGroup is required");
            }

            @Override
            public final java.lang.Object getCloudWatchLogsLogGroup() {
                return this.cloudWatchLogsLogGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchLogsLogGroup", om.valueToTree(this.getCloudWatchLogsLogGroup()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.LogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogDestinationProperty.Jsii$Proxy that = (LogDestinationProperty.Jsii$Proxy) o;

                return this.cloudWatchLogsLogGroup.equals(that.cloudWatchLogsLogGroup);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsLogGroup.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * LoggingConfigurationProperty loggingConfigurationProperty = LoggingConfigurationProperty.builder()
     *         .destinations(List.of(LogDestinationProperty.builder()
     *                 .cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty.builder()
     *                         .logGroupArn("logGroupArn")
     *                         .build())
     *                 .build()))
     *         .includeExecutionData(false)
     *         .level("level")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.LoggingConfigurationProperty.Destinations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinations();

        /**
         * `CfnStateMachine.LoggingConfigurationProperty.IncludeExecutionData`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIncludeExecutionData();

        /**
         * `CfnStateMachine.LoggingConfigurationProperty.Level`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLevel();

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            java.lang.Object destinations;
            java.lang.Object includeExecutionData;
            java.lang.String level;

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getDestinations}
             * @param destinations `CfnStateMachine.LoggingConfigurationProperty.Destinations`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(software.amazon.awscdk.core.IResolvable destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getDestinations}
             * @param destinations `CfnStateMachine.LoggingConfigurationProperty.Destinations`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getIncludeExecutionData}
             * @param includeExecutionData `CfnStateMachine.LoggingConfigurationProperty.IncludeExecutionData`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeExecutionData(java.lang.Boolean includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getIncludeExecutionData}
             * @param includeExecutionData `CfnStateMachine.LoggingConfigurationProperty.IncludeExecutionData`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeExecutionData(software.amazon.awscdk.core.IResolvable includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getLevel}
             * @param level `CfnStateMachine.LoggingConfigurationProperty.Level`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder level(java.lang.String level) {
                this.level = level;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfigurationProperty {
            private final java.lang.Object destinations;
            private final java.lang.Object includeExecutionData;
            private final java.lang.String level;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeExecutionData = software.amazon.jsii.Kernel.get(this, "includeExecutionData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.level = software.amazon.jsii.Kernel.get(this, "level", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinations = java.util.Objects.requireNonNull(builder.destinations, "destinations is required");
                this.includeExecutionData = java.util.Objects.requireNonNull(builder.includeExecutionData, "includeExecutionData is required");
                this.level = java.util.Objects.requireNonNull(builder.level, "level is required");
            }

            @Override
            public final java.lang.Object getDestinations() {
                return this.destinations;
            }

            @Override
            public final java.lang.Object getIncludeExecutionData() {
                return this.includeExecutionData;
            }

            @Override
            public final java.lang.String getLevel() {
                return this.level;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinations", om.valueToTree(this.getDestinations()));
                data.set("includeExecutionData", om.valueToTree(this.getIncludeExecutionData()));
                data.set("level", om.valueToTree(this.getLevel()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.LoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingConfigurationProperty.Jsii$Proxy that = (LoggingConfigurationProperty.Jsii$Proxy) o;

                if (!destinations.equals(that.destinations)) return false;
                if (!includeExecutionData.equals(that.includeExecutionData)) return false;
                return this.level.equals(that.level);
            }

            @Override
            public final int hashCode() {
                int result = this.destinations.hashCode();
                result = 31 * result + (this.includeExecutionData.hashCode());
                result = 31 * result + (this.level.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         // the properties below are optional
     *         .version(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.S3LocationProperty.Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnStateMachine.S3LocationProperty.Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * `CfnStateMachine.S3LocationProperty.Version`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String key;
            java.lang.Number version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket `CfnStateMachine.S3LocationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key `CfnStateMachine.S3LocationProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version `CfnStateMachine.S3LocationProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * SAMPolicyTemplateProperty sAMPolicyTemplateProperty = SAMPolicyTemplateProperty.builder()
     *         .lambdaInvokePolicy(FunctionSAMPTProperty.builder()
     *                 .functionName("functionName")
     *                 .build())
     *         .stepFunctionsExecutionPolicy(StateMachineSAMPTProperty.builder()
     *                 .stateMachineName("stateMachineName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.SAMPolicyTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(SAMPolicyTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAMPolicyTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaInvokePolicy() {
            return null;
        }

        /**
         * `CfnStateMachine.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStepFunctionsExecutionPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAMPolicyTemplateProperty> {
            java.lang.Object lambdaInvokePolicy;
            java.lang.Object stepFunctionsExecutionPolicy;

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getLambdaInvokePolicy}
             * @param lambdaInvokePolicy `CfnStateMachine.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaInvokePolicy(software.amazon.awscdk.core.IResolvable lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getLambdaInvokePolicy}
             * @param lambdaInvokePolicy `CfnStateMachine.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaInvokePolicy(software.amazon.awscdk.services.sam.CfnStateMachine.FunctionSAMPTProperty lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getStepFunctionsExecutionPolicy}
             * @param stepFunctionsExecutionPolicy `CfnStateMachine.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctionsExecutionPolicy(software.amazon.awscdk.core.IResolvable stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getStepFunctionsExecutionPolicy}
             * @param stepFunctionsExecutionPolicy `CfnStateMachine.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctionsExecutionPolicy(software.amazon.awscdk.services.sam.CfnStateMachine.StateMachineSAMPTProperty stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAMPolicyTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAMPolicyTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAMPolicyTemplateProperty {
            private final java.lang.Object lambdaInvokePolicy;
            private final java.lang.Object stepFunctionsExecutionPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaInvokePolicy = software.amazon.jsii.Kernel.get(this, "lambdaInvokePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stepFunctionsExecutionPolicy = software.amazon.jsii.Kernel.get(this, "stepFunctionsExecutionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaInvokePolicy = builder.lambdaInvokePolicy;
                this.stepFunctionsExecutionPolicy = builder.stepFunctionsExecutionPolicy;
            }

            @Override
            public final java.lang.Object getLambdaInvokePolicy() {
                return this.lambdaInvokePolicy;
            }

            @Override
            public final java.lang.Object getStepFunctionsExecutionPolicy() {
                return this.stepFunctionsExecutionPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLambdaInvokePolicy() != null) {
                    data.set("lambdaInvokePolicy", om.valueToTree(this.getLambdaInvokePolicy()));
                }
                if (this.getStepFunctionsExecutionPolicy() != null) {
                    data.set("stepFunctionsExecutionPolicy", om.valueToTree(this.getStepFunctionsExecutionPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.SAMPolicyTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAMPolicyTemplateProperty.Jsii$Proxy that = (SAMPolicyTemplateProperty.Jsii$Proxy) o;

                if (this.lambdaInvokePolicy != null ? !this.lambdaInvokePolicy.equals(that.lambdaInvokePolicy) : that.lambdaInvokePolicy != null) return false;
                return this.stepFunctionsExecutionPolicy != null ? this.stepFunctionsExecutionPolicy.equals(that.stepFunctionsExecutionPolicy) : that.stepFunctionsExecutionPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaInvokePolicy != null ? this.lambdaInvokePolicy.hashCode() : 0;
                result = 31 * result + (this.stepFunctionsExecutionPolicy != null ? this.stepFunctionsExecutionPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * ScheduleEventProperty scheduleEventProperty = ScheduleEventProperty.builder()
     *         .schedule("schedule")
     *         // the properties below are optional
     *         .input("input")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.ScheduleEventProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.ScheduleEventProperty.Schedule`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSchedule();

        /**
         * `CfnStateMachine.ScheduleEventProperty.Input`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleEventProperty> {
            java.lang.String schedule;
            java.lang.String input;

            /**
             * Sets the value of {@link ScheduleEventProperty#getSchedule}
             * @param schedule `CfnStateMachine.ScheduleEventProperty.Schedule`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(java.lang.String schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleEventProperty#getInput}
             * @param input `CfnStateMachine.ScheduleEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleEventProperty {
            private final java.lang.String schedule;
            private final java.lang.String input;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
                this.input = builder.input;
            }

            @Override
            public final java.lang.String getSchedule() {
                return this.schedule;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("schedule", om.valueToTree(this.getSchedule()));
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.ScheduleEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleEventProperty.Jsii$Proxy that = (ScheduleEventProperty.Jsii$Proxy) o;

                if (!schedule.equals(that.schedule)) return false;
                return this.input != null ? this.input.equals(that.input) : that.input == null;
            }

            @Override
            public final int hashCode() {
                int result = this.schedule.hashCode();
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * StateMachineSAMPTProperty stateMachineSAMPTProperty = StateMachineSAMPTProperty.builder()
     *         .stateMachineName("stateMachineName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.StateMachineSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(StateMachineSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StateMachineSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.StateMachineSAMPTProperty.StateMachineName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStateMachineName();

        /**
         * @return a {@link Builder} of {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StateMachineSAMPTProperty> {
            java.lang.String stateMachineName;

            /**
             * Sets the value of {@link StateMachineSAMPTProperty#getStateMachineName}
             * @param stateMachineName `CfnStateMachine.StateMachineSAMPTProperty.StateMachineName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateMachineName(java.lang.String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StateMachineSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StateMachineSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateMachineSAMPTProperty {
            private final java.lang.String stateMachineName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stateMachineName = software.amazon.jsii.Kernel.get(this, "stateMachineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stateMachineName = java.util.Objects.requireNonNull(builder.stateMachineName, "stateMachineName is required");
            }

            @Override
            public final java.lang.String getStateMachineName() {
                return this.stateMachineName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("stateMachineName", om.valueToTree(this.getStateMachineName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.StateMachineSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StateMachineSAMPTProperty.Jsii$Proxy that = (StateMachineSAMPTProperty.Jsii$Proxy) o;

                return this.stateMachineName.equals(that.stateMachineName);
            }

            @Override
            public final int hashCode() {
                int result = this.stateMachineName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * TracingConfigurationProperty tracingConfigurationProperty = TracingConfigurationProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnStateMachine.TracingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TracingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TracingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStateMachine.TracingConfigurationProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TracingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TracingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TracingConfigurationProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link TracingConfigurationProperty#getEnabled}
             * @param enabled `CfnStateMachine.TracingConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TracingConfigurationProperty#getEnabled}
             * @param enabled `CfnStateMachine.TracingConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TracingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TracingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TracingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TracingConfigurationProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnStateMachine.TracingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TracingConfigurationProperty.Jsii$Proxy that = (TracingConfigurationProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sam.CfnStateMachine}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sam.CfnStateMachine> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sam.CfnStateMachineProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::Serverless::StateMachine.Definition`.
         * <p>
         * @return {@code this}
         * @param definition `AWS::Serverless::StateMachine.Definition`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final java.lang.Object definition) {
            this.props().definition(definition);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.DefinitionSubstitutions`.
         * <p>
         * @return {@code this}
         * @param definitionSubstitutions `AWS::Serverless::StateMachine.DefinitionSubstitutions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(final software.amazon.awscdk.core.IResolvable definitionSubstitutions) {
            this.props().definitionSubstitutions(definitionSubstitutions);
            return this;
        }
        /**
         * `AWS::Serverless::StateMachine.DefinitionSubstitutions`.
         * <p>
         * @return {@code this}
         * @param definitionSubstitutions `AWS::Serverless::StateMachine.DefinitionSubstitutions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(final java.util.Map<java.lang.String, java.lang.String> definitionSubstitutions) {
            this.props().definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.DefinitionUri`.
         * <p>
         * @return {@code this}
         * @param definitionUri `AWS::Serverless::StateMachine.DefinitionUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(final java.lang.String definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }
        /**
         * `AWS::Serverless::StateMachine.DefinitionUri`.
         * <p>
         * @return {@code this}
         * @param definitionUri `AWS::Serverless::StateMachine.DefinitionUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(final software.amazon.awscdk.core.IResolvable definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }
        /**
         * `AWS::Serverless::StateMachine.DefinitionUri`.
         * <p>
         * @return {@code this}
         * @param definitionUri `AWS::Serverless::StateMachine.DefinitionUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(final software.amazon.awscdk.services.sam.CfnStateMachine.S3LocationProperty definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.Events`.
         * <p>
         * @return {@code this}
         * @param events `AWS::Serverless::StateMachine.Events`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final software.amazon.awscdk.core.IResolvable events) {
            this.props().events(events);
            return this;
        }
        /**
         * `AWS::Serverless::StateMachine.Events`.
         * <p>
         * @return {@code this}
         * @param events `AWS::Serverless::StateMachine.Events`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.Map<java.lang.String, ? extends java.lang.Object> events) {
            this.props().events(events);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.Logging`.
         * <p>
         * @return {@code this}
         * @param logging `AWS::Serverless::StateMachine.Logging`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.core.IResolvable logging) {
            this.props().logging(logging);
            return this;
        }
        /**
         * `AWS::Serverless::StateMachine.Logging`.
         * <p>
         * @return {@code this}
         * @param logging `AWS::Serverless::StateMachine.Logging`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.sam.CfnStateMachine.LoggingConfigurationProperty logging) {
            this.props().logging(logging);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::Serverless::StateMachine.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.PermissionsBoundaries`.
         * <p>
         * @return {@code this}
         * @param permissionsBoundaries `AWS::Serverless::StateMachine.PermissionsBoundaries`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundaries(final java.lang.String permissionsBoundaries) {
            this.props().permissionsBoundaries(permissionsBoundaries);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.Policies`.
         * <p>
         * @return {@code this}
         * @param policies `AWS::Serverless::StateMachine.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final java.lang.String policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * `AWS::Serverless::StateMachine.Policies`.
         * <p>
         * @return {@code this}
         * @param policies `AWS::Serverless::StateMachine.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.core.IResolvable policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * `AWS::Serverless::StateMachine.Policies`.
         * <p>
         * @return {@code this}
         * @param policies `AWS::Serverless::StateMachine.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.services.sam.CfnStateMachine.IAMPolicyDocumentProperty policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * `AWS::Serverless::StateMachine.Policies`.
         * <p>
         * @return {@code this}
         * @param policies `AWS::Serverless::StateMachine.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final java.util.List<? extends java.lang.Object> policies) {
            this.props().policies(policies);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.Role`.
         * <p>
         * @return {@code this}
         * @param role `AWS::Serverless::StateMachine.Role`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final java.lang.String role) {
            this.props().role(role);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::Serverless::StateMachine.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.Tracing`.
         * <p>
         * @return {@code this}
         * @param tracing `AWS::Serverless::StateMachine.Tracing`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(final software.amazon.awscdk.core.IResolvable tracing) {
            this.props().tracing(tracing);
            return this;
        }
        /**
         * `AWS::Serverless::StateMachine.Tracing`.
         * <p>
         * @return {@code this}
         * @param tracing `AWS::Serverless::StateMachine.Tracing`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(final software.amazon.awscdk.services.sam.CfnStateMachine.TracingConfigurationProperty tracing) {
            this.props().tracing(tracing);
            return this;
        }

        /**
         * `AWS::Serverless::StateMachine.Type`.
         * <p>
         * @return {@code this}
         * @param type `AWS::Serverless::StateMachine.Type`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props().type(type);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sam.CfnStateMachine}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sam.CfnStateMachine build() {
            return new software.amazon.awscdk.services.sam.CfnStateMachine(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sam.CfnStateMachineProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sam.CfnStateMachineProps.Builder();
            }
            return this.props;
        }
    }
}
