/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.services.sam.;
import software.amazon.awscdk.services.sam.CfnFunctionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction")
public class CfnFunction
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"cfnResourceTypeName", String.class);
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"requiredTransform", String.class);

    protected CfnFunction(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public CfnFunction(Construct scope, String id, CfnFunctionProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    protected Map<String, Object> getCfnProperties() {
        return (Map)this.jsiiGet("cfnProperties", Map.class);
    }

    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    public Object getCodeUri() {
        return this.jsiiGet("codeUri", Object.class);
    }

    public void setCodeUri(String value) {
        this.jsiiSet("codeUri", Objects.requireNonNull(value, "codeUri is required"));
    }

    public void setCodeUri(IResolvable value) {
        this.jsiiSet("codeUri", Objects.requireNonNull(value, "codeUri is required"));
    }

    public void setCodeUri(S3LocationProperty value) {
        this.jsiiSet("codeUri", Objects.requireNonNull(value, "codeUri is required"));
    }

    public String getHandler() {
        return (String)this.jsiiGet("handler", String.class);
    }

    public void setHandler(String value) {
        this.jsiiSet("handler", Objects.requireNonNull(value, "handler is required"));
    }

    public String getRuntime() {
        return (String)this.jsiiGet("runtime", String.class);
    }

    public void setRuntime(String value) {
        this.jsiiSet("runtime", Objects.requireNonNull(value, "runtime is required"));
    }

    @Nullable
    public String getAutoPublishAlias() {
        return (String)this.jsiiGet("autoPublishAlias", String.class);
    }

    public void setAutoPublishAlias(@Nullable String value) {
        this.jsiiSet("autoPublishAlias", value);
    }

    @Nullable
    public Object getDeadLetterQueue() {
        return this.jsiiGet("deadLetterQueue", Object.class);
    }

    public void setDeadLetterQueue(@Nullable IResolvable value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    public void setDeadLetterQueue(@Nullable DeadLetterQueueProperty value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    @Nullable
    public Object getDeploymentPreference() {
        return this.jsiiGet("deploymentPreference", Object.class);
    }

    public void setDeploymentPreference(@Nullable IResolvable value) {
        this.jsiiSet("deploymentPreference", value);
    }

    public void setDeploymentPreference(@Nullable DeploymentPreferenceProperty value) {
        this.jsiiSet("deploymentPreference", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public Object getEnvironment() {
        return this.jsiiGet("environment", Object.class);
    }

    public void setEnvironment(@Nullable IResolvable value) {
        this.jsiiSet("environment", value);
    }

    public void setEnvironment(@Nullable FunctionEnvironmentProperty value) {
        this.jsiiSet("environment", value);
    }

    @Nullable
    public Object getEvents() {
        return this.jsiiGet("events", Object.class);
    }

    public void setEvents(@Nullable IResolvable value) {
        this.jsiiSet("events", value);
    }

    public void setEvents(@Nullable Map<String, Object> value) {
        this.jsiiSet("events", value);
    }

    @Nullable
    public String getFunctionName() {
        return (String)this.jsiiGet("functionName", String.class);
    }

    public void setFunctionName(@Nullable String value) {
        this.jsiiSet("functionName", value);
    }

    @Nullable
    public String getKmsKeyArn() {
        return (String)this.jsiiGet("kmsKeyArn", String.class);
    }

    public void setKmsKeyArn(@Nullable String value) {
        this.jsiiSet("kmsKeyArn", value);
    }

    @Nullable
    public List<String> getLayers() {
        return (List)this.jsiiGet("layers", List.class);
    }

    public void setLayers(@Nullable List<String> value) {
        this.jsiiSet("layers", value);
    }

    @Nullable
    public Number getMemorySize() {
        return (Number)this.jsiiGet("memorySize", Number.class);
    }

    public void setMemorySize(@Nullable Number value) {
        this.jsiiSet("memorySize", value);
    }

    @Nullable
    public String getPermissionsBoundary() {
        return (String)this.jsiiGet("permissionsBoundary", String.class);
    }

    public void setPermissionsBoundary(@Nullable String value) {
        this.jsiiSet("permissionsBoundary", value);
    }

    @Nullable
    public Object getPolicies() {
        return this.jsiiGet("policies", Object.class);
    }

    public void setPolicies(@Nullable String value) {
        this.jsiiSet("policies", value);
    }

    public void setPolicies(@Nullable IResolvable value) {
        this.jsiiSet("policies", value);
    }

    public void setPolicies(@Nullable IAMPolicyDocumentProperty value) {
        this.jsiiSet("policies", value);
    }

    public void setPolicies(@Nullable List<Object> value) {
        this.jsiiSet("policies", value);
    }

    @Nullable
    public Number getReservedConcurrentExecutions() {
        return (Number)this.jsiiGet("reservedConcurrentExecutions", Number.class);
    }

    public void setReservedConcurrentExecutions(@Nullable Number value) {
        this.jsiiSet("reservedConcurrentExecutions", value);
    }

    @Nullable
    public String getRole() {
        return (String)this.jsiiGet("role", String.class);
    }

    public void setRole(@Nullable String value) {
        this.jsiiSet("role", value);
    }

    @Nullable
    public Number getTimeout() {
        return (Number)this.jsiiGet("timeout", Number.class);
    }

    public void setTimeout(@Nullable Number value) {
        this.jsiiSet("timeout", value);
    }

    @Nullable
    public String getTracing() {
        return (String)this.jsiiGet("tracing", String.class);
    }

    public void setTracing(@Nullable String value) {
        this.jsiiSet("tracing", value);
    }

    @Nullable
    public Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", Object.class);
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    public void setVpcConfig(@Nullable VpcConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }

    public static interface VpcConfigProperty
    extends JsiiSerializable {
        public List<String> getSecurityGroupIds();

        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> _securityGroupIds;
            private List<String> _subnetIds;

            public Builder withSecurityGroupIds(List<String> value) {
                this._securityGroupIds = Objects.requireNonNull(value, "securityGroupIds is required");
                return this;
            }

            public Builder withSubnetIds(List<String> value) {
                this._subnetIds = Objects.requireNonNull(value, "subnetIds is required");
                return this;
            }

            public VpcConfigProperty build() {
                return new VpcConfigProperty(){
                    private final List<String> $securityGroupIds;
                    private final List<String> $subnetIds;
                    {
                        this.$securityGroupIds = Objects.requireNonNull(_securityGroupIds, "securityGroupIds is required");
                        this.$subnetIds = Objects.requireNonNull(_subnetIds, "subnetIds is required");
                    }

                    @Override
                    public List<String> getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public List<String> getSubnetIds() {
                        return this.$subnetIds;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                        obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface TopicSAMPTProperty
    extends JsiiSerializable {
        public String getTopicName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _topicName;

            public Builder withTopicName(String value) {
                this._topicName = Objects.requireNonNull(value, "topicName is required");
                return this;
            }

            public TopicSAMPTProperty build() {
                return new TopicSAMPTProperty(){
                    private final String $topicName;
                    {
                        this.$topicName = Objects.requireNonNull(_topicName, "topicName is required");
                    }

                    @Override
                    public String getTopicName() {
                        return this.$topicName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("topicName", om.valueToTree((Object)this.getTopicName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface TableStreamSAMPTProperty
    extends JsiiSerializable {
        public String getStreamName();

        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _streamName;
            private String _tableName;

            public Builder withStreamName(String value) {
                this._streamName = Objects.requireNonNull(value, "streamName is required");
                return this;
            }

            public Builder withTableName(String value) {
                this._tableName = Objects.requireNonNull(value, "tableName is required");
                return this;
            }

            public TableStreamSAMPTProperty build() {
                return new TableStreamSAMPTProperty(){
                    private final String $streamName;
                    private final String $tableName;
                    {
                        this.$streamName = Objects.requireNonNull(_streamName, "streamName is required");
                        this.$tableName = Objects.requireNonNull(_tableName, "tableName is required");
                    }

                    @Override
                    public String getStreamName() {
                        return this.$streamName;
                    }

                    @Override
                    public String getTableName() {
                        return this.$tableName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("streamName", om.valueToTree((Object)this.getStreamName()));
                        obj.set("tableName", om.valueToTree((Object)this.getTableName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface TableSAMPTProperty
    extends JsiiSerializable {
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _tableName;

            public Builder withTableName(String value) {
                this._tableName = Objects.requireNonNull(value, "tableName is required");
                return this;
            }

            public TableSAMPTProperty build() {
                return new TableSAMPTProperty(){
                    private final String $tableName;
                    {
                        this.$tableName = Objects.requireNonNull(_tableName, "tableName is required");
                    }

                    @Override
                    public String getTableName() {
                        return this.$tableName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("tableName", om.valueToTree((Object)this.getTableName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface StreamSAMPTProperty
    extends JsiiSerializable {
        public String getStreamName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _streamName;

            public Builder withStreamName(String value) {
                this._streamName = Objects.requireNonNull(value, "streamName is required");
                return this;
            }

            public StreamSAMPTProperty build() {
                return new StreamSAMPTProperty(){
                    private final String $streamName;
                    {
                        this.$streamName = Objects.requireNonNull(_streamName, "streamName is required");
                    }

                    @Override
                    public String getStreamName() {
                        return this.$streamName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("streamName", om.valueToTree((Object)this.getStreamName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface StateMachineSAMPTProperty
    extends JsiiSerializable {
        public String getStateMachineName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _stateMachineName;

            public Builder withStateMachineName(String value) {
                this._stateMachineName = Objects.requireNonNull(value, "stateMachineName is required");
                return this;
            }

            public StateMachineSAMPTProperty build() {
                return new StateMachineSAMPTProperty(){
                    private final String $stateMachineName;
                    {
                        this.$stateMachineName = Objects.requireNonNull(_stateMachineName, "stateMachineName is required");
                    }

                    @Override
                    public String getStateMachineName() {
                        return this.$stateMachineName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("stateMachineName", om.valueToTree((Object)this.getStateMachineName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ScheduleEventProperty
    extends JsiiSerializable {
        public String getSchedule();

        public String getInput();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _schedule;
            @Nullable
            private String _input;

            public Builder withSchedule(String value) {
                this._schedule = Objects.requireNonNull(value, "schedule is required");
                return this;
            }

            public Builder withInput(@Nullable String value) {
                this._input = value;
                return this;
            }

            public ScheduleEventProperty build() {
                return new ScheduleEventProperty(){
                    private final String $schedule;
                    @Nullable
                    private final String $input;
                    {
                        this.$schedule = Objects.requireNonNull(_schedule, "schedule is required");
                        this.$input = _input;
                    }

                    @Override
                    public String getSchedule() {
                        return this.$schedule;
                    }

                    @Override
                    public String getInput() {
                        return this.$input;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("schedule", om.valueToTree((Object)this.getSchedule()));
                        if (this.getInput() != null) {
                            obj.set("input", om.valueToTree((Object)this.getInput()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface SQSEventProperty
    extends JsiiSerializable {
        public String getQueue();

        public Number getBatchSize();

        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _queue;
            @Nullable
            private Number _batchSize;
            @Nullable
            private Object _enabled;

            public Builder withQueue(String value) {
                this._queue = Objects.requireNonNull(value, "queue is required");
                return this;
            }

            public Builder withBatchSize(@Nullable Number value) {
                this._batchSize = value;
                return this;
            }

            public Builder withEnabled(@Nullable Boolean value) {
                this._enabled = value;
                return this;
            }

            public Builder withEnabled(@Nullable IResolvable value) {
                this._enabled = value;
                return this;
            }

            public SQSEventProperty build() {
                return new SQSEventProperty(){
                    private final String $queue;
                    @Nullable
                    private final Number $batchSize;
                    @Nullable
                    private final Object $enabled;
                    {
                        this.$queue = Objects.requireNonNull(_queue, "queue is required");
                        this.$batchSize = _batchSize;
                        this.$enabled = _enabled;
                    }

                    @Override
                    public String getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public Number getBatchSize() {
                        return this.$batchSize;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("queue", om.valueToTree((Object)this.getQueue()));
                        if (this.getBatchSize() != null) {
                            obj.set("batchSize", om.valueToTree((Object)this.getBatchSize()));
                        }
                        if (this.getEnabled() != null) {
                            obj.set("enabled", om.valueToTree(this.getEnabled()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface SNSEventProperty
    extends JsiiSerializable {
        public String getTopic();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _topic;

            public Builder withTopic(String value) {
                this._topic = Objects.requireNonNull(value, "topic is required");
                return this;
            }

            public SNSEventProperty build() {
                return new SNSEventProperty(){
                    private final String $topic;
                    {
                        this.$topic = Objects.requireNonNull(_topic, "topic is required");
                    }

                    @Override
                    public String getTopic() {
                        return this.$topic;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("topic", om.valueToTree((Object)this.getTopic()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface SAMPolicyTemplateProperty
    extends JsiiSerializable {
        public Object getAmiDescribePolicy();

        public Object getCloudFormationDescribeStacksPolicy();

        public Object getCloudWatchPutMetricPolicy();

        public Object getDynamoDbCrudPolicy();

        public Object getDynamoDbReadPolicy();

        public Object getDynamoDbStreamReadPolicy();

        public Object getEc2DescribePolicy();

        public Object getElasticsearchHttpPostPolicy();

        public Object getFilterLogEventsPolicy();

        public Object getKinesisCrudPolicy();

        public Object getKinesisStreamReadPolicy();

        public Object getKmsDecryptPolicy();

        public Object getLambdaInvokePolicy();

        public Object getRekognitionDetectOnlyPolicy();

        public Object getRekognitionLabelsPolicy();

        public Object getRekognitionNoDataAccessPolicy();

        public Object getRekognitionReadPolicy();

        public Object getRekognitionWriteOnlyAccessPolicy();

        public Object getS3CrudPolicy();

        public Object getS3ReadPolicy();

        public Object getSesBulkTemplatedCrudPolicy();

        public Object getSesCrudPolicy();

        public Object getSesEmailTemplateCrudPolicy();

        public Object getSesSendBouncePolicy();

        public Object getSnsCrudPolicy();

        public Object getSnsPublishMessagePolicy();

        public Object getSqsPollerPolicy();

        public Object getSqsSendMessagePolicy();

        public Object getStepFunctionsExecutionPolicy();

        public Object getVpcAccessPolicy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _amiDescribePolicy;
            @Nullable
            private Object _cloudFormationDescribeStacksPolicy;
            @Nullable
            private Object _cloudWatchPutMetricPolicy;
            @Nullable
            private Object _dynamoDbCrudPolicy;
            @Nullable
            private Object _dynamoDbReadPolicy;
            @Nullable
            private Object _dynamoDbStreamReadPolicy;
            @Nullable
            private Object _ec2DescribePolicy;
            @Nullable
            private Object _elasticsearchHttpPostPolicy;
            @Nullable
            private Object _filterLogEventsPolicy;
            @Nullable
            private Object _kinesisCrudPolicy;
            @Nullable
            private Object _kinesisStreamReadPolicy;
            @Nullable
            private Object _kmsDecryptPolicy;
            @Nullable
            private Object _lambdaInvokePolicy;
            @Nullable
            private Object _rekognitionDetectOnlyPolicy;
            @Nullable
            private Object _rekognitionLabelsPolicy;
            @Nullable
            private Object _rekognitionNoDataAccessPolicy;
            @Nullable
            private Object _rekognitionReadPolicy;
            @Nullable
            private Object _rekognitionWriteOnlyAccessPolicy;
            @Nullable
            private Object _s3CrudPolicy;
            @Nullable
            private Object _s3ReadPolicy;
            @Nullable
            private Object _sesBulkTemplatedCrudPolicy;
            @Nullable
            private Object _sesCrudPolicy;
            @Nullable
            private Object _sesEmailTemplateCrudPolicy;
            @Nullable
            private Object _sesSendBouncePolicy;
            @Nullable
            private Object _snsCrudPolicy;
            @Nullable
            private Object _snsPublishMessagePolicy;
            @Nullable
            private Object _sqsPollerPolicy;
            @Nullable
            private Object _sqsSendMessagePolicy;
            @Nullable
            private Object _stepFunctionsExecutionPolicy;
            @Nullable
            private Object _vpcAccessPolicy;

            public Builder withAmiDescribePolicy(@Nullable IResolvable value) {
                this._amiDescribePolicy = value;
                return this;
            }

            public Builder withAmiDescribePolicy(@Nullable EmptySAMPTProperty value) {
                this._amiDescribePolicy = value;
                return this;
            }

            public Builder withCloudFormationDescribeStacksPolicy(@Nullable IResolvable value) {
                this._cloudFormationDescribeStacksPolicy = value;
                return this;
            }

            public Builder withCloudFormationDescribeStacksPolicy(@Nullable EmptySAMPTProperty value) {
                this._cloudFormationDescribeStacksPolicy = value;
                return this;
            }

            public Builder withCloudWatchPutMetricPolicy(@Nullable IResolvable value) {
                this._cloudWatchPutMetricPolicy = value;
                return this;
            }

            public Builder withCloudWatchPutMetricPolicy(@Nullable EmptySAMPTProperty value) {
                this._cloudWatchPutMetricPolicy = value;
                return this;
            }

            public Builder withDynamoDbCrudPolicy(@Nullable IResolvable value) {
                this._dynamoDbCrudPolicy = value;
                return this;
            }

            public Builder withDynamoDbCrudPolicy(@Nullable TableSAMPTProperty value) {
                this._dynamoDbCrudPolicy = value;
                return this;
            }

            public Builder withDynamoDbReadPolicy(@Nullable IResolvable value) {
                this._dynamoDbReadPolicy = value;
                return this;
            }

            public Builder withDynamoDbReadPolicy(@Nullable TableSAMPTProperty value) {
                this._dynamoDbReadPolicy = value;
                return this;
            }

            public Builder withDynamoDbStreamReadPolicy(@Nullable IResolvable value) {
                this._dynamoDbStreamReadPolicy = value;
                return this;
            }

            public Builder withDynamoDbStreamReadPolicy(@Nullable TableStreamSAMPTProperty value) {
                this._dynamoDbStreamReadPolicy = value;
                return this;
            }

            public Builder withEc2DescribePolicy(@Nullable IResolvable value) {
                this._ec2DescribePolicy = value;
                return this;
            }

            public Builder withEc2DescribePolicy(@Nullable EmptySAMPTProperty value) {
                this._ec2DescribePolicy = value;
                return this;
            }

            public Builder withElasticsearchHttpPostPolicy(@Nullable IResolvable value) {
                this._elasticsearchHttpPostPolicy = value;
                return this;
            }

            public Builder withElasticsearchHttpPostPolicy(@Nullable DomainSAMPTProperty value) {
                this._elasticsearchHttpPostPolicy = value;
                return this;
            }

            public Builder withFilterLogEventsPolicy(@Nullable IResolvable value) {
                this._filterLogEventsPolicy = value;
                return this;
            }

            public Builder withFilterLogEventsPolicy(@Nullable LogGroupSAMPTProperty value) {
                this._filterLogEventsPolicy = value;
                return this;
            }

            public Builder withKinesisCrudPolicy(@Nullable IResolvable value) {
                this._kinesisCrudPolicy = value;
                return this;
            }

            public Builder withKinesisCrudPolicy(@Nullable StreamSAMPTProperty value) {
                this._kinesisCrudPolicy = value;
                return this;
            }

            public Builder withKinesisStreamReadPolicy(@Nullable IResolvable value) {
                this._kinesisStreamReadPolicy = value;
                return this;
            }

            public Builder withKinesisStreamReadPolicy(@Nullable StreamSAMPTProperty value) {
                this._kinesisStreamReadPolicy = value;
                return this;
            }

            public Builder withKmsDecryptPolicy(@Nullable IResolvable value) {
                this._kmsDecryptPolicy = value;
                return this;
            }

            public Builder withKmsDecryptPolicy(@Nullable KeySAMPTProperty value) {
                this._kmsDecryptPolicy = value;
                return this;
            }

            public Builder withLambdaInvokePolicy(@Nullable IResolvable value) {
                this._lambdaInvokePolicy = value;
                return this;
            }

            public Builder withLambdaInvokePolicy(@Nullable FunctionSAMPTProperty value) {
                this._lambdaInvokePolicy = value;
                return this;
            }

            public Builder withRekognitionDetectOnlyPolicy(@Nullable IResolvable value) {
                this._rekognitionDetectOnlyPolicy = value;
                return this;
            }

            public Builder withRekognitionDetectOnlyPolicy(@Nullable EmptySAMPTProperty value) {
                this._rekognitionDetectOnlyPolicy = value;
                return this;
            }

            public Builder withRekognitionLabelsPolicy(@Nullable IResolvable value) {
                this._rekognitionLabelsPolicy = value;
                return this;
            }

            public Builder withRekognitionLabelsPolicy(@Nullable EmptySAMPTProperty value) {
                this._rekognitionLabelsPolicy = value;
                return this;
            }

            public Builder withRekognitionNoDataAccessPolicy(@Nullable IResolvable value) {
                this._rekognitionNoDataAccessPolicy = value;
                return this;
            }

            public Builder withRekognitionNoDataAccessPolicy(@Nullable CollectionSAMPTProperty value) {
                this._rekognitionNoDataAccessPolicy = value;
                return this;
            }

            public Builder withRekognitionReadPolicy(@Nullable IResolvable value) {
                this._rekognitionReadPolicy = value;
                return this;
            }

            public Builder withRekognitionReadPolicy(@Nullable CollectionSAMPTProperty value) {
                this._rekognitionReadPolicy = value;
                return this;
            }

            public Builder withRekognitionWriteOnlyAccessPolicy(@Nullable IResolvable value) {
                this._rekognitionWriteOnlyAccessPolicy = value;
                return this;
            }

            public Builder withRekognitionWriteOnlyAccessPolicy(@Nullable CollectionSAMPTProperty value) {
                this._rekognitionWriteOnlyAccessPolicy = value;
                return this;
            }

            public Builder withS3CrudPolicy(@Nullable IResolvable value) {
                this._s3CrudPolicy = value;
                return this;
            }

            public Builder withS3CrudPolicy(@Nullable BucketSAMPTProperty value) {
                this._s3CrudPolicy = value;
                return this;
            }

            public Builder withS3ReadPolicy(@Nullable IResolvable value) {
                this._s3ReadPolicy = value;
                return this;
            }

            public Builder withS3ReadPolicy(@Nullable BucketSAMPTProperty value) {
                this._s3ReadPolicy = value;
                return this;
            }

            public Builder withSesBulkTemplatedCrudPolicy(@Nullable IResolvable value) {
                this._sesBulkTemplatedCrudPolicy = value;
                return this;
            }

            public Builder withSesBulkTemplatedCrudPolicy(@Nullable IdentitySAMPTProperty value) {
                this._sesBulkTemplatedCrudPolicy = value;
                return this;
            }

            public Builder withSesCrudPolicy(@Nullable IResolvable value) {
                this._sesCrudPolicy = value;
                return this;
            }

            public Builder withSesCrudPolicy(@Nullable IdentitySAMPTProperty value) {
                this._sesCrudPolicy = value;
                return this;
            }

            public Builder withSesEmailTemplateCrudPolicy(@Nullable IResolvable value) {
                this._sesEmailTemplateCrudPolicy = value;
                return this;
            }

            public Builder withSesEmailTemplateCrudPolicy(@Nullable EmptySAMPTProperty value) {
                this._sesEmailTemplateCrudPolicy = value;
                return this;
            }

            public Builder withSesSendBouncePolicy(@Nullable IResolvable value) {
                this._sesSendBouncePolicy = value;
                return this;
            }

            public Builder withSesSendBouncePolicy(@Nullable IdentitySAMPTProperty value) {
                this._sesSendBouncePolicy = value;
                return this;
            }

            public Builder withSnsCrudPolicy(@Nullable IResolvable value) {
                this._snsCrudPolicy = value;
                return this;
            }

            public Builder withSnsCrudPolicy(@Nullable TopicSAMPTProperty value) {
                this._snsCrudPolicy = value;
                return this;
            }

            public Builder withSnsPublishMessagePolicy(@Nullable IResolvable value) {
                this._snsPublishMessagePolicy = value;
                return this;
            }

            public Builder withSnsPublishMessagePolicy(@Nullable TopicSAMPTProperty value) {
                this._snsPublishMessagePolicy = value;
                return this;
            }

            public Builder withSqsPollerPolicy(@Nullable IResolvable value) {
                this._sqsPollerPolicy = value;
                return this;
            }

            public Builder withSqsPollerPolicy(@Nullable QueueSAMPTProperty value) {
                this._sqsPollerPolicy = value;
                return this;
            }

            public Builder withSqsSendMessagePolicy(@Nullable IResolvable value) {
                this._sqsSendMessagePolicy = value;
                return this;
            }

            public Builder withSqsSendMessagePolicy(@Nullable QueueSAMPTProperty value) {
                this._sqsSendMessagePolicy = value;
                return this;
            }

            public Builder withStepFunctionsExecutionPolicy(@Nullable IResolvable value) {
                this._stepFunctionsExecutionPolicy = value;
                return this;
            }

            public Builder withStepFunctionsExecutionPolicy(@Nullable StateMachineSAMPTProperty value) {
                this._stepFunctionsExecutionPolicy = value;
                return this;
            }

            public Builder withVpcAccessPolicy(@Nullable IResolvable value) {
                this._vpcAccessPolicy = value;
                return this;
            }

            public Builder withVpcAccessPolicy(@Nullable EmptySAMPTProperty value) {
                this._vpcAccessPolicy = value;
                return this;
            }

            public SAMPolicyTemplateProperty build() {
                return new SAMPolicyTemplateProperty(){
                    @Nullable
                    private final Object $amiDescribePolicy;
                    @Nullable
                    private final Object $cloudFormationDescribeStacksPolicy;
                    @Nullable
                    private final Object $cloudWatchPutMetricPolicy;
                    @Nullable
                    private final Object $dynamoDbCrudPolicy;
                    @Nullable
                    private final Object $dynamoDbReadPolicy;
                    @Nullable
                    private final Object $dynamoDbStreamReadPolicy;
                    @Nullable
                    private final Object $ec2DescribePolicy;
                    @Nullable
                    private final Object $elasticsearchHttpPostPolicy;
                    @Nullable
                    private final Object $filterLogEventsPolicy;
                    @Nullable
                    private final Object $kinesisCrudPolicy;
                    @Nullable
                    private final Object $kinesisStreamReadPolicy;
                    @Nullable
                    private final Object $kmsDecryptPolicy;
                    @Nullable
                    private final Object $lambdaInvokePolicy;
                    @Nullable
                    private final Object $rekognitionDetectOnlyPolicy;
                    @Nullable
                    private final Object $rekognitionLabelsPolicy;
                    @Nullable
                    private final Object $rekognitionNoDataAccessPolicy;
                    @Nullable
                    private final Object $rekognitionReadPolicy;
                    @Nullable
                    private final Object $rekognitionWriteOnlyAccessPolicy;
                    @Nullable
                    private final Object $s3CrudPolicy;
                    @Nullable
                    private final Object $s3ReadPolicy;
                    @Nullable
                    private final Object $sesBulkTemplatedCrudPolicy;
                    @Nullable
                    private final Object $sesCrudPolicy;
                    @Nullable
                    private final Object $sesEmailTemplateCrudPolicy;
                    @Nullable
                    private final Object $sesSendBouncePolicy;
                    @Nullable
                    private final Object $snsCrudPolicy;
                    @Nullable
                    private final Object $snsPublishMessagePolicy;
                    @Nullable
                    private final Object $sqsPollerPolicy;
                    @Nullable
                    private final Object $sqsSendMessagePolicy;
                    @Nullable
                    private final Object $stepFunctionsExecutionPolicy;
                    @Nullable
                    private final Object $vpcAccessPolicy;
                    {
                        this.$amiDescribePolicy = _amiDescribePolicy;
                        this.$cloudFormationDescribeStacksPolicy = _cloudFormationDescribeStacksPolicy;
                        this.$cloudWatchPutMetricPolicy = _cloudWatchPutMetricPolicy;
                        this.$dynamoDbCrudPolicy = _dynamoDbCrudPolicy;
                        this.$dynamoDbReadPolicy = _dynamoDbReadPolicy;
                        this.$dynamoDbStreamReadPolicy = _dynamoDbStreamReadPolicy;
                        this.$ec2DescribePolicy = _ec2DescribePolicy;
                        this.$elasticsearchHttpPostPolicy = _elasticsearchHttpPostPolicy;
                        this.$filterLogEventsPolicy = _filterLogEventsPolicy;
                        this.$kinesisCrudPolicy = _kinesisCrudPolicy;
                        this.$kinesisStreamReadPolicy = _kinesisStreamReadPolicy;
                        this.$kmsDecryptPolicy = _kmsDecryptPolicy;
                        this.$lambdaInvokePolicy = _lambdaInvokePolicy;
                        this.$rekognitionDetectOnlyPolicy = _rekognitionDetectOnlyPolicy;
                        this.$rekognitionLabelsPolicy = _rekognitionLabelsPolicy;
                        this.$rekognitionNoDataAccessPolicy = _rekognitionNoDataAccessPolicy;
                        this.$rekognitionReadPolicy = _rekognitionReadPolicy;
                        this.$rekognitionWriteOnlyAccessPolicy = _rekognitionWriteOnlyAccessPolicy;
                        this.$s3CrudPolicy = _s3CrudPolicy;
                        this.$s3ReadPolicy = _s3ReadPolicy;
                        this.$sesBulkTemplatedCrudPolicy = _sesBulkTemplatedCrudPolicy;
                        this.$sesCrudPolicy = _sesCrudPolicy;
                        this.$sesEmailTemplateCrudPolicy = _sesEmailTemplateCrudPolicy;
                        this.$sesSendBouncePolicy = _sesSendBouncePolicy;
                        this.$snsCrudPolicy = _snsCrudPolicy;
                        this.$snsPublishMessagePolicy = _snsPublishMessagePolicy;
                        this.$sqsPollerPolicy = _sqsPollerPolicy;
                        this.$sqsSendMessagePolicy = _sqsSendMessagePolicy;
                        this.$stepFunctionsExecutionPolicy = _stepFunctionsExecutionPolicy;
                        this.$vpcAccessPolicy = _vpcAccessPolicy;
                    }

                    @Override
                    public Object getAmiDescribePolicy() {
                        return this.$amiDescribePolicy;
                    }

                    @Override
                    public Object getCloudFormationDescribeStacksPolicy() {
                        return this.$cloudFormationDescribeStacksPolicy;
                    }

                    @Override
                    public Object getCloudWatchPutMetricPolicy() {
                        return this.$cloudWatchPutMetricPolicy;
                    }

                    @Override
                    public Object getDynamoDbCrudPolicy() {
                        return this.$dynamoDbCrudPolicy;
                    }

                    @Override
                    public Object getDynamoDbReadPolicy() {
                        return this.$dynamoDbReadPolicy;
                    }

                    @Override
                    public Object getDynamoDbStreamReadPolicy() {
                        return this.$dynamoDbStreamReadPolicy;
                    }

                    @Override
                    public Object getEc2DescribePolicy() {
                        return this.$ec2DescribePolicy;
                    }

                    @Override
                    public Object getElasticsearchHttpPostPolicy() {
                        return this.$elasticsearchHttpPostPolicy;
                    }

                    @Override
                    public Object getFilterLogEventsPolicy() {
                        return this.$filterLogEventsPolicy;
                    }

                    @Override
                    public Object getKinesisCrudPolicy() {
                        return this.$kinesisCrudPolicy;
                    }

                    @Override
                    public Object getKinesisStreamReadPolicy() {
                        return this.$kinesisStreamReadPolicy;
                    }

                    @Override
                    public Object getKmsDecryptPolicy() {
                        return this.$kmsDecryptPolicy;
                    }

                    @Override
                    public Object getLambdaInvokePolicy() {
                        return this.$lambdaInvokePolicy;
                    }

                    @Override
                    public Object getRekognitionDetectOnlyPolicy() {
                        return this.$rekognitionDetectOnlyPolicy;
                    }

                    @Override
                    public Object getRekognitionLabelsPolicy() {
                        return this.$rekognitionLabelsPolicy;
                    }

                    @Override
                    public Object getRekognitionNoDataAccessPolicy() {
                        return this.$rekognitionNoDataAccessPolicy;
                    }

                    @Override
                    public Object getRekognitionReadPolicy() {
                        return this.$rekognitionReadPolicy;
                    }

                    @Override
                    public Object getRekognitionWriteOnlyAccessPolicy() {
                        return this.$rekognitionWriteOnlyAccessPolicy;
                    }

                    @Override
                    public Object getS3CrudPolicy() {
                        return this.$s3CrudPolicy;
                    }

                    @Override
                    public Object getS3ReadPolicy() {
                        return this.$s3ReadPolicy;
                    }

                    @Override
                    public Object getSesBulkTemplatedCrudPolicy() {
                        return this.$sesBulkTemplatedCrudPolicy;
                    }

                    @Override
                    public Object getSesCrudPolicy() {
                        return this.$sesCrudPolicy;
                    }

                    @Override
                    public Object getSesEmailTemplateCrudPolicy() {
                        return this.$sesEmailTemplateCrudPolicy;
                    }

                    @Override
                    public Object getSesSendBouncePolicy() {
                        return this.$sesSendBouncePolicy;
                    }

                    @Override
                    public Object getSnsCrudPolicy() {
                        return this.$snsCrudPolicy;
                    }

                    @Override
                    public Object getSnsPublishMessagePolicy() {
                        return this.$snsPublishMessagePolicy;
                    }

                    @Override
                    public Object getSqsPollerPolicy() {
                        return this.$sqsPollerPolicy;
                    }

                    @Override
                    public Object getSqsSendMessagePolicy() {
                        return this.$sqsSendMessagePolicy;
                    }

                    @Override
                    public Object getStepFunctionsExecutionPolicy() {
                        return this.$stepFunctionsExecutionPolicy;
                    }

                    @Override
                    public Object getVpcAccessPolicy() {
                        return this.$vpcAccessPolicy;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        if (this.getAmiDescribePolicy() != null) {
                            obj.set("amiDescribePolicy", om.valueToTree(this.getAmiDescribePolicy()));
                        }
                        if (this.getCloudFormationDescribeStacksPolicy() != null) {
                            obj.set("cloudFormationDescribeStacksPolicy", om.valueToTree(this.getCloudFormationDescribeStacksPolicy()));
                        }
                        if (this.getCloudWatchPutMetricPolicy() != null) {
                            obj.set("cloudWatchPutMetricPolicy", om.valueToTree(this.getCloudWatchPutMetricPolicy()));
                        }
                        if (this.getDynamoDbCrudPolicy() != null) {
                            obj.set("dynamoDbCrudPolicy", om.valueToTree(this.getDynamoDbCrudPolicy()));
                        }
                        if (this.getDynamoDbReadPolicy() != null) {
                            obj.set("dynamoDbReadPolicy", om.valueToTree(this.getDynamoDbReadPolicy()));
                        }
                        if (this.getDynamoDbStreamReadPolicy() != null) {
                            obj.set("dynamoDbStreamReadPolicy", om.valueToTree(this.getDynamoDbStreamReadPolicy()));
                        }
                        if (this.getEc2DescribePolicy() != null) {
                            obj.set("ec2DescribePolicy", om.valueToTree(this.getEc2DescribePolicy()));
                        }
                        if (this.getElasticsearchHttpPostPolicy() != null) {
                            obj.set("elasticsearchHttpPostPolicy", om.valueToTree(this.getElasticsearchHttpPostPolicy()));
                        }
                        if (this.getFilterLogEventsPolicy() != null) {
                            obj.set("filterLogEventsPolicy", om.valueToTree(this.getFilterLogEventsPolicy()));
                        }
                        if (this.getKinesisCrudPolicy() != null) {
                            obj.set("kinesisCrudPolicy", om.valueToTree(this.getKinesisCrudPolicy()));
                        }
                        if (this.getKinesisStreamReadPolicy() != null) {
                            obj.set("kinesisStreamReadPolicy", om.valueToTree(this.getKinesisStreamReadPolicy()));
                        }
                        if (this.getKmsDecryptPolicy() != null) {
                            obj.set("kmsDecryptPolicy", om.valueToTree(this.getKmsDecryptPolicy()));
                        }
                        if (this.getLambdaInvokePolicy() != null) {
                            obj.set("lambdaInvokePolicy", om.valueToTree(this.getLambdaInvokePolicy()));
                        }
                        if (this.getRekognitionDetectOnlyPolicy() != null) {
                            obj.set("rekognitionDetectOnlyPolicy", om.valueToTree(this.getRekognitionDetectOnlyPolicy()));
                        }
                        if (this.getRekognitionLabelsPolicy() != null) {
                            obj.set("rekognitionLabelsPolicy", om.valueToTree(this.getRekognitionLabelsPolicy()));
                        }
                        if (this.getRekognitionNoDataAccessPolicy() != null) {
                            obj.set("rekognitionNoDataAccessPolicy", om.valueToTree(this.getRekognitionNoDataAccessPolicy()));
                        }
                        if (this.getRekognitionReadPolicy() != null) {
                            obj.set("rekognitionReadPolicy", om.valueToTree(this.getRekognitionReadPolicy()));
                        }
                        if (this.getRekognitionWriteOnlyAccessPolicy() != null) {
                            obj.set("rekognitionWriteOnlyAccessPolicy", om.valueToTree(this.getRekognitionWriteOnlyAccessPolicy()));
                        }
                        if (this.getS3CrudPolicy() != null) {
                            obj.set("s3CrudPolicy", om.valueToTree(this.getS3CrudPolicy()));
                        }
                        if (this.getS3ReadPolicy() != null) {
                            obj.set("s3ReadPolicy", om.valueToTree(this.getS3ReadPolicy()));
                        }
                        if (this.getSesBulkTemplatedCrudPolicy() != null) {
                            obj.set("sesBulkTemplatedCrudPolicy", om.valueToTree(this.getSesBulkTemplatedCrudPolicy()));
                        }
                        if (this.getSesCrudPolicy() != null) {
                            obj.set("sesCrudPolicy", om.valueToTree(this.getSesCrudPolicy()));
                        }
                        if (this.getSesEmailTemplateCrudPolicy() != null) {
                            obj.set("sesEmailTemplateCrudPolicy", om.valueToTree(this.getSesEmailTemplateCrudPolicy()));
                        }
                        if (this.getSesSendBouncePolicy() != null) {
                            obj.set("sesSendBouncePolicy", om.valueToTree(this.getSesSendBouncePolicy()));
                        }
                        if (this.getSnsCrudPolicy() != null) {
                            obj.set("snsCrudPolicy", om.valueToTree(this.getSnsCrudPolicy()));
                        }
                        if (this.getSnsPublishMessagePolicy() != null) {
                            obj.set("snsPublishMessagePolicy", om.valueToTree(this.getSnsPublishMessagePolicy()));
                        }
                        if (this.getSqsPollerPolicy() != null) {
                            obj.set("sqsPollerPolicy", om.valueToTree(this.getSqsPollerPolicy()));
                        }
                        if (this.getSqsSendMessagePolicy() != null) {
                            obj.set("sqsSendMessagePolicy", om.valueToTree(this.getSqsSendMessagePolicy()));
                        }
                        if (this.getStepFunctionsExecutionPolicy() != null) {
                            obj.set("stepFunctionsExecutionPolicy", om.valueToTree(this.getStepFunctionsExecutionPolicy()));
                        }
                        if (this.getVpcAccessPolicy() != null) {
                            obj.set("vpcAccessPolicy", om.valueToTree(this.getVpcAccessPolicy()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface S3NotificationFilterProperty
    extends JsiiSerializable {
        public String getS3Key();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _s3Key;

            public Builder withS3Key(String value) {
                this._s3Key = Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            public S3NotificationFilterProperty build() {
                return new S3NotificationFilterProperty(){
                    private final String $s3Key;
                    {
                        this.$s3Key = Objects.requireNonNull(_s3Key, "s3Key is required");
                    }

                    @Override
                    public String getS3Key() {
                        return this.$s3Key;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("s3Key", om.valueToTree((Object)this.getS3Key()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface S3LocationProperty
    extends JsiiSerializable {
        public String getBucket();

        public String getKey();

        public Number getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _bucket;
            private String _key;
            @Nullable
            private Number _version;

            public Builder withBucket(String value) {
                this._bucket = Objects.requireNonNull(value, "bucket is required");
                return this;
            }

            public Builder withKey(String value) {
                this._key = Objects.requireNonNull(value, "key is required");
                return this;
            }

            public Builder withVersion(@Nullable Number value) {
                this._version = value;
                return this;
            }

            public S3LocationProperty build() {
                return new S3LocationProperty(){
                    private final String $bucket;
                    private final String $key;
                    @Nullable
                    private final Number $version;
                    {
                        this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                        this.$key = Objects.requireNonNull(_key, "key is required");
                        this.$version = _version;
                    }

                    @Override
                    public String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public String getKey() {
                        return this.$key;
                    }

                    @Override
                    public Number getVersion() {
                        return this.$version;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree((Object)this.getBucket()));
                        obj.set("key", om.valueToTree((Object)this.getKey()));
                        if (this.getVersion() != null) {
                            obj.set("version", om.valueToTree((Object)this.getVersion()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface S3EventProperty
    extends JsiiSerializable {
        public String getBucket();

        public Object getEvents();

        public Object getFilter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _bucket;
            private Object _events;
            @Nullable
            private Object _filter;

            public Builder withBucket(String value) {
                this._bucket = Objects.requireNonNull(value, "bucket is required");
                return this;
            }

            public Builder withEvents(String value) {
                this._events = Objects.requireNonNull(value, "events is required");
                return this;
            }

            public Builder withEvents(IResolvable value) {
                this._events = Objects.requireNonNull(value, "events is required");
                return this;
            }

            public Builder withEvents(List<String> value) {
                this._events = Objects.requireNonNull(value, "events is required");
                return this;
            }

            public Builder withFilter(@Nullable IResolvable value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable S3NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public S3EventProperty build() {
                return new S3EventProperty(){
                    private final String $bucket;
                    private final Object $events;
                    @Nullable
                    private final Object $filter;
                    {
                        this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                        this.$events = Objects.requireNonNull(_events, "events is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public Object getEvents() {
                        return this.$events;
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree((Object)this.getBucket()));
                        obj.set("events", om.valueToTree(this.getEvents()));
                        if (this.getFilter() != null) {
                            obj.set("filter", om.valueToTree(this.getFilter()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface QueueSAMPTProperty
    extends JsiiSerializable {
        public String getQueueName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _queueName;

            public Builder withQueueName(String value) {
                this._queueName = Objects.requireNonNull(value, "queueName is required");
                return this;
            }

            public QueueSAMPTProperty build() {
                return new QueueSAMPTProperty(){
                    private final String $queueName;
                    {
                        this.$queueName = Objects.requireNonNull(_queueName, "queueName is required");
                    }

                    @Override
                    public String getQueueName() {
                        return this.$queueName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("queueName", om.valueToTree((Object)this.getQueueName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface LogGroupSAMPTProperty
    extends JsiiSerializable {
        public String getLogGroupName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _logGroupName;

            public Builder withLogGroupName(String value) {
                this._logGroupName = Objects.requireNonNull(value, "logGroupName is required");
                return this;
            }

            public LogGroupSAMPTProperty build() {
                return new LogGroupSAMPTProperty(){
                    private final String $logGroupName;
                    {
                        this.$logGroupName = Objects.requireNonNull(_logGroupName, "logGroupName is required");
                    }

                    @Override
                    public String getLogGroupName() {
                        return this.$logGroupName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("logGroupName", om.valueToTree((Object)this.getLogGroupName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface KinesisEventProperty
    extends JsiiSerializable {
        public String getStartingPosition();

        public String getStream();

        public Number getBatchSize();

        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _startingPosition;
            private String _stream;
            @Nullable
            private Number _batchSize;
            @Nullable
            private Object _enabled;

            public Builder withStartingPosition(String value) {
                this._startingPosition = Objects.requireNonNull(value, "startingPosition is required");
                return this;
            }

            public Builder withStream(String value) {
                this._stream = Objects.requireNonNull(value, "stream is required");
                return this;
            }

            public Builder withBatchSize(@Nullable Number value) {
                this._batchSize = value;
                return this;
            }

            public Builder withEnabled(@Nullable Boolean value) {
                this._enabled = value;
                return this;
            }

            public Builder withEnabled(@Nullable IResolvable value) {
                this._enabled = value;
                return this;
            }

            public KinesisEventProperty build() {
                return new KinesisEventProperty(){
                    private final String $startingPosition;
                    private final String $stream;
                    @Nullable
                    private final Number $batchSize;
                    @Nullable
                    private final Object $enabled;
                    {
                        this.$startingPosition = Objects.requireNonNull(_startingPosition, "startingPosition is required");
                        this.$stream = Objects.requireNonNull(_stream, "stream is required");
                        this.$batchSize = _batchSize;
                        this.$enabled = _enabled;
                    }

                    @Override
                    public String getStartingPosition() {
                        return this.$startingPosition;
                    }

                    @Override
                    public String getStream() {
                        return this.$stream;
                    }

                    @Override
                    public Number getBatchSize() {
                        return this.$batchSize;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("startingPosition", om.valueToTree((Object)this.getStartingPosition()));
                        obj.set("stream", om.valueToTree((Object)this.getStream()));
                        if (this.getBatchSize() != null) {
                            obj.set("batchSize", om.valueToTree((Object)this.getBatchSize()));
                        }
                        if (this.getEnabled() != null) {
                            obj.set("enabled", om.valueToTree(this.getEnabled()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface KeySAMPTProperty
    extends JsiiSerializable {
        public String getKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _keyId;

            public Builder withKeyId(String value) {
                this._keyId = Objects.requireNonNull(value, "keyId is required");
                return this;
            }

            public KeySAMPTProperty build() {
                return new KeySAMPTProperty(){
                    private final String $keyId;
                    {
                        this.$keyId = Objects.requireNonNull(_keyId, "keyId is required");
                    }

                    @Override
                    public String getKeyId() {
                        return this.$keyId;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("keyId", om.valueToTree((Object)this.getKeyId()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface IoTRuleEventProperty
    extends JsiiSerializable {
        public String getSql();

        public String getAwsIotSqlVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _sql;
            @Nullable
            private String _awsIotSqlVersion;

            public Builder withSql(String value) {
                this._sql = Objects.requireNonNull(value, "sql is required");
                return this;
            }

            public Builder withAwsIotSqlVersion(@Nullable String value) {
                this._awsIotSqlVersion = value;
                return this;
            }

            public IoTRuleEventProperty build() {
                return new IoTRuleEventProperty(){
                    private final String $sql;
                    @Nullable
                    private final String $awsIotSqlVersion;
                    {
                        this.$sql = Objects.requireNonNull(_sql, "sql is required");
                        this.$awsIotSqlVersion = _awsIotSqlVersion;
                    }

                    @Override
                    public String getSql() {
                        return this.$sql;
                    }

                    @Override
                    public String getAwsIotSqlVersion() {
                        return this.$awsIotSqlVersion;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("sql", om.valueToTree((Object)this.getSql()));
                        if (this.getAwsIotSqlVersion() != null) {
                            obj.set("awsIotSqlVersion", om.valueToTree((Object)this.getAwsIotSqlVersion()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface IdentitySAMPTProperty
    extends JsiiSerializable {
        public String getIdentityName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _identityName;

            public Builder withIdentityName(String value) {
                this._identityName = Objects.requireNonNull(value, "identityName is required");
                return this;
            }

            public IdentitySAMPTProperty build() {
                return new IdentitySAMPTProperty(){
                    private final String $identityName;
                    {
                        this.$identityName = Objects.requireNonNull(_identityName, "identityName is required");
                    }

                    @Override
                    public String getIdentityName() {
                        return this.$identityName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("identityName", om.valueToTree((Object)this.getIdentityName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface IAMPolicyDocumentProperty
    extends JsiiSerializable {
        public Object getStatement();
    }

    public static interface FunctionSAMPTProperty
    extends JsiiSerializable {
        public String getFunctionName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _functionName;

            public Builder withFunctionName(String value) {
                this._functionName = Objects.requireNonNull(value, "functionName is required");
                return this;
            }

            public FunctionSAMPTProperty build() {
                return new FunctionSAMPTProperty(){
                    private final String $functionName;
                    {
                        this.$functionName = Objects.requireNonNull(_functionName, "functionName is required");
                    }

                    @Override
                    public String getFunctionName() {
                        return this.$functionName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("functionName", om.valueToTree((Object)this.getFunctionName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface FunctionEnvironmentProperty
    extends JsiiSerializable {
        public Object getVariables();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _variables;

            public Builder withVariables(IResolvable value) {
                this._variables = Objects.requireNonNull(value, "variables is required");
                return this;
            }

            public Builder withVariables(Map<String, String> value) {
                this._variables = Objects.requireNonNull(value, "variables is required");
                return this;
            }

            public FunctionEnvironmentProperty build() {
                return new FunctionEnvironmentProperty(){
                    private final Object $variables;
                    {
                        this.$variables = Objects.requireNonNull(_variables, "variables is required");
                    }

                    @Override
                    public Object getVariables() {
                        return this.$variables;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("variables", om.valueToTree(this.getVariables()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface EventSourceProperty
    extends JsiiSerializable {
        public Object getProperties();

        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _properties;
            private String _type;

            public Builder withProperties(IResolvable value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(AlexaSkillEventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(ApiEventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(CloudWatchEventEventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(DynamoDBEventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(S3EventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(SNSEventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(SQSEventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(KinesisEventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(ScheduleEventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withProperties(IoTRuleEventProperty value) {
                this._properties = Objects.requireNonNull(value, "properties is required");
                return this;
            }

            public Builder withType(String value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public EventSourceProperty build() {
                return new EventSourceProperty(){
                    private final Object $properties;
                    private final String $type;
                    {
                        this.$properties = Objects.requireNonNull(_properties, "properties is required");
                        this.$type = Objects.requireNonNull(_type, "type is required");
                    }

                    @Override
                    public Object getProperties() {
                        return this.$properties;
                    }

                    @Override
                    public String getType() {
                        return this.$type;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("properties", om.valueToTree(this.getProperties()));
                        obj.set("type", om.valueToTree((Object)this.getType()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface EmptySAMPTProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public EmptySAMPTProperty build() {
                return new EmptySAMPTProperty(){

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        return obj;
                    }
                };
            }
        }
    }

    public static interface DynamoDBEventProperty
    extends JsiiSerializable {
        public String getStartingPosition();

        public String getStream();

        public Number getBatchSize();

        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _startingPosition;
            private String _stream;
            @Nullable
            private Number _batchSize;
            @Nullable
            private Object _enabled;

            public Builder withStartingPosition(String value) {
                this._startingPosition = Objects.requireNonNull(value, "startingPosition is required");
                return this;
            }

            public Builder withStream(String value) {
                this._stream = Objects.requireNonNull(value, "stream is required");
                return this;
            }

            public Builder withBatchSize(@Nullable Number value) {
                this._batchSize = value;
                return this;
            }

            public Builder withEnabled(@Nullable Boolean value) {
                this._enabled = value;
                return this;
            }

            public Builder withEnabled(@Nullable IResolvable value) {
                this._enabled = value;
                return this;
            }

            public DynamoDBEventProperty build() {
                return new DynamoDBEventProperty(){
                    private final String $startingPosition;
                    private final String $stream;
                    @Nullable
                    private final Number $batchSize;
                    @Nullable
                    private final Object $enabled;
                    {
                        this.$startingPosition = Objects.requireNonNull(_startingPosition, "startingPosition is required");
                        this.$stream = Objects.requireNonNull(_stream, "stream is required");
                        this.$batchSize = _batchSize;
                        this.$enabled = _enabled;
                    }

                    @Override
                    public String getStartingPosition() {
                        return this.$startingPosition;
                    }

                    @Override
                    public String getStream() {
                        return this.$stream;
                    }

                    @Override
                    public Number getBatchSize() {
                        return this.$batchSize;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("startingPosition", om.valueToTree((Object)this.getStartingPosition()));
                        obj.set("stream", om.valueToTree((Object)this.getStream()));
                        if (this.getBatchSize() != null) {
                            obj.set("batchSize", om.valueToTree((Object)this.getBatchSize()));
                        }
                        if (this.getEnabled() != null) {
                            obj.set("enabled", om.valueToTree(this.getEnabled()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface DomainSAMPTProperty
    extends JsiiSerializable {
        public String getDomainName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _domainName;

            public Builder withDomainName(String value) {
                this._domainName = Objects.requireNonNull(value, "domainName is required");
                return this;
            }

            public DomainSAMPTProperty build() {
                return new DomainSAMPTProperty(){
                    private final String $domainName;
                    {
                        this.$domainName = Objects.requireNonNull(_domainName, "domainName is required");
                    }

                    @Override
                    public String getDomainName() {
                        return this.$domainName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("domainName", om.valueToTree((Object)this.getDomainName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface DeploymentPreferenceProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public String getType();

        public List<String> getAlarms();

        public List<String> getHooks();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _enabled;
            private String _type;
            @Nullable
            private List<String> _alarms;
            @Nullable
            private List<String> _hooks;

            public Builder withEnabled(Boolean value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withEnabled(IResolvable value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withType(String value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withAlarms(@Nullable List<String> value) {
                this._alarms = value;
                return this;
            }

            public Builder withHooks(@Nullable List<String> value) {
                this._hooks = value;
                return this;
            }

            public DeploymentPreferenceProperty build() {
                return new DeploymentPreferenceProperty(){
                    private final Object $enabled;
                    private final String $type;
                    @Nullable
                    private final List<String> $alarms;
                    @Nullable
                    private final List<String> $hooks;
                    {
                        this.$enabled = Objects.requireNonNull(_enabled, "enabled is required");
                        this.$type = Objects.requireNonNull(_type, "type is required");
                        this.$alarms = _alarms;
                        this.$hooks = _hooks;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public String getType() {
                        return this.$type;
                    }

                    @Override
                    public List<String> getAlarms() {
                        return this.$alarms;
                    }

                    @Override
                    public List<String> getHooks() {
                        return this.$hooks;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        obj.set("type", om.valueToTree((Object)this.getType()));
                        if (this.getAlarms() != null) {
                            obj.set("alarms", om.valueToTree(this.getAlarms()));
                        }
                        if (this.getHooks() != null) {
                            obj.set("hooks", om.valueToTree(this.getHooks()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface DeadLetterQueueProperty
    extends JsiiSerializable {
        public String getTargetArn();

        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _targetArn;
            private String _type;

            public Builder withTargetArn(String value) {
                this._targetArn = Objects.requireNonNull(value, "targetArn is required");
                return this;
            }

            public Builder withType(String value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public DeadLetterQueueProperty build() {
                return new DeadLetterQueueProperty(){
                    private final String $targetArn;
                    private final String $type;
                    {
                        this.$targetArn = Objects.requireNonNull(_targetArn, "targetArn is required");
                        this.$type = Objects.requireNonNull(_type, "type is required");
                    }

                    @Override
                    public String getTargetArn() {
                        return this.$targetArn;
                    }

                    @Override
                    public String getType() {
                        return this.$type;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("targetArn", om.valueToTree((Object)this.getTargetArn()));
                        obj.set("type", om.valueToTree((Object)this.getType()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface CollectionSAMPTProperty
    extends JsiiSerializable {
        public String getCollectionId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _collectionId;

            public Builder withCollectionId(String value) {
                this._collectionId = Objects.requireNonNull(value, "collectionId is required");
                return this;
            }

            public CollectionSAMPTProperty build() {
                return new CollectionSAMPTProperty(){
                    private final String $collectionId;
                    {
                        this.$collectionId = Objects.requireNonNull(_collectionId, "collectionId is required");
                    }

                    @Override
                    public String getCollectionId() {
                        return this.$collectionId;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("collectionId", om.valueToTree((Object)this.getCollectionId()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface CloudWatchEventEventProperty
    extends JsiiSerializable {
        public Object getPattern();

        public String getInput();

        public String getInputPath();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _pattern;
            @Nullable
            private String _input;
            @Nullable
            private String _inputPath;

            public Builder withPattern(ObjectNode value) {
                this._pattern = Objects.requireNonNull(value, "pattern is required");
                return this;
            }

            public Builder withPattern(IResolvable value) {
                this._pattern = Objects.requireNonNull(value, "pattern is required");
                return this;
            }

            public Builder withInput(@Nullable String value) {
                this._input = value;
                return this;
            }

            public Builder withInputPath(@Nullable String value) {
                this._inputPath = value;
                return this;
            }

            public CloudWatchEventEventProperty build() {
                return new CloudWatchEventEventProperty(){
                    private final Object $pattern;
                    @Nullable
                    private final String $input;
                    @Nullable
                    private final String $inputPath;
                    {
                        this.$pattern = Objects.requireNonNull(_pattern, "pattern is required");
                        this.$input = _input;
                        this.$inputPath = _inputPath;
                    }

                    @Override
                    public Object getPattern() {
                        return this.$pattern;
                    }

                    @Override
                    public String getInput() {
                        return this.$input;
                    }

                    @Override
                    public String getInputPath() {
                        return this.$inputPath;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("pattern", om.valueToTree(this.getPattern()));
                        if (this.getInput() != null) {
                            obj.set("input", om.valueToTree((Object)this.getInput()));
                        }
                        if (this.getInputPath() != null) {
                            obj.set("inputPath", om.valueToTree((Object)this.getInputPath()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface BucketSAMPTProperty
    extends JsiiSerializable {
        public String getBucketName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _bucketName;

            public Builder withBucketName(String value) {
                this._bucketName = Objects.requireNonNull(value, "bucketName is required");
                return this;
            }

            public BucketSAMPTProperty build() {
                return new BucketSAMPTProperty(){
                    private final String $bucketName;
                    {
                        this.$bucketName = Objects.requireNonNull(_bucketName, "bucketName is required");
                    }

                    @Override
                    public String getBucketName() {
                        return this.$bucketName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("bucketName", om.valueToTree((Object)this.getBucketName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ApiEventProperty
    extends JsiiSerializable {
        public String getMethod();

        public String getPath();

        public String getRestApiId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _method;
            private String _path;
            @Nullable
            private String _restApiId;

            public Builder withMethod(String value) {
                this._method = Objects.requireNonNull(value, "method is required");
                return this;
            }

            public Builder withPath(String value) {
                this._path = Objects.requireNonNull(value, "path is required");
                return this;
            }

            public Builder withRestApiId(@Nullable String value) {
                this._restApiId = value;
                return this;
            }

            public ApiEventProperty build() {
                return new ApiEventProperty(){
                    private final String $method;
                    private final String $path;
                    @Nullable
                    private final String $restApiId;
                    {
                        this.$method = Objects.requireNonNull(_method, "method is required");
                        this.$path = Objects.requireNonNull(_path, "path is required");
                        this.$restApiId = _restApiId;
                    }

                    @Override
                    public String getMethod() {
                        return this.$method;
                    }

                    @Override
                    public String getPath() {
                        return this.$path;
                    }

                    @Override
                    public String getRestApiId() {
                        return this.$restApiId;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("method", om.valueToTree((Object)this.getMethod()));
                        obj.set("path", om.valueToTree((Object)this.getPath()));
                        if (this.getRestApiId() != null) {
                            obj.set("restApiId", om.valueToTree((Object)this.getRestApiId()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface AlexaSkillEventProperty
    extends JsiiSerializable {
        public Object getVariables();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _variables;

            public Builder withVariables(@Nullable IResolvable value) {
                this._variables = value;
                return this;
            }

            public Builder withVariables(@Nullable Map<String, String> value) {
                this._variables = value;
                return this;
            }

            public AlexaSkillEventProperty build() {
                return new AlexaSkillEventProperty(){
                    @Nullable
                    private final Object $variables;
                    {
                        this.$variables = _variables;
                    }

                    @Override
                    public Object getVariables() {
                        return this.$variables;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        if (this.getVariables() != null) {
                            obj.set("variables", om.valueToTree(this.getVariables()));
                        }
                        return obj;
                    }
                };
            }
        }
    }
}

