/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.sam.CfnApplication;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnApplicationProps
extends JsiiSerializable {
    public Object getLocation();

    public List<String> getNotificationArns();

    public Object getParameters();

    public Map<String, String> getTags();

    public Object getTimeoutInMinutes();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object _location;
        @Nullable
        private List<String> _notificationArns;
        @Nullable
        private Object _parameters;
        @Nullable
        private Map<String, String> _tags;
        @Nullable
        private Object _timeoutInMinutes;

        public Builder withLocation(String value) {
            this._location = Objects.requireNonNull(value, "location is required");
            return this;
        }

        public Builder withLocation(Token value) {
            this._location = Objects.requireNonNull(value, "location is required");
            return this;
        }

        public Builder withLocation(CfnApplication.ApplicationLocationProperty value) {
            this._location = Objects.requireNonNull(value, "location is required");
            return this;
        }

        public Builder withNotificationArns(@Nullable List<String> value) {
            this._notificationArns = value;
            return this;
        }

        public Builder withParameters(@Nullable Token value) {
            this._parameters = value;
            return this;
        }

        public Builder withParameters(@Nullable Map<String, String> value) {
            this._parameters = value;
            return this;
        }

        public Builder withTags(@Nullable Map<String, String> value) {
            this._tags = value;
            return this;
        }

        public Builder withTimeoutInMinutes(@Nullable Number value) {
            this._timeoutInMinutes = value;
            return this;
        }

        public Builder withTimeoutInMinutes(@Nullable Token value) {
            this._timeoutInMinutes = value;
            return this;
        }

        public CfnApplicationProps build() {
            return new CfnApplicationProps(){
                private final Object $location;
                @Nullable
                private final List<String> $notificationArns;
                @Nullable
                private final Object $parameters;
                @Nullable
                private final Map<String, String> $tags;
                @Nullable
                private final Object $timeoutInMinutes;
                {
                    this.$location = Objects.requireNonNull(_location, "location is required");
                    this.$notificationArns = _notificationArns;
                    this.$parameters = _parameters;
                    this.$tags = _tags;
                    this.$timeoutInMinutes = _timeoutInMinutes;
                }

                @Override
                public Object getLocation() {
                    return this.$location;
                }

                @Override
                public List<String> getNotificationArns() {
                    return this.$notificationArns;
                }

                @Override
                public Object getParameters() {
                    return this.$parameters;
                }

                @Override
                public Map<String, String> getTags() {
                    return this.$tags;
                }

                @Override
                public Object getTimeoutInMinutes() {
                    return this.$timeoutInMinutes;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("location", om.valueToTree(this.getLocation()));
                    obj.set("notificationArns", om.valueToTree(this.getNotificationArns()));
                    obj.set("parameters", om.valueToTree(this.getParameters()));
                    obj.set("tags", om.valueToTree(this.getTags()));
                    obj.set("timeoutInMinutes", om.valueToTree(this.getTimeoutInMinutes()));
                    return obj;
                }
            };
        }
    }
}

