/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sagemaker.$Module;
import software.amazon.awscdk.services.sagemaker.CfnModelCard;
import software.amazon.awscdk.services.sagemaker.CfnModelCardProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard")
public class CfnModelCard
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnModelCard.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnModelCard(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnModelCard(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnModelCard(@NotNull Construct scope, @NotNull String id, @NotNull CfnModelCardProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreatedByDomainId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrCreatedByDomainId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreatedByUserProfileArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrCreatedByUserProfileArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreatedByUserProfileName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrCreatedByUserProfileName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreationTime() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastModifiedByDomainId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrLastModifiedByDomainId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastModifiedByUserProfileArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrLastModifiedByUserProfileArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastModifiedByUserProfileName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrLastModifiedByUserProfileName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastModifiedTime() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrLastModifiedTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrModelCardArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrModelCardArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrModelCardProcessingStatus() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrModelCardProcessingStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getAttrModelCardVersion() {
        return (Number)Kernel.get((Object)((Object)this), (String)"attrModelCardVersion", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public Object getContent() {
        return Kernel.get((Object)((Object)this), (String)"content", (NativeType)NativeType.forClass(Object.class));
    }

    public void setContent(@NotNull IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"content", (Object)Objects.requireNonNull(value, "content is required"));
    }

    public void setContent(@NotNull ContentProperty value) {
        Kernel.set((Object)((Object)this), (String)"content", (Object)Objects.requireNonNull(value, "content is required"));
    }

    @NotNull
    public String getModelCardName() {
        return (String)Kernel.get((Object)((Object)this), (String)"modelCardName", (NativeType)NativeType.forClass(String.class));
    }

    public void setModelCardName(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"modelCardName", (Object)Objects.requireNonNull(value, "modelCardName is required"));
    }

    @NotNull
    public String getModelCardStatus() {
        return (String)Kernel.get((Object)((Object)this), (String)"modelCardStatus", (NativeType)NativeType.forClass(String.class));
    }

    public void setModelCardStatus(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"modelCardStatus", (Object)Objects.requireNonNull(value, "modelCardStatus is required"));
    }

    @Nullable
    public Object getCreatedBy() {
        return Kernel.get((Object)((Object)this), (String)"createdBy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCreatedBy(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"createdBy", (Object)value);
    }

    public void setCreatedBy(@Nullable UserContextProperty value) {
        Kernel.set((Object)((Object)this), (String)"createdBy", (Object)value);
    }

    @Nullable
    public Object getLastModifiedBy() {
        return Kernel.get((Object)((Object)this), (String)"lastModifiedBy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLastModifiedBy(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"lastModifiedBy", (Object)value);
    }

    public void setLastModifiedBy(@Nullable UserContextProperty value) {
        Kernel.set((Object)((Object)this), (String)"lastModifiedBy", (Object)value);
    }

    @Nullable
    public Object getSecurityConfig() {
        return Kernel.get((Object)((Object)this), (String)"securityConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSecurityConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"securityConfig", (Object)value);
    }

    public void setSecurityConfig(@Nullable SecurityConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"securityConfig", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnModelCard> {
        private final Construct scope;
        private final String id;
        private final CfnModelCardProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnModelCardProps.Builder();
        }

        public Builder content(IResolvable content) {
            this.props.content(content);
            return this;
        }

        public Builder content(ContentProperty content) {
            this.props.content(content);
            return this;
        }

        public Builder modelCardName(String modelCardName) {
            this.props.modelCardName(modelCardName);
            return this;
        }

        public Builder modelCardStatus(String modelCardStatus) {
            this.props.modelCardStatus(modelCardStatus);
            return this;
        }

        public Builder createdBy(IResolvable createdBy) {
            this.props.createdBy(createdBy);
            return this;
        }

        public Builder createdBy(UserContextProperty createdBy) {
            this.props.createdBy(createdBy);
            return this;
        }

        public Builder lastModifiedBy(IResolvable lastModifiedBy) {
            this.props.lastModifiedBy(lastModifiedBy);
            return this;
        }

        public Builder lastModifiedBy(UserContextProperty lastModifiedBy) {
            this.props.lastModifiedBy(lastModifiedBy);
            return this;
        }

        public Builder securityConfig(IResolvable securityConfig) {
            this.props.securityConfig(securityConfig);
            return this;
        }

        public Builder securityConfig(SecurityConfigProperty securityConfig) {
            this.props.securityConfig(securityConfig);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnModelCard build() {
            return new CfnModelCard(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.UserContextProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UserContextProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDomainId() {
            return null;
        }

        @Nullable
        default public String getUserProfileArn() {
            return null;
        }

        @Nullable
        default public String getUserProfileName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UserContextProperty> {
            String domainId;
            String userProfileArn;
            String userProfileName;

            public Builder domainId(String domainId) {
                this.domainId = domainId;
                return this;
            }

            public Builder userProfileArn(String userProfileArn) {
                this.userProfileArn = userProfileArn;
                return this;
            }

            public Builder userProfileName(String userProfileName) {
                this.userProfileName = userProfileName;
                return this;
            }

            public UserContextProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.TrainingMetricProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrainingMetricProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public Number getValue();

        @Nullable
        default public String getNotes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrainingMetricProperty> {
            String name;
            Number value;
            String notes;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public Builder notes(String notes) {
                this.notes = notes;
                return this;
            }

            public TrainingMetricProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.TrainingJobDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrainingJobDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHyperParameters() {
            return null;
        }

        @Nullable
        default public String getTrainingArn() {
            return null;
        }

        @Nullable
        default public List<String> getTrainingDatasets() {
            return null;
        }

        @Nullable
        default public Object getTrainingEnvironment() {
            return null;
        }

        @Nullable
        default public Object getTrainingMetrics() {
            return null;
        }

        @Nullable
        default public Object getUserProvidedHyperParameters() {
            return null;
        }

        @Nullable
        default public Object getUserProvidedTrainingMetrics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrainingJobDetailsProperty> {
            Object hyperParameters;
            String trainingArn;
            List<String> trainingDatasets;
            Object trainingEnvironment;
            Object trainingMetrics;
            Object userProvidedHyperParameters;
            Object userProvidedTrainingMetrics;

            public Builder hyperParameters(IResolvable hyperParameters) {
                this.hyperParameters = hyperParameters;
                return this;
            }

            public Builder hyperParameters(List<? extends Object> hyperParameters) {
                this.hyperParameters = hyperParameters;
                return this;
            }

            public Builder trainingArn(String trainingArn) {
                this.trainingArn = trainingArn;
                return this;
            }

            public Builder trainingDatasets(List<String> trainingDatasets) {
                this.trainingDatasets = trainingDatasets;
                return this;
            }

            public Builder trainingEnvironment(IResolvable trainingEnvironment) {
                this.trainingEnvironment = trainingEnvironment;
                return this;
            }

            public Builder trainingEnvironment(TrainingEnvironmentProperty trainingEnvironment) {
                this.trainingEnvironment = trainingEnvironment;
                return this;
            }

            public Builder trainingMetrics(IResolvable trainingMetrics) {
                this.trainingMetrics = trainingMetrics;
                return this;
            }

            public Builder trainingMetrics(List<? extends Object> trainingMetrics) {
                this.trainingMetrics = trainingMetrics;
                return this;
            }

            public Builder userProvidedHyperParameters(IResolvable userProvidedHyperParameters) {
                this.userProvidedHyperParameters = userProvidedHyperParameters;
                return this;
            }

            public Builder userProvidedHyperParameters(List<? extends Object> userProvidedHyperParameters) {
                this.userProvidedHyperParameters = userProvidedHyperParameters;
                return this;
            }

            public Builder userProvidedTrainingMetrics(IResolvable userProvidedTrainingMetrics) {
                this.userProvidedTrainingMetrics = userProvidedTrainingMetrics;
                return this;
            }

            public Builder userProvidedTrainingMetrics(List<? extends Object> userProvidedTrainingMetrics) {
                this.userProvidedTrainingMetrics = userProvidedTrainingMetrics;
                return this;
            }

            public TrainingJobDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.TrainingHyperParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrainingHyperParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrainingHyperParameterProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TrainingHyperParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.TrainingEnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrainingEnvironmentProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getContainerImage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrainingEnvironmentProperty> {
            List<String> containerImage;

            public Builder containerImage(List<String> containerImage) {
                this.containerImage = containerImage;
                return this;
            }

            public TrainingEnvironmentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.TrainingDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrainingDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getObjectiveFunction() {
            return null;
        }

        @Nullable
        default public Object getTrainingJobDetails() {
            return null;
        }

        @Nullable
        default public String getTrainingObservations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrainingDetailsProperty> {
            Object objectiveFunction;
            Object trainingJobDetails;
            String trainingObservations;

            public Builder objectiveFunction(IResolvable objectiveFunction) {
                this.objectiveFunction = objectiveFunction;
                return this;
            }

            public Builder objectiveFunction(ObjectiveFunctionProperty objectiveFunction) {
                this.objectiveFunction = objectiveFunction;
                return this;
            }

            public Builder trainingJobDetails(IResolvable trainingJobDetails) {
                this.trainingJobDetails = trainingJobDetails;
                return this;
            }

            public Builder trainingJobDetails(TrainingJobDetailsProperty trainingJobDetails) {
                this.trainingJobDetails = trainingJobDetails;
                return this;
            }

            public Builder trainingObservations(String trainingObservations) {
                this.trainingObservations = trainingObservations;
                return this;
            }

            public TrainingDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.SourceAlgorithmProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceAlgorithmProperty
    extends JsiiSerializable {
        @NotNull
        public String getAlgorithmName();

        @Nullable
        default public String getModelDataUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceAlgorithmProperty> {
            String algorithmName;
            String modelDataUrl;

            public Builder algorithmName(String algorithmName) {
                this.algorithmName = algorithmName;
                return this;
            }

            public Builder modelDataUrl(String modelDataUrl) {
                this.modelDataUrl = modelDataUrl;
                return this;
            }

            public SourceAlgorithmProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.SecurityConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SecurityConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SecurityConfigProperty> {
            String kmsKeyId;

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public SecurityConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.ObjectiveFunctionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ObjectiveFunctionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFunction() {
            return null;
        }

        @Nullable
        default public String getNotes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ObjectiveFunctionProperty> {
            Object function;
            String notes;

            public Builder function(IResolvable function) {
                this.function = function;
                return this;
            }

            public Builder function(FunctionProperty function) {
                this.function = function;
                return this;
            }

            public Builder notes(String notes) {
                this.notes = notes;
                return this;
            }

            public ObjectiveFunctionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.ModelPackageDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelPackageDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getApprovalDescription() {
            return null;
        }

        @Nullable
        default public Object getCreatedBy() {
            return null;
        }

        @Nullable
        default public String getDomain() {
            return null;
        }

        @Nullable
        default public Object getInferenceSpecification() {
            return null;
        }

        @Nullable
        default public String getModelApprovalStatus() {
            return null;
        }

        @Nullable
        default public String getModelPackageArn() {
            return null;
        }

        @Nullable
        default public String getModelPackageDescription() {
            return null;
        }

        @Nullable
        default public String getModelPackageGroupName() {
            return null;
        }

        @Nullable
        default public String getModelPackageName() {
            return null;
        }

        @Nullable
        default public String getModelPackageStatus() {
            return null;
        }

        @Nullable
        default public Number getModelPackageVersion() {
            return null;
        }

        @Nullable
        default public Object getSourceAlgorithms() {
            return null;
        }

        @Nullable
        default public String getTask() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelPackageDetailsProperty> {
            String approvalDescription;
            Object createdBy;
            String domain;
            Object inferenceSpecification;
            String modelApprovalStatus;
            String modelPackageArn;
            String modelPackageDescription;
            String modelPackageGroupName;
            String modelPackageName;
            String modelPackageStatus;
            Number modelPackageVersion;
            Object sourceAlgorithms;
            String task;

            public Builder approvalDescription(String approvalDescription) {
                this.approvalDescription = approvalDescription;
                return this;
            }

            public Builder createdBy(IResolvable createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            public Builder createdBy(ModelPackageCreatorProperty createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            public Builder domain(String domain) {
                this.domain = domain;
                return this;
            }

            public Builder inferenceSpecification(IResolvable inferenceSpecification) {
                this.inferenceSpecification = inferenceSpecification;
                return this;
            }

            public Builder inferenceSpecification(InferenceSpecificationProperty inferenceSpecification) {
                this.inferenceSpecification = inferenceSpecification;
                return this;
            }

            public Builder modelApprovalStatus(String modelApprovalStatus) {
                this.modelApprovalStatus = modelApprovalStatus;
                return this;
            }

            public Builder modelPackageArn(String modelPackageArn) {
                this.modelPackageArn = modelPackageArn;
                return this;
            }

            public Builder modelPackageDescription(String modelPackageDescription) {
                this.modelPackageDescription = modelPackageDescription;
                return this;
            }

            public Builder modelPackageGroupName(String modelPackageGroupName) {
                this.modelPackageGroupName = modelPackageGroupName;
                return this;
            }

            public Builder modelPackageName(String modelPackageName) {
                this.modelPackageName = modelPackageName;
                return this;
            }

            public Builder modelPackageStatus(String modelPackageStatus) {
                this.modelPackageStatus = modelPackageStatus;
                return this;
            }

            public Builder modelPackageVersion(Number modelPackageVersion) {
                this.modelPackageVersion = modelPackageVersion;
                return this;
            }

            public Builder sourceAlgorithms(IResolvable sourceAlgorithms) {
                this.sourceAlgorithms = sourceAlgorithms;
                return this;
            }

            public Builder sourceAlgorithms(List<? extends Object> sourceAlgorithms) {
                this.sourceAlgorithms = sourceAlgorithms;
                return this;
            }

            public Builder task(String task) {
                this.task = task;
                return this;
            }

            public ModelPackageDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.ModelPackageCreatorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelPackageCreatorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getUserProfileName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelPackageCreatorProperty> {
            String userProfileName;

            public Builder userProfileName(String userProfileName) {
                this.userProfileName = userProfileName;
                return this;
            }

            public ModelPackageCreatorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.ModelOverviewProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelOverviewProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAlgorithmType() {
            return null;
        }

        @Nullable
        default public Object getInferenceEnvironment() {
            return null;
        }

        @Nullable
        default public List<String> getModelArtifact() {
            return null;
        }

        @Nullable
        default public String getModelCreator() {
            return null;
        }

        @Nullable
        default public String getModelDescription() {
            return null;
        }

        @Nullable
        default public String getModelId() {
            return null;
        }

        @Nullable
        default public String getModelName() {
            return null;
        }

        @Nullable
        default public String getModelOwner() {
            return null;
        }

        @Nullable
        default public Number getModelVersion() {
            return null;
        }

        @Nullable
        default public String getProblemType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelOverviewProperty> {
            String algorithmType;
            Object inferenceEnvironment;
            List<String> modelArtifact;
            String modelCreator;
            String modelDescription;
            String modelId;
            String modelName;
            String modelOwner;
            Number modelVersion;
            String problemType;

            public Builder algorithmType(String algorithmType) {
                this.algorithmType = algorithmType;
                return this;
            }

            public Builder inferenceEnvironment(IResolvable inferenceEnvironment) {
                this.inferenceEnvironment = inferenceEnvironment;
                return this;
            }

            public Builder inferenceEnvironment(InferenceEnvironmentProperty inferenceEnvironment) {
                this.inferenceEnvironment = inferenceEnvironment;
                return this;
            }

            public Builder modelArtifact(List<String> modelArtifact) {
                this.modelArtifact = modelArtifact;
                return this;
            }

            public Builder modelCreator(String modelCreator) {
                this.modelCreator = modelCreator;
                return this;
            }

            public Builder modelDescription(String modelDescription) {
                this.modelDescription = modelDescription;
                return this;
            }

            public Builder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public Builder modelName(String modelName) {
                this.modelName = modelName;
                return this;
            }

            public Builder modelOwner(String modelOwner) {
                this.modelOwner = modelOwner;
                return this;
            }

            public Builder modelVersion(Number modelVersion) {
                this.modelVersion = modelVersion;
                return this;
            }

            public Builder problemType(String problemType) {
                this.problemType = problemType;
                return this;
            }

            public ModelOverviewProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.MetricGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricGroupProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMetricData();

        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricGroupProperty> {
            Object metricData;
            String name;

            public Builder metricData(IResolvable metricData) {
                this.metricData = metricData;
                return this;
            }

            public Builder metricData(List<? extends Object> metricData) {
                this.metricData = metricData;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public MetricGroupProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.MetricDataItemsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricDataItemsProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getType();

        @NotNull
        public Object getValue();

        @Nullable
        default public String getNotes() {
            return null;
        }

        @Nullable
        default public List<String> getXAxisName() {
            return null;
        }

        @Nullable
        default public List<String> getYAxisName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricDataItemsProperty> {
            String name;
            String type;
            Object value;
            String notes;
            List<String> xAxisName;
            List<String> yAxisName;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(Object value) {
                this.value = value;
                return this;
            }

            public Builder notes(String notes) {
                this.notes = notes;
                return this;
            }

            public Builder xAxisName(List<String> xAxisName) {
                this.xAxisName = xAxisName;
                return this;
            }

            public Builder yAxisName(List<String> yAxisName) {
                this.yAxisName = yAxisName;
                return this;
            }

            public MetricDataItemsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.IntendedUsesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntendedUsesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getExplanationsForRiskRating() {
            return null;
        }

        @Nullable
        default public String getFactorsAffectingModelEfficiency() {
            return null;
        }

        @Nullable
        default public String getIntendedUses() {
            return null;
        }

        @Nullable
        default public String getPurposeOfModel() {
            return null;
        }

        @Nullable
        default public String getRiskRating() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntendedUsesProperty> {
            String explanationsForRiskRating;
            String factorsAffectingModelEfficiency;
            String intendedUses;
            String purposeOfModel;
            String riskRating;

            public Builder explanationsForRiskRating(String explanationsForRiskRating) {
                this.explanationsForRiskRating = explanationsForRiskRating;
                return this;
            }

            public Builder factorsAffectingModelEfficiency(String factorsAffectingModelEfficiency) {
                this.factorsAffectingModelEfficiency = factorsAffectingModelEfficiency;
                return this;
            }

            public Builder intendedUses(String intendedUses) {
                this.intendedUses = intendedUses;
                return this;
            }

            public Builder purposeOfModel(String purposeOfModel) {
                this.purposeOfModel = purposeOfModel;
                return this;
            }

            public Builder riskRating(String riskRating) {
                this.riskRating = riskRating;
                return this;
            }

            public IntendedUsesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.InferenceSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InferenceSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getContainers();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InferenceSpecificationProperty> {
            Object containers;

            public Builder containers(IResolvable containers) {
                this.containers = containers;
                return this;
            }

            public Builder containers(List<? extends Object> containers) {
                this.containers = containers;
                return this;
            }

            public InferenceSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.InferenceEnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InferenceEnvironmentProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getContainerImage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InferenceEnvironmentProperty> {
            List<String> containerImage;

            public Builder containerImage(List<String> containerImage) {
                this.containerImage = containerImage;
                return this;
            }

            public InferenceEnvironmentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.FunctionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCondition() {
            return null;
        }

        @Nullable
        default public String getFacet() {
            return null;
        }

        @Nullable
        default public String getFunction() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunctionProperty> {
            String condition;
            String facet;
            String function;

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public Builder facet(String facet) {
                this.facet = facet;
                return this;
            }

            public Builder function(String function) {
                this.function = function;
                return this;
            }

            public FunctionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.EvaluationDetailProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EvaluationDetailProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public List<String> getDatasets() {
            return null;
        }

        @Nullable
        default public String getEvaluationJobArn() {
            return null;
        }

        @Nullable
        default public String getEvaluationObservation() {
            return null;
        }

        @Nullable
        default public Object getMetadata() {
            return null;
        }

        @Nullable
        default public Object getMetricGroups() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EvaluationDetailProperty> {
            String name;
            List<String> datasets;
            String evaluationJobArn;
            String evaluationObservation;
            Object metadata;
            Object metricGroups;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder datasets(List<String> datasets) {
                this.datasets = datasets;
                return this;
            }

            public Builder evaluationJobArn(String evaluationJobArn) {
                this.evaluationJobArn = evaluationJobArn;
                return this;
            }

            public Builder evaluationObservation(String evaluationObservation) {
                this.evaluationObservation = evaluationObservation;
                return this;
            }

            public Builder metadata(IResolvable metadata) {
                this.metadata = metadata;
                return this;
            }

            public Builder metadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Builder metricGroups(IResolvable metricGroups) {
                this.metricGroups = metricGroups;
                return this;
            }

            public Builder metricGroups(List<? extends Object> metricGroups) {
                this.metricGroups = metricGroups;
                return this;
            }

            public EvaluationDetailProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.ContentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAdditionalInformation() {
            return null;
        }

        @Nullable
        default public Object getBusinessDetails() {
            return null;
        }

        @Nullable
        default public Object getEvaluationDetails() {
            return null;
        }

        @Nullable
        default public Object getIntendedUses() {
            return null;
        }

        @Nullable
        default public Object getModelOverview() {
            return null;
        }

        @Nullable
        default public Object getModelPackageDetails() {
            return null;
        }

        @Nullable
        default public Object getTrainingDetails() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContentProperty> {
            Object additionalInformation;
            Object businessDetails;
            Object evaluationDetails;
            Object intendedUses;
            Object modelOverview;
            Object modelPackageDetails;
            Object trainingDetails;

            public Builder additionalInformation(IResolvable additionalInformation) {
                this.additionalInformation = additionalInformation;
                return this;
            }

            public Builder additionalInformation(AdditionalInformationProperty additionalInformation) {
                this.additionalInformation = additionalInformation;
                return this;
            }

            public Builder businessDetails(IResolvable businessDetails) {
                this.businessDetails = businessDetails;
                return this;
            }

            public Builder businessDetails(BusinessDetailsProperty businessDetails) {
                this.businessDetails = businessDetails;
                return this;
            }

            public Builder evaluationDetails(IResolvable evaluationDetails) {
                this.evaluationDetails = evaluationDetails;
                return this;
            }

            public Builder evaluationDetails(List<? extends Object> evaluationDetails) {
                this.evaluationDetails = evaluationDetails;
                return this;
            }

            public Builder intendedUses(IResolvable intendedUses) {
                this.intendedUses = intendedUses;
                return this;
            }

            public Builder intendedUses(IntendedUsesProperty intendedUses) {
                this.intendedUses = intendedUses;
                return this;
            }

            public Builder modelOverview(IResolvable modelOverview) {
                this.modelOverview = modelOverview;
                return this;
            }

            public Builder modelOverview(ModelOverviewProperty modelOverview) {
                this.modelOverview = modelOverview;
                return this;
            }

            public Builder modelPackageDetails(IResolvable modelPackageDetails) {
                this.modelPackageDetails = modelPackageDetails;
                return this;
            }

            public Builder modelPackageDetails(ModelPackageDetailsProperty modelPackageDetails) {
                this.modelPackageDetails = modelPackageDetails;
                return this;
            }

            public Builder trainingDetails(IResolvable trainingDetails) {
                this.trainingDetails = trainingDetails;
                return this;
            }

            public Builder trainingDetails(TrainingDetailsProperty trainingDetails) {
                this.trainingDetails = trainingDetails;
                return this;
            }

            public ContentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.ContainerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerProperty
    extends JsiiSerializable {
        @NotNull
        public String getImage();

        @Nullable
        default public String getModelDataUrl() {
            return null;
        }

        @Nullable
        default public String getNearestModelName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerProperty> {
            String image;
            String modelDataUrl;
            String nearestModelName;

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder modelDataUrl(String modelDataUrl) {
                this.modelDataUrl = modelDataUrl;
                return this;
            }

            public Builder nearestModelName(String nearestModelName) {
                this.nearestModelName = nearestModelName;
                return this;
            }

            public ContainerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.BusinessDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BusinessDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBusinessProblem() {
            return null;
        }

        @Nullable
        default public String getBusinessStakeholders() {
            return null;
        }

        @Nullable
        default public String getLineOfBusiness() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BusinessDetailsProperty> {
            String businessProblem;
            String businessStakeholders;
            String lineOfBusiness;

            public Builder businessProblem(String businessProblem) {
                this.businessProblem = businessProblem;
                return this;
            }

            public Builder businessStakeholders(String businessStakeholders) {
                this.businessStakeholders = businessStakeholders;
                return this;
            }

            public Builder lineOfBusiness(String lineOfBusiness) {
                this.lineOfBusiness = lineOfBusiness;
                return this;
            }

            public BusinessDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModelCard.AdditionalInformationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AdditionalInformationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCaveatsAndRecommendations() {
            return null;
        }

        @Nullable
        default public Object getCustomDetails() {
            return null;
        }

        @Nullable
        default public String getEthicalConsiderations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AdditionalInformationProperty> {
            String caveatsAndRecommendations;
            Object customDetails;
            String ethicalConsiderations;

            public Builder caveatsAndRecommendations(String caveatsAndRecommendations) {
                this.caveatsAndRecommendations = caveatsAndRecommendations;
                return this;
            }

            public Builder customDetails(IResolvable customDetails) {
                this.customDetails = customDetails;
                return this;
            }

            public Builder customDetails(Map<String, String> customDetails) {
                this.customDetails = customDetails;
                return this;
            }

            public Builder ethicalConsiderations(String ethicalConsiderations) {
                this.ethicalConsiderations = ethicalConsiderations;
                return this;
            }

            public AdditionalInformationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

