/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.BlockPublicAccess;
import software.amazon.awscdk.services.s3.BucketAccessControl;
import software.amazon.awscdk.services.s3.BucketAttributes;
import software.amazon.awscdk.services.s3.BucketEncryption;
import software.amazon.awscdk.services.s3.BucketMetrics;
import software.amazon.awscdk.services.s3.BucketPolicy;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awscdk.services.s3.CorsRule;
import software.amazon.awscdk.services.s3.EventType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.IBucketNotificationDestination;
import software.amazon.awscdk.services.s3.Inventory;
import software.amazon.awscdk.services.s3.LifecycleRule;
import software.amazon.awscdk.services.s3.NotificationKeyFilter;
import software.amazon.awscdk.services.s3.ObjectOwnership;
import software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions;
import software.amazon.awscdk.services.s3.RedirectTarget;
import software.amazon.awscdk.services.s3.RoutingRule;
import software.amazon.awscdk.services.s3.VirtualHostedStyleUrlOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.Bucket")
public class Bucket
extends Resource
implements IBucket {
    protected Bucket(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Bucket(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Bucket(@NotNull Construct scope, @NotNull String id, @Nullable BucketProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Bucket(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IBucket fromBucketArn(@NotNull Construct scope, @NotNull String id, @NotNull String bucketArn) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"fromBucketArn", (NativeType)NativeType.forClass(IBucket.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(bucketArn, "bucketArn is required")});
    }

    @NotNull
    public static IBucket fromBucketAttributes(@NotNull Construct scope, @NotNull String id, @NotNull BucketAttributes attrs) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"fromBucketAttributes", (NativeType)NativeType.forClass(IBucket.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IBucket fromBucketName(@NotNull Construct scope, @NotNull String id, @NotNull String bucketName) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"fromBucketName", (NativeType)NativeType.forClass(IBucket.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(bucketName, "bucketName is required")});
    }

    public void addCorsRule(@NotNull CorsRule rule) {
        Kernel.call((Object)this, (String)"addCorsRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public void addEventNotification(@NotNull EventType event, @NotNull IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        Kernel.call((Object)this, (String)"addEventNotification", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(event, "event is required"), Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    public void addInventory(@NotNull Inventory inventory) {
        Kernel.call((Object)this, (String)"addInventory", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inventory, "inventory is required")});
    }

    public void addLifecycleRule(@NotNull LifecycleRule rule) {
        Kernel.call((Object)this, (String)"addLifecycleRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public void addMetric(@NotNull BucketMetrics metric) {
        Kernel.call((Object)this, (String)"addMetric", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(metric, "metric is required")});
    }

    public void addObjectCreatedNotification(@NotNull IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        Kernel.call((Object)this, (String)"addObjectCreatedNotification", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    public void addObjectRemovedNotification(@NotNull IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        Kernel.call((Object)this, (String)"addObjectRemovedNotification", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement permission) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(permission, "permission is required")});
    }

    @Override
    @NotNull
    public String arnForObjects(@NotNull String keyPattern) {
        return (String)Kernel.call((Object)this, (String)"arnForObjects", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(keyPattern, "keyPattern is required")});
    }

    @Override
    @NotNull
    public Grant grantDelete(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)Kernel.call((Object)this, (String)"grantDelete", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    @NotNull
    public Grant grantDelete(@NotNull IGrantable identity) {
        return (Grant)Kernel.call((Object)this, (String)"grantDelete", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantPublicAccess(@Nullable String keyPrefix, String ... allowedActions) {
        return (Grant)Kernel.call((Object)this, (String)"grantPublicAccess", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{keyPrefix}), Arrays.stream(allowedActions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Grant grantPut(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)Kernel.call((Object)this, (String)"grantPut", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    @NotNull
    public Grant grantPut(@NotNull IGrantable identity) {
        return (Grant)Kernel.call((Object)this, (String)"grantPut", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable identity) {
        return (Grant)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)Kernel.call((Object)this, (String)"grantReadWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable identity) {
        return (Grant)Kernel.call((Object)this, (String)"grantReadWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable identity) {
        return (Grant)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    @NotNull
    public Rule onCloudTrailEvent(@NotNull String id, @Nullable OnCloudTrailBucketEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCloudTrailEvent(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onCloudTrailPutObject(@NotNull String id, @Nullable OnCloudTrailBucketEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailPutObject", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCloudTrailPutObject(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailPutObject", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onCloudTrailWriteObject(@NotNull String id, @Nullable OnCloudTrailBucketEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailWriteObject", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCloudTrailWriteObject(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onCloudTrailWriteObject", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public String s3UrlForObject(@Nullable String key) {
        return (String)Kernel.call((Object)this, (String)"s3UrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key});
    }

    @Override
    @NotNull
    public String s3UrlForObject() {
        return (String)Kernel.call((Object)this, (String)"s3UrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String urlForObject(@Nullable String key) {
        return (String)Kernel.call((Object)this, (String)"urlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key});
    }

    @Override
    @NotNull
    public String urlForObject() {
        return (String)Kernel.call((Object)this, (String)"urlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public String virtualHostedUrlForObject(@Nullable String key, @Nullable VirtualHostedStyleUrlOptions options) {
        return (String)Kernel.call((Object)this, (String)"virtualHostedUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key, options});
    }

    @Override
    @NotNull
    public String virtualHostedUrlForObject(@Nullable String key) {
        return (String)Kernel.call((Object)this, (String)"virtualHostedUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key});
    }

    @Override
    @NotNull
    public String virtualHostedUrlForObject() {
        return (String)Kernel.call((Object)this, (String)"virtualHostedUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getBucketArn() {
        return (String)Kernel.get((Object)this, (String)"bucketArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketDomainName() {
        return (String)Kernel.get((Object)this, (String)"bucketDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketDualStackDomainName() {
        return (String)Kernel.get((Object)this, (String)"bucketDualStackDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketName() {
        return (String)Kernel.get((Object)this, (String)"bucketName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketRegionalDomainName() {
        return (String)Kernel.get((Object)this, (String)"bucketRegionalDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketWebsiteDomainName() {
        return (String)Kernel.get((Object)this, (String)"bucketWebsiteDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketWebsiteUrl() {
        return (String)Kernel.get((Object)this, (String)"bucketWebsiteUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"encryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Override
    @Nullable
    public Boolean getIsWebsite() {
        return (Boolean)Kernel.get((Object)this, (String)"isWebsite", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    protected Boolean getAutoCreatePolicy() {
        return (Boolean)Kernel.get((Object)this, (String)"autoCreatePolicy", (NativeType)NativeType.forClass(Boolean.class));
    }

    protected void setAutoCreatePolicy(@NotNull Boolean value) {
        Kernel.set((Object)this, (String)"autoCreatePolicy", (Object)Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    @Nullable
    protected Boolean getDisallowPublicAccess() {
        return (Boolean)Kernel.get((Object)this, (String)"disallowPublicAccess", (NativeType)NativeType.forClass(Boolean.class));
    }

    protected void setDisallowPublicAccess(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"disallowPublicAccess", (Object)value);
    }

    @Override
    @Nullable
    public BucketPolicy getPolicy() {
        return (BucketPolicy)((Object)Kernel.get((Object)this, (String)"policy", (NativeType)NativeType.forClass(BucketPolicy.class)));
    }

    @Override
    public void setPolicy(@Nullable BucketPolicy value) {
        Kernel.set((Object)this, (String)"policy", (Object)((Object)value));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Bucket> {
        private final Construct scope;
        private final String id;
        private BucketProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder accessControl(BucketAccessControl accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        public Builder autoDeleteObjects(Boolean autoDeleteObjects) {
            this.props().autoDeleteObjects(autoDeleteObjects);
            return this;
        }

        public Builder blockPublicAccess(BlockPublicAccess blockPublicAccess) {
            this.props().blockPublicAccess(blockPublicAccess);
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.props().bucketName(bucketName);
            return this;
        }

        public Builder cors(List<? extends CorsRule> cors) {
            this.props().cors(cors);
            return this;
        }

        public Builder encryption(BucketEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder inventories(List<? extends Inventory> inventories) {
            this.props().inventories(inventories);
            return this;
        }

        public Builder lifecycleRules(List<? extends LifecycleRule> lifecycleRules) {
            this.props().lifecycleRules(lifecycleRules);
            return this;
        }

        public Builder metrics(List<? extends BucketMetrics> metrics) {
            this.props().metrics(metrics);
            return this;
        }

        public Builder objectOwnership(ObjectOwnership objectOwnership) {
            this.props().objectOwnership(objectOwnership);
            return this;
        }

        public Builder publicReadAccess(Boolean publicReadAccess) {
            this.props().publicReadAccess(publicReadAccess);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder serverAccessLogsBucket(IBucket serverAccessLogsBucket) {
            this.props().serverAccessLogsBucket(serverAccessLogsBucket);
            return this;
        }

        public Builder serverAccessLogsPrefix(String serverAccessLogsPrefix) {
            this.props().serverAccessLogsPrefix(serverAccessLogsPrefix);
            return this;
        }

        public Builder versioned(Boolean versioned) {
            this.props().versioned(versioned);
            return this;
        }

        public Builder websiteErrorDocument(String websiteErrorDocument) {
            this.props().websiteErrorDocument(websiteErrorDocument);
            return this;
        }

        public Builder websiteIndexDocument(String websiteIndexDocument) {
            this.props().websiteIndexDocument(websiteIndexDocument);
            return this;
        }

        public Builder websiteRedirect(RedirectTarget websiteRedirect) {
            this.props().websiteRedirect(websiteRedirect);
            return this;
        }

        public Builder websiteRoutingRules(List<? extends RoutingRule> websiteRoutingRules) {
            this.props().websiteRoutingRules(websiteRoutingRules);
            return this;
        }

        public Bucket build() {
            return new Bucket(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private BucketProps.Builder props() {
            if (this.props == null) {
                this.props = new BucketProps.Builder();
            }
            return this.props;
        }
    }
}

