/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.CfnBucket;
import software.amazon.awscdk.services.s3.CfnBucketProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnBucket.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnBucket(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBucket(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnBucket(@NotNull Construct scope, @NotNull String id, @Nullable CfnBucketProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnBucket(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrDomainName() {
        return (String)this.jsiiGet("attrDomainName", String.class);
    }

    @NotNull
    public String getAttrDualStackDomainName() {
        return (String)this.jsiiGet("attrDualStackDomainName", String.class);
    }

    @NotNull
    public String getAttrRegionalDomainName() {
        return (String)this.jsiiGet("attrRegionalDomainName", String.class);
    }

    @NotNull
    public String getAttrWebsiteUrl() {
        return (String)this.jsiiGet("attrWebsiteUrl", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @Nullable
    public Object getAccelerateConfiguration() {
        return this.jsiiGet("accelerateConfiguration", Object.class);
    }

    public void setAccelerateConfiguration(@Nullable AccelerateConfigurationProperty value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    public void setAccelerateConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("accelerateConfiguration", value);
    }

    @Nullable
    public String getAccessControl() {
        return (String)this.jsiiGet("accessControl", String.class);
    }

    public void setAccessControl(@Nullable String value) {
        this.jsiiSet("accessControl", value);
    }

    @Nullable
    public Object getAnalyticsConfigurations() {
        return this.jsiiGet("analyticsConfigurations", Object.class);
    }

    public void setAnalyticsConfigurations(@Nullable IResolvable value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    public void setAnalyticsConfigurations(@Nullable List<Object> value) {
        this.jsiiSet("analyticsConfigurations", value);
    }

    @Nullable
    public Object getBucketEncryption() {
        return this.jsiiGet("bucketEncryption", Object.class);
    }

    public void setBucketEncryption(@Nullable IResolvable value) {
        this.jsiiSet("bucketEncryption", value);
    }

    public void setBucketEncryption(@Nullable BucketEncryptionProperty value) {
        this.jsiiSet("bucketEncryption", value);
    }

    @Nullable
    public String getBucketName() {
        return (String)this.jsiiGet("bucketName", String.class);
    }

    public void setBucketName(@Nullable String value) {
        this.jsiiSet("bucketName", value);
    }

    @Nullable
    public Object getCorsConfiguration() {
        return this.jsiiGet("corsConfiguration", Object.class);
    }

    public void setCorsConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("corsConfiguration", value);
    }

    public void setCorsConfiguration(@Nullable CorsConfigurationProperty value) {
        this.jsiiSet("corsConfiguration", value);
    }

    @Nullable
    public Object getInventoryConfigurations() {
        return this.jsiiGet("inventoryConfigurations", Object.class);
    }

    public void setInventoryConfigurations(@Nullable IResolvable value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    public void setInventoryConfigurations(@Nullable List<Object> value) {
        this.jsiiSet("inventoryConfigurations", value);
    }

    @Nullable
    public Object getLifecycleConfiguration() {
        return this.jsiiGet("lifecycleConfiguration", Object.class);
    }

    public void setLifecycleConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    public void setLifecycleConfiguration(@Nullable LifecycleConfigurationProperty value) {
        this.jsiiSet("lifecycleConfiguration", value);
    }

    @Nullable
    public Object getLoggingConfiguration() {
        return this.jsiiGet("loggingConfiguration", Object.class);
    }

    public void setLoggingConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    public void setLoggingConfiguration(@Nullable LoggingConfigurationProperty value) {
        this.jsiiSet("loggingConfiguration", value);
    }

    @Nullable
    public Object getMetricsConfigurations() {
        return this.jsiiGet("metricsConfigurations", Object.class);
    }

    public void setMetricsConfigurations(@Nullable IResolvable value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    public void setMetricsConfigurations(@Nullable List<Object> value) {
        this.jsiiSet("metricsConfigurations", value);
    }

    @Nullable
    public Object getNotificationConfiguration() {
        return this.jsiiGet("notificationConfiguration", Object.class);
    }

    public void setNotificationConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    public void setNotificationConfiguration(@Nullable NotificationConfigurationProperty value) {
        this.jsiiSet("notificationConfiguration", value);
    }

    @Nullable
    public Object getObjectLockConfiguration() {
        return this.jsiiGet("objectLockConfiguration", Object.class);
    }

    public void setObjectLockConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    public void setObjectLockConfiguration(@Nullable ObjectLockConfigurationProperty value) {
        this.jsiiSet("objectLockConfiguration", value);
    }

    @Nullable
    public Object getObjectLockEnabled() {
        return this.jsiiGet("objectLockEnabled", Object.class);
    }

    public void setObjectLockEnabled(@Nullable Boolean value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    public void setObjectLockEnabled(@Nullable IResolvable value) {
        this.jsiiSet("objectLockEnabled", value);
    }

    @Nullable
    public Object getPublicAccessBlockConfiguration() {
        return this.jsiiGet("publicAccessBlockConfiguration", Object.class);
    }

    public void setPublicAccessBlockConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    public void setPublicAccessBlockConfiguration(@Nullable PublicAccessBlockConfigurationProperty value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    @Nullable
    public Object getReplicationConfiguration() {
        return this.jsiiGet("replicationConfiguration", Object.class);
    }

    public void setReplicationConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    public void setReplicationConfiguration(@Nullable ReplicationConfigurationProperty value) {
        this.jsiiSet("replicationConfiguration", value);
    }

    @Nullable
    public Object getVersioningConfiguration() {
        return this.jsiiGet("versioningConfiguration", Object.class);
    }

    public void setVersioningConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    public void setVersioningConfiguration(@Nullable VersioningConfigurationProperty value) {
        this.jsiiSet("versioningConfiguration", value);
    }

    @Nullable
    public Object getWebsiteConfiguration() {
        return this.jsiiGet("websiteConfiguration", Object.class);
    }

    public void setWebsiteConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("websiteConfiguration", value);
    }

    public void setWebsiteConfiguration(@Nullable WebsiteConfigurationProperty value) {
        this.jsiiSet("websiteConfiguration", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private CfnBucketProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder accelerateConfiguration(AccelerateConfigurationProperty accelerateConfiguration) {
            this.props().accelerateConfiguration(accelerateConfiguration);
            return this;
        }

        public Builder accelerateConfiguration(IResolvable accelerateConfiguration) {
            this.props().accelerateConfiguration(accelerateConfiguration);
            return this;
        }

        public Builder accessControl(String accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        public Builder analyticsConfigurations(IResolvable analyticsConfigurations) {
            this.props().analyticsConfigurations(analyticsConfigurations);
            return this;
        }

        public Builder analyticsConfigurations(List<Object> analyticsConfigurations) {
            this.props().analyticsConfigurations(analyticsConfigurations);
            return this;
        }

        public Builder bucketEncryption(IResolvable bucketEncryption) {
            this.props().bucketEncryption(bucketEncryption);
            return this;
        }

        public Builder bucketEncryption(BucketEncryptionProperty bucketEncryption) {
            this.props().bucketEncryption(bucketEncryption);
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.props().bucketName(bucketName);
            return this;
        }

        public Builder corsConfiguration(IResolvable corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }

        public Builder corsConfiguration(CorsConfigurationProperty corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }

        public Builder inventoryConfigurations(IResolvable inventoryConfigurations) {
            this.props().inventoryConfigurations(inventoryConfigurations);
            return this;
        }

        public Builder inventoryConfigurations(List<Object> inventoryConfigurations) {
            this.props().inventoryConfigurations(inventoryConfigurations);
            return this;
        }

        public Builder lifecycleConfiguration(IResolvable lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        public Builder lifecycleConfiguration(LifecycleConfigurationProperty lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        public Builder loggingConfiguration(IResolvable loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder loggingConfiguration(LoggingConfigurationProperty loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder metricsConfigurations(IResolvable metricsConfigurations) {
            this.props().metricsConfigurations(metricsConfigurations);
            return this;
        }

        public Builder metricsConfigurations(List<Object> metricsConfigurations) {
            this.props().metricsConfigurations(metricsConfigurations);
            return this;
        }

        public Builder notificationConfiguration(IResolvable notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }

        public Builder notificationConfiguration(NotificationConfigurationProperty notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }

        public Builder objectLockConfiguration(IResolvable objectLockConfiguration) {
            this.props().objectLockConfiguration(objectLockConfiguration);
            return this;
        }

        public Builder objectLockConfiguration(ObjectLockConfigurationProperty objectLockConfiguration) {
            this.props().objectLockConfiguration(objectLockConfiguration);
            return this;
        }

        public Builder objectLockEnabled(Boolean objectLockEnabled) {
            this.props().objectLockEnabled(objectLockEnabled);
            return this;
        }

        public Builder objectLockEnabled(IResolvable objectLockEnabled) {
            this.props().objectLockEnabled(objectLockEnabled);
            return this;
        }

        public Builder publicAccessBlockConfiguration(IResolvable publicAccessBlockConfiguration) {
            this.props().publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        public Builder publicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.props().publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        public Builder replicationConfiguration(IResolvable replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }

        public Builder replicationConfiguration(ReplicationConfigurationProperty replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder versioningConfiguration(IResolvable versioningConfiguration) {
            this.props().versioningConfiguration(versioningConfiguration);
            return this;
        }

        public Builder versioningConfiguration(VersioningConfigurationProperty versioningConfiguration) {
            this.props().versioningConfiguration(versioningConfiguration);
            return this;
        }

        public Builder websiteConfiguration(IResolvable websiteConfiguration) {
            this.props().websiteConfiguration(websiteConfiguration);
            return this;
        }

        public Builder websiteConfiguration(WebsiteConfigurationProperty websiteConfiguration) {
            this.props().websiteConfiguration(websiteConfiguration);
            return this;
        }

        public CfnBucket build() {
            return new CfnBucket(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnBucketProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnBucketProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.WebsiteConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebsiteConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getErrorDocument() {
            return null;
        }

        @Nullable
        default public String getIndexDocument() {
            return null;
        }

        @Nullable
        default public Object getRedirectAllRequestsTo() {
            return null;
        }

        @Nullable
        default public Object getRoutingRules() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String errorDocument;
            private String indexDocument;
            private Object redirectAllRequestsTo;
            private Object routingRules;

            public Builder errorDocument(String errorDocument) {
                this.errorDocument = errorDocument;
                return this;
            }

            public Builder indexDocument(String indexDocument) {
                this.indexDocument = indexDocument;
                return this;
            }

            public Builder redirectAllRequestsTo(IResolvable redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            public Builder redirectAllRequestsTo(RedirectAllRequestsToProperty redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            public Builder routingRules(IResolvable routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            public Builder routingRules(List<Object> routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            public WebsiteConfigurationProperty build() {
                return new Jsii.Proxy(this.errorDocument, this.indexDocument, this.redirectAllRequestsTo, this.routingRules, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.VersioningConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VersioningConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public VersioningConfigurationProperty build() {
                return new Jsii.Proxy(this.status, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.TransitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getStorageClass();

        @Nullable
        default public Object getTransitionDate() {
            return null;
        }

        @Nullable
        default public Number getTransitionInDays() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String storageClass;
            private Object transitionDate;
            private Number transitionInDays;

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public Builder transitionDate(IResolvable transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            public Builder transitionDate(Instant transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            public Builder transitionInDays(Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            public TransitionProperty build() {
                return new Jsii.Proxy(this.storageClass, this.transitionDate, this.transitionInDays, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.TopicConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopicConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEvent();

        @NotNull
        public String getTopic();

        @Nullable
        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String event;
            private String topic;
            private Object filter;

            public Builder event(String event) {
                this.event = event;
                return this;
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public TopicConfigurationProperty build() {
                return new Jsii.Proxy(this.event, this.topic, this.filter, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.TagFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagFilterProperty build() {
                return new Jsii.Proxy(this.key, this.value, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.StorageClassAnalysisProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageClassAnalysisProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataExport() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object dataExport;

            public Builder dataExport(IResolvable dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            public Builder dataExport(DataExportProperty dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            public StorageClassAnalysisProperty build() {
                return new Jsii.Proxy(this.dataExport, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.SseKmsEncryptedObjectsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SseKmsEncryptedObjectsProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public SseKmsEncryptedObjectsProperty build() {
                return new Jsii.Proxy(this.status, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.SourceSelectionCriteriaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceSelectionCriteriaProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSseKmsEncryptedObjects();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object sseKmsEncryptedObjects;

            public Builder sseKmsEncryptedObjects(IResolvable sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            public Builder sseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            public SourceSelectionCriteriaProperty build() {
                return new Jsii.Proxy(this.sseKmsEncryptedObjects, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServerSideEncryptionRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getServerSideEncryptionByDefault() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object serverSideEncryptionByDefault;

            public Builder serverSideEncryptionByDefault(IResolvable serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            public Builder serverSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            public ServerSideEncryptionRuleProperty build() {
                return new Jsii.Proxy(this.serverSideEncryptionByDefault, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionByDefaultProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServerSideEncryptionByDefaultProperty
    extends JsiiSerializable {
        @NotNull
        public String getSseAlgorithm();

        @Nullable
        default public String getKmsMasterKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String sseAlgorithm;
            private String kmsMasterKeyId;

            public Builder sseAlgorithm(String sseAlgorithm) {
                this.sseAlgorithm = sseAlgorithm;
                return this;
            }

            public Builder kmsMasterKeyId(String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            public ServerSideEncryptionByDefaultProperty build() {
                return new Jsii.Proxy(this.sseAlgorithm, this.kmsMasterKeyId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.S3KeyFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<Object> rules) {
                this.rules = rules;
                return this;
            }

            public S3KeyFilterProperty build() {
                return new Jsii.Proxy(this.rules, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        @Nullable
        default public Object getAbortIncompleteMultipartUpload() {
            return null;
        }

        @Nullable
        default public Object getExpirationDate() {
            return null;
        }

        @Nullable
        default public Number getExpirationInDays() {
            return null;
        }

        @Nullable
        default public String getId() {
            return null;
        }

        @Nullable
        default public Number getNoncurrentVersionExpirationInDays() {
            return null;
        }

        @Nullable
        default public Object getNoncurrentVersionTransition() {
            return null;
        }

        @Nullable
        default public Object getNoncurrentVersionTransitions() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        @Nullable
        default public Object getTransition() {
            return null;
        }

        @Nullable
        default public Object getTransitions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String status;
            private Object abortIncompleteMultipartUpload;
            private Object expirationDate;
            private Number expirationInDays;
            private String id;
            private Number noncurrentVersionExpirationInDays;
            private Object noncurrentVersionTransition;
            private Object noncurrentVersionTransitions;
            private String prefix;
            private Object tagFilters;
            private Object transition;
            private Object transitions;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder abortIncompleteMultipartUpload(IResolvable abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            public Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            public Builder expirationDate(IResolvable expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            public Builder expirationDate(Instant expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            public Builder expirationInDays(Number expirationInDays) {
                this.expirationInDays = expirationInDays;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder noncurrentVersionExpirationInDays(Number noncurrentVersionExpirationInDays) {
                this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
                return this;
            }

            public Builder noncurrentVersionTransition(IResolvable noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            public Builder noncurrentVersionTransition(NoncurrentVersionTransitionProperty noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            public Builder noncurrentVersionTransitions(IResolvable noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            public Builder noncurrentVersionTransitions(List<Object> noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder transition(IResolvable transition) {
                this.transition = transition;
                return this;
            }

            public Builder transition(TransitionProperty transition) {
                this.transition = transition;
                return this;
            }

            public Builder transitions(IResolvable transitions) {
                this.transitions = transitions;
                return this;
            }

            public Builder transitions(List<Object> transitions) {
                this.transitions = transitions;
                return this;
            }

            public RuleProperty build() {
                return new Jsii.Proxy(this.status, this.abortIncompleteMultipartUpload, this.expirationDate, this.expirationInDays, this.id, this.noncurrentVersionExpirationInDays, this.noncurrentVersionTransition, this.noncurrentVersionTransitions, this.prefix, this.tagFilters, this.transition, this.transitions, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RoutingRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RoutingRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRedirectRule();

        @Nullable
        default public Object getRoutingRuleCondition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object redirectRule;
            private Object routingRuleCondition;

            public Builder redirectRule(IResolvable redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            public Builder redirectRule(RedirectRuleProperty redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            public Builder routingRuleCondition(IResolvable routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            public Builder routingRuleCondition(RoutingRuleConditionProperty routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            public RoutingRuleProperty build() {
                return new Jsii.Proxy(this.redirectRule, this.routingRuleCondition, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RoutingRuleConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RoutingRuleConditionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHttpErrorCodeReturnedEquals() {
            return null;
        }

        @Nullable
        default public String getKeyPrefixEquals() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String httpErrorCodeReturnedEquals;
            private String keyPrefixEquals;

            public Builder httpErrorCodeReturnedEquals(String httpErrorCodeReturnedEquals) {
                this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
                return this;
            }

            public Builder keyPrefixEquals(String keyPrefixEquals) {
                this.keyPrefixEquals = keyPrefixEquals;
                return this;
            }

            public RoutingRuleConditionProperty build() {
                return new Jsii.Proxy(this.httpErrorCodeReturnedEquals, this.keyPrefixEquals, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDestination();

        @NotNull
        public String getPrefix();

        @NotNull
        public String getStatus();

        @Nullable
        default public String getId() {
            return null;
        }

        @Nullable
        default public Object getSourceSelectionCriteria() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object destination;
            private String prefix;
            private String status;
            private String id;
            private Object sourceSelectionCriteria;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(ReplicationDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder sourceSelectionCriteria(IResolvable sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            public Builder sourceSelectionCriteria(SourceSelectionCriteriaProperty sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            public ReplicationRuleProperty build() {
                return new Jsii.Proxy(this.destination, this.prefix, this.status, this.id, this.sourceSelectionCriteria, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationDestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationDestinationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @Nullable
        default public Object getAccessControlTranslation() {
            return null;
        }

        @Nullable
        default public String getAccount() {
            return null;
        }

        @Nullable
        default public Object getEncryptionConfiguration() {
            return null;
        }

        @Nullable
        default public String getStorageClass() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucket;
            private Object accessControlTranslation;
            private String account;
            private Object encryptionConfiguration;
            private String storageClass;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder accessControlTranslation(IResolvable accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            public Builder accessControlTranslation(AccessControlTranslationProperty accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            public Builder account(String account) {
                this.account = account;
                return this;
            }

            public Builder encryptionConfiguration(IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder encryptionConfiguration(EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public ReplicationDestinationProperty build() {
                return new Jsii.Proxy(this.bucket, this.accessControlTranslation, this.account, this.encryptionConfiguration, this.storageClass, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getRole();

        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String role;
            private Object rules;

            public Builder role(String role) {
                this.role = role;
                return this;
            }

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<Object> rules) {
                this.rules = rules;
                return this;
            }

            public ReplicationConfigurationProperty build() {
                return new Jsii.Proxy(this.role, this.rules, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RedirectRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedirectRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHostName() {
            return null;
        }

        @Nullable
        default public String getHttpRedirectCode() {
            return null;
        }

        @Nullable
        default public String getProtocol() {
            return null;
        }

        @Nullable
        default public String getReplaceKeyPrefixWith() {
            return null;
        }

        @Nullable
        default public String getReplaceKeyWith() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String hostName;
            private String httpRedirectCode;
            private String protocol;
            private String replaceKeyPrefixWith;
            private String replaceKeyWith;

            public Builder hostName(String hostName) {
                this.hostName = hostName;
                return this;
            }

            public Builder httpRedirectCode(String httpRedirectCode) {
                this.httpRedirectCode = httpRedirectCode;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder replaceKeyPrefixWith(String replaceKeyPrefixWith) {
                this.replaceKeyPrefixWith = replaceKeyPrefixWith;
                return this;
            }

            public Builder replaceKeyWith(String replaceKeyWith) {
                this.replaceKeyWith = replaceKeyWith;
                return this;
            }

            public RedirectRuleProperty build() {
                return new Jsii.Proxy(this.hostName, this.httpRedirectCode, this.protocol, this.replaceKeyPrefixWith, this.replaceKeyWith, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RedirectAllRequestsToProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedirectAllRequestsToProperty
    extends JsiiSerializable {
        @NotNull
        public String getHostName();

        @Nullable
        default public String getProtocol() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String hostName;
            private String protocol;

            public Builder hostName(String hostName) {
                this.hostName = hostName;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public RedirectAllRequestsToProperty build() {
                return new Jsii.Proxy(this.hostName, this.protocol, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.QueueConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QueueConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEvent();

        @NotNull
        public String getQueue();

        @Nullable
        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String event;
            private String queue;
            private Object filter;

            public Builder event(String event) {
                this.event = event;
                return this;
            }

            public Builder queue(String queue) {
                this.queue = queue;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public QueueConfigurationProperty build() {
                return new Jsii.Proxy(this.event, this.queue, this.filter, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.PublicAccessBlockConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PublicAccessBlockConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBlockPublicAcls() {
            return null;
        }

        @Nullable
        default public Object getBlockPublicPolicy() {
            return null;
        }

        @Nullable
        default public Object getIgnorePublicAcls() {
            return null;
        }

        @Nullable
        default public Object getRestrictPublicBuckets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object blockPublicAcls;
            private Object blockPublicPolicy;
            private Object ignorePublicAcls;
            private Object restrictPublicBuckets;

            public Builder blockPublicAcls(Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicAcls(IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicPolicy(Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder blockPublicPolicy(IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder ignorePublicAcls(Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder ignorePublicAcls(IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public Builder restrictPublicBuckets(IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii.Proxy(this.blockPublicAcls, this.blockPublicPolicy, this.ignorePublicAcls, this.restrictPublicBuckets, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ObjectLockRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ObjectLockRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDefaultRetention() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object defaultRetention;

            public Builder defaultRetention(IResolvable defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            public Builder defaultRetention(DefaultRetentionProperty defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            public ObjectLockRuleProperty build() {
                return new Jsii.Proxy(this.defaultRetention, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ObjectLockConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ObjectLockConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getObjectLockEnabled() {
            return null;
        }

        @Nullable
        default public Object getRule() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String objectLockEnabled;
            private Object rule;

            public Builder objectLockEnabled(String objectLockEnabled) {
                this.objectLockEnabled = objectLockEnabled;
                return this;
            }

            public Builder rule(IResolvable rule) {
                this.rule = rule;
                return this;
            }

            public Builder rule(ObjectLockRuleProperty rule) {
                this.rule = rule;
                return this;
            }

            public ObjectLockConfigurationProperty build() {
                return new Jsii.Proxy(this.objectLockEnabled, this.rule, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.NotificationFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotificationFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Key();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object s3Key;

            public Builder s3Key(IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3Key(S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public NotificationFilterProperty build() {
                return new Jsii.Proxy(this.s3Key, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.NotificationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotificationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLambdaConfigurations() {
            return null;
        }

        @Nullable
        default public Object getQueueConfigurations() {
            return null;
        }

        @Nullable
        default public Object getTopicConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object lambdaConfigurations;
            private Object queueConfigurations;
            private Object topicConfigurations;

            public Builder lambdaConfigurations(IResolvable lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            public Builder lambdaConfigurations(List<Object> lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            public Builder queueConfigurations(IResolvable queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            public Builder queueConfigurations(List<Object> queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            public Builder topicConfigurations(IResolvable topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            public Builder topicConfigurations(List<Object> topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            public NotificationConfigurationProperty build() {
                return new Jsii.Proxy(this.lambdaConfigurations, this.queueConfigurations, this.topicConfigurations, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.NoncurrentVersionTransitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NoncurrentVersionTransitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getStorageClass();

        @NotNull
        public Number getTransitionInDays();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String storageClass;
            private Number transitionInDays;

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public Builder transitionInDays(Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            public NoncurrentVersionTransitionProperty build() {
                return new Jsii.Proxy(this.storageClass, this.transitionInDays, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.MetricsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String id;
            private String prefix;
            private Object tagFilters;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public MetricsConfigurationProperty build() {
                return new Jsii.Proxy(this.id, this.prefix, this.tagFilters, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDestinationBucketName() {
            return null;
        }

        @Nullable
        default public String getLogFilePrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String destinationBucketName;
            private String logFilePrefix;

            public Builder destinationBucketName(String destinationBucketName) {
                this.destinationBucketName = destinationBucketName;
                return this;
            }

            public Builder logFilePrefix(String logFilePrefix) {
                this.logFilePrefix = logFilePrefix;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new Jsii.Proxy(this.destinationBucketName, this.logFilePrefix, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.LifecycleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LifecycleConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<Object> rules) {
                this.rules = rules;
                return this;
            }

            public LifecycleConfigurationProperty build() {
                return new Jsii.Proxy(this.rules, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.LambdaConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEvent();

        @NotNull
        public String getFunction();

        @Nullable
        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String event;
            private String function;
            private Object filter;

            public Builder event(String event) {
                this.event = event;
                return this;
            }

            public Builder function(String function) {
                this.function = function;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public LambdaConfigurationProperty build() {
                return new Jsii.Proxy(this.event, this.function, this.filter, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.InventoryConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InventoryConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDestination();

        @NotNull
        public Object getEnabled();

        @NotNull
        public String getId();

        @NotNull
        public String getIncludedObjectVersions();

        @NotNull
        public String getScheduleFrequency();

        @Nullable
        default public List<String> getOptionalFields() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object destination;
            private Object enabled;
            private String id;
            private String includedObjectVersions;
            private String scheduleFrequency;
            private List<String> optionalFields;
            private String prefix;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder includedObjectVersions(String includedObjectVersions) {
                this.includedObjectVersions = includedObjectVersions;
                return this;
            }

            public Builder scheduleFrequency(String scheduleFrequency) {
                this.scheduleFrequency = scheduleFrequency;
                return this;
            }

            public Builder optionalFields(List<String> optionalFields) {
                this.optionalFields = optionalFields;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public InventoryConfigurationProperty build() {
                return new Jsii.Proxy(this.destination, this.enabled, this.id, this.includedObjectVersions, this.scheduleFrequency, this.optionalFields, this.prefix, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.FilterRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterRuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public FilterRuleProperty build() {
                return new Jsii.Proxy(this.name, this.value, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getReplicaKmsKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String replicaKmsKeyId;

            public Builder replicaKmsKeyId(String replicaKmsKeyId) {
                this.replicaKmsKeyId = replicaKmsKeyId;
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this.replicaKmsKeyId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.DestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @NotNull
        public String getFormat();

        @Nullable
        default public String getBucketAccountId() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucketArn;
            private String format;
            private String bucketAccountId;
            private String prefix;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder bucketAccountId(String bucketAccountId) {
                this.bucketAccountId = bucketAccountId;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public DestinationProperty build() {
                return new Jsii.Proxy(this.bucketArn, this.format, this.bucketAccountId, this.prefix, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.DefaultRetentionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultRetentionProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDays() {
            return null;
        }

        @Nullable
        default public String getMode() {
            return null;
        }

        @Nullable
        default public Number getYears() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number days;
            private String mode;
            private Number years;

            public Builder days(Number days) {
                this.days = days;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder years(Number years) {
                this.years = years;
                return this;
            }

            public DefaultRetentionProperty build() {
                return new Jsii.Proxy(this.days, this.mode, this.years, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.DataExportProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataExportProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDestination();

        @NotNull
        public String getOutputSchemaVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object destination;
            private String outputSchemaVersion;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder outputSchemaVersion(String outputSchemaVersion) {
                this.outputSchemaVersion = outputSchemaVersion;
                return this;
            }

            public DataExportProperty build() {
                return new Jsii.Proxy(this.destination, this.outputSchemaVersion, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.CorsRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CorsRuleProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getAllowedMethods();

        @NotNull
        public List<String> getAllowedOrigins();

        @Nullable
        default public List<String> getAllowedHeaders() {
            return null;
        }

        @Nullable
        default public List<String> getExposedHeaders() {
            return null;
        }

        @Nullable
        default public String getId() {
            return null;
        }

        @Nullable
        default public Number getMaxAge() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> allowedMethods;
            private List<String> allowedOrigins;
            private List<String> allowedHeaders;
            private List<String> exposedHeaders;
            private String id;
            private Number maxAge;

            public Builder allowedMethods(List<String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            public Builder allowedOrigins(List<String> allowedOrigins) {
                this.allowedOrigins = allowedOrigins;
                return this;
            }

            public Builder allowedHeaders(List<String> allowedHeaders) {
                this.allowedHeaders = allowedHeaders;
                return this;
            }

            public Builder exposedHeaders(List<String> exposedHeaders) {
                this.exposedHeaders = exposedHeaders;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder maxAge(Number maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            public CorsRuleProperty build() {
                return new Jsii.Proxy(this.allowedMethods, this.allowedOrigins, this.allowedHeaders, this.exposedHeaders, this.id, this.maxAge, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.CorsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CorsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCorsRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object corsRules;

            public Builder corsRules(IResolvable corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            public Builder corsRules(List<Object> corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            public CorsConfigurationProperty build() {
                return new Jsii.Proxy(this.corsRules, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.BucketEncryptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BucketEncryptionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getServerSideEncryptionConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object serverSideEncryptionConfiguration;

            public Builder serverSideEncryptionConfiguration(IResolvable serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            public Builder serverSideEncryptionConfiguration(List<Object> serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            public BucketEncryptionProperty build() {
                return new Jsii.Proxy(this.serverSideEncryptionConfiguration, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.AnalyticsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalyticsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @NotNull
        public Object getStorageClassAnalysis();

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String id;
            private Object storageClassAnalysis;
            private String prefix;
            private Object tagFilters;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder storageClassAnalysis(IResolvable storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            public Builder storageClassAnalysis(StorageClassAnalysisProperty storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public AnalyticsConfigurationProperty build() {
                return new Jsii.Proxy(this.id, this.storageClassAnalysis, this.prefix, this.tagFilters, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.AccessControlTranslationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessControlTranslationProperty
    extends JsiiSerializable {
        @NotNull
        public String getOwner();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String owner;

            public Builder owner(String owner) {
                this.owner = owner;
                return this;
            }

            public AccessControlTranslationProperty build() {
                return new Jsii.Proxy(this.owner, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.AccelerateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccelerateConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAccelerationStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String accelerationStatus;

            public Builder accelerationStatus(String accelerationStatus) {
                this.accelerationStatus = accelerationStatus;
                return this;
            }

            public AccelerateConfigurationProperty build() {
                return new Jsii.Proxy(this.accelerationStatus, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.AbortIncompleteMultipartUploadProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AbortIncompleteMultipartUploadProperty
    extends JsiiSerializable {
        @NotNull
        public Number getDaysAfterInitiation();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number daysAfterInitiation;

            public Builder daysAfterInitiation(Number daysAfterInitiation) {
                this.daysAfterInitiation = daysAfterInitiation;
                return this;
            }

            public AbortIncompleteMultipartUploadProperty build() {
                return new Jsii.Proxy(this.daysAfterInitiation, null);
            }
        }
    }
}

