/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.s3.$Module;
import software.amazon.awscdk.services.s3.CfnAccessPoint;
import software.amazon.awscdk.services.s3.CfnAccessPointProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-s3.CfnAccessPoint")
public class CfnAccessPoint
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAccessPoint.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnAccessPoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAccessPoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAccessPoint(Construct scope, String id, CfnAccessPointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public String getBucket() {
        return (String)this.jsiiGet("bucket", String.class);
    }

    public void setBucket(String value) {
        this.jsiiSet("bucket", Objects.requireNonNull(value, "bucket is required"));
    }

    public Object getPolicy() {
        return this.jsiiGet("policy", Object.class);
    }

    public void setPolicy(Object value) {
        this.jsiiSet("policy", Objects.requireNonNull(value, "policy is required"));
    }

    public Object getPolicyStatus() {
        return this.jsiiGet("policyStatus", Object.class);
    }

    public void setPolicyStatus(Object value) {
        this.jsiiSet("policyStatus", Objects.requireNonNull(value, "policyStatus is required"));
    }

    public String getCreationDate() {
        return (String)this.jsiiGet("creationDate", String.class);
    }

    public void setCreationDate(String value) {
        this.jsiiSet("creationDate", value);
    }

    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(String value) {
        this.jsiiSet("name", value);
    }

    public String getNetworkOrigin() {
        return (String)this.jsiiGet("networkOrigin", String.class);
    }

    public void setNetworkOrigin(String value) {
        this.jsiiSet("networkOrigin", value);
    }

    public Object getPublicAccessBlockConfiguration() {
        return this.jsiiGet("publicAccessBlockConfiguration", Object.class);
    }

    public void setPublicAccessBlockConfiguration(IResolvable value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    public void setPublicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty value) {
        this.jsiiSet("publicAccessBlockConfiguration", value);
    }

    public Object getVpcConfiguration() {
        return this.jsiiGet("vpcConfiguration", Object.class);
    }

    public void setVpcConfiguration(IResolvable value) {
        this.jsiiSet("vpcConfiguration", value);
    }

    public void setVpcConfiguration(VpcConfigurationProperty value) {
        this.jsiiSet("vpcConfiguration", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnAccessPointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAccessPointProps.Builder();
        }

        public Builder bucket(String bucket) {
            this.props.bucket(bucket);
            return this;
        }

        public Builder creationDate(String creationDate) {
            this.props.creationDate(creationDate);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder networkOrigin(String networkOrigin) {
            this.props.networkOrigin(networkOrigin);
            return this;
        }

        public Builder policy(Object policy) {
            this.props.policy(policy);
            return this;
        }

        public Builder policyStatus(Object policyStatus) {
            this.props.policyStatus(policyStatus);
            return this;
        }

        public Builder publicAccessBlockConfiguration(IResolvable publicAccessBlockConfiguration) {
            this.props.publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        public Builder publicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.props.publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        public Builder vpcConfiguration(IResolvable vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }

        public Builder vpcConfiguration(VpcConfigurationProperty vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }

        public CfnAccessPoint build() {
            return new CfnAccessPoint(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-s3.CfnAccessPoint.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigurationProperty
    extends JsiiSerializable {
        default public String getVpcId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String vpcId;

            public Builder vpcId(String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            public VpcConfigurationProperty build() {
                return new Jsii.Proxy(this.vpcId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-s3.CfnAccessPoint.PublicAccessBlockConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PublicAccessBlockConfigurationProperty
    extends JsiiSerializable {
        default public Object getBlockPublicAcls() {
            return null;
        }

        default public Object getBlockPublicPolicy() {
            return null;
        }

        default public Object getIgnorePublicAcls() {
            return null;
        }

        default public Object getRestrictPublicBuckets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object blockPublicAcls;
            private Object blockPublicPolicy;
            private Object ignorePublicAcls;
            private Object restrictPublicBuckets;

            public Builder blockPublicAcls(Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicAcls(IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicPolicy(Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder blockPublicPolicy(IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder ignorePublicAcls(Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder ignorePublicAcls(IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public Builder restrictPublicBuckets(IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii.Proxy(this.blockPublicAcls, this.blockPublicPolicy, this.ignorePublicAcls, this.restrictPublicBuckets, null);
            }
        }
    }
}

