package software.amazon.awscdk.services.s3;

/**
 * Properties for defining a `CfnBucket`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnBucket rawBucket = CfnBucket.Builder.create(this, "Bucket").build();
 * // -or-
 * CfnBucket rawBucketAlt = (CfnBucket)myBucket.getNode().getDefaultChild();
 * // then
 * rawBucket.getCfnOptions().getCondition() = CfnCondition.Builder.create(this, "EnableBucket").build();
 * rawBucket.getCfnOptions().getMetadata() = Map.of(
 *         "metadataKey", "MetadataValue");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:27.841Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucketProps")
@software.amazon.jsii.Jsii.Proxy(CfnBucketProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBucketProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configures the transfer acceleration state for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccelerateConfiguration() {
        return null;
    }

    /**
     * A canned access control list (ACL) that grants predefined permissions to the bucket.
     * <p>
     * For more information about canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Be aware that the syntax for this property differs from the information provided in the <em>Amazon S3 User Guide</em> . The AccessControl property is case-sensitive and must be one of the following values: Private, PublicRead, PublicReadWrite, AuthenticatedRead, LogDeliveryWrite, BucketOwnerRead, BucketOwnerFullControl, or AwsExecRead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessControl() {
        return null;
    }

    /**
     * Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAnalyticsConfigurations() {
        return null;
    }

    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.
     * <p>
     * For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Encryption for S3 Buckets</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBucketEncryption() {
        return null;
    }

    /**
     * A name for the bucket.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Amazon S3 bucket restrictions and limitations</a> . For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for naming Amazon S3 buckets</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return null;
    }

    /**
     * Describes the cross-origin access configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCorsConfiguration() {
        return null;
    }

    /**
     * Defines how Amazon S3 handles Intelligent-Tiering storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIntelligentTieringConfigurations() {
        return null;
    }

    /**
     * Specifies the inventory configuration for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <em>Amazon S3 API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInventoryConfigurations() {
        return null;
    }

    /**
     * Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleConfiguration() {
        return null;
    }

    /**
     * Settings that define where logs are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfiguration() {
        return null;
    }

    /**
     * Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.
     * <p>
     * If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PutBucketMetricsConfiguration</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetricsConfigurations() {
        return null;
    }

    /**
     * Configuration that defines how Amazon S3 handles bucket notifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationConfiguration() {
        return null;
    }

    /**
     * Places an Object Lock configuration on the specified bucket.
     * <p>
     * The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> .
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>The <code>DefaultRetention</code> settings require both a mode and a period.</li>
     * <li>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</li>
     * <li>You can only enable Object Lock for new buckets. If you want to turn on Object Lock for an existing bucket, contact AWS Support.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getObjectLockConfiguration() {
        return null;
    }

    /**
     * Indicates whether this bucket has an Object Lock configuration enabled.
     * <p>
     * Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getObjectLockEnabled() {
        return null;
    }

    /**
     * Configuration that defines how Amazon S3 handles Object Ownership rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOwnershipControls() {
        return null;
    }

    /**
     * Configuration that defines how Amazon S3 handles public access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPublicAccessBlockConfiguration() {
        return null;
    }

    /**
     * Configuration for replicating objects in an S3 bucket.
     * <p>
     * To enable replication, you must also enable versioning by using the <code>VersioningConfiguration</code> property.
     * <p>
     * Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReplicationConfiguration() {
        return null;
    }

    /**
     * An arbitrary set of tags (key-value pairs) for this S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * Enables multiple versions of all objects in this bucket.
     * <p>
     * You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVersioningConfiguration() {
        return null;
    }

    /**
     * Information used to configure the bucket as a static website.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWebsiteConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBucketProps> {
        java.lang.Object accelerateConfiguration;
        java.lang.String accessControl;
        java.lang.Object analyticsConfigurations;
        java.lang.Object bucketEncryption;
        java.lang.String bucketName;
        java.lang.Object corsConfiguration;
        java.lang.Object intelligentTieringConfigurations;
        java.lang.Object inventoryConfigurations;
        java.lang.Object lifecycleConfiguration;
        java.lang.Object loggingConfiguration;
        java.lang.Object metricsConfigurations;
        java.lang.Object notificationConfiguration;
        java.lang.Object objectLockConfiguration;
        java.lang.Object objectLockEnabled;
        java.lang.Object ownershipControls;
        java.lang.Object publicAccessBlockConfiguration;
        java.lang.Object replicationConfiguration;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Object versioningConfiguration;
        java.lang.Object websiteConfiguration;

        /**
         * Sets the value of {@link CfnBucketProps#getAccelerateConfiguration}
         * @param accelerateConfiguration Configures the transfer acceleration state for an Amazon S3 bucket.
         *                                For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerateConfiguration(software.amazon.awscdk.core.IResolvable accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getAccelerateConfiguration}
         * @param accelerateConfiguration Configures the transfer acceleration state for an Amazon S3 bucket.
         *                                For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerateConfiguration(software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getAccessControl}
         * @param accessControl A canned access control list (ACL) that grants predefined permissions to the bucket.
         *                      For more information about canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 User Guide</em> .
         *                      <p>
         *                      Be aware that the syntax for this property differs from the information provided in the <em>Amazon S3 User Guide</em> . The AccessControl property is case-sensitive and must be one of the following values: Private, PublicRead, PublicReadWrite, AuthenticatedRead, LogDeliveryWrite, BucketOwnerRead, BucketOwnerFullControl, or AwsExecRead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControl(java.lang.String accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getAnalyticsConfigurations}
         * @param analyticsConfigurations Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfigurations(software.amazon.awscdk.core.IResolvable analyticsConfigurations) {
            this.analyticsConfigurations = analyticsConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getAnalyticsConfigurations}
         * @param analyticsConfigurations Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfigurations(java.util.List<? extends java.lang.Object> analyticsConfigurations) {
            this.analyticsConfigurations = analyticsConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getBucketEncryption}
         * @param bucketEncryption Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.
         *                         For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Encryption for S3 Buckets</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(software.amazon.awscdk.core.IResolvable bucketEncryption) {
            this.bucketEncryption = bucketEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getBucketEncryption}
         * @param bucketEncryption Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.
         *                         For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Encryption for S3 Buckets</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty bucketEncryption) {
            this.bucketEncryption = bucketEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getBucketName}
         * @param bucketName A name for the bucket.
         *                   If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Amazon S3 bucket restrictions and limitations</a> . For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for naming Amazon S3 buckets</a> in the <em>Amazon S3 User Guide</em> .
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getCorsConfiguration}
         * @param corsConfiguration Describes the cross-origin access configuration for objects in an Amazon S3 bucket.
         *                          For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(software.amazon.awscdk.core.IResolvable corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getCorsConfiguration}
         * @param corsConfiguration Describes the cross-origin access configuration for objects in an Amazon S3 bucket.
         *                          For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getIntelligentTieringConfigurations}
         * @param intelligentTieringConfigurations Defines how Amazon S3 handles Intelligent-Tiering storage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder intelligentTieringConfigurations(software.amazon.awscdk.core.IResolvable intelligentTieringConfigurations) {
            this.intelligentTieringConfigurations = intelligentTieringConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getIntelligentTieringConfigurations}
         * @param intelligentTieringConfigurations Defines how Amazon S3 handles Intelligent-Tiering storage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder intelligentTieringConfigurations(java.util.List<? extends java.lang.Object> intelligentTieringConfigurations) {
            this.intelligentTieringConfigurations = intelligentTieringConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getInventoryConfigurations}
         * @param inventoryConfigurations Specifies the inventory configuration for an Amazon S3 bucket.
         *                                For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <em>Amazon S3 API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inventoryConfigurations(software.amazon.awscdk.core.IResolvable inventoryConfigurations) {
            this.inventoryConfigurations = inventoryConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getInventoryConfigurations}
         * @param inventoryConfigurations Specifies the inventory configuration for an Amazon S3 bucket.
         *                                For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <em>Amazon S3 API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inventoryConfigurations(java.util.List<? extends java.lang.Object> inventoryConfigurations) {
            this.inventoryConfigurations = inventoryConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getLifecycleConfiguration}
         * @param lifecycleConfiguration Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
         *                               For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(software.amazon.awscdk.core.IResolvable lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getLifecycleConfiguration}
         * @param lifecycleConfiguration Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
         *                               For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getLoggingConfiguration}
         * @param loggingConfiguration Settings that define where logs are stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.core.IResolvable loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getLoggingConfiguration}
         * @param loggingConfiguration Settings that define where logs are stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getMetricsConfigurations}
         * @param metricsConfigurations Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.
         *                              If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PutBucketMetricsConfiguration</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfigurations(software.amazon.awscdk.core.IResolvable metricsConfigurations) {
            this.metricsConfigurations = metricsConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getMetricsConfigurations}
         * @param metricsConfigurations Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.
         *                              If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PutBucketMetricsConfiguration</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfigurations(java.util.List<? extends java.lang.Object> metricsConfigurations) {
            this.metricsConfigurations = metricsConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getNotificationConfiguration}
         * @param notificationConfiguration Configuration that defines how Amazon S3 handles bucket notifications.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(software.amazon.awscdk.core.IResolvable notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getNotificationConfiguration}
         * @param notificationConfiguration Configuration that defines how Amazon S3 handles bucket notifications.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getObjectLockConfiguration}
         * @param objectLockConfiguration Places an Object Lock configuration on the specified bucket.
         *                                The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> .
         *                                <p>
         *                                <blockquote>
         *                                <p>
         *                                <ul>
         *                                <li>The <code>DefaultRetention</code> settings require both a mode and a period.</li>
         *                                <li>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</li>
         *                                <li>You can only enable Object Lock for new buckets. If you want to turn on Object Lock for an existing bucket, contact AWS Support.</li>
         *                                </ul>
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockConfiguration(software.amazon.awscdk.core.IResolvable objectLockConfiguration) {
            this.objectLockConfiguration = objectLockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getObjectLockConfiguration}
         * @param objectLockConfiguration Places an Object Lock configuration on the specified bucket.
         *                                The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a> .
         *                                <p>
         *                                <blockquote>
         *                                <p>
         *                                <ul>
         *                                <li>The <code>DefaultRetention</code> settings require both a mode and a period.</li>
         *                                <li>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</li>
         *                                <li>You can only enable Object Lock for new buckets. If you want to turn on Object Lock for an existing bucket, contact AWS Support.</li>
         *                                </ul>
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockConfiguration(software.amazon.awscdk.services.s3.CfnBucket.ObjectLockConfigurationProperty objectLockConfiguration) {
            this.objectLockConfiguration = objectLockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getObjectLockEnabled}
         * @param objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled.
         *                          Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockEnabled(java.lang.Boolean objectLockEnabled) {
            this.objectLockEnabled = objectLockEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getObjectLockEnabled}
         * @param objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled.
         *                          Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLockEnabled(software.amazon.awscdk.core.IResolvable objectLockEnabled) {
            this.objectLockEnabled = objectLockEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getOwnershipControls}
         * @param ownershipControls Configuration that defines how Amazon S3 handles Object Ownership rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipControls(software.amazon.awscdk.core.IResolvable ownershipControls) {
            this.ownershipControls = ownershipControls;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getOwnershipControls}
         * @param ownershipControls Configuration that defines how Amazon S3 handles Object Ownership rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipControls(software.amazon.awscdk.services.s3.CfnBucket.OwnershipControlsProperty ownershipControls) {
            this.ownershipControls = ownershipControls;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getPublicAccessBlockConfiguration}
         * @param publicAccessBlockConfiguration Configuration that defines how Amazon S3 handles public access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(software.amazon.awscdk.core.IResolvable publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getPublicAccessBlockConfiguration}
         * @param publicAccessBlockConfiguration Configuration that defines how Amazon S3 handles public access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getReplicationConfiguration}
         * @param replicationConfiguration Configuration for replicating objects in an S3 bucket.
         *                                 To enable replication, you must also enable versioning by using the <code>VersioningConfiguration</code> property.
         *                                 <p>
         *                                 Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(software.amazon.awscdk.core.IResolvable replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getReplicationConfiguration}
         * @param replicationConfiguration Configuration for replicating objects in an S3 bucket.
         *                                 To enable replication, you must also enable versioning by using the <code>VersioningConfiguration</code> property.
         *                                 <p>
         *                                 Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getTags}
         * @param tags An arbitrary set of tags (key-value pairs) for this S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getVersioningConfiguration}
         * @param versioningConfiguration Enables multiple versions of all objects in this bucket.
         *                                You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(software.amazon.awscdk.core.IResolvable versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getVersioningConfiguration}
         * @param versioningConfiguration Enables multiple versions of all objects in this bucket.
         *                                You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versioningConfiguration(software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getWebsiteConfiguration}
         * @param websiteConfiguration Information used to configure the bucket as a static website.
         *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteConfiguration(software.amazon.awscdk.core.IResolvable websiteConfiguration) {
            this.websiteConfiguration = websiteConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getWebsiteConfiguration}
         * @param websiteConfiguration Information used to configure the bucket as a static website.
         *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteConfiguration(software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty websiteConfiguration) {
            this.websiteConfiguration = websiteConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBucketProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBucketProps {
        private final java.lang.Object accelerateConfiguration;
        private final java.lang.String accessControl;
        private final java.lang.Object analyticsConfigurations;
        private final java.lang.Object bucketEncryption;
        private final java.lang.String bucketName;
        private final java.lang.Object corsConfiguration;
        private final java.lang.Object intelligentTieringConfigurations;
        private final java.lang.Object inventoryConfigurations;
        private final java.lang.Object lifecycleConfiguration;
        private final java.lang.Object loggingConfiguration;
        private final java.lang.Object metricsConfigurations;
        private final java.lang.Object notificationConfiguration;
        private final java.lang.Object objectLockConfiguration;
        private final java.lang.Object objectLockEnabled;
        private final java.lang.Object ownershipControls;
        private final java.lang.Object publicAccessBlockConfiguration;
        private final java.lang.Object replicationConfiguration;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object versioningConfiguration;
        private final java.lang.Object websiteConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accelerateConfiguration = software.amazon.jsii.Kernel.get(this, "accelerateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.accessControl = software.amazon.jsii.Kernel.get(this, "accessControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.analyticsConfigurations = software.amazon.jsii.Kernel.get(this, "analyticsConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bucketEncryption = software.amazon.jsii.Kernel.get(this, "bucketEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.corsConfiguration = software.amazon.jsii.Kernel.get(this, "corsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.intelligentTieringConfigurations = software.amazon.jsii.Kernel.get(this, "intelligentTieringConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inventoryConfigurations = software.amazon.jsii.Kernel.get(this, "inventoryConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lifecycleConfiguration = software.amazon.jsii.Kernel.get(this, "lifecycleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.loggingConfiguration = software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.metricsConfigurations = software.amazon.jsii.Kernel.get(this, "metricsConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationConfiguration = software.amazon.jsii.Kernel.get(this, "notificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.objectLockConfiguration = software.amazon.jsii.Kernel.get(this, "objectLockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.objectLockEnabled = software.amazon.jsii.Kernel.get(this, "objectLockEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ownershipControls = software.amazon.jsii.Kernel.get(this, "ownershipControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.publicAccessBlockConfiguration = software.amazon.jsii.Kernel.get(this, "publicAccessBlockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replicationConfiguration = software.amazon.jsii.Kernel.get(this, "replicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.versioningConfiguration = software.amazon.jsii.Kernel.get(this, "versioningConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.websiteConfiguration = software.amazon.jsii.Kernel.get(this, "websiteConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accelerateConfiguration = builder.accelerateConfiguration;
            this.accessControl = builder.accessControl;
            this.analyticsConfigurations = builder.analyticsConfigurations;
            this.bucketEncryption = builder.bucketEncryption;
            this.bucketName = builder.bucketName;
            this.corsConfiguration = builder.corsConfiguration;
            this.intelligentTieringConfigurations = builder.intelligentTieringConfigurations;
            this.inventoryConfigurations = builder.inventoryConfigurations;
            this.lifecycleConfiguration = builder.lifecycleConfiguration;
            this.loggingConfiguration = builder.loggingConfiguration;
            this.metricsConfigurations = builder.metricsConfigurations;
            this.notificationConfiguration = builder.notificationConfiguration;
            this.objectLockConfiguration = builder.objectLockConfiguration;
            this.objectLockEnabled = builder.objectLockEnabled;
            this.ownershipControls = builder.ownershipControls;
            this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
            this.replicationConfiguration = builder.replicationConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.versioningConfiguration = builder.versioningConfiguration;
            this.websiteConfiguration = builder.websiteConfiguration;
        }

        @Override
        public final java.lang.Object getAccelerateConfiguration() {
            return this.accelerateConfiguration;
        }

        @Override
        public final java.lang.String getAccessControl() {
            return this.accessControl;
        }

        @Override
        public final java.lang.Object getAnalyticsConfigurations() {
            return this.analyticsConfigurations;
        }

        @Override
        public final java.lang.Object getBucketEncryption() {
            return this.bucketEncryption;
        }

        @Override
        public final java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final java.lang.Object getCorsConfiguration() {
            return this.corsConfiguration;
        }

        @Override
        public final java.lang.Object getIntelligentTieringConfigurations() {
            return this.intelligentTieringConfigurations;
        }

        @Override
        public final java.lang.Object getInventoryConfigurations() {
            return this.inventoryConfigurations;
        }

        @Override
        public final java.lang.Object getLifecycleConfiguration() {
            return this.lifecycleConfiguration;
        }

        @Override
        public final java.lang.Object getLoggingConfiguration() {
            return this.loggingConfiguration;
        }

        @Override
        public final java.lang.Object getMetricsConfigurations() {
            return this.metricsConfigurations;
        }

        @Override
        public final java.lang.Object getNotificationConfiguration() {
            return this.notificationConfiguration;
        }

        @Override
        public final java.lang.Object getObjectLockConfiguration() {
            return this.objectLockConfiguration;
        }

        @Override
        public final java.lang.Object getObjectLockEnabled() {
            return this.objectLockEnabled;
        }

        @Override
        public final java.lang.Object getOwnershipControls() {
            return this.ownershipControls;
        }

        @Override
        public final java.lang.Object getPublicAccessBlockConfiguration() {
            return this.publicAccessBlockConfiguration;
        }

        @Override
        public final java.lang.Object getReplicationConfiguration() {
            return this.replicationConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVersioningConfiguration() {
            return this.versioningConfiguration;
        }

        @Override
        public final java.lang.Object getWebsiteConfiguration() {
            return this.websiteConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccelerateConfiguration() != null) {
                data.set("accelerateConfiguration", om.valueToTree(this.getAccelerateConfiguration()));
            }
            if (this.getAccessControl() != null) {
                data.set("accessControl", om.valueToTree(this.getAccessControl()));
            }
            if (this.getAnalyticsConfigurations() != null) {
                data.set("analyticsConfigurations", om.valueToTree(this.getAnalyticsConfigurations()));
            }
            if (this.getBucketEncryption() != null) {
                data.set("bucketEncryption", om.valueToTree(this.getBucketEncryption()));
            }
            if (this.getBucketName() != null) {
                data.set("bucketName", om.valueToTree(this.getBucketName()));
            }
            if (this.getCorsConfiguration() != null) {
                data.set("corsConfiguration", om.valueToTree(this.getCorsConfiguration()));
            }
            if (this.getIntelligentTieringConfigurations() != null) {
                data.set("intelligentTieringConfigurations", om.valueToTree(this.getIntelligentTieringConfigurations()));
            }
            if (this.getInventoryConfigurations() != null) {
                data.set("inventoryConfigurations", om.valueToTree(this.getInventoryConfigurations()));
            }
            if (this.getLifecycleConfiguration() != null) {
                data.set("lifecycleConfiguration", om.valueToTree(this.getLifecycleConfiguration()));
            }
            if (this.getLoggingConfiguration() != null) {
                data.set("loggingConfiguration", om.valueToTree(this.getLoggingConfiguration()));
            }
            if (this.getMetricsConfigurations() != null) {
                data.set("metricsConfigurations", om.valueToTree(this.getMetricsConfigurations()));
            }
            if (this.getNotificationConfiguration() != null) {
                data.set("notificationConfiguration", om.valueToTree(this.getNotificationConfiguration()));
            }
            if (this.getObjectLockConfiguration() != null) {
                data.set("objectLockConfiguration", om.valueToTree(this.getObjectLockConfiguration()));
            }
            if (this.getObjectLockEnabled() != null) {
                data.set("objectLockEnabled", om.valueToTree(this.getObjectLockEnabled()));
            }
            if (this.getOwnershipControls() != null) {
                data.set("ownershipControls", om.valueToTree(this.getOwnershipControls()));
            }
            if (this.getPublicAccessBlockConfiguration() != null) {
                data.set("publicAccessBlockConfiguration", om.valueToTree(this.getPublicAccessBlockConfiguration()));
            }
            if (this.getReplicationConfiguration() != null) {
                data.set("replicationConfiguration", om.valueToTree(this.getReplicationConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVersioningConfiguration() != null) {
                data.set("versioningConfiguration", om.valueToTree(this.getVersioningConfiguration()));
            }
            if (this.getWebsiteConfiguration() != null) {
                data.set("websiteConfiguration", om.valueToTree(this.getWebsiteConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3.CfnBucketProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBucketProps.Jsii$Proxy that = (CfnBucketProps.Jsii$Proxy) o;

            if (this.accelerateConfiguration != null ? !this.accelerateConfiguration.equals(that.accelerateConfiguration) : that.accelerateConfiguration != null) return false;
            if (this.accessControl != null ? !this.accessControl.equals(that.accessControl) : that.accessControl != null) return false;
            if (this.analyticsConfigurations != null ? !this.analyticsConfigurations.equals(that.analyticsConfigurations) : that.analyticsConfigurations != null) return false;
            if (this.bucketEncryption != null ? !this.bucketEncryption.equals(that.bucketEncryption) : that.bucketEncryption != null) return false;
            if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
            if (this.corsConfiguration != null ? !this.corsConfiguration.equals(that.corsConfiguration) : that.corsConfiguration != null) return false;
            if (this.intelligentTieringConfigurations != null ? !this.intelligentTieringConfigurations.equals(that.intelligentTieringConfigurations) : that.intelligentTieringConfigurations != null) return false;
            if (this.inventoryConfigurations != null ? !this.inventoryConfigurations.equals(that.inventoryConfigurations) : that.inventoryConfigurations != null) return false;
            if (this.lifecycleConfiguration != null ? !this.lifecycleConfiguration.equals(that.lifecycleConfiguration) : that.lifecycleConfiguration != null) return false;
            if (this.loggingConfiguration != null ? !this.loggingConfiguration.equals(that.loggingConfiguration) : that.loggingConfiguration != null) return false;
            if (this.metricsConfigurations != null ? !this.metricsConfigurations.equals(that.metricsConfigurations) : that.metricsConfigurations != null) return false;
            if (this.notificationConfiguration != null ? !this.notificationConfiguration.equals(that.notificationConfiguration) : that.notificationConfiguration != null) return false;
            if (this.objectLockConfiguration != null ? !this.objectLockConfiguration.equals(that.objectLockConfiguration) : that.objectLockConfiguration != null) return false;
            if (this.objectLockEnabled != null ? !this.objectLockEnabled.equals(that.objectLockEnabled) : that.objectLockEnabled != null) return false;
            if (this.ownershipControls != null ? !this.ownershipControls.equals(that.ownershipControls) : that.ownershipControls != null) return false;
            if (this.publicAccessBlockConfiguration != null ? !this.publicAccessBlockConfiguration.equals(that.publicAccessBlockConfiguration) : that.publicAccessBlockConfiguration != null) return false;
            if (this.replicationConfiguration != null ? !this.replicationConfiguration.equals(that.replicationConfiguration) : that.replicationConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.versioningConfiguration != null ? !this.versioningConfiguration.equals(that.versioningConfiguration) : that.versioningConfiguration != null) return false;
            return this.websiteConfiguration != null ? this.websiteConfiguration.equals(that.websiteConfiguration) : that.websiteConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accelerateConfiguration != null ? this.accelerateConfiguration.hashCode() : 0;
            result = 31 * result + (this.accessControl != null ? this.accessControl.hashCode() : 0);
            result = 31 * result + (this.analyticsConfigurations != null ? this.analyticsConfigurations.hashCode() : 0);
            result = 31 * result + (this.bucketEncryption != null ? this.bucketEncryption.hashCode() : 0);
            result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
            result = 31 * result + (this.corsConfiguration != null ? this.corsConfiguration.hashCode() : 0);
            result = 31 * result + (this.intelligentTieringConfigurations != null ? this.intelligentTieringConfigurations.hashCode() : 0);
            result = 31 * result + (this.inventoryConfigurations != null ? this.inventoryConfigurations.hashCode() : 0);
            result = 31 * result + (this.lifecycleConfiguration != null ? this.lifecycleConfiguration.hashCode() : 0);
            result = 31 * result + (this.loggingConfiguration != null ? this.loggingConfiguration.hashCode() : 0);
            result = 31 * result + (this.metricsConfigurations != null ? this.metricsConfigurations.hashCode() : 0);
            result = 31 * result + (this.notificationConfiguration != null ? this.notificationConfiguration.hashCode() : 0);
            result = 31 * result + (this.objectLockConfiguration != null ? this.objectLockConfiguration.hashCode() : 0);
            result = 31 * result + (this.objectLockEnabled != null ? this.objectLockEnabled.hashCode() : 0);
            result = 31 * result + (this.ownershipControls != null ? this.ownershipControls.hashCode() : 0);
            result = 31 * result + (this.publicAccessBlockConfiguration != null ? this.publicAccessBlockConfiguration.hashCode() : 0);
            result = 31 * result + (this.replicationConfiguration != null ? this.replicationConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.versioningConfiguration != null ? this.versioningConfiguration.hashCode() : 0);
            result = 31 * result + (this.websiteConfiguration != null ? this.websiteConfiguration.hashCode() : 0);
            return result;
        }
    }
}
