/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.BlockPublicAccess;
import software.amazon.awscdk.services.s3.BucketAccessControl;
import software.amazon.awscdk.services.s3.BucketAttributes;
import software.amazon.awscdk.services.s3.BucketBase;
import software.amazon.awscdk.services.s3.BucketEncryption;
import software.amazon.awscdk.services.s3.BucketMetrics;
import software.amazon.awscdk.services.s3.BucketPolicy;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awscdk.services.s3.CorsRule;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.Inventory;
import software.amazon.awscdk.services.s3.LifecycleRule;
import software.amazon.awscdk.services.s3.ObjectOwnership;
import software.amazon.awscdk.services.s3.RedirectTarget;
import software.amazon.awscdk.services.s3.RoutingRule;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.Bucket")
public class Bucket
extends BucketBase {
    protected Bucket(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Bucket(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Bucket(@NotNull Construct scope, @NotNull String id, @Nullable BucketProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Bucket(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IBucket fromBucketArn(@NotNull Construct scope, @NotNull String id, @NotNull String bucketArn) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"fromBucketArn", (NativeType)NativeType.forClass(IBucket.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(bucketArn, "bucketArn is required")});
    }

    @NotNull
    public static IBucket fromBucketAttributes(@NotNull Construct scope, @NotNull String id, @NotNull BucketAttributes attrs) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"fromBucketAttributes", (NativeType)NativeType.forClass(IBucket.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IBucket fromBucketName(@NotNull Construct scope, @NotNull String id, @NotNull String bucketName) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"fromBucketName", (NativeType)NativeType.forClass(IBucket.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(bucketName, "bucketName is required")});
    }

    public static void validateBucketName(@NotNull String physicalName) {
        JsiiObject.jsiiStaticCall(Bucket.class, (String)"validateBucketName", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(physicalName, "physicalName is required")});
    }

    public void addCorsRule(@NotNull CorsRule rule) {
        Kernel.call((Object)this, (String)"addCorsRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public void addInventory(@NotNull Inventory inventory) {
        Kernel.call((Object)this, (String)"addInventory", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inventory, "inventory is required")});
    }

    public void addLifecycleRule(@NotNull LifecycleRule rule) {
        Kernel.call((Object)this, (String)"addLifecycleRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public void addMetric(@NotNull BucketMetrics metric) {
        Kernel.call((Object)this, (String)"addMetric", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(metric, "metric is required")});
    }

    @Override
    @NotNull
    public String getBucketArn() {
        return (String)Kernel.get((Object)this, (String)"bucketArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketDomainName() {
        return (String)Kernel.get((Object)this, (String)"bucketDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketDualStackDomainName() {
        return (String)Kernel.get((Object)this, (String)"bucketDualStackDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketName() {
        return (String)Kernel.get((Object)this, (String)"bucketName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketRegionalDomainName() {
        return (String)Kernel.get((Object)this, (String)"bucketRegionalDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketWebsiteDomainName() {
        return (String)Kernel.get((Object)this, (String)"bucketWebsiteDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBucketWebsiteUrl() {
        return (String)Kernel.get((Object)this, (String)"bucketWebsiteUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"encryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Override
    @Nullable
    public Boolean getIsWebsite() {
        return (Boolean)Kernel.get((Object)this, (String)"isWebsite", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    protected Boolean getAutoCreatePolicy() {
        return (Boolean)Kernel.get((Object)this, (String)"autoCreatePolicy", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    protected void setAutoCreatePolicy(@NotNull Boolean value) {
        Kernel.set((Object)this, (String)"autoCreatePolicy", (Object)Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    @Override
    @Nullable
    protected Boolean getDisallowPublicAccess() {
        return (Boolean)Kernel.get((Object)this, (String)"disallowPublicAccess", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    protected void setDisallowPublicAccess(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"disallowPublicAccess", (Object)value);
    }

    @Override
    @Nullable
    public BucketPolicy getPolicy() {
        return (BucketPolicy)((Object)Kernel.get((Object)this, (String)"policy", (NativeType)NativeType.forClass(BucketPolicy.class)));
    }

    @Override
    public void setPolicy(@Nullable BucketPolicy value) {
        Kernel.set((Object)this, (String)"policy", (Object)((Object)value));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Bucket> {
        private final Construct scope;
        private final String id;
        private BucketProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder accessControl(BucketAccessControl accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        public Builder autoDeleteObjects(Boolean autoDeleteObjects) {
            this.props().autoDeleteObjects(autoDeleteObjects);
            return this;
        }

        public Builder blockPublicAccess(BlockPublicAccess blockPublicAccess) {
            this.props().blockPublicAccess(blockPublicAccess);
            return this;
        }

        public Builder bucketKeyEnabled(Boolean bucketKeyEnabled) {
            this.props().bucketKeyEnabled(bucketKeyEnabled);
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.props().bucketName(bucketName);
            return this;
        }

        public Builder cors(List<? extends CorsRule> cors) {
            this.props().cors(cors);
            return this;
        }

        public Builder encryption(BucketEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder enforceSsl(Boolean enforceSsl) {
            this.props().enforceSsl(enforceSsl);
            return this;
        }

        public Builder inventories(List<? extends Inventory> inventories) {
            this.props().inventories(inventories);
            return this;
        }

        public Builder lifecycleRules(List<? extends LifecycleRule> lifecycleRules) {
            this.props().lifecycleRules(lifecycleRules);
            return this;
        }

        public Builder metrics(List<? extends BucketMetrics> metrics) {
            this.props().metrics(metrics);
            return this;
        }

        public Builder objectOwnership(ObjectOwnership objectOwnership) {
            this.props().objectOwnership(objectOwnership);
            return this;
        }

        public Builder publicReadAccess(Boolean publicReadAccess) {
            this.props().publicReadAccess(publicReadAccess);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder serverAccessLogsBucket(IBucket serverAccessLogsBucket) {
            this.props().serverAccessLogsBucket(serverAccessLogsBucket);
            return this;
        }

        public Builder serverAccessLogsPrefix(String serverAccessLogsPrefix) {
            this.props().serverAccessLogsPrefix(serverAccessLogsPrefix);
            return this;
        }

        public Builder versioned(Boolean versioned) {
            this.props().versioned(versioned);
            return this;
        }

        public Builder websiteErrorDocument(String websiteErrorDocument) {
            this.props().websiteErrorDocument(websiteErrorDocument);
            return this;
        }

        public Builder websiteIndexDocument(String websiteIndexDocument) {
            this.props().websiteIndexDocument(websiteIndexDocument);
            return this;
        }

        public Builder websiteRedirect(RedirectTarget websiteRedirect) {
            this.props().websiteRedirect(websiteRedirect);
            return this;
        }

        public Builder websiteRoutingRules(List<? extends RoutingRule> websiteRoutingRules) {
            this.props().websiteRoutingRules(websiteRoutingRules);
            return this;
        }

        public Bucket build() {
            return new Bucket(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private BucketProps.Builder props() {
            if (this.props == null) {
                this.props = new BucketProps.Builder();
            }
            return this.props;
        }
    }
}

