/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.cloudformation;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.BucketArn;
import software.amazon.awscdk.services.s3.BucketDomainName;
import software.amazon.awscdk.services.s3.BucketDualStackDomainName;
import software.amazon.awscdk.services.s3.BucketWebsiteUrl;
import software.amazon.awscdk.services.s3.cloudformation.BucketResource;
import software.amazon.awscdk.services.s3.cloudformation.BucketResourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.cloudformation.BucketResource")
public class BucketResource
extends Resource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(BucketResource.class, (String)"resourceTypeName", String.class);

    protected BucketResource(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public BucketResource(Construct parent, String name, @Nullable BucketResourceProps properties) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(parent, "parent is required")), Stream.of(Objects.requireNonNull(name, "name is required"))), Stream.of(properties)).toArray());
    }

    public BucketResource(Construct parent, String name) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.of(Objects.requireNonNull(parent, "parent is required")), Stream.of(Objects.requireNonNull(name, "name is required"))).toArray());
    }

    protected Map<String, Object> renderProperties() {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[0]);
    }

    public BucketArn getBucketArn() {
        return (BucketArn)((Object)this.jsiiGet("bucketArn", BucketArn.class));
    }

    public BucketDomainName getBucketDomainName() {
        return (BucketDomainName)((Object)this.jsiiGet("bucketDomainName", BucketDomainName.class));
    }

    public BucketDualStackDomainName getBucketDualStackDomainName() {
        return (BucketDualStackDomainName)((Object)this.jsiiGet("bucketDualStackDomainName", BucketDualStackDomainName.class));
    }

    public BucketWebsiteUrl getBucketWebsiteUrl() {
        return (BucketWebsiteUrl)((Object)this.jsiiGet("bucketWebsiteUrl", BucketWebsiteUrl.class));
    }

    public static interface WebsiteConfigurationProperty
    extends JsiiSerializable {
        public Object getErrorDocument();

        public void setErrorDocument(String var1);

        public void setErrorDocument(Token var1);

        public Object getIndexDocument();

        public void setIndexDocument(String var1);

        public void setIndexDocument(Token var1);

        public Object getRedirectAllRequestsTo();

        public void setRedirectAllRequestsTo(Token var1);

        public void setRedirectAllRequestsTo(RedirectAllRequestsToProperty var1);

        public Object getRoutingRules();

        public void setRoutingRules(Token var1);

        public void setRoutingRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Jsii.Pojo instance = new Jsii.Pojo();

            public Builder withErrorDocument(String value) {
                this.instance._errorDocument = value;
                return this;
            }

            public Builder withErrorDocument(Token value) {
                this.instance._errorDocument = value;
                return this;
            }

            public Builder withIndexDocument(String value) {
                this.instance._indexDocument = value;
                return this;
            }

            public Builder withIndexDocument(Token value) {
                this.instance._indexDocument = value;
                return this;
            }

            public Builder withRedirectAllRequestsTo(Token value) {
                this.instance._redirectAllRequestsTo = value;
                return this;
            }

            public Builder withRedirectAllRequestsTo(RedirectAllRequestsToProperty value) {
                this.instance._redirectAllRequestsTo = value;
                return this;
            }

            public Builder withRoutingRules(Token value) {
                this.instance._routingRules = value;
                return this;
            }

            public Builder withRoutingRules(List<Object> value) {
                this.instance._routingRules = value;
                return this;
            }

            public WebsiteConfigurationProperty build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }
    }

    public static interface VersioningConfigurationProperty
    extends JsiiSerializable {
        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withStatus(String value) {
                return new FullBuilder().withStatus(value);
            }

            public Build withStatus(Token value) {
                return new FullBuilder().withStatus(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withStatus(String value) {
                    Objects.requireNonNull(value, "VersioningConfigurationProperty#status is required");
                    this.instance._status = value;
                    return this;
                }

                public Build withStatus(Token value) {
                    Objects.requireNonNull(value, "VersioningConfigurationProperty#status is required");
                    this.instance._status = value;
                    return this;
                }

                @Override
                public VersioningConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public VersioningConfigurationProperty build();
            }
        }
    }

    public static interface TransitionProperty
    extends JsiiSerializable {
        public Object getStorageClass();

        public void setStorageClass(String var1);

        public void setStorageClass(Token var1);

        public Object getTransitionDate();

        public void setTransitionDate(Token var1);

        public void setTransitionDate(Instant var1);

        public Object getTransitionInDays();

        public void setTransitionInDays(Number var1);

        public void setTransitionInDays(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withStorageClass(String value) {
                return new FullBuilder().withStorageClass(value);
            }

            public Build withStorageClass(Token value) {
                return new FullBuilder().withStorageClass(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withStorageClass(String value) {
                    Objects.requireNonNull(value, "TransitionProperty#storageClass is required");
                    this.instance._storageClass = value;
                    return this;
                }

                public Build withStorageClass(Token value) {
                    Objects.requireNonNull(value, "TransitionProperty#storageClass is required");
                    this.instance._storageClass = value;
                    return this;
                }

                @Override
                public Build withTransitionDate(Token value) {
                    this.instance._transitionDate = value;
                    return this;
                }

                @Override
                public Build withTransitionDate(Instant value) {
                    this.instance._transitionDate = value;
                    return this;
                }

                @Override
                public Build withTransitionInDays(Number value) {
                    this.instance._transitionInDays = value;
                    return this;
                }

                @Override
                public Build withTransitionInDays(Token value) {
                    this.instance._transitionInDays = value;
                    return this;
                }

                @Override
                public TransitionProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public TransitionProperty build();

                public Build withTransitionDate(Token var1);

                public Build withTransitionDate(Instant var1);

                public Build withTransitionInDays(Number var1);

                public Build withTransitionInDays(Token var1);
            }
        }
    }

    public static interface TopicConfigurationProperty
    extends JsiiSerializable {
        public Object getEvent();

        public void setEvent(String var1);

        public void setEvent(Token var1);

        public Object getFilter();

        public void setFilter(Token var1);

        public void setFilter(NotificationFilterProperty var1);

        public Object getTopic();

        public void setTopic(String var1);

        public void setTopic(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public TopicStep withEvent(String value) {
                return new FullBuilder().withEvent(value);
            }

            public TopicStep withEvent(Token value) {
                return new FullBuilder().withEvent(value);
            }

            final class FullBuilder
            implements TopicStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public TopicStep withEvent(String value) {
                    Objects.requireNonNull(value, "TopicConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }

                public TopicStep withEvent(Token value) {
                    Objects.requireNonNull(value, "TopicConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }

                @Override
                public Build withFilter(Token value) {
                    this.instance._filter = value;
                    return this;
                }

                @Override
                public Build withFilter(NotificationFilterProperty value) {
                    this.instance._filter = value;
                    return this;
                }

                @Override
                public Build withTopic(String value) {
                    Objects.requireNonNull(value, "TopicConfigurationProperty#topic is required");
                    this.instance._topic = value;
                    return this;
                }

                @Override
                public Build withTopic(Token value) {
                    Objects.requireNonNull(value, "TopicConfigurationProperty#topic is required");
                    this.instance._topic = value;
                    return this;
                }

                @Override
                public TopicConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public TopicConfigurationProperty build();

                public Build withFilter(Token var1);

                public Build withFilter(NotificationFilterProperty var1);
            }

            public static interface TopicStep {
                public Build withTopic(String var1);

                public Build withTopic(Token var1);
            }
        }
    }

    public static interface TagFilterProperty
    extends JsiiSerializable {
        public Object getKey();

        public void setKey(String var1);

        public void setKey(Token var1);

        public Object getValue();

        public void setValue(String var1);

        public void setValue(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public ValueStep withKey(String value) {
                return new FullBuilder().withKey(value);
            }

            public ValueStep withKey(Token value) {
                return new FullBuilder().withKey(value);
            }

            final class FullBuilder
            implements ValueStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public ValueStep withKey(String value) {
                    Objects.requireNonNull(value, "TagFilterProperty#key is required");
                    this.instance._key = value;
                    return this;
                }

                public ValueStep withKey(Token value) {
                    Objects.requireNonNull(value, "TagFilterProperty#key is required");
                    this.instance._key = value;
                    return this;
                }

                @Override
                public Build withValue(String value) {
                    Objects.requireNonNull(value, "TagFilterProperty#value is required");
                    this.instance._value = value;
                    return this;
                }

                @Override
                public Build withValue(Token value) {
                    Objects.requireNonNull(value, "TagFilterProperty#value is required");
                    this.instance._value = value;
                    return this;
                }

                @Override
                public TagFilterProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public TagFilterProperty build();
            }

            public static interface ValueStep {
                public Build withValue(String var1);

                public Build withValue(Token var1);
            }
        }
    }

    public static interface StorageClassAnalysisProperty
    extends JsiiSerializable {
        public Object getDataExport();

        public void setDataExport(Token var1);

        public void setDataExport(DataExportProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Jsii.Pojo instance = new Jsii.Pojo();

            public Builder withDataExport(Token value) {
                this.instance._dataExport = value;
                return this;
            }

            public Builder withDataExport(DataExportProperty value) {
                this.instance._dataExport = value;
                return this;
            }

            public StorageClassAnalysisProperty build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }
    }

    public static interface SseKmsEncryptedObjectsProperty
    extends JsiiSerializable {
        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withStatus(String value) {
                return new FullBuilder().withStatus(value);
            }

            public Build withStatus(Token value) {
                return new FullBuilder().withStatus(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withStatus(String value) {
                    Objects.requireNonNull(value, "SseKmsEncryptedObjectsProperty#status is required");
                    this.instance._status = value;
                    return this;
                }

                public Build withStatus(Token value) {
                    Objects.requireNonNull(value, "SseKmsEncryptedObjectsProperty#status is required");
                    this.instance._status = value;
                    return this;
                }

                @Override
                public SseKmsEncryptedObjectsProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public SseKmsEncryptedObjectsProperty build();
            }
        }
    }

    public static interface SourceSelectionCriteriaProperty
    extends JsiiSerializable {
        public Object getSseKmsEncryptedObjects();

        public void setSseKmsEncryptedObjects(Token var1);

        public void setSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withSseKmsEncryptedObjects(Token value) {
                return new FullBuilder().withSseKmsEncryptedObjects(value);
            }

            public Build withSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty value) {
                return new FullBuilder().withSseKmsEncryptedObjects(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withSseKmsEncryptedObjects(Token value) {
                    Objects.requireNonNull(value, "SourceSelectionCriteriaProperty#sseKmsEncryptedObjects is required");
                    this.instance._sseKmsEncryptedObjects = value;
                    return this;
                }

                public Build withSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty value) {
                    Objects.requireNonNull(value, "SourceSelectionCriteriaProperty#sseKmsEncryptedObjects is required");
                    this.instance._sseKmsEncryptedObjects = value;
                    return this;
                }

                @Override
                public SourceSelectionCriteriaProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public SourceSelectionCriteriaProperty build();
            }
        }
    }

    public static interface ServerSideEncryptionRuleProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionByDefault();

        public void setServerSideEncryptionByDefault(Token var1);

        public void setServerSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Jsii.Pojo instance = new Jsii.Pojo();

            public Builder withServerSideEncryptionByDefault(Token value) {
                this.instance._serverSideEncryptionByDefault = value;
                return this;
            }

            public Builder withServerSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty value) {
                this.instance._serverSideEncryptionByDefault = value;
                return this;
            }

            public ServerSideEncryptionRuleProperty build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }
    }

    public static interface ServerSideEncryptionByDefaultProperty
    extends JsiiSerializable {
        public Object getKmsMasterKeyId();

        public void setKmsMasterKeyId(String var1);

        public void setKmsMasterKeyId(Token var1);

        public Object getSseAlgorithm();

        public void setSseAlgorithm(String var1);

        public void setSseAlgorithm(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withSseAlgorithm(String value) {
                return new FullBuilder().withSseAlgorithm(value);
            }

            public Build withSseAlgorithm(Token value) {
                return new FullBuilder().withSseAlgorithm(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                @Override
                public Build withKmsMasterKeyId(String value) {
                    this.instance._kmsMasterKeyId = value;
                    return this;
                }

                @Override
                public Build withKmsMasterKeyId(Token value) {
                    this.instance._kmsMasterKeyId = value;
                    return this;
                }

                public Build withSseAlgorithm(String value) {
                    Objects.requireNonNull(value, "ServerSideEncryptionByDefaultProperty#sseAlgorithm is required");
                    this.instance._sseAlgorithm = value;
                    return this;
                }

                public Build withSseAlgorithm(Token value) {
                    Objects.requireNonNull(value, "ServerSideEncryptionByDefaultProperty#sseAlgorithm is required");
                    this.instance._sseAlgorithm = value;
                    return this;
                }

                @Override
                public ServerSideEncryptionByDefaultProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public ServerSideEncryptionByDefaultProperty build();

                public Build withKmsMasterKeyId(String var1);

                public Build withKmsMasterKeyId(Token var1);
            }
        }
    }

    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        public Object getRules();

        public void setRules(Token var1);

        public void setRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withRules(Token value) {
                return new FullBuilder().withRules(value);
            }

            public Build withRules(List<Object> value) {
                return new FullBuilder().withRules(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withRules(Token value) {
                    Objects.requireNonNull(value, "S3KeyFilterProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }

                public Build withRules(List<Object> value) {
                    Objects.requireNonNull(value, "S3KeyFilterProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }

                @Override
                public S3KeyFilterProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public S3KeyFilterProperty build();
            }
        }
    }

    public static interface RuleProperty
    extends JsiiSerializable {
        public Object getAbortIncompleteMultipartUpload();

        public void setAbortIncompleteMultipartUpload(Token var1);

        public void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty var1);

        public Object getExpirationDate();

        public void setExpirationDate(Token var1);

        public void setExpirationDate(Instant var1);

        public Object getExpirationInDays();

        public void setExpirationInDays(Number var1);

        public void setExpirationInDays(Token var1);

        public Object getId();

        public void setId(String var1);

        public void setId(Token var1);

        public Object getNoncurrentVersionExpirationInDays();

        public void setNoncurrentVersionExpirationInDays(Number var1);

        public void setNoncurrentVersionExpirationInDays(Token var1);

        public Object getNoncurrentVersionTransition();

        public void setNoncurrentVersionTransition(Token var1);

        public void setNoncurrentVersionTransition(NoncurrentVersionTransitionProperty var1);

        public Object getNoncurrentVersionTransitions();

        public void setNoncurrentVersionTransitions(Token var1);

        public void setNoncurrentVersionTransitions(List<Object> var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(Token var1);

        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(Token var1);

        public Object getTagFilters();

        public void setTagFilters(Token var1);

        public void setTagFilters(List<Object> var1);

        public Object getTransition();

        public void setTransition(Token var1);

        public void setTransition(TransitionProperty var1);

        public Object getTransitions();

        public void setTransitions(Token var1);

        public void setTransitions(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withStatus(String value) {
                return new FullBuilder().withStatus(value);
            }

            public Build withStatus(Token value) {
                return new FullBuilder().withStatus(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                @Override
                public Build withAbortIncompleteMultipartUpload(Token value) {
                    this.instance._abortIncompleteMultipartUpload = value;
                    return this;
                }

                @Override
                public Build withAbortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty value) {
                    this.instance._abortIncompleteMultipartUpload = value;
                    return this;
                }

                @Override
                public Build withExpirationDate(Token value) {
                    this.instance._expirationDate = value;
                    return this;
                }

                @Override
                public Build withExpirationDate(Instant value) {
                    this.instance._expirationDate = value;
                    return this;
                }

                @Override
                public Build withExpirationInDays(Number value) {
                    this.instance._expirationInDays = value;
                    return this;
                }

                @Override
                public Build withExpirationInDays(Token value) {
                    this.instance._expirationInDays = value;
                    return this;
                }

                @Override
                public Build withId(String value) {
                    this.instance._id = value;
                    return this;
                }

                @Override
                public Build withId(Token value) {
                    this.instance._id = value;
                    return this;
                }

                @Override
                public Build withNoncurrentVersionExpirationInDays(Number value) {
                    this.instance._noncurrentVersionExpirationInDays = value;
                    return this;
                }

                @Override
                public Build withNoncurrentVersionExpirationInDays(Token value) {
                    this.instance._noncurrentVersionExpirationInDays = value;
                    return this;
                }

                @Override
                public Build withNoncurrentVersionTransition(Token value) {
                    this.instance._noncurrentVersionTransition = value;
                    return this;
                }

                @Override
                public Build withNoncurrentVersionTransition(NoncurrentVersionTransitionProperty value) {
                    this.instance._noncurrentVersionTransition = value;
                    return this;
                }

                @Override
                public Build withNoncurrentVersionTransitions(Token value) {
                    this.instance._noncurrentVersionTransitions = value;
                    return this;
                }

                @Override
                public Build withNoncurrentVersionTransitions(List<Object> value) {
                    this.instance._noncurrentVersionTransitions = value;
                    return this;
                }

                @Override
                public Build withPrefix(String value) {
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public Build withPrefix(Token value) {
                    this.instance._prefix = value;
                    return this;
                }

                public Build withStatus(String value) {
                    Objects.requireNonNull(value, "RuleProperty#status is required");
                    this.instance._status = value;
                    return this;
                }

                public Build withStatus(Token value) {
                    Objects.requireNonNull(value, "RuleProperty#status is required");
                    this.instance._status = value;
                    return this;
                }

                @Override
                public Build withTagFilters(Token value) {
                    this.instance._tagFilters = value;
                    return this;
                }

                @Override
                public Build withTagFilters(List<Object> value) {
                    this.instance._tagFilters = value;
                    return this;
                }

                @Override
                public Build withTransition(Token value) {
                    this.instance._transition = value;
                    return this;
                }

                @Override
                public Build withTransition(TransitionProperty value) {
                    this.instance._transition = value;
                    return this;
                }

                @Override
                public Build withTransitions(Token value) {
                    this.instance._transitions = value;
                    return this;
                }

                @Override
                public Build withTransitions(List<Object> value) {
                    this.instance._transitions = value;
                    return this;
                }

                @Override
                public RuleProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public RuleProperty build();

                public Build withAbortIncompleteMultipartUpload(Token var1);

                public Build withAbortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty var1);

                public Build withExpirationDate(Token var1);

                public Build withExpirationDate(Instant var1);

                public Build withExpirationInDays(Number var1);

                public Build withExpirationInDays(Token var1);

                public Build withId(String var1);

                public Build withId(Token var1);

                public Build withNoncurrentVersionExpirationInDays(Number var1);

                public Build withNoncurrentVersionExpirationInDays(Token var1);

                public Build withNoncurrentVersionTransition(Token var1);

                public Build withNoncurrentVersionTransition(NoncurrentVersionTransitionProperty var1);

                public Build withNoncurrentVersionTransitions(Token var1);

                public Build withNoncurrentVersionTransitions(List<Object> var1);

                public Build withPrefix(String var1);

                public Build withPrefix(Token var1);

                public Build withTagFilters(Token var1);

                public Build withTagFilters(List<Object> var1);

                public Build withTransition(Token var1);

                public Build withTransition(TransitionProperty var1);

                public Build withTransitions(Token var1);

                public Build withTransitions(List<Object> var1);
            }
        }
    }

    public static interface RoutingRuleProperty
    extends JsiiSerializable {
        public Object getRedirectRule();

        public void setRedirectRule(Token var1);

        public void setRedirectRule(RedirectRuleProperty var1);

        public Object getRoutingRuleCondition();

        public void setRoutingRuleCondition(Token var1);

        public void setRoutingRuleCondition(RoutingRuleConditionProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withRedirectRule(Token value) {
                return new FullBuilder().withRedirectRule(value);
            }

            public Build withRedirectRule(RedirectRuleProperty value) {
                return new FullBuilder().withRedirectRule(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withRedirectRule(Token value) {
                    Objects.requireNonNull(value, "RoutingRuleProperty#redirectRule is required");
                    this.instance._redirectRule = value;
                    return this;
                }

                public Build withRedirectRule(RedirectRuleProperty value) {
                    Objects.requireNonNull(value, "RoutingRuleProperty#redirectRule is required");
                    this.instance._redirectRule = value;
                    return this;
                }

                @Override
                public Build withRoutingRuleCondition(Token value) {
                    this.instance._routingRuleCondition = value;
                    return this;
                }

                @Override
                public Build withRoutingRuleCondition(RoutingRuleConditionProperty value) {
                    this.instance._routingRuleCondition = value;
                    return this;
                }

                @Override
                public RoutingRuleProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public RoutingRuleProperty build();

                public Build withRoutingRuleCondition(Token var1);

                public Build withRoutingRuleCondition(RoutingRuleConditionProperty var1);
            }
        }
    }

    public static interface RoutingRuleConditionProperty
    extends JsiiSerializable {
        public Object getHttpErrorCodeReturnedEquals();

        public void setHttpErrorCodeReturnedEquals(String var1);

        public void setHttpErrorCodeReturnedEquals(Token var1);

        public Object getKeyPrefixEquals();

        public void setKeyPrefixEquals(String var1);

        public void setKeyPrefixEquals(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Jsii.Pojo instance = new Jsii.Pojo();

            public Builder withHttpErrorCodeReturnedEquals(String value) {
                this.instance._httpErrorCodeReturnedEquals = value;
                return this;
            }

            public Builder withHttpErrorCodeReturnedEquals(Token value) {
                this.instance._httpErrorCodeReturnedEquals = value;
                return this;
            }

            public Builder withKeyPrefixEquals(String value) {
                this.instance._keyPrefixEquals = value;
                return this;
            }

            public Builder withKeyPrefixEquals(Token value) {
                this.instance._keyPrefixEquals = value;
                return this;
            }

            public RoutingRuleConditionProperty build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }
    }

    public static interface ReplicationRuleProperty
    extends JsiiSerializable {
        public Object getDestination();

        public void setDestination(Token var1);

        public void setDestination(ReplicationDestinationProperty var1);

        public Object getId();

        public void setId(String var1);

        public void setId(Token var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(Token var1);

        public Object getSourceSelectionCriteria();

        public void setSourceSelectionCriteria(Token var1);

        public void setSourceSelectionCriteria(SourceSelectionCriteriaProperty var1);

        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public PrefixStep withDestination(Token value) {
                return new FullBuilder().withDestination(value);
            }

            public PrefixStep withDestination(ReplicationDestinationProperty value) {
                return new FullBuilder().withDestination(value);
            }

            final class FullBuilder
            implements PrefixStep,
            StatusStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public PrefixStep withDestination(Token value) {
                    Objects.requireNonNull(value, "ReplicationRuleProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }

                public PrefixStep withDestination(ReplicationDestinationProperty value) {
                    Objects.requireNonNull(value, "ReplicationRuleProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }

                @Override
                public Build withId(String value) {
                    this.instance._id = value;
                    return this;
                }

                @Override
                public Build withId(Token value) {
                    this.instance._id = value;
                    return this;
                }

                @Override
                public StatusStep withPrefix(String value) {
                    Objects.requireNonNull(value, "ReplicationRuleProperty#prefix is required");
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public StatusStep withPrefix(Token value) {
                    Objects.requireNonNull(value, "ReplicationRuleProperty#prefix is required");
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public Build withSourceSelectionCriteria(Token value) {
                    this.instance._sourceSelectionCriteria = value;
                    return this;
                }

                @Override
                public Build withSourceSelectionCriteria(SourceSelectionCriteriaProperty value) {
                    this.instance._sourceSelectionCriteria = value;
                    return this;
                }

                @Override
                public Build withStatus(String value) {
                    Objects.requireNonNull(value, "ReplicationRuleProperty#status is required");
                    this.instance._status = value;
                    return this;
                }

                @Override
                public Build withStatus(Token value) {
                    Objects.requireNonNull(value, "ReplicationRuleProperty#status is required");
                    this.instance._status = value;
                    return this;
                }

                @Override
                public ReplicationRuleProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public ReplicationRuleProperty build();

                public Build withId(String var1);

                public Build withId(Token var1);

                public Build withSourceSelectionCriteria(Token var1);

                public Build withSourceSelectionCriteria(SourceSelectionCriteriaProperty var1);
            }

            public static interface StatusStep {
                public Build withStatus(String var1);

                public Build withStatus(Token var1);
            }

            public static interface PrefixStep {
                public StatusStep withPrefix(String var1);

                public StatusStep withPrefix(Token var1);
            }
        }
    }

    public static interface ReplicationDestinationProperty
    extends JsiiSerializable {
        public Object getAccessControlTranslation();

        public void setAccessControlTranslation(Token var1);

        public void setAccessControlTranslation(AccessControlTranslationProperty var1);

        public Object getAccount();

        public void setAccount(String var1);

        public void setAccount(Token var1);

        public Object getBucket();

        public void setBucket(String var1);

        public void setBucket(Token var1);

        public Object getEncryptionConfiguration();

        public void setEncryptionConfiguration(Token var1);

        public void setEncryptionConfiguration(EncryptionConfigurationProperty var1);

        public Object getStorageClass();

        public void setStorageClass(String var1);

        public void setStorageClass(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withBucket(String value) {
                return new FullBuilder().withBucket(value);
            }

            public Build withBucket(Token value) {
                return new FullBuilder().withBucket(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                @Override
                public Build withAccessControlTranslation(Token value) {
                    this.instance._accessControlTranslation = value;
                    return this;
                }

                @Override
                public Build withAccessControlTranslation(AccessControlTranslationProperty value) {
                    this.instance._accessControlTranslation = value;
                    return this;
                }

                @Override
                public Build withAccount(String value) {
                    this.instance._account = value;
                    return this;
                }

                @Override
                public Build withAccount(Token value) {
                    this.instance._account = value;
                    return this;
                }

                public Build withBucket(String value) {
                    Objects.requireNonNull(value, "ReplicationDestinationProperty#bucket is required");
                    this.instance._bucket = value;
                    return this;
                }

                public Build withBucket(Token value) {
                    Objects.requireNonNull(value, "ReplicationDestinationProperty#bucket is required");
                    this.instance._bucket = value;
                    return this;
                }

                @Override
                public Build withEncryptionConfiguration(Token value) {
                    this.instance._encryptionConfiguration = value;
                    return this;
                }

                @Override
                public Build withEncryptionConfiguration(EncryptionConfigurationProperty value) {
                    this.instance._encryptionConfiguration = value;
                    return this;
                }

                @Override
                public Build withStorageClass(String value) {
                    this.instance._storageClass = value;
                    return this;
                }

                @Override
                public Build withStorageClass(Token value) {
                    this.instance._storageClass = value;
                    return this;
                }

                @Override
                public ReplicationDestinationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public ReplicationDestinationProperty build();

                public Build withAccessControlTranslation(Token var1);

                public Build withAccessControlTranslation(AccessControlTranslationProperty var1);

                public Build withAccount(String var1);

                public Build withAccount(Token var1);

                public Build withEncryptionConfiguration(Token var1);

                public Build withEncryptionConfiguration(EncryptionConfigurationProperty var1);

                public Build withStorageClass(String var1);

                public Build withStorageClass(Token var1);
            }
        }
    }

    public static interface ReplicationConfigurationProperty
    extends JsiiSerializable {
        public Object getRole();

        public void setRole(String var1);

        public void setRole(Token var1);

        public Object getRules();

        public void setRules(Token var1);

        public void setRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public RulesStep withRole(String value) {
                return new FullBuilder().withRole(value);
            }

            public RulesStep withRole(Token value) {
                return new FullBuilder().withRole(value);
            }

            final class FullBuilder
            implements RulesStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public RulesStep withRole(String value) {
                    Objects.requireNonNull(value, "ReplicationConfigurationProperty#role is required");
                    this.instance._role = value;
                    return this;
                }

                public RulesStep withRole(Token value) {
                    Objects.requireNonNull(value, "ReplicationConfigurationProperty#role is required");
                    this.instance._role = value;
                    return this;
                }

                @Override
                public Build withRules(Token value) {
                    Objects.requireNonNull(value, "ReplicationConfigurationProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }

                @Override
                public Build withRules(List<Object> value) {
                    Objects.requireNonNull(value, "ReplicationConfigurationProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }

                @Override
                public ReplicationConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public ReplicationConfigurationProperty build();
            }

            public static interface RulesStep {
                public Build withRules(Token var1);

                public Build withRules(List<Object> var1);
            }
        }
    }

    public static interface RedirectRuleProperty
    extends JsiiSerializable {
        public Object getHostName();

        public void setHostName(String var1);

        public void setHostName(Token var1);

        public Object getHttpRedirectCode();

        public void setHttpRedirectCode(String var1);

        public void setHttpRedirectCode(Token var1);

        public Object getProtocol();

        public void setProtocol(String var1);

        public void setProtocol(Token var1);

        public Object getReplaceKeyPrefixWith();

        public void setReplaceKeyPrefixWith(String var1);

        public void setReplaceKeyPrefixWith(Token var1);

        public Object getReplaceKeyWith();

        public void setReplaceKeyWith(String var1);

        public void setReplaceKeyWith(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Jsii.Pojo instance = new Jsii.Pojo();

            public Builder withHostName(String value) {
                this.instance._hostName = value;
                return this;
            }

            public Builder withHostName(Token value) {
                this.instance._hostName = value;
                return this;
            }

            public Builder withHttpRedirectCode(String value) {
                this.instance._httpRedirectCode = value;
                return this;
            }

            public Builder withHttpRedirectCode(Token value) {
                this.instance._httpRedirectCode = value;
                return this;
            }

            public Builder withProtocol(String value) {
                this.instance._protocol = value;
                return this;
            }

            public Builder withProtocol(Token value) {
                this.instance._protocol = value;
                return this;
            }

            public Builder withReplaceKeyPrefixWith(String value) {
                this.instance._replaceKeyPrefixWith = value;
                return this;
            }

            public Builder withReplaceKeyPrefixWith(Token value) {
                this.instance._replaceKeyPrefixWith = value;
                return this;
            }

            public Builder withReplaceKeyWith(String value) {
                this.instance._replaceKeyWith = value;
                return this;
            }

            public Builder withReplaceKeyWith(Token value) {
                this.instance._replaceKeyWith = value;
                return this;
            }

            public RedirectRuleProperty build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }
    }

    public static interface RedirectAllRequestsToProperty
    extends JsiiSerializable {
        public Object getHostName();

        public void setHostName(String var1);

        public void setHostName(Token var1);

        public Object getProtocol();

        public void setProtocol(String var1);

        public void setProtocol(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withHostName(String value) {
                return new FullBuilder().withHostName(value);
            }

            public Build withHostName(Token value) {
                return new FullBuilder().withHostName(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withHostName(String value) {
                    Objects.requireNonNull(value, "RedirectAllRequestsToProperty#hostName is required");
                    this.instance._hostName = value;
                    return this;
                }

                public Build withHostName(Token value) {
                    Objects.requireNonNull(value, "RedirectAllRequestsToProperty#hostName is required");
                    this.instance._hostName = value;
                    return this;
                }

                @Override
                public Build withProtocol(String value) {
                    this.instance._protocol = value;
                    return this;
                }

                @Override
                public Build withProtocol(Token value) {
                    this.instance._protocol = value;
                    return this;
                }

                @Override
                public RedirectAllRequestsToProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public RedirectAllRequestsToProperty build();

                public Build withProtocol(String var1);

                public Build withProtocol(Token var1);
            }
        }
    }

    public static interface QueueConfigurationProperty
    extends JsiiSerializable {
        public Object getEvent();

        public void setEvent(String var1);

        public void setEvent(Token var1);

        public Object getFilter();

        public void setFilter(Token var1);

        public void setFilter(NotificationFilterProperty var1);

        public Object getQueue();

        public void setQueue(String var1);

        public void setQueue(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public QueueStep withEvent(String value) {
                return new FullBuilder().withEvent(value);
            }

            public QueueStep withEvent(Token value) {
                return new FullBuilder().withEvent(value);
            }

            final class FullBuilder
            implements QueueStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public QueueStep withEvent(String value) {
                    Objects.requireNonNull(value, "QueueConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }

                public QueueStep withEvent(Token value) {
                    Objects.requireNonNull(value, "QueueConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }

                @Override
                public Build withFilter(Token value) {
                    this.instance._filter = value;
                    return this;
                }

                @Override
                public Build withFilter(NotificationFilterProperty value) {
                    this.instance._filter = value;
                    return this;
                }

                @Override
                public Build withQueue(String value) {
                    Objects.requireNonNull(value, "QueueConfigurationProperty#queue is required");
                    this.instance._queue = value;
                    return this;
                }

                @Override
                public Build withQueue(Token value) {
                    Objects.requireNonNull(value, "QueueConfigurationProperty#queue is required");
                    this.instance._queue = value;
                    return this;
                }

                @Override
                public QueueConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public QueueConfigurationProperty build();

                public Build withFilter(Token var1);

                public Build withFilter(NotificationFilterProperty var1);
            }

            public static interface QueueStep {
                public Build withQueue(String var1);

                public Build withQueue(Token var1);
            }
        }
    }

    public static interface NotificationFilterProperty
    extends JsiiSerializable {
        public Object getS3Key();

        public void setS3Key(Token var1);

        public void setS3Key(S3KeyFilterProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withS3Key(Token value) {
                return new FullBuilder().withS3Key(value);
            }

            public Build withS3Key(S3KeyFilterProperty value) {
                return new FullBuilder().withS3Key(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withS3Key(Token value) {
                    Objects.requireNonNull(value, "NotificationFilterProperty#s3Key is required");
                    this.instance._s3Key = value;
                    return this;
                }

                public Build withS3Key(S3KeyFilterProperty value) {
                    Objects.requireNonNull(value, "NotificationFilterProperty#s3Key is required");
                    this.instance._s3Key = value;
                    return this;
                }

                @Override
                public NotificationFilterProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public NotificationFilterProperty build();
            }
        }
    }

    public static interface NotificationConfigurationProperty
    extends JsiiSerializable {
        public Object getLambdaConfigurations();

        public void setLambdaConfigurations(Token var1);

        public void setLambdaConfigurations(List<Object> var1);

        public Object getQueueConfigurations();

        public void setQueueConfigurations(Token var1);

        public void setQueueConfigurations(List<Object> var1);

        public Object getTopicConfigurations();

        public void setTopicConfigurations(Token var1);

        public void setTopicConfigurations(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Jsii.Pojo instance = new Jsii.Pojo();

            public Builder withLambdaConfigurations(Token value) {
                this.instance._lambdaConfigurations = value;
                return this;
            }

            public Builder withLambdaConfigurations(List<Object> value) {
                this.instance._lambdaConfigurations = value;
                return this;
            }

            public Builder withQueueConfigurations(Token value) {
                this.instance._queueConfigurations = value;
                return this;
            }

            public Builder withQueueConfigurations(List<Object> value) {
                this.instance._queueConfigurations = value;
                return this;
            }

            public Builder withTopicConfigurations(Token value) {
                this.instance._topicConfigurations = value;
                return this;
            }

            public Builder withTopicConfigurations(List<Object> value) {
                this.instance._topicConfigurations = value;
                return this;
            }

            public NotificationConfigurationProperty build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }
    }

    public static interface NoncurrentVersionTransitionProperty
    extends JsiiSerializable {
        public Object getStorageClass();

        public void setStorageClass(String var1);

        public void setStorageClass(Token var1);

        public Object getTransitionInDays();

        public void setTransitionInDays(Number var1);

        public void setTransitionInDays(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public TransitionInDaysStep withStorageClass(String value) {
                return new FullBuilder().withStorageClass(value);
            }

            public TransitionInDaysStep withStorageClass(Token value) {
                return new FullBuilder().withStorageClass(value);
            }

            final class FullBuilder
            implements TransitionInDaysStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public TransitionInDaysStep withStorageClass(String value) {
                    Objects.requireNonNull(value, "NoncurrentVersionTransitionProperty#storageClass is required");
                    this.instance._storageClass = value;
                    return this;
                }

                public TransitionInDaysStep withStorageClass(Token value) {
                    Objects.requireNonNull(value, "NoncurrentVersionTransitionProperty#storageClass is required");
                    this.instance._storageClass = value;
                    return this;
                }

                @Override
                public Build withTransitionInDays(Number value) {
                    Objects.requireNonNull(value, "NoncurrentVersionTransitionProperty#transitionInDays is required");
                    this.instance._transitionInDays = value;
                    return this;
                }

                @Override
                public Build withTransitionInDays(Token value) {
                    Objects.requireNonNull(value, "NoncurrentVersionTransitionProperty#transitionInDays is required");
                    this.instance._transitionInDays = value;
                    return this;
                }

                @Override
                public NoncurrentVersionTransitionProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public NoncurrentVersionTransitionProperty build();
            }

            public static interface TransitionInDaysStep {
                public Build withTransitionInDays(Number var1);

                public Build withTransitionInDays(Token var1);
            }
        }
    }

    public static interface MetricsConfigurationProperty
    extends JsiiSerializable {
        public Object getId();

        public void setId(String var1);

        public void setId(Token var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(Token var1);

        public Object getTagFilters();

        public void setTagFilters(Token var1);

        public void setTagFilters(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withId(String value) {
                return new FullBuilder().withId(value);
            }

            public Build withId(Token value) {
                return new FullBuilder().withId(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withId(String value) {
                    Objects.requireNonNull(value, "MetricsConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }

                public Build withId(Token value) {
                    Objects.requireNonNull(value, "MetricsConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }

                @Override
                public Build withPrefix(String value) {
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public Build withPrefix(Token value) {
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public Build withTagFilters(Token value) {
                    this.instance._tagFilters = value;
                    return this;
                }

                @Override
                public Build withTagFilters(List<Object> value) {
                    this.instance._tagFilters = value;
                    return this;
                }

                @Override
                public MetricsConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public MetricsConfigurationProperty build();

                public Build withPrefix(String var1);

                public Build withPrefix(Token var1);

                public Build withTagFilters(Token var1);

                public Build withTagFilters(List<Object> var1);
            }
        }
    }

    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        public Object getDestinationBucketName();

        public void setDestinationBucketName(String var1);

        public void setDestinationBucketName(Token var1);

        public Object getLogFilePrefix();

        public void setLogFilePrefix(String var1);

        public void setLogFilePrefix(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Jsii.Pojo instance = new Jsii.Pojo();

            public Builder withDestinationBucketName(String value) {
                this.instance._destinationBucketName = value;
                return this;
            }

            public Builder withDestinationBucketName(Token value) {
                this.instance._destinationBucketName = value;
                return this;
            }

            public Builder withLogFilePrefix(String value) {
                this.instance._logFilePrefix = value;
                return this;
            }

            public Builder withLogFilePrefix(Token value) {
                this.instance._logFilePrefix = value;
                return this;
            }

            public LoggingConfigurationProperty build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }
    }

    public static interface LifecycleConfigurationProperty
    extends JsiiSerializable {
        public Object getRules();

        public void setRules(Token var1);

        public void setRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withRules(Token value) {
                return new FullBuilder().withRules(value);
            }

            public Build withRules(List<Object> value) {
                return new FullBuilder().withRules(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withRules(Token value) {
                    Objects.requireNonNull(value, "LifecycleConfigurationProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }

                public Build withRules(List<Object> value) {
                    Objects.requireNonNull(value, "LifecycleConfigurationProperty#rules is required");
                    this.instance._rules = value;
                    return this;
                }

                @Override
                public LifecycleConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public LifecycleConfigurationProperty build();
            }
        }
    }

    public static interface LambdaConfigurationProperty
    extends JsiiSerializable {
        public Object getEvent();

        public void setEvent(String var1);

        public void setEvent(Token var1);

        public Object getFilter();

        public void setFilter(Token var1);

        public void setFilter(NotificationFilterProperty var1);

        public Object getFunction();

        public void setFunction(String var1);

        public void setFunction(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public FunctionStep withEvent(String value) {
                return new FullBuilder().withEvent(value);
            }

            public FunctionStep withEvent(Token value) {
                return new FullBuilder().withEvent(value);
            }

            final class FullBuilder
            implements FunctionStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public FunctionStep withEvent(String value) {
                    Objects.requireNonNull(value, "LambdaConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }

                public FunctionStep withEvent(Token value) {
                    Objects.requireNonNull(value, "LambdaConfigurationProperty#event is required");
                    this.instance._event = value;
                    return this;
                }

                @Override
                public Build withFilter(Token value) {
                    this.instance._filter = value;
                    return this;
                }

                @Override
                public Build withFilter(NotificationFilterProperty value) {
                    this.instance._filter = value;
                    return this;
                }

                @Override
                public Build withFunction(String value) {
                    Objects.requireNonNull(value, "LambdaConfigurationProperty#function is required");
                    this.instance._function = value;
                    return this;
                }

                @Override
                public Build withFunction(Token value) {
                    Objects.requireNonNull(value, "LambdaConfigurationProperty#function is required");
                    this.instance._function = value;
                    return this;
                }

                @Override
                public LambdaConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public LambdaConfigurationProperty build();

                public Build withFilter(Token var1);

                public Build withFilter(NotificationFilterProperty var1);
            }

            public static interface FunctionStep {
                public Build withFunction(String var1);

                public Build withFunction(Token var1);
            }
        }
    }

    public static interface InventoryConfigurationProperty
    extends JsiiSerializable {
        public Object getDestination();

        public void setDestination(Token var1);

        public void setDestination(DestinationProperty var1);

        public Object getEnabled();

        public void setEnabled(Boolean var1);

        public void setEnabled(Token var1);

        public Object getId();

        public void setId(String var1);

        public void setId(Token var1);

        public Object getIncludedObjectVersions();

        public void setIncludedObjectVersions(String var1);

        public void setIncludedObjectVersions(Token var1);

        public Object getOptionalFields();

        public void setOptionalFields(Token var1);

        public void setOptionalFields(List<Object> var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(Token var1);

        public Object getScheduleFrequency();

        public void setScheduleFrequency(String var1);

        public void setScheduleFrequency(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public EnabledStep withDestination(Token value) {
                return new FullBuilder().withDestination(value);
            }

            public EnabledStep withDestination(DestinationProperty value) {
                return new FullBuilder().withDestination(value);
            }

            final class FullBuilder
            implements EnabledStep,
            IdStep,
            IncludedObjectVersionsStep,
            ScheduleFrequencyStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public EnabledStep withDestination(Token value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }

                public EnabledStep withDestination(DestinationProperty value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }

                @Override
                public IdStep withEnabled(Boolean value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#enabled is required");
                    this.instance._enabled = value;
                    return this;
                }

                @Override
                public IdStep withEnabled(Token value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#enabled is required");
                    this.instance._enabled = value;
                    return this;
                }

                @Override
                public IncludedObjectVersionsStep withId(String value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }

                @Override
                public IncludedObjectVersionsStep withId(Token value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }

                @Override
                public ScheduleFrequencyStep withIncludedObjectVersions(String value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#includedObjectVersions is required");
                    this.instance._includedObjectVersions = value;
                    return this;
                }

                @Override
                public ScheduleFrequencyStep withIncludedObjectVersions(Token value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#includedObjectVersions is required");
                    this.instance._includedObjectVersions = value;
                    return this;
                }

                @Override
                public Build withOptionalFields(Token value) {
                    this.instance._optionalFields = value;
                    return this;
                }

                @Override
                public Build withOptionalFields(List<Object> value) {
                    this.instance._optionalFields = value;
                    return this;
                }

                @Override
                public Build withPrefix(String value) {
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public Build withPrefix(Token value) {
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public Build withScheduleFrequency(String value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#scheduleFrequency is required");
                    this.instance._scheduleFrequency = value;
                    return this;
                }

                @Override
                public Build withScheduleFrequency(Token value) {
                    Objects.requireNonNull(value, "InventoryConfigurationProperty#scheduleFrequency is required");
                    this.instance._scheduleFrequency = value;
                    return this;
                }

                @Override
                public InventoryConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public InventoryConfigurationProperty build();

                public Build withOptionalFields(Token var1);

                public Build withOptionalFields(List<Object> var1);

                public Build withPrefix(String var1);

                public Build withPrefix(Token var1);
            }

            public static interface ScheduleFrequencyStep {
                public Build withScheduleFrequency(String var1);

                public Build withScheduleFrequency(Token var1);
            }

            public static interface IncludedObjectVersionsStep {
                public ScheduleFrequencyStep withIncludedObjectVersions(String var1);

                public ScheduleFrequencyStep withIncludedObjectVersions(Token var1);
            }

            public static interface IdStep {
                public IncludedObjectVersionsStep withId(String var1);

                public IncludedObjectVersionsStep withId(Token var1);
            }

            public static interface EnabledStep {
                public IdStep withEnabled(Boolean var1);

                public IdStep withEnabled(Token var1);
            }
        }
    }

    public static interface FilterRuleProperty
    extends JsiiSerializable {
        public Object getName();

        public void setName(String var1);

        public void setName(Token var1);

        public Object getValue();

        public void setValue(String var1);

        public void setValue(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public ValueStep withName(String value) {
                return new FullBuilder().withName(value);
            }

            public ValueStep withName(Token value) {
                return new FullBuilder().withName(value);
            }

            final class FullBuilder
            implements ValueStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public ValueStep withName(String value) {
                    Objects.requireNonNull(value, "FilterRuleProperty#name is required");
                    this.instance._name = value;
                    return this;
                }

                public ValueStep withName(Token value) {
                    Objects.requireNonNull(value, "FilterRuleProperty#name is required");
                    this.instance._name = value;
                    return this;
                }

                @Override
                public Build withValue(String value) {
                    Objects.requireNonNull(value, "FilterRuleProperty#value is required");
                    this.instance._value = value;
                    return this;
                }

                @Override
                public Build withValue(Token value) {
                    Objects.requireNonNull(value, "FilterRuleProperty#value is required");
                    this.instance._value = value;
                    return this;
                }

                @Override
                public FilterRuleProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public FilterRuleProperty build();
            }

            public static interface ValueStep {
                public Build withValue(String var1);

                public Build withValue(Token var1);
            }
        }
    }

    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        public Object getReplicaKmsKeyId();

        public void setReplicaKmsKeyId(String var1);

        public void setReplicaKmsKeyId(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withReplicaKmsKeyId(String value) {
                return new FullBuilder().withReplicaKmsKeyId(value);
            }

            public Build withReplicaKmsKeyId(Token value) {
                return new FullBuilder().withReplicaKmsKeyId(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withReplicaKmsKeyId(String value) {
                    Objects.requireNonNull(value, "EncryptionConfigurationProperty#replicaKmsKeyId is required");
                    this.instance._replicaKmsKeyId = value;
                    return this;
                }

                public Build withReplicaKmsKeyId(Token value) {
                    Objects.requireNonNull(value, "EncryptionConfigurationProperty#replicaKmsKeyId is required");
                    this.instance._replicaKmsKeyId = value;
                    return this;
                }

                @Override
                public EncryptionConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public EncryptionConfigurationProperty build();
            }
        }
    }

    public static interface DestinationProperty
    extends JsiiSerializable {
        public Object getBucketAccountId();

        public void setBucketAccountId(String var1);

        public void setBucketAccountId(Token var1);

        public Object getBucketArn();

        public void setBucketArn(String var1);

        public void setBucketArn(Token var1);

        public Object getFormat();

        public void setFormat(String var1);

        public void setFormat(Token var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public FormatStep withBucketArn(String value) {
                return new FullBuilder().withBucketArn(value);
            }

            public FormatStep withBucketArn(Token value) {
                return new FullBuilder().withBucketArn(value);
            }

            final class FullBuilder
            implements FormatStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                @Override
                public Build withBucketAccountId(String value) {
                    this.instance._bucketAccountId = value;
                    return this;
                }

                @Override
                public Build withBucketAccountId(Token value) {
                    this.instance._bucketAccountId = value;
                    return this;
                }

                public FormatStep withBucketArn(String value) {
                    Objects.requireNonNull(value, "DestinationProperty#bucketArn is required");
                    this.instance._bucketArn = value;
                    return this;
                }

                public FormatStep withBucketArn(Token value) {
                    Objects.requireNonNull(value, "DestinationProperty#bucketArn is required");
                    this.instance._bucketArn = value;
                    return this;
                }

                @Override
                public Build withFormat(String value) {
                    Objects.requireNonNull(value, "DestinationProperty#format is required");
                    this.instance._format = value;
                    return this;
                }

                @Override
                public Build withFormat(Token value) {
                    Objects.requireNonNull(value, "DestinationProperty#format is required");
                    this.instance._format = value;
                    return this;
                }

                @Override
                public Build withPrefix(String value) {
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public Build withPrefix(Token value) {
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public DestinationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public DestinationProperty build();

                public Build withBucketAccountId(String var1);

                public Build withBucketAccountId(Token var1);

                public Build withPrefix(String var1);

                public Build withPrefix(Token var1);
            }

            public static interface FormatStep {
                public Build withFormat(String var1);

                public Build withFormat(Token var1);
            }
        }
    }

    public static interface DataExportProperty
    extends JsiiSerializable {
        public Object getDestination();

        public void setDestination(Token var1);

        public void setDestination(DestinationProperty var1);

        public Object getOutputSchemaVersion();

        public void setOutputSchemaVersion(String var1);

        public void setOutputSchemaVersion(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public OutputSchemaVersionStep withDestination(Token value) {
                return new FullBuilder().withDestination(value);
            }

            public OutputSchemaVersionStep withDestination(DestinationProperty value) {
                return new FullBuilder().withDestination(value);
            }

            final class FullBuilder
            implements OutputSchemaVersionStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public OutputSchemaVersionStep withDestination(Token value) {
                    Objects.requireNonNull(value, "DataExportProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }

                public OutputSchemaVersionStep withDestination(DestinationProperty value) {
                    Objects.requireNonNull(value, "DataExportProperty#destination is required");
                    this.instance._destination = value;
                    return this;
                }

                @Override
                public Build withOutputSchemaVersion(String value) {
                    Objects.requireNonNull(value, "DataExportProperty#outputSchemaVersion is required");
                    this.instance._outputSchemaVersion = value;
                    return this;
                }

                @Override
                public Build withOutputSchemaVersion(Token value) {
                    Objects.requireNonNull(value, "DataExportProperty#outputSchemaVersion is required");
                    this.instance._outputSchemaVersion = value;
                    return this;
                }

                @Override
                public DataExportProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public DataExportProperty build();
            }

            public static interface OutputSchemaVersionStep {
                public Build withOutputSchemaVersion(String var1);

                public Build withOutputSchemaVersion(Token var1);
            }
        }
    }

    public static interface CorsRuleProperty
    extends JsiiSerializable {
        public Object getAllowedHeaders();

        public void setAllowedHeaders(Token var1);

        public void setAllowedHeaders(List<Object> var1);

        public Object getAllowedMethods();

        public void setAllowedMethods(Token var1);

        public void setAllowedMethods(List<Object> var1);

        public Object getAllowedOrigins();

        public void setAllowedOrigins(Token var1);

        public void setAllowedOrigins(List<Object> var1);

        public Object getExposedHeaders();

        public void setExposedHeaders(Token var1);

        public void setExposedHeaders(List<Object> var1);

        public Object getId();

        public void setId(String var1);

        public void setId(Token var1);

        public Object getMaxAge();

        public void setMaxAge(Number var1);

        public void setMaxAge(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public AllowedOriginsStep withAllowedMethods(Token value) {
                return new FullBuilder().withAllowedMethods(value);
            }

            public AllowedOriginsStep withAllowedMethods(List<Object> value) {
                return new FullBuilder().withAllowedMethods(value);
            }

            final class FullBuilder
            implements AllowedOriginsStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                @Override
                public Build withAllowedHeaders(Token value) {
                    this.instance._allowedHeaders = value;
                    return this;
                }

                @Override
                public Build withAllowedHeaders(List<Object> value) {
                    this.instance._allowedHeaders = value;
                    return this;
                }

                public AllowedOriginsStep withAllowedMethods(Token value) {
                    Objects.requireNonNull(value, "CorsRuleProperty#allowedMethods is required");
                    this.instance._allowedMethods = value;
                    return this;
                }

                public AllowedOriginsStep withAllowedMethods(List<Object> value) {
                    Objects.requireNonNull(value, "CorsRuleProperty#allowedMethods is required");
                    this.instance._allowedMethods = value;
                    return this;
                }

                @Override
                public Build withAllowedOrigins(Token value) {
                    Objects.requireNonNull(value, "CorsRuleProperty#allowedOrigins is required");
                    this.instance._allowedOrigins = value;
                    return this;
                }

                @Override
                public Build withAllowedOrigins(List<Object> value) {
                    Objects.requireNonNull(value, "CorsRuleProperty#allowedOrigins is required");
                    this.instance._allowedOrigins = value;
                    return this;
                }

                @Override
                public Build withExposedHeaders(Token value) {
                    this.instance._exposedHeaders = value;
                    return this;
                }

                @Override
                public Build withExposedHeaders(List<Object> value) {
                    this.instance._exposedHeaders = value;
                    return this;
                }

                @Override
                public Build withId(String value) {
                    this.instance._id = value;
                    return this;
                }

                @Override
                public Build withId(Token value) {
                    this.instance._id = value;
                    return this;
                }

                @Override
                public Build withMaxAge(Number value) {
                    this.instance._maxAge = value;
                    return this;
                }

                @Override
                public Build withMaxAge(Token value) {
                    this.instance._maxAge = value;
                    return this;
                }

                @Override
                public CorsRuleProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public CorsRuleProperty build();

                public Build withAllowedHeaders(Token var1);

                public Build withAllowedHeaders(List<Object> var1);

                public Build withExposedHeaders(Token var1);

                public Build withExposedHeaders(List<Object> var1);

                public Build withId(String var1);

                public Build withId(Token var1);

                public Build withMaxAge(Number var1);

                public Build withMaxAge(Token var1);
            }

            public static interface AllowedOriginsStep {
                public Build withAllowedOrigins(Token var1);

                public Build withAllowedOrigins(List<Object> var1);
            }
        }
    }

    public static interface CorsConfigurationProperty
    extends JsiiSerializable {
        public Object getCorsRules();

        public void setCorsRules(Token var1);

        public void setCorsRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withCorsRules(Token value) {
                return new FullBuilder().withCorsRules(value);
            }

            public Build withCorsRules(List<Object> value) {
                return new FullBuilder().withCorsRules(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withCorsRules(Token value) {
                    Objects.requireNonNull(value, "CorsConfigurationProperty#corsRules is required");
                    this.instance._corsRules = value;
                    return this;
                }

                public Build withCorsRules(List<Object> value) {
                    Objects.requireNonNull(value, "CorsConfigurationProperty#corsRules is required");
                    this.instance._corsRules = value;
                    return this;
                }

                @Override
                public CorsConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public CorsConfigurationProperty build();
            }
        }
    }

    public static interface BucketEncryptionProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionConfiguration();

        public void setServerSideEncryptionConfiguration(Token var1);

        public void setServerSideEncryptionConfiguration(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withServerSideEncryptionConfiguration(Token value) {
                return new FullBuilder().withServerSideEncryptionConfiguration(value);
            }

            public Build withServerSideEncryptionConfiguration(List<Object> value) {
                return new FullBuilder().withServerSideEncryptionConfiguration(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withServerSideEncryptionConfiguration(Token value) {
                    Objects.requireNonNull(value, "BucketEncryptionProperty#serverSideEncryptionConfiguration is required");
                    this.instance._serverSideEncryptionConfiguration = value;
                    return this;
                }

                public Build withServerSideEncryptionConfiguration(List<Object> value) {
                    Objects.requireNonNull(value, "BucketEncryptionProperty#serverSideEncryptionConfiguration is required");
                    this.instance._serverSideEncryptionConfiguration = value;
                    return this;
                }

                @Override
                public BucketEncryptionProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public BucketEncryptionProperty build();
            }
        }
    }

    public static interface AnalyticsConfigurationProperty
    extends JsiiSerializable {
        public Object getId();

        public void setId(String var1);

        public void setId(Token var1);

        public Object getPrefix();

        public void setPrefix(String var1);

        public void setPrefix(Token var1);

        public Object getStorageClassAnalysis();

        public void setStorageClassAnalysis(Token var1);

        public void setStorageClassAnalysis(StorageClassAnalysisProperty var1);

        public Object getTagFilters();

        public void setTagFilters(Token var1);

        public void setTagFilters(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public StorageClassAnalysisStep withId(String value) {
                return new FullBuilder().withId(value);
            }

            public StorageClassAnalysisStep withId(Token value) {
                return new FullBuilder().withId(value);
            }

            final class FullBuilder
            implements StorageClassAnalysisStep,
            Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public StorageClassAnalysisStep withId(String value) {
                    Objects.requireNonNull(value, "AnalyticsConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }

                public StorageClassAnalysisStep withId(Token value) {
                    Objects.requireNonNull(value, "AnalyticsConfigurationProperty#id is required");
                    this.instance._id = value;
                    return this;
                }

                @Override
                public Build withPrefix(String value) {
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public Build withPrefix(Token value) {
                    this.instance._prefix = value;
                    return this;
                }

                @Override
                public Build withStorageClassAnalysis(Token value) {
                    Objects.requireNonNull(value, "AnalyticsConfigurationProperty#storageClassAnalysis is required");
                    this.instance._storageClassAnalysis = value;
                    return this;
                }

                @Override
                public Build withStorageClassAnalysis(StorageClassAnalysisProperty value) {
                    Objects.requireNonNull(value, "AnalyticsConfigurationProperty#storageClassAnalysis is required");
                    this.instance._storageClassAnalysis = value;
                    return this;
                }

                @Override
                public Build withTagFilters(Token value) {
                    this.instance._tagFilters = value;
                    return this;
                }

                @Override
                public Build withTagFilters(List<Object> value) {
                    this.instance._tagFilters = value;
                    return this;
                }

                @Override
                public AnalyticsConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public AnalyticsConfigurationProperty build();

                public Build withPrefix(String var1);

                public Build withPrefix(Token var1);

                public Build withTagFilters(Token var1);

                public Build withTagFilters(List<Object> var1);
            }

            public static interface StorageClassAnalysisStep {
                public Build withStorageClassAnalysis(Token var1);

                public Build withStorageClassAnalysis(StorageClassAnalysisProperty var1);
            }
        }
    }

    public static interface AccessControlTranslationProperty
    extends JsiiSerializable {
        public Object getOwner();

        public void setOwner(String var1);

        public void setOwner(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withOwner(String value) {
                return new FullBuilder().withOwner(value);
            }

            public Build withOwner(Token value) {
                return new FullBuilder().withOwner(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withOwner(String value) {
                    Objects.requireNonNull(value, "AccessControlTranslationProperty#owner is required");
                    this.instance._owner = value;
                    return this;
                }

                public Build withOwner(Token value) {
                    Objects.requireNonNull(value, "AccessControlTranslationProperty#owner is required");
                    this.instance._owner = value;
                    return this;
                }

                @Override
                public AccessControlTranslationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public AccessControlTranslationProperty build();
            }
        }
    }

    public static interface AccelerateConfigurationProperty
    extends JsiiSerializable {
        public Object getAccelerationStatus();

        public void setAccelerationStatus(String var1);

        public void setAccelerationStatus(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withAccelerationStatus(String value) {
                return new FullBuilder().withAccelerationStatus(value);
            }

            public Build withAccelerationStatus(Token value) {
                return new FullBuilder().withAccelerationStatus(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withAccelerationStatus(String value) {
                    Objects.requireNonNull(value, "AccelerateConfigurationProperty#accelerationStatus is required");
                    this.instance._accelerationStatus = value;
                    return this;
                }

                public Build withAccelerationStatus(Token value) {
                    Objects.requireNonNull(value, "AccelerateConfigurationProperty#accelerationStatus is required");
                    this.instance._accelerationStatus = value;
                    return this;
                }

                @Override
                public AccelerateConfigurationProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public AccelerateConfigurationProperty build();
            }
        }
    }

    public static interface AbortIncompleteMultipartUploadProperty
    extends JsiiSerializable {
        public Object getDaysAfterInitiation();

        public void setDaysAfterInitiation(Number var1);

        public void setDaysAfterInitiation(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public Build withDaysAfterInitiation(Number value) {
                return new FullBuilder().withDaysAfterInitiation(value);
            }

            public Build withDaysAfterInitiation(Token value) {
                return new FullBuilder().withDaysAfterInitiation(value);
            }

            final class FullBuilder
            implements Build {
                private Jsii.Pojo instance = new Jsii.Pojo();

                FullBuilder() {
                }

                public Build withDaysAfterInitiation(Number value) {
                    Objects.requireNonNull(value, "AbortIncompleteMultipartUploadProperty#daysAfterInitiation is required");
                    this.instance._daysAfterInitiation = value;
                    return this;
                }

                public Build withDaysAfterInitiation(Token value) {
                    Objects.requireNonNull(value, "AbortIncompleteMultipartUploadProperty#daysAfterInitiation is required");
                    this.instance._daysAfterInitiation = value;
                    return this;
                }

                @Override
                public AbortIncompleteMultipartUploadProperty build() {
                    Jsii.Pojo result = this.instance;
                    this.instance = new Jsii.Pojo();
                    return result;
                }
            }

            public static interface Build {
                public AbortIncompleteMultipartUploadProperty build();
            }
        }
    }
}

