/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.s3.HttpMethods;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CorsRule
extends JsiiSerializable {
    public List<HttpMethods> getAllowedMethods();

    public List<String> getAllowedOrigins();

    public List<String> getAllowedHeaders();

    public List<String> getExposedHeaders();

    public String getId();

    public Number getMaxAge();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<HttpMethods> _allowedMethods;
        private List<String> _allowedOrigins;
        @Nullable
        private List<String> _allowedHeaders;
        @Nullable
        private List<String> _exposedHeaders;
        @Nullable
        private String _id;
        @Nullable
        private Number _maxAge;

        public Builder withAllowedMethods(List<HttpMethods> value) {
            this._allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
            return this;
        }

        public Builder withAllowedOrigins(List<String> value) {
            this._allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
            return this;
        }

        public Builder withAllowedHeaders(@Nullable List<String> value) {
            this._allowedHeaders = value;
            return this;
        }

        public Builder withExposedHeaders(@Nullable List<String> value) {
            this._exposedHeaders = value;
            return this;
        }

        public Builder withId(@Nullable String value) {
            this._id = value;
            return this;
        }

        public Builder withMaxAge(@Nullable Number value) {
            this._maxAge = value;
            return this;
        }

        public CorsRule build() {
            return new CorsRule(){
                private final List<HttpMethods> $allowedMethods;
                private final List<String> $allowedOrigins;
                @Nullable
                private final List<String> $allowedHeaders;
                @Nullable
                private final List<String> $exposedHeaders;
                @Nullable
                private final String $id;
                @Nullable
                private final Number $maxAge;
                {
                    this.$allowedMethods = Objects.requireNonNull(_allowedMethods, "allowedMethods is required");
                    this.$allowedOrigins = Objects.requireNonNull(_allowedOrigins, "allowedOrigins is required");
                    this.$allowedHeaders = _allowedHeaders;
                    this.$exposedHeaders = _exposedHeaders;
                    this.$id = _id;
                    this.$maxAge = _maxAge;
                }

                @Override
                public List<HttpMethods> getAllowedMethods() {
                    return this.$allowedMethods;
                }

                @Override
                public List<String> getAllowedOrigins() {
                    return this.$allowedOrigins;
                }

                @Override
                public List<String> getAllowedHeaders() {
                    return this.$allowedHeaders;
                }

                @Override
                public List<String> getExposedHeaders() {
                    return this.$exposedHeaders;
                }

                @Override
                public String getId() {
                    return this.$id;
                }

                @Override
                public Number getMaxAge() {
                    return this.$maxAge;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                    obj.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
                    if (this.getAllowedHeaders() != null) {
                        obj.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
                    }
                    if (this.getExposedHeaders() != null) {
                        obj.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
                    }
                    if (this.getId() != null) {
                        obj.set("id", om.valueToTree((Object)this.getId()));
                    }
                    if (this.getMaxAge() != null) {
                        obj.set("maxAge", om.valueToTree((Object)this.getMaxAge()));
                    }
                    return obj;
                }
            };
        }
    }
}

