/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.s3.StorageClass;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface Transition
extends JsiiSerializable {
    public StorageClass getStorageClass();

    public Duration getTransitionAfter();

    public Instant getTransitionDate();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StorageClass _storageClass;
        @Nullable
        private Duration _transitionAfter;
        @Nullable
        private Instant _transitionDate;

        public Builder withStorageClass(StorageClass value) {
            this._storageClass = Objects.requireNonNull(value, "storageClass is required");
            return this;
        }

        public Builder withTransitionAfter(@Nullable Duration value) {
            this._transitionAfter = value;
            return this;
        }

        public Builder withTransitionDate(@Nullable Instant value) {
            this._transitionDate = value;
            return this;
        }

        public Transition build() {
            return new Transition(){
                private final StorageClass $storageClass;
                @Nullable
                private final Duration $transitionAfter;
                @Nullable
                private final Instant $transitionDate;
                {
                    this.$storageClass = Objects.requireNonNull(_storageClass, "storageClass is required");
                    this.$transitionAfter = _transitionAfter;
                    this.$transitionDate = _transitionDate;
                }

                @Override
                public StorageClass getStorageClass() {
                    return this.$storageClass;
                }

                @Override
                public Duration getTransitionAfter() {
                    return this.$transitionAfter;
                }

                @Override
                public Instant getTransitionDate() {
                    return this.$transitionDate;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("storageClass", om.valueToTree((Object)this.getStorageClass()));
                    if (this.getTransitionAfter() != null) {
                        obj.set("transitionAfter", om.valueToTree((Object)this.getTransitionAfter()));
                    }
                    if (this.getTransitionDate() != null) {
                        obj.set("transitionDate", om.valueToTree((Object)this.getTransitionDate()));
                    }
                    return obj;
                }
            };
        }
    }
}

