/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.BucketAttributes;
import software.amazon.awscdk.services.s3.BucketMetrics;
import software.amazon.awscdk.services.s3.BucketPolicy;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awscdk.services.s3.EventType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.IBucketNotificationDestination;
import software.amazon.awscdk.services.s3.LifecycleRule;
import software.amazon.awscdk.services.s3.NotificationKeyFilter;
import software.amazon.awscdk.services.s3.OnCloudTrailBucketEventOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.Bucket")
public class Bucket
extends Resource
implements IBucket {
    protected Bucket(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public Bucket(Construct scope, String id, @Nullable BucketProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Bucket(Construct scope, String id) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public static IBucket fromBucketArn(Construct scope, String id, String bucketArn) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"fromBucketArn", IBucket.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(bucketArn, "bucketArn is required")});
    }

    public static IBucket fromBucketAttributes(Construct scope, String id, BucketAttributes attrs) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"fromBucketAttributes", IBucket.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public static IBucket fromBucketName(Construct scope, String id, String bucketName) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"fromBucketName", IBucket.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(bucketName, "bucketName is required")});
    }

    public void addEventNotification(EventType event, IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        this.jsiiCall("addEventNotification", Void.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(event, "event is required"), Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    public void addLifecycleRule(LifecycleRule rule) {
        this.jsiiCall("addLifecycleRule", Void.class, new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public void addMetric(BucketMetrics metric) {
        this.jsiiCall("addMetric", Void.class, new Object[]{Objects.requireNonNull(metric, "metric is required")});
    }

    public void addObjectCreatedNotification(IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        this.jsiiCall("addObjectCreatedNotification", Void.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    public void addObjectRemovedNotification(IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        this.jsiiCall("addObjectRemovedNotification", Void.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    @Override
    public void addToResourcePolicy(PolicyStatement permission) {
        this.jsiiCall("addToResourcePolicy", Void.class, new Object[]{Objects.requireNonNull(permission, "permission is required")});
    }

    @Override
    public String arnForObjects(String keyPattern) {
        return (String)this.jsiiCall("arnForObjects", String.class, new Object[]{Objects.requireNonNull(keyPattern, "keyPattern is required")});
    }

    @Override
    public Grant grantDelete(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantDelete", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantDelete(IGrantable identity) {
        return (Grant)this.jsiiCall("grantDelete", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public Grant grantPublicAccess(@Nullable String keyPrefix, String ... allowedActions) {
        return (Grant)this.jsiiCall("grantPublicAccess", Grant.class, Stream.concat(Arrays.stream(new Object[]{keyPrefix}), Arrays.stream(allowedActions)).toArray(Object[]::new));
    }

    @Override
    public Grant grantPut(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantPut", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantPut(IGrantable identity) {
        return (Grant)this.jsiiCall("grantPut", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public Grant grantRead(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantRead(IGrantable identity) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public Grant grantReadWrite(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantReadWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantReadWrite(IGrantable identity) {
        return (Grant)this.jsiiCall("grantReadWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public Grant grantWrite(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantWrite(IGrantable identity) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public Rule onCloudTrailEvent(String id, OnCloudTrailBucketEventOptions options) {
        return (Rule)this.jsiiCall("onCloudTrailEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public Rule onCloudTrailPutObject(String id, OnCloudTrailBucketEventOptions options) {
        return (Rule)this.jsiiCall("onCloudTrailPutObject", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public String urlForObject(@Nullable String key) {
        return (String)this.jsiiCall("urlForObject", String.class, new Object[]{key});
    }

    @Override
    public String urlForObject() {
        return (String)this.jsiiCall("urlForObject", String.class, new Object[0]);
    }

    @Override
    public String getBucketArn() {
        return (String)this.jsiiGet("bucketArn", String.class);
    }

    @Override
    public String getBucketDomainName() {
        return (String)this.jsiiGet("bucketDomainName", String.class);
    }

    @Override
    public String getBucketDualStackDomainName() {
        return (String)this.jsiiGet("bucketDualStackDomainName", String.class);
    }

    @Override
    public String getBucketName() {
        return (String)this.jsiiGet("bucketName", String.class);
    }

    @Override
    public String getBucketRegionalDomainName() {
        return (String)this.jsiiGet("bucketRegionalDomainName", String.class);
    }

    @Override
    public String getBucketWebsiteUrl() {
        return (String)this.jsiiGet("bucketWebsiteUrl", String.class);
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)this.jsiiGet("encryptionKey", IKey.class);
    }

    protected Boolean getAutoCreatePolicy() {
        return (Boolean)this.jsiiGet("autoCreatePolicy", Boolean.class);
    }

    protected void setAutoCreatePolicy(Boolean value) {
        this.jsiiSet("autoCreatePolicy", Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    @Nullable
    protected Boolean getDisallowPublicAccess() {
        return (Boolean)this.jsiiGet("disallowPublicAccess", Boolean.class);
    }

    protected void setDisallowPublicAccess(@Nullable Boolean value) {
        this.jsiiSet("disallowPublicAccess", value);
    }

    @Override
    @Nullable
    public BucketPolicy getPolicy() {
        return (BucketPolicy)((Object)this.jsiiGet("policy", BucketPolicy.class));
    }

    @Override
    public void setPolicy(@Nullable BucketPolicy value) {
        this.jsiiSet("policy", (Object)value);
    }
}

