/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.BlockPublicAccess;
import software.amazon.awscdk.services.s3.BucketEncryption;
import software.amazon.awscdk.services.s3.BucketMetrics;
import software.amazon.awscdk.services.s3.LifecycleRule;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface BucketProps
extends JsiiSerializable {
    public BlockPublicAccess getBlockPublicAccess();

    public String getBucketName();

    public BucketEncryption getEncryption();

    public IKey getEncryptionKey();

    public List<LifecycleRule> getLifecycleRules();

    public List<BucketMetrics> getMetrics();

    public Boolean getPublicReadAccess();

    public RemovalPolicy getRemovalPolicy();

    public Boolean getVersioned();

    public String getWebsiteErrorDocument();

    public String getWebsiteIndexDocument();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private BlockPublicAccess _blockPublicAccess;
        @Nullable
        private String _bucketName;
        @Nullable
        private BucketEncryption _encryption;
        @Nullable
        private IKey _encryptionKey;
        @Nullable
        private List<LifecycleRule> _lifecycleRules;
        @Nullable
        private List<BucketMetrics> _metrics;
        @Nullable
        private Boolean _publicReadAccess;
        @Nullable
        private RemovalPolicy _removalPolicy;
        @Nullable
        private Boolean _versioned;
        @Nullable
        private String _websiteErrorDocument;
        @Nullable
        private String _websiteIndexDocument;

        public Builder withBlockPublicAccess(@Nullable BlockPublicAccess value) {
            this._blockPublicAccess = value;
            return this;
        }

        public Builder withBucketName(@Nullable String value) {
            this._bucketName = value;
            return this;
        }

        public Builder withEncryption(@Nullable BucketEncryption value) {
            this._encryption = value;
            return this;
        }

        public Builder withEncryptionKey(@Nullable IKey value) {
            this._encryptionKey = value;
            return this;
        }

        public Builder withLifecycleRules(@Nullable List<LifecycleRule> value) {
            this._lifecycleRules = value;
            return this;
        }

        public Builder withMetrics(@Nullable List<BucketMetrics> value) {
            this._metrics = value;
            return this;
        }

        public Builder withPublicReadAccess(@Nullable Boolean value) {
            this._publicReadAccess = value;
            return this;
        }

        public Builder withRemovalPolicy(@Nullable RemovalPolicy value) {
            this._removalPolicy = value;
            return this;
        }

        public Builder withVersioned(@Nullable Boolean value) {
            this._versioned = value;
            return this;
        }

        public Builder withWebsiteErrorDocument(@Nullable String value) {
            this._websiteErrorDocument = value;
            return this;
        }

        public Builder withWebsiteIndexDocument(@Nullable String value) {
            this._websiteIndexDocument = value;
            return this;
        }

        public BucketProps build() {
            return new BucketProps(){
                @Nullable
                private final BlockPublicAccess $blockPublicAccess;
                @Nullable
                private final String $bucketName;
                @Nullable
                private final BucketEncryption $encryption;
                @Nullable
                private final IKey $encryptionKey;
                @Nullable
                private final List<LifecycleRule> $lifecycleRules;
                @Nullable
                private final List<BucketMetrics> $metrics;
                @Nullable
                private final Boolean $publicReadAccess;
                @Nullable
                private final RemovalPolicy $removalPolicy;
                @Nullable
                private final Boolean $versioned;
                @Nullable
                private final String $websiteErrorDocument;
                @Nullable
                private final String $websiteIndexDocument;
                {
                    this.$blockPublicAccess = _blockPublicAccess;
                    this.$bucketName = _bucketName;
                    this.$encryption = _encryption;
                    this.$encryptionKey = _encryptionKey;
                    this.$lifecycleRules = _lifecycleRules;
                    this.$metrics = _metrics;
                    this.$publicReadAccess = _publicReadAccess;
                    this.$removalPolicy = _removalPolicy;
                    this.$versioned = _versioned;
                    this.$websiteErrorDocument = _websiteErrorDocument;
                    this.$websiteIndexDocument = _websiteIndexDocument;
                }

                @Override
                public BlockPublicAccess getBlockPublicAccess() {
                    return this.$blockPublicAccess;
                }

                @Override
                public String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public BucketEncryption getEncryption() {
                    return this.$encryption;
                }

                @Override
                public IKey getEncryptionKey() {
                    return this.$encryptionKey;
                }

                @Override
                public List<LifecycleRule> getLifecycleRules() {
                    return this.$lifecycleRules;
                }

                @Override
                public List<BucketMetrics> getMetrics() {
                    return this.$metrics;
                }

                @Override
                public Boolean getPublicReadAccess() {
                    return this.$publicReadAccess;
                }

                @Override
                public RemovalPolicy getRemovalPolicy() {
                    return this.$removalPolicy;
                }

                @Override
                public Boolean getVersioned() {
                    return this.$versioned;
                }

                @Override
                public String getWebsiteErrorDocument() {
                    return this.$websiteErrorDocument;
                }

                @Override
                public String getWebsiteIndexDocument() {
                    return this.$websiteIndexDocument;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("blockPublicAccess", om.valueToTree((Object)this.getBlockPublicAccess()));
                    obj.set("bucketName", om.valueToTree((Object)this.getBucketName()));
                    obj.set("encryption", om.valueToTree((Object)this.getEncryption()));
                    obj.set("encryptionKey", om.valueToTree((Object)this.getEncryptionKey()));
                    obj.set("lifecycleRules", om.valueToTree(this.getLifecycleRules()));
                    obj.set("metrics", om.valueToTree(this.getMetrics()));
                    obj.set("publicReadAccess", om.valueToTree((Object)this.getPublicReadAccess()));
                    obj.set("removalPolicy", om.valueToTree((Object)this.getRemovalPolicy()));
                    obj.set("versioned", om.valueToTree((Object)this.getVersioned()));
                    obj.set("websiteErrorDocument", om.valueToTree((Object)this.getWebsiteErrorDocument()));
                    obj.set("websiteIndexDocument", om.valueToTree((Object)this.getWebsiteIndexDocument()));
                    return obj;
                }
            };
        }
    }
}

