/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.events.EventRule;
import software.amazon.awscdk.services.events.IEventRuleTarget;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IEncryptionKey;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.BucketImportProps;
import software.amazon.awscdk.services.s3.BucketPolicy;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.BucketBase")
public abstract class BucketBase
extends Resource
implements IBucket {
    protected BucketBase(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public BucketBase(Construct scope, String id) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void addToResourcePolicy(PolicyStatement permission) {
        this.jsiiCall("addToResourcePolicy", Void.class, new Object[]{Objects.requireNonNull(permission, "permission is required")});
    }

    @Override
    public String arnForObjects(String ... keyPattern) {
        return (String)this.jsiiCall("arnForObjects", String.class, Arrays.stream(keyPattern).toArray(Object[]::new));
    }

    @Override
    public abstract BucketImportProps export();

    @Override
    public Grant grantDelete(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantDelete", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantDelete(IGrantable identity) {
        return (Grant)this.jsiiCall("grantDelete", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public Grant grantPublicAccess(@Nullable String keyPrefix, String ... allowedActions) {
        return (Grant)this.jsiiCall("grantPublicAccess", Grant.class, Stream.concat(Arrays.stream(new Object[]{keyPrefix}), Arrays.stream(allowedActions)).toArray(Object[]::new));
    }

    @Override
    public Grant grantPut(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantPut", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantPut(IGrantable identity) {
        return (Grant)this.jsiiCall("grantPut", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public Grant grantRead(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantRead(IGrantable identity) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public Grant grantReadWrite(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantReadWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantReadWrite(IGrantable identity) {
        return (Grant)this.jsiiCall("grantReadWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public Grant grantWrite(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    @Override
    public Grant grantWrite(IGrantable identity) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @Override
    public EventRule onPutObject(String name, @Nullable IEventRuleTarget target, @Nullable String path) {
        return (EventRule)this.jsiiCall("onPutObject", EventRule.class, new Object[]{Objects.requireNonNull(name, "name is required"), target, path});
    }

    @Override
    public EventRule onPutObject(String name, @Nullable IEventRuleTarget target) {
        return (EventRule)this.jsiiCall("onPutObject", EventRule.class, new Object[]{Objects.requireNonNull(name, "name is required"), target});
    }

    @Override
    public EventRule onPutObject(String name) {
        return (EventRule)this.jsiiCall("onPutObject", EventRule.class, new Object[]{Objects.requireNonNull(name, "name is required")});
    }

    @Override
    public String urlForObject(@Nullable String key) {
        return (String)this.jsiiCall("urlForObject", String.class, new Object[]{key});
    }

    @Override
    public String urlForObject() {
        return (String)this.jsiiCall("urlForObject", String.class, new Object[0]);
    }

    @Override
    public String getBucketArn() {
        return (String)this.jsiiGet("bucketArn", String.class);
    }

    @Override
    public String getBucketName() {
        return (String)this.jsiiGet("bucketName", String.class);
    }

    @Override
    public String getBucketUrl() {
        return (String)this.jsiiGet("bucketUrl", String.class);
    }

    @Override
    public String getDomainName() {
        return (String)this.jsiiGet("domainName", String.class);
    }

    @Override
    @Nullable
    public IEncryptionKey getEncryptionKey() {
        return (IEncryptionKey)this.jsiiGet("encryptionKey", IEncryptionKey.class);
    }

    protected Boolean getAutoCreatePolicy() {
        return (Boolean)this.jsiiGet("autoCreatePolicy", Boolean.class);
    }

    protected void setAutoCreatePolicy(Boolean value) {
        this.jsiiSet("autoCreatePolicy", Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    @Nullable
    protected Boolean getDisallowPublicAccess() {
        return (Boolean)this.jsiiGet("disallowPublicAccess", Boolean.class);
    }

    protected void setDisallowPublicAccess(@Nullable Boolean value) {
        this.jsiiSet("disallowPublicAccess", value);
    }

    @Override
    @Nullable
    public BucketPolicy getPolicy() {
        return (BucketPolicy)((Object)this.jsiiGet("policy", BucketPolicy.class));
    }

    @Override
    public void setPolicy(@Nullable BucketPolicy value) {
        this.jsiiSet("policy", (Object)value);
    }
}

