/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.assets;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.assets.FollowMode;
import software.amazon.awscdk.core.AssetHashType;
import software.amazon.awscdk.core.BundlingOptions;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IAsset;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.assets.;
import software.amazon.awscdk.services.s3.assets.AssetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3-assets.Asset")
public class Asset
extends Construct
implements IAsset {
    protected Asset(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Asset(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Asset(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull AssetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addResourceMetadata(@NotNull CfnResource resource, @NotNull String resourceProperty) {
        Kernel.call((Object)((Object)this), (String)"addResourceMetadata", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(resource, "resource is required"), Objects.requireNonNull(resourceProperty, "resourceProperty is required")});
    }

    public void grantRead(@NotNull IGrantable grantee) {
        Kernel.call((Object)((Object)this), (String)"grantRead", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    public String getAssetHash() {
        return (String)Kernel.get((Object)((Object)this), (String)"assetHash", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAssetPath() {
        return (String)Kernel.get((Object)((Object)this), (String)"assetPath", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IBucket getBucket() {
        return (IBucket)Kernel.get((Object)((Object)this), (String)"bucket", (NativeType)NativeType.forClass(IBucket.class));
    }

    @NotNull
    public String getHttpUrl() {
        return (String)Kernel.get((Object)((Object)this), (String)"httpUrl", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Boolean getIsZipArchive() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"isZipArchive", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public String getS3BucketName() {
        return (String)Kernel.get((Object)((Object)this), (String)"s3BucketName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getS3ObjectKey() {
        return (String)Kernel.get((Object)((Object)this), (String)"s3ObjectKey", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getS3ObjectUrl() {
        return (String)Kernel.get((Object)((Object)this), (String)"s3ObjectUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Deprecated
    @NotNull
    public String getS3Url() {
        return (String)Kernel.get((Object)((Object)this), (String)"s3Url", (NativeType)NativeType.forClass(String.class));
    }

    @Deprecated
    @NotNull
    public String getSourceHash() {
        return (String)Kernel.get((Object)((Object)this), (String)"sourceHash", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Asset> {
        private final software.constructs.Construct scope;
        private final String id;
        private final AssetProps.Builder props;

        public static Builder create(software.constructs.Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(software.constructs.Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AssetProps.Builder();
        }

        @Deprecated
        public Builder exclude(List<String> exclude) {
            this.props.exclude(exclude);
            return this;
        }

        @Deprecated
        public Builder follow(FollowMode follow) {
            this.props.follow(follow);
            return this;
        }

        public Builder assetHash(String assetHash) {
            this.props.assetHash(assetHash);
            return this;
        }

        public Builder assetHashType(AssetHashType assetHashType) {
            this.props.assetHashType(assetHashType);
            return this;
        }

        public Builder bundling(BundlingOptions bundling) {
            this.props.bundling(bundling);
            return this;
        }

        public Builder readers(List<? extends IGrantable> readers) {
            this.props.readers(readers);
            return this;
        }

        @Deprecated
        public Builder sourceHash(String sourceHash) {
            this.props.sourceHash(sourceHash);
            return this;
        }

        public Builder path(String path) {
            this.props.path(path);
            return this;
        }

        public Asset build() {
            return new Asset(this.scope, this.id, this.props.build());
        }
    }
}

