/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.assets;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.assets.CopyOptions;
import software.amazon.awscdk.assets.FollowMode;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface AssetProps
extends JsiiSerializable,
CopyOptions {
    public String getPath();

    public List<IGrantable> getReaders();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _path;
        @Nullable
        private List<IGrantable> _readers;
        @Nullable
        private List<String> _exclude;
        @Nullable
        private FollowMode _follow;

        public Builder withPath(String value) {
            this._path = Objects.requireNonNull(value, "path is required");
            return this;
        }

        public Builder withReaders(@Nullable List<IGrantable> value) {
            this._readers = value;
            return this;
        }

        public Builder withExclude(@Nullable List<String> value) {
            this._exclude = value;
            return this;
        }

        public Builder withFollow(@Nullable FollowMode value) {
            this._follow = value;
            return this;
        }

        public AssetProps build() {
            return new AssetProps(){
                private final String $path;
                @Nullable
                private final List<IGrantable> $readers;
                @Nullable
                private final List<String> $exclude;
                @Nullable
                private final FollowMode $follow;
                {
                    this.$path = Objects.requireNonNull(_path, "path is required");
                    this.$readers = _readers;
                    this.$exclude = _exclude;
                    this.$follow = _follow;
                }

                @Override
                public String getPath() {
                    return this.$path;
                }

                @Override
                public List<IGrantable> getReaders() {
                    return this.$readers;
                }

                public List<String> getExclude() {
                    return this.$exclude;
                }

                public FollowMode getFollow() {
                    return this.$follow;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("path", om.valueToTree((Object)this.getPath()));
                    if (this.getReaders() != null) {
                        obj.set("readers", om.valueToTree(this.getReaders()));
                    }
                    if (this.getExclude() != null) {
                        obj.set("exclude", om.valueToTree(this.getExclude()));
                    }
                    if (this.getFollow() != null) {
                        obj.set("follow", om.valueToTree((Object)this.getFollow()));
                    }
                    return obj;
                }
            };
        }
    }
}

