package software.amazon.awscdk.services.s3.assets;

/**
 * An asset represents a local file or directory, which is automatically uploaded to S3 and then can be referenced within a CDK application.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T17:01:23.949Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.assets.$Module.class, fqn = "@aws-cdk/aws-s3-assets.Asset")
public class Asset extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.assets.IAsset {
    protected Asset(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Asset(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.s3.assets.AssetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds CloudFormation template metadata to the specified resource with information that indicates which resource property is mapped to this local asset.
     * 
     * This can be used by tools such as SAM CLI to provide local
     * experience such as local invocation and debugging of Lambda functions.
     * 
     * Asset metadata will only be included if the stack is synthesized with the
     * "aws:cdk:enable-asset-metadata" context key defined, which is the default
     * behavior when synthesizing via the CDK Toolkit.
     * 
     * EXPERIMENTAL
     * 
     * @see https://github.com/awslabs/aws-cdk/issues/1432
     * @param resource The CloudFormation resource which is using this asset [disable-awslint:ref-via-interface].
     * @param resourceProperty The property name where this asset is referenced (e.g. "Code" for AWS::Lambda::Function).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addResourceMetadata(final software.amazon.awscdk.core.CfnResource resource, final java.lang.String resourceProperty) {
        this.jsiiCall("addResourceMetadata", Void.class, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required"), java.util.Objects.requireNonNull(resourceProperty, "resourceProperty is required") });
    }

    /**
     * Grants read permissions to the principal on the asset's S3 object.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void grantRead(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        this.jsiiCall("grantRead", Void.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * A hash of the bundle for of this asset, which is only available at deployment time.
     * 
     * As this is
     * a late-bound token, it may not be used in construct IDs, but can be passed as a resource
     * property in order to force a change on a resource when an asset is effectively updated. This is
     * more reliable than `sourceHash` in particular for assets which bundling phase involve external
     * resources that can change over time (such as Docker image builds).
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getArtifactHash() {
        return this.jsiiGet("artifactHash", java.lang.String.class);
    }

    /**
     * The path to the asset (stringinfied token).
     * 
     * If asset staging is disabled, this will just be the original path.
     * If asset staging is enabled it will be the staged path.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getAssetPath() {
        return this.jsiiGet("assetPath", java.lang.String.class);
    }

    /**
     * The S3 bucket in which this asset resides.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.s3.IBucket getBucket() {
        return this.jsiiGet("bucket", software.amazon.awscdk.services.s3.IBucket.class);
    }

    /**
     * Indicates if this asset is a zip archive.
     * 
     * Allows constructs to ensure that the
     * correct file type was used.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Boolean getIsZipArchive() {
        return this.jsiiGet("isZipArchive", java.lang.Boolean.class);
    }

    /**
     * Attribute that represents the name of the bucket this asset exists in.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getS3BucketName() {
        return this.jsiiGet("s3BucketName", java.lang.String.class);
    }

    /**
     * Attribute which represents the S3 object key of this asset.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getS3ObjectKey() {
        return this.jsiiGet("s3ObjectKey", java.lang.String.class);
    }

    /**
     * Attribute which represents the S3 URL of this asset.
     * 
     * Example:
     * 
     * https://s3.us-west-1.amazonaws.com/bucket/key
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getS3Url() {
        return this.jsiiGet("s3Url", java.lang.String.class);
    }

    /**
     * A hash of the source of this asset, which is available at construction time.
     * 
     * As this is a plain
     * string, it can be used in construct IDs in order to enforce creation of a new resource when
     * the content hash has changed.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getSourceHash() {
        return this.jsiiGet("sourceHash", java.lang.String.class);
    }
}
