package software.amazon.awscdk.services.route53resolver.alpha;

/**
 * (experimental) Domains configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.alpha.*;
 * DomainsConfig domainsConfig = DomainsConfig.builder()
 *         .domainFileUrl("domainFileUrl")
 *         .domains(List.of("domains"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-08T20:48:17.883Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53resolver.alpha.$Module.class, fqn = "@aws-cdk/aws-route53resolver-alpha.DomainsConfig")
@software.amazon.jsii.Jsii.Proxy(DomainsConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DomainsConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The fully qualified URL or URI of the file stored in Amazon S3 that contains the list of domains to import.
     * <p>
     * The file must be a text file and must contain
     * a single domain per line. The content type of the S3 object must be <code>plain/text</code>.
     * <p>
     * Default: - use `domains`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainFileUrl() {
        return null;
    }

    /**
     * (experimental) A list of domains.
     * <p>
     * Default: - use `domainFileUrl`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDomains() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DomainsConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainsConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DomainsConfig> {
        java.lang.String domainFileUrl;
        java.util.List<java.lang.String> domains;

        /**
         * Sets the value of {@link DomainsConfig#getDomainFileUrl}
         * @param domainFileUrl The fully qualified URL or URI of the file stored in Amazon S3 that contains the list of domains to import.
         *                      The file must be a text file and must contain
         *                      a single domain per line. The content type of the S3 object must be <code>plain/text</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainFileUrl(java.lang.String domainFileUrl) {
            this.domainFileUrl = domainFileUrl;
            return this;
        }

        /**
         * Sets the value of {@link DomainsConfig#getDomains}
         * @param domains A list of domains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domains(java.util.List<java.lang.String> domains) {
            this.domains = domains;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainsConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DomainsConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainsConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainsConfig {
        private final java.lang.String domainFileUrl;
        private final java.util.List<java.lang.String> domains;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainFileUrl = software.amazon.jsii.Kernel.get(this, "domainFileUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domains = software.amazon.jsii.Kernel.get(this, "domains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainFileUrl = builder.domainFileUrl;
            this.domains = builder.domains;
        }

        @Override
        public final java.lang.String getDomainFileUrl() {
            return this.domainFileUrl;
        }

        @Override
        public final java.util.List<java.lang.String> getDomains() {
            return this.domains;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDomainFileUrl() != null) {
                data.set("domainFileUrl", om.valueToTree(this.getDomainFileUrl()));
            }
            if (this.getDomains() != null) {
                data.set("domains", om.valueToTree(this.getDomains()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53resolver-alpha.DomainsConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainsConfig.Jsii$Proxy that = (DomainsConfig.Jsii$Proxy) o;

            if (this.domainFileUrl != null ? !this.domainFileUrl.equals(that.domainFileUrl) : that.domainFileUrl != null) return false;
            return this.domains != null ? this.domains.equals(that.domains) : that.domains == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainFileUrl != null ? this.domainFileUrl.hashCode() : 0;
            result = 31 * result + (this.domains != null ? this.domains.hashCode() : 0);
            return result;
        }
    }
}
