package software.amazon.awscdk.services.route53resolver.alpha;

/**
 * (experimental) A Firewall Rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FirewallDomainList myBlockList;
 * FirewallRuleGroup ruleGroup;
 * ruleGroup.addRule(FirewallRule.builder()
 *         .priority(10)
 *         .firewallDomainList(myBlockList)
 *         // block and reply with NXDOMAIN
 *         .action(FirewallRuleAction.block(DnsBlockResponse.nxDomain()))
 *         .build());
 * ruleGroup.addRule(FirewallRule.builder()
 *         .priority(20)
 *         .firewallDomainList(myBlockList)
 *         // block and override DNS response with a custom domain
 *         .action(FirewallRuleAction.block(DnsBlockResponse.override("amazon.com")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.1 (build 2799dc8)", date = "2022-07-16T02:16:06.004Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53resolver.alpha.$Module.class, fqn = "@aws-cdk/aws-route53resolver-alpha.FirewallRule")
@software.amazon.jsii.Jsii.Proxy(FirewallRule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FirewallRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The action for this rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.alpha.FirewallRuleAction getAction();

    /**
     * (experimental) The domain list for this rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.alpha.IFirewallDomainList getFirewallDomainList();

    /**
     * (experimental) The priority of the rule in the rule group.
     * <p>
     * This value must be unique within
     * the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * @return a {@link Builder} of {@link FirewallRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirewallRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FirewallRule> {
        software.amazon.awscdk.services.route53resolver.alpha.FirewallRuleAction action;
        software.amazon.awscdk.services.route53resolver.alpha.IFirewallDomainList firewallDomainList;
        java.lang.Number priority;

        /**
         * Sets the value of {@link FirewallRule#getAction}
         * @param action The action for this rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder action(software.amazon.awscdk.services.route53resolver.alpha.FirewallRuleAction action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link FirewallRule#getFirewallDomainList}
         * @param firewallDomainList The domain list for this rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder firewallDomainList(software.amazon.awscdk.services.route53resolver.alpha.IFirewallDomainList firewallDomainList) {
            this.firewallDomainList = firewallDomainList;
            return this;
        }

        /**
         * Sets the value of {@link FirewallRule#getPriority}
         * @param priority The priority of the rule in the rule group. This parameter is required.
         *                 This value must be unique within
         *                 the rule group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirewallRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FirewallRule build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FirewallRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirewallRule {
        private final software.amazon.awscdk.services.route53resolver.alpha.FirewallRuleAction action;
        private final software.amazon.awscdk.services.route53resolver.alpha.IFirewallDomainList firewallDomainList;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53resolver.alpha.FirewallRuleAction.class));
            this.firewallDomainList = software.amazon.jsii.Kernel.get(this, "firewallDomainList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53resolver.alpha.IFirewallDomainList.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            this.firewallDomainList = java.util.Objects.requireNonNull(builder.firewallDomainList, "firewallDomainList is required");
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
        }

        @Override
        public final software.amazon.awscdk.services.route53resolver.alpha.FirewallRuleAction getAction() {
            return this.action;
        }

        @Override
        public final software.amazon.awscdk.services.route53resolver.alpha.IFirewallDomainList getFirewallDomainList() {
            return this.firewallDomainList;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            data.set("firewallDomainList", om.valueToTree(this.getFirewallDomainList()));
            data.set("priority", om.valueToTree(this.getPriority()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53resolver-alpha.FirewallRule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirewallRule.Jsii$Proxy that = (FirewallRule.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (!firewallDomainList.equals(that.firewallDomainList)) return false;
            return this.priority.equals(that.priority);
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.firewallDomainList.hashCode());
            result = 31 * result + (this.priority.hashCode());
            return result;
        }
    }
}
