package software.amazon.awscdk.services.route53resolver.alpha;

/**
 * (experimental) A list of domains.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FirewallDomainList blockList = FirewallDomainList.Builder.create(this, "BlockList")
 *         .domains(FirewallDomains.fromList(List.of("bad-domain.com", "bot-domain.net")))
 *         .build();
 * FirewallDomainList s3List = FirewallDomainList.Builder.create(this, "S3List")
 *         .domains(FirewallDomains.fromS3Url("s3://bucket/prefix/object"))
 *         .build();
 * FirewallDomainList assetList = FirewallDomainList.Builder.create(this, "AssetList")
 *         .domains(FirewallDomains.fromAsset("/path/to/domains.txt"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.1 (build 2799dc8)", date = "2022-07-09T01:06:21.419Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53resolver.alpha.$Module.class, fqn = "@aws-cdk/aws-route53resolver-alpha.FirewallDomains")
public abstract class FirewallDomains extends software.amazon.jsii.JsiiObject {

    protected FirewallDomains(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirewallDomains(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected FirewallDomains() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Firewall domains created from a local disk path to a text file.
     * <p>
     * The file must be a text file (<code>.txt</code> extension) and must contain a single
     * domain per line. It will be uploaded to S3.
     * <p>
     * @param assetPath path to the text file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String assetPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains.class), new Object[] { java.util.Objects.requireNonNull(assetPath, "assetPath is required") });
    }

    /**
     * (experimental) Firewall domains created from a list of domains.
     * <p>
     * @param list the list of domains. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains fromList(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> list) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains.class, "fromList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains.class), new Object[] { java.util.Objects.requireNonNull(list, "list is required") });
    }

    /**
     * (experimental) Firewall domains created from a file stored in Amazon S3.
     * <p>
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be <code>plain/text</code>.
     * <p>
     * @param bucket S3 bucket. This parameter is required.
     * @param key S3 key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains fromS3(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains.class, "fromS3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * (experimental) Firewall domains created from the URL of a file stored in Amazon S3.
     * <p>
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be <code>plain/text</code>.
     * <p>
     * @param url S3 bucket url (s3://bucket/prefix/objet). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains fromS3Url(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains.class, "fromS3Url", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) Binds the domains to a domain list.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.alpha.DomainsConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Binds the domains to a domain list.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.alpha.DomainsConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53resolver.alpha.DomainsConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
