package software.amazon.awscdk.services.route53resolver.alpha;

/**
 * (experimental) Options for a Firewall Rule Group Association.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.alpha.*;
 * import software.amazon.awscdk.services.ec2.*;
 * Vpc vpc;
 * FirewallRuleGroupAssociationOptions firewallRuleGroupAssociationOptions = FirewallRuleGroupAssociationOptions.builder()
 *         .priority(123)
 *         .vpc(vpc)
 *         // the properties below are optional
 *         .mutationProtection(false)
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:24:45.574Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53resolver.alpha.$Module.class, fqn = "@aws-cdk/aws-route53resolver-alpha.FirewallRuleGroupAssociationOptions")
@software.amazon.jsii.Jsii.Proxy(FirewallRuleGroupAssociationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FirewallRuleGroupAssociationOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMutationProtection() {
        return null;
    }

    /**
     * (experimental) The name of the association.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * (experimental) The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC.
     * <p>
     * DNS Firewall filters VPC
     * traffic starting from rule group with the lowest numeric priority setting.
     * <p>
     * This value must be greater than 100 and less than 9,000
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * (experimental) The VPC that to associate with the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * @return a {@link Builder} of {@link FirewallRuleGroupAssociationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirewallRuleGroupAssociationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FirewallRuleGroupAssociationOptions> {
        java.lang.Boolean mutationProtection;
        java.lang.String name;
        java.lang.Number priority;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link FirewallRuleGroupAssociationOptions#getMutationProtection}
         * @param mutationProtection If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mutationProtection(java.lang.Boolean mutationProtection) {
            this.mutationProtection = mutationProtection;
            return this;
        }

        /**
         * Sets the value of {@link FirewallRuleGroupAssociationOptions#getName}
         * @param name The name of the association.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link FirewallRuleGroupAssociationOptions#getPriority}
         * @param priority The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. This parameter is required.
         *                 DNS Firewall filters VPC
         *                 traffic starting from rule group with the lowest numeric priority setting.
         *                 <p>
         *                 This value must be greater than 100 and less than 9,000
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link FirewallRuleGroupAssociationOptions#getVpc}
         * @param vpc The VPC that to associate with the rule group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirewallRuleGroupAssociationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FirewallRuleGroupAssociationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FirewallRuleGroupAssociationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirewallRuleGroupAssociationOptions {
        private final java.lang.Boolean mutationProtection;
        private final java.lang.String name;
        private final java.lang.Number priority;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mutationProtection = software.amazon.jsii.Kernel.get(this, "mutationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mutationProtection = builder.mutationProtection;
            this.name = builder.name;
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
        }

        @Override
        public final java.lang.Boolean getMutationProtection() {
            return this.mutationProtection;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMutationProtection() != null) {
                data.set("mutationProtection", om.valueToTree(this.getMutationProtection()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            data.set("priority", om.valueToTree(this.getPriority()));
            data.set("vpc", om.valueToTree(this.getVpc()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53resolver-alpha.FirewallRuleGroupAssociationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirewallRuleGroupAssociationOptions.Jsii$Proxy that = (FirewallRuleGroupAssociationOptions.Jsii$Proxy) o;

            if (this.mutationProtection != null ? !this.mutationProtection.equals(that.mutationProtection) : that.mutationProtection != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (!priority.equals(that.priority)) return false;
            return this.vpc.equals(that.vpc);
        }

        @Override
        public final int hashCode() {
            int result = this.mutationProtection != null ? this.mutationProtection.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.priority.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            return result;
        }
    }
}
