package software.amazon.awscdk.services.route53resolver.alpha;

/**
 * (experimental) Properties for a Firewall Domain List.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FirewallDomainList blockList = FirewallDomainList.Builder.create(this, "BlockList")
 *         .domains(FirewallDomains.fromList(List.of("bad-domain.com", "bot-domain.net")))
 *         .build();
 * FirewallDomainList s3List = FirewallDomainList.Builder.create(this, "S3List")
 *         .domains(FirewallDomains.fromS3Url("s3://bucket/prefix/object"))
 *         .build();
 * FirewallDomainList assetList = FirewallDomainList.Builder.create(this, "AssetList")
 *         .domains(FirewallDomains.fromAsset("/path/to/domains.txt"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-01T02:31:50.673Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53resolver.alpha.$Module.class, fqn = "@aws-cdk/aws-route53resolver-alpha.FirewallDomainListProps")
@software.amazon.jsii.Jsii.Proxy(FirewallDomainListProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FirewallDomainListProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A list of domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains getDomains();

    /**
     * (experimental) A name for the domain list.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FirewallDomainListProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirewallDomainListProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FirewallDomainListProps> {
        software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains domains;
        java.lang.String name;

        /**
         * Sets the value of {@link FirewallDomainListProps#getDomains}
         * @param domains A list of domains. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domains(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains domains) {
            this.domains = domains;
            return this;
        }

        /**
         * Sets the value of {@link FirewallDomainListProps#getName}
         * @param name A name for the domain list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirewallDomainListProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FirewallDomainListProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FirewallDomainListProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirewallDomainListProps {
        private final software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains domains;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domains = software.amazon.jsii.Kernel.get(this, "domains", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domains = java.util.Objects.requireNonNull(builder.domains, "domains is required");
            this.name = builder.name;
        }

        @Override
        public final software.amazon.awscdk.services.route53resolver.alpha.FirewallDomains getDomains() {
            return this.domains;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domains", om.valueToTree(this.getDomains()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53resolver-alpha.FirewallDomainListProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirewallDomainListProps.Jsii$Proxy that = (FirewallDomainListProps.Jsii$Proxy) o;

            if (!domains.equals(that.domains)) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domains.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
