/**
 * <h2>Amazon Route53 Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * To add a public hosted zone:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.route53.*;
 * 
 * new PublicHostedZone(this, "HostedZone", new PublicHostedZoneProps()
 *         .zoneName("fully.qualified.domain.com"));
 * </pre></blockquote>
 * <p>
 * To add a private hosted zone, use <code>PrivateHostedZone</code>. Note that
 * <code>enableDnsHostnames</code> and <code>enableDnsSupport</code> must have been enabled for the
 * VPC you're configuring for private hosted zones.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.route53.*;
 * 
 * Vpc vpc = new Vpc(this, "VPC");
 * 
 * PrivateHostedZone zone = new PrivateHostedZone(this, "HostedZone", new PrivateHostedZoneProps()
 *         .zoneName("fully.qualified.domain.com")
 *         .vpc(vpc));
 * </pre></blockquote>
 * <p>
 * Additional VPCs can be added with <code>zone.addVpc()</code>.
 * <p>
 * <h3>Adding Records</h3>
 * <p>
 * To add a TXT record to your zone:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.route53.*;
 * 
 * new TxtRecord(this, "TXTRecord", new TxtRecordProps()
 *         .zone(myZone)
 *         .recordName("_foo")// If the name ends with a ".", it will be used as-is;
 *         // if it ends with a "." followed by the zone name, a trailing "." will be added automatically;
 *         // otherwise, a ".", the zone name, and a trailing "." will be added automatically.
 *         // Defaults to zone root if not specified.
 *         .values(asList("Bar!", "Baz?"))
 *         .ttl(Duration.minutes(90)));
 * </pre></blockquote>
 * <p>
 * To add a A record to your zone:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.route53.*;
 * 
 * new ARecord(this, "ARecord", new ARecordProps()
 *         .zone(myZone)
 *         .target(route53.RecordTarget.fromIpAddresses("1.2.3.4", "5.6.7.8")));
 * </pre></blockquote>
 * <p>
 * To add a AAAA record pointing to a CloudFront distribution:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.route53.*;
 * import software.amazon.awscdk.services.route53.targets.*;
 * 
 * new AaaaRecord(this, "Alias", new AaaaRecordProps()
 *         .zone(myZone)
 *         .target(route53.RecordTarget.fromAlias(new CloudFrontTarget(distribution))));
 * </pre></blockquote>
 * <p>
 * Constructs are available for A, AAAA, CAA, CNAME, MX, NS, SRV and TXT records.
 * <p>
 * Use the <code>CaaAmazonRecord</code> construct to easily restrict certificate authorities
 * allowed to issue certificates for a domain to Amazon only.
 * <p>
 * <h3>Imports</h3>
 * <p>
 * If you don't know the ID of the Hosted Zone to import, you can use the
 * <code>HostedZone.fromLookup</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * HostedZone.fromLookup(this, "MyZone", Map.of(
 *         "domainName", "example.com"));
 * </pre></blockquote>
 * <p>
 * <code>HostedZone.fromLookup</code> requires an environment to be configured. Check
 * out the <a href="https://docs.aws.amazon.com/cdk/latest/guide/environments.html">documentation</a> for more documentation and examples. CDK
 * automatically looks into your <code>~/.aws/config</code> file for the <code>[default]</code> profile.
 * If you want to specify a different account run <code>cdk deploy --profile [profile]</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * MyDevStack.Builder.create(app, "dev")
 *         .env(Map.of(
 *                 "account", process.env.getCDK_DEFAULT_ACCOUNT(),
 *                 "region", process.env.getCDK_DEFAULT_REGION()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * If you know the ID and Name of a Hosted Zone, you can import it directly:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var zone = HostedZone.fromHostedZoneAttributes(this, "MyZone", Map.of(
 *         "zoneName", "example.com",
 *         "hostedZoneId", "ZOJJZC49E0EPZ"));
 * </pre></blockquote>
 * <p>
 * Alternatively, use the <code>HostedZone.fromHostedZoneId</code> to import hosted zones if
 * you know the ID and the retrieval for the <code>zoneName</code> is undesirable.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var zone = HostedZone.fromHostedZoneId(this, "MyZone", Map.of(
 *         "hostedZoneId", "ZOJJZC49E0EPZ"));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.route53;
