package software.amazon.awscdk.services.route53;

/**
 * The record type.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.272Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.RecordType")
public enum RecordType {
    /**
     * route traffic to a resource, such as a web server, using an IPv4 address in dotted decimal notation.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#AFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    A,
    /**
     * route traffic to a resource, such as a web server, using an IPv6 address in colon-separated hexadecimal format.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#AAAAFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AAAA,
    /**
     * A CAA record specifies which certificate authorities (CAs) are allowed to issue certificates for a domain or subdomain.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#CAAFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CAA,
    /**
     * A CNAME record maps DNS queries for the name of the current record, such as acme.example.com, to another domain (example.com or example.net) or subdomain (acme.example.com or zenith.example.org).
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#CNAMEFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CNAME,
    /**
     * An MX record specifies the names of your mail servers and, if you have two or more mail servers, the priority order.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#MXFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MX,
    /**
     * A Name Authority Pointer (NAPTR) is a type of record that is used by Dynamic Delegation Discovery System (DDDS) applications to convert one value to another or to replace one value with another.
     * <p>
     * For example, one common use is to convert phone numbers into SIP URIs.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#NAPTRFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NAPTR,
    /**
     * An NS record identifies the name servers for the hosted zone.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#NSFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NS,
    /**
     * A PTR record maps an IP address to the corresponding domain name.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#PTRFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PTR,
    /**
     * A start of authority (SOA) record provides information about a domain and the corresponding Amazon Route 53 hosted zone.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SOAFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SOA,
    /**
     * SPF records were formerly used to verify the identity of the sender of email messages.
     * <p>
     * Instead of an SPF record, we recommend that you create a TXT record that contains the applicable value.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SPFFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SPF,
    /**
     * An SRV record Value element consists of four space-separated values.
     * <p>
     * The first three values are
     * decimal numbers representing priority, weight, and port. The fourth value is a domain name.
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SRVFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SRV,
    /**
     * A TXT record contains one or more strings that are enclosed in double quotation marks (").
     * <p>
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#TXTFormat
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TXT,
}
