package software.amazon.awscdk.services.route53;

/**
 * Reference to a hosted zone.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.268Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.HostedZoneAttributes")
@software.amazon.jsii.Jsii.Proxy(HostedZoneAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HostedZoneAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifier of the hosted zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneId();

    /**
     * Name of the hosted zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getZoneName();

    /**
     * @return a {@link Builder} of {@link HostedZoneAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HostedZoneAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HostedZoneAttributes> {
        private java.lang.String hostedZoneId;
        private java.lang.String zoneName;

        /**
         * Sets the value of {@link HostedZoneAttributes#getHostedZoneId}
         * @param hostedZoneId Identifier of the hosted zone. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(java.lang.String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link HostedZoneAttributes#getZoneName}
         * @param zoneName Name of the hosted zone. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneName(java.lang.String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HostedZoneAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HostedZoneAttributes build() {
            return new Jsii$Proxy(hostedZoneId, zoneName);
        }
    }

    /**
     * An implementation for {@link HostedZoneAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostedZoneAttributes {
        private final java.lang.String hostedZoneId;
        private final java.lang.String zoneName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZoneId = this.jsiiGet("hostedZoneId", java.lang.String.class);
            this.zoneName = this.jsiiGet("zoneName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String hostedZoneId, final java.lang.String zoneName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZoneId = java.util.Objects.requireNonNull(hostedZoneId, "hostedZoneId is required");
            this.zoneName = java.util.Objects.requireNonNull(zoneName, "zoneName is required");
        }

        @Override
        public java.lang.String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public java.lang.String getZoneName() {
            return this.zoneName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
            data.set("zoneName", om.valueToTree(this.getZoneName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.HostedZoneAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HostedZoneAttributes.Jsii$Proxy that = (HostedZoneAttributes.Jsii$Proxy) o;

            if (!hostedZoneId.equals(that.hostedZoneId)) return false;
            return this.zoneName.equals(that.zoneName);
        }

        @Override
        public int hashCode() {
            int result = this.hostedZoneId.hashCode();
            result = 31 * result + (this.zoneName.hashCode());
            return result;
        }
    }
}
