package software.amazon.awscdk.services.route53;

/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.265Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CfnRecordSetGroup")
public class CfnRecordSetGroup extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnRecordSetGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRecordSetGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53.CfnRecordSetGroup.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Route53::RecordSetGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRecordSetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.CfnRecordSetGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Route53::RecordSetGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRecordSetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Route53::RecordSetGroup.Comment`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return this.jsiiGet("comment", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSetGroup.Comment`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComment(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("comment", value);
    }

    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzoneid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
        return this.jsiiGet("hostedZoneId", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzoneid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedZoneId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("hostedZoneId", value);
    }

    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzonename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneName() {
        return this.jsiiGet("hostedZoneName", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzonename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedZoneName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("hostedZoneName", value);
    }

    /**
     * `AWS::Route53::RecordSetGroup.RecordSets`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecordSets() {
        return this.jsiiGet("recordSets", java.lang.Object.class);
    }

    /**
     * `AWS::Route53::RecordSetGroup.RecordSets`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordSets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("recordSets", value);
    }

    /**
     * `AWS::Route53::RecordSetGroup.RecordSets`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordSets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("recordSets", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CfnRecordSetGroup.AliasTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(AliasTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AliasTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRecordSetGroup.AliasTargetProperty.DNSName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-dnshostname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

        /**
         * `CfnRecordSetGroup.AliasTargetProperty.HostedZoneId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-hostedzoneid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneId();

        /**
         * `CfnRecordSetGroup.AliasTargetProperty.EvaluateTargetHealth`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-evaluatetargethealth
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvaluateTargetHealth() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AliasTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AliasTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AliasTargetProperty> {
            private java.lang.String dnsName;
            private java.lang.String hostedZoneId;
            private java.lang.Object evaluateTargetHealth;

            /**
             * Sets the value of {@link AliasTargetProperty#getDnsName}
             * @param dnsName `CfnRecordSetGroup.AliasTargetProperty.DNSName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Sets the value of {@link AliasTargetProperty#getHostedZoneId}
             * @param hostedZoneId `CfnRecordSetGroup.AliasTargetProperty.HostedZoneId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneId(java.lang.String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            /**
             * Sets the value of {@link AliasTargetProperty#getEvaluateTargetHealth}
             * @param evaluateTargetHealth `CfnRecordSetGroup.AliasTargetProperty.EvaluateTargetHealth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateTargetHealth(java.lang.Boolean evaluateTargetHealth) {
                this.evaluateTargetHealth = evaluateTargetHealth;
                return this;
            }

            /**
             * Sets the value of {@link AliasTargetProperty#getEvaluateTargetHealth}
             * @param evaluateTargetHealth `CfnRecordSetGroup.AliasTargetProperty.EvaluateTargetHealth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateTargetHealth(software.amazon.awscdk.core.IResolvable evaluateTargetHealth) {
                this.evaluateTargetHealth = evaluateTargetHealth;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AliasTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AliasTargetProperty build() {
                return new Jsii$Proxy(dnsName, hostedZoneId, evaluateTargetHealth);
            }
        }

        /**
         * An implementation for {@link AliasTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasTargetProperty {
            private final java.lang.String dnsName;
            private final java.lang.String hostedZoneId;
            private final java.lang.Object evaluateTargetHealth;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsName = this.jsiiGet("dnsName", java.lang.String.class);
                this.hostedZoneId = this.jsiiGet("hostedZoneId", java.lang.String.class);
                this.evaluateTargetHealth = this.jsiiGet("evaluateTargetHealth", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String dnsName, final java.lang.String hostedZoneId, final java.lang.Object evaluateTargetHealth) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsName = java.util.Objects.requireNonNull(dnsName, "dnsName is required");
                this.hostedZoneId = java.util.Objects.requireNonNull(hostedZoneId, "hostedZoneId is required");
                this.evaluateTargetHealth = evaluateTargetHealth;
            }

            @Override
            public java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            public java.lang.String getHostedZoneId() {
                return this.hostedZoneId;
            }

            @Override
            public java.lang.Object getEvaluateTargetHealth() {
                return this.evaluateTargetHealth;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dnsName", om.valueToTree(this.getDnsName()));
                data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
                if (this.getEvaluateTargetHealth() != null) {
                    data.set("evaluateTargetHealth", om.valueToTree(this.getEvaluateTargetHealth()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.CfnRecordSetGroup.AliasTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AliasTargetProperty.Jsii$Proxy that = (AliasTargetProperty.Jsii$Proxy) o;

                if (!dnsName.equals(that.dnsName)) return false;
                if (!hostedZoneId.equals(that.hostedZoneId)) return false;
                return this.evaluateTargetHealth != null ? this.evaluateTargetHealth.equals(that.evaluateTargetHealth) : that.evaluateTargetHealth == null;
            }

            @Override
            public int hashCode() {
                int result = this.dnsName.hashCode();
                result = 31 * result + (this.hostedZoneId.hashCode());
                result = 31 * result + (this.evaluateTargetHealth != null ? this.evaluateTargetHealth.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CfnRecordSetGroup.GeoLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRecordSetGroup.GeoLocationProperty.ContinentCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordsetgroup-geolocation-continentcode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContinentCode() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.GeoLocationProperty.CountryCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-countrycode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCountryCode() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.GeoLocationProperty.SubdivisionCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-subdivisioncode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubdivisionCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoLocationProperty> {
            private java.lang.String continentCode;
            private java.lang.String countryCode;
            private java.lang.String subdivisionCode;

            /**
             * Sets the value of {@link GeoLocationProperty#getContinentCode}
             * @param continentCode `CfnRecordSetGroup.GeoLocationProperty.ContinentCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continentCode(java.lang.String continentCode) {
                this.continentCode = continentCode;
                return this;
            }

            /**
             * Sets the value of {@link GeoLocationProperty#getCountryCode}
             * @param countryCode `CfnRecordSetGroup.GeoLocationProperty.CountryCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder countryCode(java.lang.String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            /**
             * Sets the value of {@link GeoLocationProperty#getSubdivisionCode}
             * @param subdivisionCode `CfnRecordSetGroup.GeoLocationProperty.SubdivisionCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subdivisionCode(java.lang.String subdivisionCode) {
                this.subdivisionCode = subdivisionCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoLocationProperty build() {
                return new Jsii$Proxy(continentCode, countryCode, subdivisionCode);
            }
        }

        /**
         * An implementation for {@link GeoLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoLocationProperty {
            private final java.lang.String continentCode;
            private final java.lang.String countryCode;
            private final java.lang.String subdivisionCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.continentCode = this.jsiiGet("continentCode", java.lang.String.class);
                this.countryCode = this.jsiiGet("countryCode", java.lang.String.class);
                this.subdivisionCode = this.jsiiGet("subdivisionCode", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String continentCode, final java.lang.String countryCode, final java.lang.String subdivisionCode) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.continentCode = continentCode;
                this.countryCode = countryCode;
                this.subdivisionCode = subdivisionCode;
            }

            @Override
            public java.lang.String getContinentCode() {
                return this.continentCode;
            }

            @Override
            public java.lang.String getCountryCode() {
                return this.countryCode;
            }

            @Override
            public java.lang.String getSubdivisionCode() {
                return this.subdivisionCode;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContinentCode() != null) {
                    data.set("continentCode", om.valueToTree(this.getContinentCode()));
                }
                if (this.getCountryCode() != null) {
                    data.set("countryCode", om.valueToTree(this.getCountryCode()));
                }
                if (this.getSubdivisionCode() != null) {
                    data.set("subdivisionCode", om.valueToTree(this.getSubdivisionCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.CfnRecordSetGroup.GeoLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoLocationProperty.Jsii$Proxy that = (GeoLocationProperty.Jsii$Proxy) o;

                if (this.continentCode != null ? !this.continentCode.equals(that.continentCode) : that.continentCode != null) return false;
                if (this.countryCode != null ? !this.countryCode.equals(that.countryCode) : that.countryCode != null) return false;
                return this.subdivisionCode != null ? this.subdivisionCode.equals(that.subdivisionCode) : that.subdivisionCode == null;
            }

            @Override
            public int hashCode() {
                int result = this.continentCode != null ? this.continentCode.hashCode() : 0;
                result = 31 * result + (this.countryCode != null ? this.countryCode.hashCode() : 0);
                result = 31 * result + (this.subdivisionCode != null ? this.subdivisionCode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CfnRecordSetGroup.RecordSetProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRecordSetGroup.RecordSetProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnRecordSetGroup.RecordSetProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnRecordSetGroup.RecordSetProperty.AliasTarget`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAliasTarget() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.Comment`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.Failover`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFailover() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.GeoLocation`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGeoLocation() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.HealthCheckId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckId() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.HostedZoneId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.HostedZoneName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneName() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.MultiValueAnswer`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultiValueAnswer() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.Region`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.ResourceRecords`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceRecords() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.SetIdentifier`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSetIdentifier() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.TTL`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTtl() {
            return null;
        }

        /**
         * `CfnRecordSetGroup.RecordSetProperty.Weight`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordSetProperty> {
            private java.lang.String name;
            private java.lang.String type;
            private java.lang.Object aliasTarget;
            private java.lang.String comment;
            private java.lang.String failover;
            private java.lang.Object geoLocation;
            private java.lang.String healthCheckId;
            private java.lang.String hostedZoneId;
            private java.lang.String hostedZoneName;
            private java.lang.Object multiValueAnswer;
            private java.lang.String region;
            private java.util.List<java.lang.String> resourceRecords;
            private java.lang.String setIdentifier;
            private java.lang.String ttl;
            private java.lang.Number weight;

            /**
             * Sets the value of {@link RecordSetProperty#getName}
             * @param name `CfnRecordSetGroup.RecordSetProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getType}
             * @param type `CfnRecordSetGroup.RecordSetProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getAliasTarget}
             * @param aliasTarget `CfnRecordSetGroup.RecordSetProperty.AliasTarget`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aliasTarget(software.amazon.awscdk.core.IResolvable aliasTarget) {
                this.aliasTarget = aliasTarget;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getAliasTarget}
             * @param aliasTarget `CfnRecordSetGroup.RecordSetProperty.AliasTarget`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aliasTarget(software.amazon.awscdk.services.route53.CfnRecordSetGroup.AliasTargetProperty aliasTarget) {
                this.aliasTarget = aliasTarget;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getComment}
             * @param comment `CfnRecordSetGroup.RecordSetProperty.Comment`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getFailover}
             * @param failover `CfnRecordSetGroup.RecordSetProperty.Failover`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failover(java.lang.String failover) {
                this.failover = failover;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getGeoLocation}
             * @param geoLocation `CfnRecordSetGroup.RecordSetProperty.GeoLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoLocation(software.amazon.awscdk.core.IResolvable geoLocation) {
                this.geoLocation = geoLocation;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getGeoLocation}
             * @param geoLocation `CfnRecordSetGroup.RecordSetProperty.GeoLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoLocation(software.amazon.awscdk.services.route53.CfnRecordSetGroup.GeoLocationProperty geoLocation) {
                this.geoLocation = geoLocation;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getHealthCheckId}
             * @param healthCheckId `CfnRecordSetGroup.RecordSetProperty.HealthCheckId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheckId(java.lang.String healthCheckId) {
                this.healthCheckId = healthCheckId;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getHostedZoneId}
             * @param hostedZoneId `CfnRecordSetGroup.RecordSetProperty.HostedZoneId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneId(java.lang.String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getHostedZoneName}
             * @param hostedZoneName `CfnRecordSetGroup.RecordSetProperty.HostedZoneName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneName(java.lang.String hostedZoneName) {
                this.hostedZoneName = hostedZoneName;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getMultiValueAnswer}
             * @param multiValueAnswer `CfnRecordSetGroup.RecordSetProperty.MultiValueAnswer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiValueAnswer(java.lang.Boolean multiValueAnswer) {
                this.multiValueAnswer = multiValueAnswer;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getMultiValueAnswer}
             * @param multiValueAnswer `CfnRecordSetGroup.RecordSetProperty.MultiValueAnswer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiValueAnswer(software.amazon.awscdk.core.IResolvable multiValueAnswer) {
                this.multiValueAnswer = multiValueAnswer;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getRegion}
             * @param region `CfnRecordSetGroup.RecordSetProperty.Region`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getResourceRecords}
             * @param resourceRecords `CfnRecordSetGroup.RecordSetProperty.ResourceRecords`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRecords(java.util.List<java.lang.String> resourceRecords) {
                this.resourceRecords = resourceRecords;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getSetIdentifier}
             * @param setIdentifier `CfnRecordSetGroup.RecordSetProperty.SetIdentifier`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setIdentifier(java.lang.String setIdentifier) {
                this.setIdentifier = setIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getTtl}
             * @param ttl `CfnRecordSetGroup.RecordSetProperty.TTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttl(java.lang.String ttl) {
                this.ttl = ttl;
                return this;
            }

            /**
             * Sets the value of {@link RecordSetProperty#getWeight}
             * @param weight `CfnRecordSetGroup.RecordSetProperty.Weight`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordSetProperty build() {
                return new Jsii$Proxy(name, type, aliasTarget, comment, failover, geoLocation, healthCheckId, hostedZoneId, hostedZoneName, multiValueAnswer, region, resourceRecords, setIdentifier, ttl, weight);
            }
        }

        /**
         * An implementation for {@link RecordSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordSetProperty {
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.lang.Object aliasTarget;
            private final java.lang.String comment;
            private final java.lang.String failover;
            private final java.lang.Object geoLocation;
            private final java.lang.String healthCheckId;
            private final java.lang.String hostedZoneId;
            private final java.lang.String hostedZoneName;
            private final java.lang.Object multiValueAnswer;
            private final java.lang.String region;
            private final java.util.List<java.lang.String> resourceRecords;
            private final java.lang.String setIdentifier;
            private final java.lang.String ttl;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.aliasTarget = this.jsiiGet("aliasTarget", java.lang.Object.class);
                this.comment = this.jsiiGet("comment", java.lang.String.class);
                this.failover = this.jsiiGet("failover", java.lang.String.class);
                this.geoLocation = this.jsiiGet("geoLocation", java.lang.Object.class);
                this.healthCheckId = this.jsiiGet("healthCheckId", java.lang.String.class);
                this.hostedZoneId = this.jsiiGet("hostedZoneId", java.lang.String.class);
                this.hostedZoneName = this.jsiiGet("hostedZoneName", java.lang.String.class);
                this.multiValueAnswer = this.jsiiGet("multiValueAnswer", java.lang.Object.class);
                this.region = this.jsiiGet("region", java.lang.String.class);
                this.resourceRecords = this.jsiiGet("resourceRecords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.setIdentifier = this.jsiiGet("setIdentifier", java.lang.String.class);
                this.ttl = this.jsiiGet("ttl", java.lang.String.class);
                this.weight = this.jsiiGet("weight", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.lang.String type, final java.lang.Object aliasTarget, final java.lang.String comment, final java.lang.String failover, final java.lang.Object geoLocation, final java.lang.String healthCheckId, final java.lang.String hostedZoneId, final java.lang.String hostedZoneName, final java.lang.Object multiValueAnswer, final java.lang.String region, final java.util.List<java.lang.String> resourceRecords, final java.lang.String setIdentifier, final java.lang.String ttl, final java.lang.Number weight) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.aliasTarget = aliasTarget;
                this.comment = comment;
                this.failover = failover;
                this.geoLocation = geoLocation;
                this.healthCheckId = healthCheckId;
                this.hostedZoneId = hostedZoneId;
                this.hostedZoneName = hostedZoneName;
                this.multiValueAnswer = multiValueAnswer;
                this.region = region;
                this.resourceRecords = resourceRecords;
                this.setIdentifier = setIdentifier;
                this.ttl = ttl;
                this.weight = weight;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.Object getAliasTarget() {
                return this.aliasTarget;
            }

            @Override
            public java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public java.lang.String getFailover() {
                return this.failover;
            }

            @Override
            public java.lang.Object getGeoLocation() {
                return this.geoLocation;
            }

            @Override
            public java.lang.String getHealthCheckId() {
                return this.healthCheckId;
            }

            @Override
            public java.lang.String getHostedZoneId() {
                return this.hostedZoneId;
            }

            @Override
            public java.lang.String getHostedZoneName() {
                return this.hostedZoneName;
            }

            @Override
            public java.lang.Object getMultiValueAnswer() {
                return this.multiValueAnswer;
            }

            @Override
            public java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public java.util.List<java.lang.String> getResourceRecords() {
                return this.resourceRecords;
            }

            @Override
            public java.lang.String getSetIdentifier() {
                return this.setIdentifier;
            }

            @Override
            public java.lang.String getTtl() {
                return this.ttl;
            }

            @Override
            public java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getAliasTarget() != null) {
                    data.set("aliasTarget", om.valueToTree(this.getAliasTarget()));
                }
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }
                if (this.getFailover() != null) {
                    data.set("failover", om.valueToTree(this.getFailover()));
                }
                if (this.getGeoLocation() != null) {
                    data.set("geoLocation", om.valueToTree(this.getGeoLocation()));
                }
                if (this.getHealthCheckId() != null) {
                    data.set("healthCheckId", om.valueToTree(this.getHealthCheckId()));
                }
                if (this.getHostedZoneId() != null) {
                    data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
                }
                if (this.getHostedZoneName() != null) {
                    data.set("hostedZoneName", om.valueToTree(this.getHostedZoneName()));
                }
                if (this.getMultiValueAnswer() != null) {
                    data.set("multiValueAnswer", om.valueToTree(this.getMultiValueAnswer()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getResourceRecords() != null) {
                    data.set("resourceRecords", om.valueToTree(this.getResourceRecords()));
                }
                if (this.getSetIdentifier() != null) {
                    data.set("setIdentifier", om.valueToTree(this.getSetIdentifier()));
                }
                if (this.getTtl() != null) {
                    data.set("ttl", om.valueToTree(this.getTtl()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.CfnRecordSetGroup.RecordSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordSetProperty.Jsii$Proxy that = (RecordSetProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                if (this.aliasTarget != null ? !this.aliasTarget.equals(that.aliasTarget) : that.aliasTarget != null) return false;
                if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
                if (this.failover != null ? !this.failover.equals(that.failover) : that.failover != null) return false;
                if (this.geoLocation != null ? !this.geoLocation.equals(that.geoLocation) : that.geoLocation != null) return false;
                if (this.healthCheckId != null ? !this.healthCheckId.equals(that.healthCheckId) : that.healthCheckId != null) return false;
                if (this.hostedZoneId != null ? !this.hostedZoneId.equals(that.hostedZoneId) : that.hostedZoneId != null) return false;
                if (this.hostedZoneName != null ? !this.hostedZoneName.equals(that.hostedZoneName) : that.hostedZoneName != null) return false;
                if (this.multiValueAnswer != null ? !this.multiValueAnswer.equals(that.multiValueAnswer) : that.multiValueAnswer != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.resourceRecords != null ? !this.resourceRecords.equals(that.resourceRecords) : that.resourceRecords != null) return false;
                if (this.setIdentifier != null ? !this.setIdentifier.equals(that.setIdentifier) : that.setIdentifier != null) return false;
                if (this.ttl != null ? !this.ttl.equals(that.ttl) : that.ttl != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.aliasTarget != null ? this.aliasTarget.hashCode() : 0);
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                result = 31 * result + (this.failover != null ? this.failover.hashCode() : 0);
                result = 31 * result + (this.geoLocation != null ? this.geoLocation.hashCode() : 0);
                result = 31 * result + (this.healthCheckId != null ? this.healthCheckId.hashCode() : 0);
                result = 31 * result + (this.hostedZoneId != null ? this.hostedZoneId.hashCode() : 0);
                result = 31 * result + (this.hostedZoneName != null ? this.hostedZoneName.hashCode() : 0);
                result = 31 * result + (this.multiValueAnswer != null ? this.multiValueAnswer.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.resourceRecords != null ? this.resourceRecords.hashCode() : 0);
                result = 31 * result + (this.setIdentifier != null ? this.setIdentifier.hashCode() : 0);
                result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.CfnRecordSetGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.CfnRecordSetGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.route53.CfnRecordSetGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::Route53::RecordSetGroup.Comment`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-comment
         * @param comment `AWS::Route53::RecordSetGroup.Comment`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * `AWS::Route53::RecordSetGroup.HostedZoneId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzoneid
         * @param hostedZoneId `AWS::Route53::RecordSetGroup.HostedZoneId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(final java.lang.String hostedZoneId) {
            this.props().hostedZoneId(hostedZoneId);
            return this;
        }

        /**
         * `AWS::Route53::RecordSetGroup.HostedZoneName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzonename
         * @param hostedZoneName `AWS::Route53::RecordSetGroup.HostedZoneName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneName(final java.lang.String hostedZoneName) {
            this.props().hostedZoneName(hostedZoneName);
            return this;
        }

        /**
         * `AWS::Route53::RecordSetGroup.RecordSets`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
         * @param recordSets `AWS::Route53::RecordSetGroup.RecordSets`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordSets(final software.amazon.awscdk.core.IResolvable recordSets) {
            this.props().recordSets(recordSets);
            return this;
        }
        /**
         * `AWS::Route53::RecordSetGroup.RecordSets`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
         * @param recordSets `AWS::Route53::RecordSetGroup.RecordSets`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordSets(final java.util.List<java.lang.Object> recordSets) {
            this.props().recordSets(recordSets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.CfnRecordSetGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.CfnRecordSetGroup build() {
            return new software.amazon.awscdk.services.route53.CfnRecordSetGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.route53.CfnRecordSetGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.route53.CfnRecordSetGroupProps.Builder();
            }
            return this.props;
        }
    }
}
