package software.amazon.awscdk.services.route53;

/**
 * A CloudFormation `AWS::Route53::RecordSet`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.264Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CfnRecordSet")
public class CfnRecordSet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnRecordSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRecordSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53.CfnRecordSet.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Route53::RecordSet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRecordSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CfnRecordSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Route53::RecordSet.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::Route53::RecordSet.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * `AWS::Route53::RecordSet.AliasTarget`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAliasTarget() {
        return this.jsiiGet("aliasTarget", java.lang.Object.class);
    }

    /**
     * `AWS::Route53::RecordSet.AliasTarget`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAliasTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("aliasTarget", value);
    }

    /**
     * `AWS::Route53::RecordSet.AliasTarget`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAliasTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.CfnRecordSet.AliasTargetProperty value) {
        this.jsiiSet("aliasTarget", value);
    }

    /**
     * `AWS::Route53::RecordSet.Comment`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return this.jsiiGet("comment", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.Comment`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComment(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("comment", value);
    }

    /**
     * `AWS::Route53::RecordSet.Failover`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFailover() {
        return this.jsiiGet("failover", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.Failover`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailover(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("failover", value);
    }

    /**
     * `AWS::Route53::RecordSet.GeoLocation`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGeoLocation() {
        return this.jsiiGet("geoLocation", java.lang.Object.class);
    }

    /**
     * `AWS::Route53::RecordSet.GeoLocation`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGeoLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("geoLocation", value);
    }

    /**
     * `AWS::Route53::RecordSet.GeoLocation`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGeoLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.CfnRecordSet.GeoLocationProperty value) {
        this.jsiiSet("geoLocation", value);
    }

    /**
     * `AWS::Route53::RecordSet.HealthCheckId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckId() {
        return this.jsiiGet("healthCheckId", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.HealthCheckId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("healthCheckId", value);
    }

    /**
     * `AWS::Route53::RecordSet.HostedZoneId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
        return this.jsiiGet("hostedZoneId", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.HostedZoneId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedZoneId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("hostedZoneId", value);
    }

    /**
     * `AWS::Route53::RecordSet.HostedZoneName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneName() {
        return this.jsiiGet("hostedZoneName", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.HostedZoneName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedZoneName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("hostedZoneName", value);
    }

    /**
     * `AWS::Route53::RecordSet.MultiValueAnswer`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiValueAnswer() {
        return this.jsiiGet("multiValueAnswer", java.lang.Object.class);
    }

    /**
     * `AWS::Route53::RecordSet.MultiValueAnswer`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiValueAnswer(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("multiValueAnswer", value);
    }

    /**
     * `AWS::Route53::RecordSet.MultiValueAnswer`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiValueAnswer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("multiValueAnswer", value);
    }

    /**
     * `AWS::Route53::RecordSet.Region`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return this.jsiiGet("region", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.Region`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("region", value);
    }

    /**
     * `AWS::Route53::RecordSet.ResourceRecords`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceRecords() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("resourceRecords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Route53::RecordSet.ResourceRecords`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceRecords(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("resourceRecords", value);
    }

    /**
     * `AWS::Route53::RecordSet.SetIdentifier`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSetIdentifier() {
        return this.jsiiGet("setIdentifier", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.SetIdentifier`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSetIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("setIdentifier", value);
    }

    /**
     * `AWS::Route53::RecordSet.TTL`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTtl() {
        return this.jsiiGet("ttl", java.lang.String.class);
    }

    /**
     * `AWS::Route53::RecordSet.TTL`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTtl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("ttl", value);
    }

    /**
     * `AWS::Route53::RecordSet.Weight`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
        return this.jsiiGet("weight", java.lang.Number.class);
    }

    /**
     * `AWS::Route53::RecordSet.Weight`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWeight(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("weight", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CfnRecordSet.AliasTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(AliasTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AliasTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRecordSet.AliasTargetProperty.DNSName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-dnshostname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

        /**
         * `CfnRecordSet.AliasTargetProperty.HostedZoneId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-hostedzoneid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneId();

        /**
         * `CfnRecordSet.AliasTargetProperty.EvaluateTargetHealth`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-evaluatetargethealth
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvaluateTargetHealth() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AliasTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AliasTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AliasTargetProperty> {
            private java.lang.String dnsName;
            private java.lang.String hostedZoneId;
            private java.lang.Object evaluateTargetHealth;

            /**
             * Sets the value of {@link AliasTargetProperty#getDnsName}
             * @param dnsName `CfnRecordSet.AliasTargetProperty.DNSName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Sets the value of {@link AliasTargetProperty#getHostedZoneId}
             * @param hostedZoneId `CfnRecordSet.AliasTargetProperty.HostedZoneId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneId(java.lang.String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            /**
             * Sets the value of {@link AliasTargetProperty#getEvaluateTargetHealth}
             * @param evaluateTargetHealth `CfnRecordSet.AliasTargetProperty.EvaluateTargetHealth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateTargetHealth(java.lang.Boolean evaluateTargetHealth) {
                this.evaluateTargetHealth = evaluateTargetHealth;
                return this;
            }

            /**
             * Sets the value of {@link AliasTargetProperty#getEvaluateTargetHealth}
             * @param evaluateTargetHealth `CfnRecordSet.AliasTargetProperty.EvaluateTargetHealth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateTargetHealth(software.amazon.awscdk.core.IResolvable evaluateTargetHealth) {
                this.evaluateTargetHealth = evaluateTargetHealth;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AliasTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AliasTargetProperty build() {
                return new Jsii$Proxy(dnsName, hostedZoneId, evaluateTargetHealth);
            }
        }

        /**
         * An implementation for {@link AliasTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasTargetProperty {
            private final java.lang.String dnsName;
            private final java.lang.String hostedZoneId;
            private final java.lang.Object evaluateTargetHealth;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsName = this.jsiiGet("dnsName", java.lang.String.class);
                this.hostedZoneId = this.jsiiGet("hostedZoneId", java.lang.String.class);
                this.evaluateTargetHealth = this.jsiiGet("evaluateTargetHealth", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String dnsName, final java.lang.String hostedZoneId, final java.lang.Object evaluateTargetHealth) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsName = java.util.Objects.requireNonNull(dnsName, "dnsName is required");
                this.hostedZoneId = java.util.Objects.requireNonNull(hostedZoneId, "hostedZoneId is required");
                this.evaluateTargetHealth = evaluateTargetHealth;
            }

            @Override
            public java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            public java.lang.String getHostedZoneId() {
                return this.hostedZoneId;
            }

            @Override
            public java.lang.Object getEvaluateTargetHealth() {
                return this.evaluateTargetHealth;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dnsName", om.valueToTree(this.getDnsName()));
                data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
                if (this.getEvaluateTargetHealth() != null) {
                    data.set("evaluateTargetHealth", om.valueToTree(this.getEvaluateTargetHealth()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.CfnRecordSet.AliasTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AliasTargetProperty.Jsii$Proxy that = (AliasTargetProperty.Jsii$Proxy) o;

                if (!dnsName.equals(that.dnsName)) return false;
                if (!hostedZoneId.equals(that.hostedZoneId)) return false;
                return this.evaluateTargetHealth != null ? this.evaluateTargetHealth.equals(that.evaluateTargetHealth) : that.evaluateTargetHealth == null;
            }

            @Override
            public int hashCode() {
                int result = this.dnsName.hashCode();
                result = 31 * result + (this.hostedZoneId.hashCode());
                result = 31 * result + (this.evaluateTargetHealth != null ? this.evaluateTargetHealth.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CfnRecordSet.GeoLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRecordSet.GeoLocationProperty.ContinentCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-continentcode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContinentCode() {
            return null;
        }

        /**
         * `CfnRecordSet.GeoLocationProperty.CountryCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-countrycode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCountryCode() {
            return null;
        }

        /**
         * `CfnRecordSet.GeoLocationProperty.SubdivisionCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-subdivisioncode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubdivisionCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoLocationProperty> {
            private java.lang.String continentCode;
            private java.lang.String countryCode;
            private java.lang.String subdivisionCode;

            /**
             * Sets the value of {@link GeoLocationProperty#getContinentCode}
             * @param continentCode `CfnRecordSet.GeoLocationProperty.ContinentCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continentCode(java.lang.String continentCode) {
                this.continentCode = continentCode;
                return this;
            }

            /**
             * Sets the value of {@link GeoLocationProperty#getCountryCode}
             * @param countryCode `CfnRecordSet.GeoLocationProperty.CountryCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder countryCode(java.lang.String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            /**
             * Sets the value of {@link GeoLocationProperty#getSubdivisionCode}
             * @param subdivisionCode `CfnRecordSet.GeoLocationProperty.SubdivisionCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subdivisionCode(java.lang.String subdivisionCode) {
                this.subdivisionCode = subdivisionCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoLocationProperty build() {
                return new Jsii$Proxy(continentCode, countryCode, subdivisionCode);
            }
        }

        /**
         * An implementation for {@link GeoLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoLocationProperty {
            private final java.lang.String continentCode;
            private final java.lang.String countryCode;
            private final java.lang.String subdivisionCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.continentCode = this.jsiiGet("continentCode", java.lang.String.class);
                this.countryCode = this.jsiiGet("countryCode", java.lang.String.class);
                this.subdivisionCode = this.jsiiGet("subdivisionCode", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String continentCode, final java.lang.String countryCode, final java.lang.String subdivisionCode) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.continentCode = continentCode;
                this.countryCode = countryCode;
                this.subdivisionCode = subdivisionCode;
            }

            @Override
            public java.lang.String getContinentCode() {
                return this.continentCode;
            }

            @Override
            public java.lang.String getCountryCode() {
                return this.countryCode;
            }

            @Override
            public java.lang.String getSubdivisionCode() {
                return this.subdivisionCode;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContinentCode() != null) {
                    data.set("continentCode", om.valueToTree(this.getContinentCode()));
                }
                if (this.getCountryCode() != null) {
                    data.set("countryCode", om.valueToTree(this.getCountryCode()));
                }
                if (this.getSubdivisionCode() != null) {
                    data.set("subdivisionCode", om.valueToTree(this.getSubdivisionCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.CfnRecordSet.GeoLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoLocationProperty.Jsii$Proxy that = (GeoLocationProperty.Jsii$Proxy) o;

                if (this.continentCode != null ? !this.continentCode.equals(that.continentCode) : that.continentCode != null) return false;
                if (this.countryCode != null ? !this.countryCode.equals(that.countryCode) : that.countryCode != null) return false;
                return this.subdivisionCode != null ? this.subdivisionCode.equals(that.subdivisionCode) : that.subdivisionCode == null;
            }

            @Override
            public int hashCode() {
                int result = this.continentCode != null ? this.continentCode.hashCode() : 0;
                result = 31 * result + (this.countryCode != null ? this.countryCode.hashCode() : 0);
                result = 31 * result + (this.subdivisionCode != null ? this.subdivisionCode.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.CfnRecordSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.CfnRecordSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.CfnRecordSetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.CfnRecordSetProps.Builder();
        }

        /**
         * `AWS::Route53::RecordSet.Name`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
         * @param name `AWS::Route53::RecordSet.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.Type`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
         * @param type `AWS::Route53::RecordSet.Type`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.AliasTarget`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
         * @param aliasTarget `AWS::Route53::RecordSet.AliasTarget`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasTarget(final software.amazon.awscdk.core.IResolvable aliasTarget) {
            this.props.aliasTarget(aliasTarget);
            return this;
        }
        /**
         * `AWS::Route53::RecordSet.AliasTarget`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
         * @param aliasTarget `AWS::Route53::RecordSet.AliasTarget`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasTarget(final software.amazon.awscdk.services.route53.CfnRecordSet.AliasTargetProperty aliasTarget) {
            this.props.aliasTarget(aliasTarget);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.Comment`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
         * @param comment `AWS::Route53::RecordSet.Comment`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.Failover`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
         * @param failover `AWS::Route53::RecordSet.Failover`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failover(final java.lang.String failover) {
            this.props.failover(failover);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.GeoLocation`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
         * @param geoLocation `AWS::Route53::RecordSet.GeoLocation`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoLocation(final software.amazon.awscdk.core.IResolvable geoLocation) {
            this.props.geoLocation(geoLocation);
            return this;
        }
        /**
         * `AWS::Route53::RecordSet.GeoLocation`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
         * @param geoLocation `AWS::Route53::RecordSet.GeoLocation`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoLocation(final software.amazon.awscdk.services.route53.CfnRecordSet.GeoLocationProperty geoLocation) {
            this.props.geoLocation(geoLocation);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.HealthCheckId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
         * @param healthCheckId `AWS::Route53::RecordSet.HealthCheckId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckId(final java.lang.String healthCheckId) {
            this.props.healthCheckId(healthCheckId);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.HostedZoneId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
         * @param hostedZoneId `AWS::Route53::RecordSet.HostedZoneId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(final java.lang.String hostedZoneId) {
            this.props.hostedZoneId(hostedZoneId);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.HostedZoneName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
         * @param hostedZoneName `AWS::Route53::RecordSet.HostedZoneName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneName(final java.lang.String hostedZoneName) {
            this.props.hostedZoneName(hostedZoneName);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.MultiValueAnswer`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
         * @param multiValueAnswer `AWS::Route53::RecordSet.MultiValueAnswer`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiValueAnswer(final java.lang.Boolean multiValueAnswer) {
            this.props.multiValueAnswer(multiValueAnswer);
            return this;
        }
        /**
         * `AWS::Route53::RecordSet.MultiValueAnswer`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
         * @param multiValueAnswer `AWS::Route53::RecordSet.MultiValueAnswer`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiValueAnswer(final software.amazon.awscdk.core.IResolvable multiValueAnswer) {
            this.props.multiValueAnswer(multiValueAnswer);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.Region`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
         * @param region `AWS::Route53::RecordSet.Region`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.ResourceRecords`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
         * @param resourceRecords `AWS::Route53::RecordSet.ResourceRecords`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceRecords(final java.util.List<java.lang.String> resourceRecords) {
            this.props.resourceRecords(resourceRecords);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.SetIdentifier`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
         * @param setIdentifier `AWS::Route53::RecordSet.SetIdentifier`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setIdentifier(final java.lang.String setIdentifier) {
            this.props.setIdentifier(setIdentifier);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.TTL`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
         * @param ttl `AWS::Route53::RecordSet.TTL`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(final java.lang.String ttl) {
            this.props.ttl(ttl);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.Weight`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
         * @param weight `AWS::Route53::RecordSet.Weight`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(final java.lang.Number weight) {
            this.props.weight(weight);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.CfnRecordSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.CfnRecordSet build() {
            return new software.amazon.awscdk.services.route53.CfnRecordSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
