package software.amazon.awscdk.services.route53;

/**
 * Properties for defining a `AWS::Route53::HostedZone`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.263Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CfnHostedZoneProps")
@software.amazon.jsii.Jsii.Proxy(CfnHostedZoneProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnHostedZoneProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Route53::HostedZone.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * `AWS::Route53::HostedZone.HostedZoneConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzoneconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHostedZoneConfig() {
        return null;
    }

    /**
     * `AWS::Route53::HostedZone.HostedZoneTags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzonetags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> getHostedZoneTags() {
        return null;
    }

    /**
     * `AWS::Route53::HostedZone.QueryLoggingConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-queryloggingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getQueryLoggingConfig() {
        return null;
    }

    /**
     * `AWS::Route53::HostedZone.VPCs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-vpcs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcs() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnHostedZoneProps> {
        private java.lang.String name;
        private java.lang.Object hostedZoneConfig;
        private java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> hostedZoneTags;
        private java.lang.Object queryLoggingConfig;
        private java.lang.Object vpcs;

        /**
         * Sets the value of {@link CfnHostedZoneProps#getName}
         * @param name `AWS::Route53::HostedZone.Name`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getHostedZoneConfig}
         * @param hostedZoneConfig `AWS::Route53::HostedZone.HostedZoneConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneConfig(software.amazon.awscdk.core.IResolvable hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getHostedZoneConfig}
         * @param hostedZoneConfig `AWS::Route53::HostedZone.HostedZoneConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneConfig(software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneConfigProperty hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getHostedZoneTags}
         * @param hostedZoneTags `AWS::Route53::HostedZone.HostedZoneTags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneTags(java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> hostedZoneTags) {
            this.hostedZoneTags = hostedZoneTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getQueryLoggingConfig}
         * @param queryLoggingConfig `AWS::Route53::HostedZone.QueryLoggingConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfig(software.amazon.awscdk.core.IResolvable queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getQueryLoggingConfig}
         * @param queryLoggingConfig `AWS::Route53::HostedZone.QueryLoggingConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfig(software.amazon.awscdk.services.route53.CfnHostedZone.QueryLoggingConfigProperty queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getVpcs}
         * @param vpcs `AWS::Route53::HostedZone.VPCs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcs(software.amazon.awscdk.core.IResolvable vpcs) {
            this.vpcs = vpcs;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedZoneProps#getVpcs}
         * @param vpcs `AWS::Route53::HostedZone.VPCs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcs(java.util.List<java.lang.Object> vpcs) {
            this.vpcs = vpcs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHostedZoneProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnHostedZoneProps build() {
            return new Jsii$Proxy(name, hostedZoneConfig, hostedZoneTags, queryLoggingConfig, vpcs);
        }
    }

    /**
     * An implementation for {@link CfnHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnHostedZoneProps {
        private final java.lang.String name;
        private final java.lang.Object hostedZoneConfig;
        private final java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> hostedZoneTags;
        private final java.lang.Object queryLoggingConfig;
        private final java.lang.Object vpcs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.hostedZoneConfig = this.jsiiGet("hostedZoneConfig", java.lang.Object.class);
            this.hostedZoneTags = this.jsiiGet("hostedZoneTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty.class)));
            this.queryLoggingConfig = this.jsiiGet("queryLoggingConfig", java.lang.Object.class);
            this.vpcs = this.jsiiGet("vpcs", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String name, final java.lang.Object hostedZoneConfig, final java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> hostedZoneTags, final java.lang.Object queryLoggingConfig, final java.lang.Object vpcs) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(name, "name is required");
            this.hostedZoneConfig = hostedZoneConfig;
            this.hostedZoneTags = hostedZoneTags;
            this.queryLoggingConfig = queryLoggingConfig;
            this.vpcs = vpcs;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.Object getHostedZoneConfig() {
            return this.hostedZoneConfig;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> getHostedZoneTags() {
            return this.hostedZoneTags;
        }

        @Override
        public java.lang.Object getQueryLoggingConfig() {
            return this.queryLoggingConfig;
        }

        @Override
        public java.lang.Object getVpcs() {
            return this.vpcs;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getHostedZoneConfig() != null) {
                data.set("hostedZoneConfig", om.valueToTree(this.getHostedZoneConfig()));
            }
            if (this.getHostedZoneTags() != null) {
                data.set("hostedZoneTags", om.valueToTree(this.getHostedZoneTags()));
            }
            if (this.getQueryLoggingConfig() != null) {
                data.set("queryLoggingConfig", om.valueToTree(this.getQueryLoggingConfig()));
            }
            if (this.getVpcs() != null) {
                data.set("vpcs", om.valueToTree(this.getVpcs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.CfnHostedZoneProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnHostedZoneProps.Jsii$Proxy that = (CfnHostedZoneProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.hostedZoneConfig != null ? !this.hostedZoneConfig.equals(that.hostedZoneConfig) : that.hostedZoneConfig != null) return false;
            if (this.hostedZoneTags != null ? !this.hostedZoneTags.equals(that.hostedZoneTags) : that.hostedZoneTags != null) return false;
            if (this.queryLoggingConfig != null ? !this.queryLoggingConfig.equals(that.queryLoggingConfig) : that.queryLoggingConfig != null) return false;
            return this.vpcs != null ? this.vpcs.equals(that.vpcs) : that.vpcs == null;
        }

        @Override
        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.hostedZoneConfig != null ? this.hostedZoneConfig.hashCode() : 0);
            result = 31 * result + (this.hostedZoneTags != null ? this.hostedZoneTags.hashCode() : 0);
            result = 31 * result + (this.queryLoggingConfig != null ? this.queryLoggingConfig.hashCode() : 0);
            result = 31 * result + (this.vpcs != null ? this.vpcs.hashCode() : 0);
            return result;
        }
    }
}
