package software.amazon.awscdk.services.route53;

/**
 * Represents the properties of an alias target destination.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.261Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.AliasRecordTargetConfig")
@software.amazon.jsii.Jsii.Proxy(AliasRecordTargetConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AliasRecordTargetConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * DNS name of the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

    /**
     * Hosted zone ID of the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneId();

    /**
     * @return a {@link Builder} of {@link AliasRecordTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AliasRecordTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AliasRecordTargetConfig> {
        private java.lang.String dnsName;
        private java.lang.String hostedZoneId;

        /**
         * Sets the value of {@link AliasRecordTargetConfig#getDnsName}
         * @param dnsName DNS name of the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsName(java.lang.String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        /**
         * Sets the value of {@link AliasRecordTargetConfig#getHostedZoneId}
         * @param hostedZoneId Hosted zone ID of the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(java.lang.String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AliasRecordTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AliasRecordTargetConfig build() {
            return new Jsii$Proxy(dnsName, hostedZoneId);
        }
    }

    /**
     * An implementation for {@link AliasRecordTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasRecordTargetConfig {
        private final java.lang.String dnsName;
        private final java.lang.String hostedZoneId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dnsName = this.jsiiGet("dnsName", java.lang.String.class);
            this.hostedZoneId = this.jsiiGet("hostedZoneId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String dnsName, final java.lang.String hostedZoneId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dnsName = java.util.Objects.requireNonNull(dnsName, "dnsName is required");
            this.hostedZoneId = java.util.Objects.requireNonNull(hostedZoneId, "hostedZoneId is required");
        }

        @Override
        public java.lang.String getDnsName() {
            return this.dnsName;
        }

        @Override
        public java.lang.String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dnsName", om.valueToTree(this.getDnsName()));
            data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.AliasRecordTargetConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AliasRecordTargetConfig.Jsii$Proxy that = (AliasRecordTargetConfig.Jsii$Proxy) o;

            if (!dnsName.equals(that.dnsName)) return false;
            return this.hostedZoneId.equals(that.hostedZoneId);
        }

        @Override
        public int hashCode() {
            int result = this.dnsName.hashCode();
            result = 31 * result + (this.hostedZoneId.hashCode());
            return result;
        }
    }
}
