/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.services.route53.CfnHostedZone;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnHostedZoneProps
extends JsiiSerializable {
    public String getName();

    public Object getHostedZoneConfig();

    public Object getHostedZoneTags();

    public Object getQueryLoggingConfig();

    public Object getVpcs();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _name;
        @Nullable
        private Object _hostedZoneConfig;
        @Nullable
        private Object _hostedZoneTags;
        @Nullable
        private Object _queryLoggingConfig;
        @Nullable
        private Object _vpcs;

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withHostedZoneConfig(@Nullable IResolvable value) {
            this._hostedZoneConfig = value;
            return this;
        }

        public Builder withHostedZoneConfig(@Nullable CfnHostedZone.HostedZoneConfigProperty value) {
            this._hostedZoneConfig = value;
            return this;
        }

        public Builder withHostedZoneTags(@Nullable IResolvable value) {
            this._hostedZoneTags = value;
            return this;
        }

        public Builder withHostedZoneTags(@Nullable List<Object> value) {
            this._hostedZoneTags = value;
            return this;
        }

        public Builder withQueryLoggingConfig(@Nullable IResolvable value) {
            this._queryLoggingConfig = value;
            return this;
        }

        public Builder withQueryLoggingConfig(@Nullable CfnHostedZone.QueryLoggingConfigProperty value) {
            this._queryLoggingConfig = value;
            return this;
        }

        public Builder withVpcs(@Nullable IResolvable value) {
            this._vpcs = value;
            return this;
        }

        public Builder withVpcs(@Nullable List<Object> value) {
            this._vpcs = value;
            return this;
        }

        public CfnHostedZoneProps build() {
            return new CfnHostedZoneProps(){
                private final String $name;
                @Nullable
                private final Object $hostedZoneConfig;
                @Nullable
                private final Object $hostedZoneTags;
                @Nullable
                private final Object $queryLoggingConfig;
                @Nullable
                private final Object $vpcs;
                {
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$hostedZoneConfig = _hostedZoneConfig;
                    this.$hostedZoneTags = _hostedZoneTags;
                    this.$queryLoggingConfig = _queryLoggingConfig;
                    this.$vpcs = _vpcs;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public Object getHostedZoneConfig() {
                    return this.$hostedZoneConfig;
                }

                @Override
                public Object getHostedZoneTags() {
                    return this.$hostedZoneTags;
                }

                @Override
                public Object getQueryLoggingConfig() {
                    return this.$queryLoggingConfig;
                }

                @Override
                public Object getVpcs() {
                    return this.$vpcs;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    if (this.getHostedZoneConfig() != null) {
                        obj.set("hostedZoneConfig", om.valueToTree(this.getHostedZoneConfig()));
                    }
                    if (this.getHostedZoneTags() != null) {
                        obj.set("hostedZoneTags", om.valueToTree(this.getHostedZoneTags()));
                    }
                    if (this.getQueryLoggingConfig() != null) {
                        obj.set("queryLoggingConfig", om.valueToTree(this.getQueryLoggingConfig()));
                    }
                    if (this.getVpcs() != null) {
                        obj.set("vpcs", om.valueToTree(this.getVpcs()));
                    }
                    return obj;
                }
            };
        }
    }
}

