/**
 * <h1>Amazon Redshift Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>Starting a Redshift Cluster Database</h2>
 * <p>
 * To set up a Redshift cluster, define a <code>Cluster</code>. It will be launched in a VPC.
 * You can specify a VPC, otherwise one will be created. The nodes are always launched in private subnets and are encrypted by default.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.redshift.*;
 * Cluster cluster = new Cluster(this, "Redshift", new ClusterProps()
 *         .masterUser(new Login()
 *                 .masterUsername("admin"))
 *         .vpc(vpc));
 * </pre></blockquote>
 * <p>
 * By default, the master password will be generated and stored in AWS Secrets Manager.
 * <p>
 * A default database named <code>default_db</code> will be created in the cluster. To change the name of this database set the <code>defaultDatabaseName</code> attribute in the constructor properties.
 * <p>
 * By default, the cluster will not be publicly accessible.
 * Depending on your use case, you can make the cluster publicly accessible with the <code>publiclyAccessible</code> property.
 * <p>
 * <h2>Connecting</h2>
 * <p>
 * To control who can access the cluster, use the <code>.connections</code> attribute. Redshift Clusters have
 * a default port, so you don't need to specify the port:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * cluster.connections.allowFromAnyIpv4("Open to the world");
 * </pre></blockquote>
 * <p>
 * The endpoint to access your database cluster will be available as the <code>.clusterEndpoint</code> attribute:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * cluster.clusterEndpoint.getSocketAddress();
 * </pre></blockquote>
 * <p>
 * <h2>Rotating credentials</h2>
 * <p>
 * When the master password is generated and stored in AWS Secrets Manager, it can be rotated automatically:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * cluster.addRotationSingleUser();
 * </pre></blockquote>
 * <p>
 * The multi user rotation scheme is also available:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * cluster.addRotationMultiUser("MyUser", Map.of(
 *         "secret", myImportedSecret));
 * </pre></blockquote>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.redshift;
