/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.redshift;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.redshift.$Module;
import software.amazon.awscdk.services.redshift.ClusterProps;
import software.amazon.awscdk.services.redshift.ClusterType;
import software.amazon.awscdk.services.redshift.IClusterParameterGroup;
import software.amazon.awscdk.services.redshift.IClusterSubnetGroup;
import software.amazon.awscdk.services.redshift.Login;
import software.amazon.awscdk.services.redshift.NodeType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-redshift.ClusterProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ClusterProps
extends JsiiSerializable {
    @NotNull
    public Login getMasterUser();

    @NotNull
    public IVpc getVpc();

    @Nullable
    default public String getClusterName() {
        return null;
    }

    @Nullable
    default public ClusterType getClusterType() {
        return null;
    }

    @Nullable
    default public String getDefaultDatabaseName() {
        return null;
    }

    @Nullable
    default public Boolean getEncrypted() {
        return null;
    }

    @Nullable
    default public IKey getEncryptionKey() {
        return null;
    }

    @Nullable
    default public IBucket getLoggingBucket() {
        return null;
    }

    @Nullable
    default public String getLoggingKeyPrefix() {
        return null;
    }

    @Nullable
    default public NodeType getNodeType() {
        return null;
    }

    @Nullable
    default public Number getNumberOfNodes() {
        return null;
    }

    @Nullable
    default public IClusterParameterGroup getParameterGroup() {
        return null;
    }

    @Nullable
    default public Number getPort() {
        return null;
    }

    @Nullable
    default public String getPreferredMaintenanceWindow() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public List<IRole> getRoles() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public IClusterSubnetGroup getSubnetGroup() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ClusterProps> {
        private Login masterUser;
        private IVpc vpc;
        private String clusterName;
        private ClusterType clusterType;
        private String defaultDatabaseName;
        private Boolean encrypted;
        private IKey encryptionKey;
        private IBucket loggingBucket;
        private String loggingKeyPrefix;
        private NodeType nodeType;
        private Number numberOfNodes;
        private IClusterParameterGroup parameterGroup;
        private Number port;
        private String preferredMaintenanceWindow;
        private RemovalPolicy removalPolicy;
        private List<IRole> roles;
        private List<ISecurityGroup> securityGroups;
        private IClusterSubnetGroup subnetGroup;
        private SubnetSelection vpcSubnets;

        public Builder masterUser(Login masterUser) {
            this.masterUser = masterUser;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder clusterType(ClusterType clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public Builder defaultDatabaseName(String defaultDatabaseName) {
            this.defaultDatabaseName = defaultDatabaseName;
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder loggingBucket(IBucket loggingBucket) {
            this.loggingBucket = loggingBucket;
            return this;
        }

        public Builder loggingKeyPrefix(String loggingKeyPrefix) {
            this.loggingKeyPrefix = loggingKeyPrefix;
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Builder numberOfNodes(Number numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public Builder parameterGroup(IClusterParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder roles(List<? extends IRole> roles) {
            this.roles = roles;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder subnetGroup(IClusterSubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public ClusterProps build() {
            return new Jsii.Proxy(this.masterUser, this.vpc, this.clusterName, this.clusterType, this.defaultDatabaseName, this.encrypted, this.encryptionKey, this.loggingBucket, this.loggingKeyPrefix, this.nodeType, this.numberOfNodes, this.parameterGroup, this.port, this.preferredMaintenanceWindow, this.removalPolicy, this.roles, this.securityGroups, this.subnetGroup, this.vpcSubnets, null);
        }
    }
}

