/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.redshift;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.redshift.$Module;
import software.amazon.awscdk.services.redshift.ClusterAttributes;
import software.amazon.awscdk.services.redshift.ClusterProps;
import software.amazon.awscdk.services.redshift.ClusterType;
import software.amazon.awscdk.services.redshift.Endpoint;
import software.amazon.awscdk.services.redshift.ICluster;
import software.amazon.awscdk.services.redshift.IClusterParameterGroup;
import software.amazon.awscdk.services.redshift.IClusterSubnetGroup;
import software.amazon.awscdk.services.redshift.Login;
import software.amazon.awscdk.services.redshift.NodeType;
import software.amazon.awscdk.services.redshift.RotationMultiUserOptions;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps;
import software.amazon.awscdk.services.secretsmanager.SecretRotation;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-redshift.Cluster")
public class Cluster
extends Resource
implements ICluster {
    protected Cluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Cluster(@NotNull Construct scope, @NotNull String id, @NotNull ClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ICluster fromClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ClusterAttributes attrs) {
        return (ICluster)JsiiObject.jsiiStaticCall(Cluster.class, (String)"fromClusterAttributes", ICluster.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public SecretRotation addRotationMultiUser(@NotNull String id, @NotNull RotationMultiUserOptions options) {
        return (SecretRotation)this.jsiiCall("addRotationMultiUser", SecretRotation.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public SecretRotation addRotationSingleUser(@Nullable Duration automaticallyAfter) {
        return (SecretRotation)this.jsiiCall("addRotationSingleUser", SecretRotation.class, new Object[]{automaticallyAfter});
    }

    @NotNull
    public SecretRotation addRotationSingleUser() {
        return (SecretRotation)this.jsiiCall("addRotationSingleUser", SecretRotation.class, new Object[0]);
    }

    @NotNull
    public SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return (SecretAttachmentTargetProps)this.jsiiCall("asSecretAttachmentTarget", SecretAttachmentTargetProps.class, new Object[0]);
    }

    @Override
    @NotNull
    public Endpoint getClusterEndpoint() {
        return (Endpoint)((Object)this.jsiiGet("clusterEndpoint", Endpoint.class));
    }

    @Override
    @NotNull
    public String getClusterName() {
        return (String)this.jsiiGet("clusterName", String.class);
    }

    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Nullable
    public ISecret getSecret() {
        return (ISecret)this.jsiiGet("secret", ISecret.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Cluster> {
        private final Construct scope;
        private final String id;
        private final ClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ClusterProps.Builder();
        }

        public Builder masterUser(Login masterUser) {
            this.props.masterUser(masterUser);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder clusterType(ClusterType clusterType) {
            this.props.clusterType(clusterType);
            return this;
        }

        public Builder defaultDatabaseName(String defaultDatabaseName) {
            this.props.defaultDatabaseName(defaultDatabaseName);
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder loggingBucket(IBucket loggingBucket) {
            this.props.loggingBucket(loggingBucket);
            return this;
        }

        public Builder loggingKeyPrefix(String loggingKeyPrefix) {
            this.props.loggingKeyPrefix(loggingKeyPrefix);
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.props.nodeType(nodeType);
            return this;
        }

        public Builder numberOfNodes(Number numberOfNodes) {
            this.props.numberOfNodes(numberOfNodes);
            return this;
        }

        public Builder parameterGroup(IClusterParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder roles(List<? extends IRole> roles) {
            this.props.roles(roles);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnetGroup(IClusterSubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Cluster build() {
            return new Cluster(this.scope, this.id, this.props.build());
        }
    }
}

