/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.redshift;

import java.util.List;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.redshift.CfnCluster;
import software.amazon.awscdk.services.redshift.CfnClusterProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnClusterProps
extends JsiiSerializable {
    public String getClusterType();

    public String getDbName();

    public String getMasterUsername();

    public String getMasterUserPassword();

    public String getNodeType();

    public Object getAllowVersionUpgrade();

    public Number getAutomatedSnapshotRetentionPeriod();

    public String getAvailabilityZone();

    public String getClusterIdentifier();

    public String getClusterParameterGroupName();

    public List<String> getClusterSecurityGroups();

    public String getClusterSubnetGroupName();

    public String getClusterVersion();

    public String getElasticIp();

    public Object getEncrypted();

    public String getHsmClientCertificateIdentifier();

    public String getHsmConfigurationIdentifier();

    public List<String> getIamRoles();

    public String getKmsKeyId();

    public Object getLoggingProperties();

    public Number getNumberOfNodes();

    public String getOwnerAccount();

    public Number getPort();

    public String getPreferredMaintenanceWindow();

    public Object getPubliclyAccessible();

    public String getSnapshotClusterIdentifier();

    public String getSnapshotIdentifier();

    public List<CfnTag> getTags();

    public List<String> getVpcSecurityGroupIds();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String clusterType;
        private String dbName;
        private String masterUsername;
        private String masterUserPassword;
        private String nodeType;
        private Object allowVersionUpgrade;
        private Number automatedSnapshotRetentionPeriod;
        private String availabilityZone;
        private String clusterIdentifier;
        private String clusterParameterGroupName;
        private List<String> clusterSecurityGroups;
        private String clusterSubnetGroupName;
        private String clusterVersion;
        private String elasticIp;
        private Object encrypted;
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private List<String> iamRoles;
        private String kmsKeyId;
        private Object loggingProperties;
        private Number numberOfNodes;
        private String ownerAccount;
        private Number port;
        private String preferredMaintenanceWindow;
        private Object publiclyAccessible;
        private String snapshotClusterIdentifier;
        private String snapshotIdentifier;
        private List<CfnTag> tags;
        private List<String> vpcSecurityGroupIds;

        public Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public Builder allowVersionUpgrade(IResolvable allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public Builder automatedSnapshotRetentionPeriod(Number automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public Builder clusterSecurityGroups(List<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = clusterSecurityGroups;
            return this;
        }

        public Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public Builder encrypted(IResolvable encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public Builder iamRoles(List<String> iamRoles) {
            this.iamRoles = iamRoles;
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public Builder loggingProperties(IResolvable loggingProperties) {
            this.loggingProperties = loggingProperties;
            return this;
        }

        public Builder loggingProperties(CfnCluster.LoggingPropertiesProperty loggingProperties) {
            this.loggingProperties = loggingProperties;
            return this;
        }

        public Builder numberOfNodes(Number numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public Builder publiclyAccessible(IResolvable publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        public CfnClusterProps build() {
            return new Jsii.Proxy(this.clusterType, this.dbName, this.masterUsername, this.masterUserPassword, this.nodeType, this.allowVersionUpgrade, this.automatedSnapshotRetentionPeriod, this.availabilityZone, this.clusterIdentifier, this.clusterParameterGroupName, this.clusterSecurityGroups, this.clusterSubnetGroupName, this.clusterVersion, this.elasticIp, this.encrypted, this.hsmClientCertificateIdentifier, this.hsmConfigurationIdentifier, this.iamRoles, this.kmsKeyId, this.loggingProperties, this.numberOfNodes, this.ownerAccount, this.port, this.preferredMaintenanceWindow, this.publiclyAccessible, this.snapshotClusterIdentifier, this.snapshotIdentifier, this.tags, this.vpcSecurityGroupIds, null);
        }
    }
}

