package software.amazon.awscdk.services.redshift;

/**
 * (experimental) Properties for accessing a Redshift database.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * import software.amazon.awscdk.services.secretsmanager.*;
 * Cluster cluster;
 * Secret secret;
 * DatabaseOptions databaseOptions = DatabaseOptions.builder()
 *         .cluster(cluster)
 *         .databaseName("databaseName")
 *         // the properties below are optional
 *         .adminUser(secret)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-21T16:39:02.567Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.DatabaseOptions")
@software.amazon.jsii.Jsii.Proxy(DatabaseOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DatabaseOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The secret containing credentials to a Redshift user with administrator privileges.
     * <p>
     * Secret JSON schema: <code>{ username: string; password: string }</code>.
     * <p>
     * Default: - the admin secret is taken from the cluster
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getAdminUser() {
        return null;
    }

    /**
     * (experimental) The cluster containing the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.ICluster getCluster();

    /**
     * (experimental) The name of the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

    /**
     * @return a {@link Builder} of {@link DatabaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseOptions> {
        software.amazon.awscdk.services.secretsmanager.ISecret adminUser;
        software.amazon.awscdk.services.redshift.ICluster cluster;
        java.lang.String databaseName;

        /**
         * Sets the value of {@link DatabaseOptions#getAdminUser}
         * @param adminUser The secret containing credentials to a Redshift user with administrator privileges.
         *                  Secret JSON schema: <code>{ username: string; password: string }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminUser(software.amazon.awscdk.services.secretsmanager.ISecret adminUser) {
            this.adminUser = adminUser;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseOptions#getCluster}
         * @param cluster The cluster containing the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.redshift.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseOptions#getDatabaseName}
         * @param databaseName The name of the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DatabaseOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseOptions {
        private final software.amazon.awscdk.services.secretsmanager.ISecret adminUser;
        private final software.amazon.awscdk.services.redshift.ICluster cluster;
        private final java.lang.String databaseName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.adminUser = software.amazon.jsii.Kernel.get(this, "adminUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.ICluster.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.adminUser = builder.adminUser;
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getAdminUser() {
            return this.adminUser;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdminUser() != null) {
                data.set("adminUser", om.valueToTree(this.getAdminUser()));
            }
            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("databaseName", om.valueToTree(this.getDatabaseName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift.DatabaseOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseOptions.Jsii$Proxy that = (DatabaseOptions.Jsii$Proxy) o;

            if (this.adminUser != null ? !this.adminUser.equals(that.adminUser) : that.adminUser != null) return false;
            if (!cluster.equals(that.cluster)) return false;
            return this.databaseName.equals(that.databaseName);
        }

        @Override
        public final int hashCode() {
            int result = this.adminUser != null ? this.adminUser.hashCode() : 0;
            result = 31 * result + (this.cluster.hashCode());
            result = 31 * result + (this.databaseName.hashCode());
            return result;
        }
    }
}
