package software.amazon.awscdk.services.redshift;

/**
 * Properties for defining a `AWS::Redshift::Cluster`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * CfnClusterProps cfnClusterProps = CfnClusterProps.builder()
 *         .clusterType("clusterType")
 *         .dbName("dbName")
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .nodeType("nodeType")
 *         // the properties below are optional
 *         .allowVersionUpgrade(false)
 *         .aquaConfigurationStatus("aquaConfigurationStatus")
 *         .automatedSnapshotRetentionPeriod(123)
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneRelocation(false)
 *         .availabilityZoneRelocationStatus("availabilityZoneRelocationStatus")
 *         .classic(false)
 *         .clusterIdentifier("clusterIdentifier")
 *         .clusterParameterGroupName("clusterParameterGroupName")
 *         .clusterSecurityGroups(List.of("clusterSecurityGroups"))
 *         .clusterSubnetGroupName("clusterSubnetGroupName")
 *         .clusterVersion("clusterVersion")
 *         .deferMaintenance(false)
 *         .deferMaintenanceDuration(123)
 *         .deferMaintenanceEndTime("deferMaintenanceEndTime")
 *         .deferMaintenanceStartTime("deferMaintenanceStartTime")
 *         .destinationRegion("destinationRegion")
 *         .elasticIp("elasticIp")
 *         .encrypted(false)
 *         .enhancedVpcRouting(false)
 *         .hsmClientCertificateIdentifier("hsmClientCertificateIdentifier")
 *         .hsmConfigurationIdentifier("hsmConfigurationIdentifier")
 *         .iamRoles(List.of("iamRoles"))
 *         .kmsKeyId("kmsKeyId")
 *         .loggingProperties(LoggingPropertiesProperty.builder()
 *                 .bucketName("bucketName")
 *                 // the properties below are optional
 *                 .s3KeyPrefix("s3KeyPrefix")
 *                 .build())
 *         .maintenanceTrackName("maintenanceTrackName")
 *         .manualSnapshotRetentionPeriod(123)
 *         .numberOfNodes(123)
 *         .ownerAccount("ownerAccount")
 *         .port(123)
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .publiclyAccessible(false)
 *         .resourceAction("resourceAction")
 *         .revisionTarget("revisionTarget")
 *         .rotateEncryptionKey(false)
 *         .snapshotClusterIdentifier("snapshotClusterIdentifier")
 *         .snapshotCopyGrantName("snapshotCopyGrantName")
 *         .snapshotCopyManual(false)
 *         .snapshotCopyRetentionPeriod(123)
 *         .snapshotIdentifier("snapshotIdentifier")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-21T16:39:02.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Redshift::Cluster.AllowVersionUpgrade`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowVersionUpgrade() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.AquaConfigurationStatus`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAquaConfigurationStatus() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.AutomatedSnapshotRetentionPeriod`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAutomatedSnapshotRetentionPeriod() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.AvailabilityZone`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.AvailabilityZoneRelocation`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAvailabilityZoneRelocation() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.AvailabilityZoneRelocationStatus`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneRelocationStatus() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.Classic`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClassic() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.ClusterIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterIdentifier() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.ClusterParameterGroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterParameterGroupName() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.ClusterSecurityGroups`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClusterSecurityGroups() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.ClusterSubnetGroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterSubnetGroupName() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.ClusterType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterType();

    /**
     * `AWS::Redshift::Cluster.ClusterVersion`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterVersion() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.DBName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbName();

    /**
     * `AWS::Redshift::Cluster.DeferMaintenance`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeferMaintenance() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenanceDuration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDeferMaintenanceDuration() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenanceEndTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeferMaintenanceEndTime() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenanceStartTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeferMaintenanceStartTime() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.DestinationRegion`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationRegion() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.ElasticIp`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getElasticIp() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.Encrypted`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.EnhancedVpcRouting`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedVpcRouting() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.HsmClientCertificateIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHsmClientCertificateIdentifier() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.HsmConfigurationIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHsmConfigurationIdentifier() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.IamRoles`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIamRoles() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.KmsKeyId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.LoggingProperties`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingProperties() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.MaintenanceTrackName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaintenanceTrackName() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.ManualSnapshotRetentionPeriod`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getManualSnapshotRetentionPeriod() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.MasterUsername`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMasterUsername();

    /**
     * `AWS::Redshift::Cluster.MasterUserPassword`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMasterUserPassword();

    /**
     * `AWS::Redshift::Cluster.NodeType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNodeType();

    /**
     * `AWS::Redshift::Cluster.NumberOfNodes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfNodes() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.OwnerAccount`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerAccount() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.Port`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.PreferredMaintenanceWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.PubliclyAccessible`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.ResourceAction`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceAction() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.RevisionTarget`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRevisionTarget() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.RotateEncryptionKey`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRotateEncryptionKey() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.SnapshotClusterIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotClusterIdentifier() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.SnapshotCopyGrantName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotCopyGrantName() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.SnapshotCopyManual`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotCopyManual() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.SnapshotCopyRetentionPeriod`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotCopyRetentionPeriod() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.SnapshotIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::Redshift::Cluster.VpcSecurityGroupIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.lang.Object allowVersionUpgrade;
        java.lang.String aquaConfigurationStatus;
        java.lang.Number automatedSnapshotRetentionPeriod;
        java.lang.String availabilityZone;
        java.lang.Object availabilityZoneRelocation;
        java.lang.String availabilityZoneRelocationStatus;
        java.lang.Object classic;
        java.lang.String clusterIdentifier;
        java.lang.String clusterParameterGroupName;
        java.util.List<java.lang.String> clusterSecurityGroups;
        java.lang.String clusterSubnetGroupName;
        java.lang.String clusterType;
        java.lang.String clusterVersion;
        java.lang.String dbName;
        java.lang.Object deferMaintenance;
        java.lang.Number deferMaintenanceDuration;
        java.lang.String deferMaintenanceEndTime;
        java.lang.String deferMaintenanceStartTime;
        java.lang.String destinationRegion;
        java.lang.String elasticIp;
        java.lang.Object encrypted;
        java.lang.Object enhancedVpcRouting;
        java.lang.String hsmClientCertificateIdentifier;
        java.lang.String hsmConfigurationIdentifier;
        java.util.List<java.lang.String> iamRoles;
        java.lang.String kmsKeyId;
        java.lang.Object loggingProperties;
        java.lang.String maintenanceTrackName;
        java.lang.Number manualSnapshotRetentionPeriod;
        java.lang.String masterUsername;
        java.lang.String masterUserPassword;
        java.lang.String nodeType;
        java.lang.Number numberOfNodes;
        java.lang.String ownerAccount;
        java.lang.Number port;
        java.lang.String preferredMaintenanceWindow;
        java.lang.Object publiclyAccessible;
        java.lang.String resourceAction;
        java.lang.String revisionTarget;
        java.lang.Object rotateEncryptionKey;
        java.lang.String snapshotClusterIdentifier;
        java.lang.String snapshotCopyGrantName;
        java.lang.Object snapshotCopyManual;
        java.lang.Number snapshotCopyRetentionPeriod;
        java.lang.String snapshotIdentifier;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Sets the value of {@link CfnClusterProps#getAllowVersionUpgrade}
         * @param allowVersionUpgrade `AWS::Redshift::Cluster.AllowVersionUpgrade`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowVersionUpgrade(java.lang.Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAllowVersionUpgrade}
         * @param allowVersionUpgrade `AWS::Redshift::Cluster.AllowVersionUpgrade`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowVersionUpgrade(software.amazon.awscdk.core.IResolvable allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAquaConfigurationStatus}
         * @param aquaConfigurationStatus `AWS::Redshift::Cluster.AquaConfigurationStatus`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aquaConfigurationStatus(java.lang.String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAutomatedSnapshotRetentionPeriod}
         * @param automatedSnapshotRetentionPeriod `AWS::Redshift::Cluster.AutomatedSnapshotRetentionPeriod`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automatedSnapshotRetentionPeriod(java.lang.Number automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAvailabilityZone}
         * @param availabilityZone `AWS::Redshift::Cluster.AvailabilityZone`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAvailabilityZoneRelocation}
         * @param availabilityZoneRelocation `AWS::Redshift::Cluster.AvailabilityZoneRelocation`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRelocation(java.lang.Boolean availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAvailabilityZoneRelocation}
         * @param availabilityZoneRelocation `AWS::Redshift::Cluster.AvailabilityZoneRelocation`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRelocation(software.amazon.awscdk.core.IResolvable availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAvailabilityZoneRelocationStatus}
         * @param availabilityZoneRelocationStatus `AWS::Redshift::Cluster.AvailabilityZoneRelocationStatus`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRelocationStatus(java.lang.String availabilityZoneRelocationStatus) {
            this.availabilityZoneRelocationStatus = availabilityZoneRelocationStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClassic}
         * @param classic `AWS::Redshift::Cluster.Classic`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classic(java.lang.Boolean classic) {
            this.classic = classic;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClassic}
         * @param classic `AWS::Redshift::Cluster.Classic`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classic(software.amazon.awscdk.core.IResolvable classic) {
            this.classic = classic;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterIdentifier}
         * @param clusterIdentifier `AWS::Redshift::Cluster.ClusterIdentifier`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterParameterGroupName}
         * @param clusterParameterGroupName `AWS::Redshift::Cluster.ClusterParameterGroupName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterParameterGroupName(java.lang.String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterSecurityGroups}
         * @param clusterSecurityGroups `AWS::Redshift::Cluster.ClusterSecurityGroups`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSecurityGroups(java.util.List<java.lang.String> clusterSecurityGroups) {
            this.clusterSecurityGroups = clusterSecurityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterSubnetGroupName}
         * @param clusterSubnetGroupName `AWS::Redshift::Cluster.ClusterSubnetGroupName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSubnetGroupName(java.lang.String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterType}
         * @param clusterType `AWS::Redshift::Cluster.ClusterType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterType(java.lang.String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterVersion}
         * @param clusterVersion `AWS::Redshift::Cluster.ClusterVersion`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterVersion(java.lang.String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDbName}
         * @param dbName `AWS::Redshift::Cluster.DBName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbName(java.lang.String dbName) {
            this.dbName = dbName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenance}
         * @param deferMaintenance `AWS::Redshift::Cluster.DeferMaintenance`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenance(java.lang.Boolean deferMaintenance) {
            this.deferMaintenance = deferMaintenance;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenance}
         * @param deferMaintenance `AWS::Redshift::Cluster.DeferMaintenance`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenance(software.amazon.awscdk.core.IResolvable deferMaintenance) {
            this.deferMaintenance = deferMaintenance;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenanceDuration}
         * @param deferMaintenanceDuration `AWS::Redshift::Cluster.DeferMaintenanceDuration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenanceDuration(java.lang.Number deferMaintenanceDuration) {
            this.deferMaintenanceDuration = deferMaintenanceDuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenanceEndTime}
         * @param deferMaintenanceEndTime `AWS::Redshift::Cluster.DeferMaintenanceEndTime`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenanceEndTime(java.lang.String deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenanceStartTime}
         * @param deferMaintenanceStartTime `AWS::Redshift::Cluster.DeferMaintenanceStartTime`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenanceStartTime(java.lang.String deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDestinationRegion}
         * @param destinationRegion `AWS::Redshift::Cluster.DestinationRegion`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationRegion(java.lang.String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getElasticIp}
         * @param elasticIp `AWS::Redshift::Cluster.ElasticIp`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIp(java.lang.String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncrypted}
         * @param encrypted `AWS::Redshift::Cluster.Encrypted`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncrypted}
         * @param encrypted `AWS::Redshift::Cluster.Encrypted`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEnhancedVpcRouting}
         * @param enhancedVpcRouting `AWS::Redshift::Cluster.EnhancedVpcRouting`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(java.lang.Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEnhancedVpcRouting}
         * @param enhancedVpcRouting `AWS::Redshift::Cluster.EnhancedVpcRouting`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(software.amazon.awscdk.core.IResolvable enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getHsmClientCertificateIdentifier}
         * @param hsmClientCertificateIdentifier `AWS::Redshift::Cluster.HsmClientCertificateIdentifier`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hsmClientCertificateIdentifier(java.lang.String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getHsmConfigurationIdentifier}
         * @param hsmConfigurationIdentifier `AWS::Redshift::Cluster.HsmConfigurationIdentifier`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hsmConfigurationIdentifier(java.lang.String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getIamRoles}
         * @param iamRoles `AWS::Redshift::Cluster.IamRoles`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoles(java.util.List<java.lang.String> iamRoles) {
            this.iamRoles = iamRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKmsKeyId}
         * @param kmsKeyId `AWS::Redshift::Cluster.KmsKeyId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLoggingProperties}
         * @param loggingProperties `AWS::Redshift::Cluster.LoggingProperties`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingProperties(software.amazon.awscdk.core.IResolvable loggingProperties) {
            this.loggingProperties = loggingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLoggingProperties}
         * @param loggingProperties `AWS::Redshift::Cluster.LoggingProperties`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingProperties(software.amazon.awscdk.services.redshift.CfnCluster.LoggingPropertiesProperty loggingProperties) {
            this.loggingProperties = loggingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getMaintenanceTrackName}
         * @param maintenanceTrackName `AWS::Redshift::Cluster.MaintenanceTrackName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceTrackName(java.lang.String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getManualSnapshotRetentionPeriod}
         * @param manualSnapshotRetentionPeriod `AWS::Redshift::Cluster.ManualSnapshotRetentionPeriod`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manualSnapshotRetentionPeriod(java.lang.Number manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getMasterUsername}
         * @param masterUsername `AWS::Redshift::Cluster.MasterUsername`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(java.lang.String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getMasterUserPassword}
         * @param masterUserPassword `AWS::Redshift::Cluster.MasterUserPassword`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(java.lang.String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getNodeType}
         * @param nodeType `AWS::Redshift::Cluster.NodeType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeType(java.lang.String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getNumberOfNodes}
         * @param numberOfNodes `AWS::Redshift::Cluster.NumberOfNodes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfNodes(java.lang.Number numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getOwnerAccount}
         * @param ownerAccount `AWS::Redshift::Cluster.OwnerAccount`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerAccount(java.lang.String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPort}
         * @param port `AWS::Redshift::Cluster.Port`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow `AWS::Redshift::Cluster.PreferredMaintenanceWindow`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPubliclyAccessible}
         * @param publiclyAccessible `AWS::Redshift::Cluster.PubliclyAccessible`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPubliclyAccessible}
         * @param publiclyAccessible `AWS::Redshift::Cluster.PubliclyAccessible`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(software.amazon.awscdk.core.IResolvable publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getResourceAction}
         * @param resourceAction `AWS::Redshift::Cluster.ResourceAction`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceAction(java.lang.String resourceAction) {
            this.resourceAction = resourceAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRevisionTarget}
         * @param revisionTarget `AWS::Redshift::Cluster.RevisionTarget`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revisionTarget(java.lang.String revisionTarget) {
            this.revisionTarget = revisionTarget;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRotateEncryptionKey}
         * @param rotateEncryptionKey `AWS::Redshift::Cluster.RotateEncryptionKey`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateEncryptionKey(java.lang.Boolean rotateEncryptionKey) {
            this.rotateEncryptionKey = rotateEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRotateEncryptionKey}
         * @param rotateEncryptionKey `AWS::Redshift::Cluster.RotateEncryptionKey`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateEncryptionKey(software.amazon.awscdk.core.IResolvable rotateEncryptionKey) {
            this.rotateEncryptionKey = rotateEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotClusterIdentifier}
         * @param snapshotClusterIdentifier `AWS::Redshift::Cluster.SnapshotClusterIdentifier`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotClusterIdentifier(java.lang.String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotCopyGrantName}
         * @param snapshotCopyGrantName `AWS::Redshift::Cluster.SnapshotCopyGrantName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyGrantName(java.lang.String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotCopyManual}
         * @param snapshotCopyManual `AWS::Redshift::Cluster.SnapshotCopyManual`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyManual(java.lang.Boolean snapshotCopyManual) {
            this.snapshotCopyManual = snapshotCopyManual;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotCopyManual}
         * @param snapshotCopyManual `AWS::Redshift::Cluster.SnapshotCopyManual`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyManual(software.amazon.awscdk.core.IResolvable snapshotCopyManual) {
            this.snapshotCopyManual = snapshotCopyManual;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotCopyRetentionPeriod}
         * @param snapshotCopyRetentionPeriod `AWS::Redshift::Cluster.SnapshotCopyRetentionPeriod`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyRetentionPeriod(java.lang.Number snapshotCopyRetentionPeriod) {
            this.snapshotCopyRetentionPeriod = snapshotCopyRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotIdentifier}
         * @param snapshotIdentifier `AWS::Redshift::Cluster.SnapshotIdentifier`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(java.lang.String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags `AWS::Redshift::Cluster.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getVpcSecurityGroupIds}
         * @param vpcSecurityGroupIds `AWS::Redshift::Cluster.VpcSecurityGroupIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.lang.Object allowVersionUpgrade;
        private final java.lang.String aquaConfigurationStatus;
        private final java.lang.Number automatedSnapshotRetentionPeriod;
        private final java.lang.String availabilityZone;
        private final java.lang.Object availabilityZoneRelocation;
        private final java.lang.String availabilityZoneRelocationStatus;
        private final java.lang.Object classic;
        private final java.lang.String clusterIdentifier;
        private final java.lang.String clusterParameterGroupName;
        private final java.util.List<java.lang.String> clusterSecurityGroups;
        private final java.lang.String clusterSubnetGroupName;
        private final java.lang.String clusterType;
        private final java.lang.String clusterVersion;
        private final java.lang.String dbName;
        private final java.lang.Object deferMaintenance;
        private final java.lang.Number deferMaintenanceDuration;
        private final java.lang.String deferMaintenanceEndTime;
        private final java.lang.String deferMaintenanceStartTime;
        private final java.lang.String destinationRegion;
        private final java.lang.String elasticIp;
        private final java.lang.Object encrypted;
        private final java.lang.Object enhancedVpcRouting;
        private final java.lang.String hsmClientCertificateIdentifier;
        private final java.lang.String hsmConfigurationIdentifier;
        private final java.util.List<java.lang.String> iamRoles;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object loggingProperties;
        private final java.lang.String maintenanceTrackName;
        private final java.lang.Number manualSnapshotRetentionPeriod;
        private final java.lang.String masterUsername;
        private final java.lang.String masterUserPassword;
        private final java.lang.String nodeType;
        private final java.lang.Number numberOfNodes;
        private final java.lang.String ownerAccount;
        private final java.lang.Number port;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.Object publiclyAccessible;
        private final java.lang.String resourceAction;
        private final java.lang.String revisionTarget;
        private final java.lang.Object rotateEncryptionKey;
        private final java.lang.String snapshotClusterIdentifier;
        private final java.lang.String snapshotCopyGrantName;
        private final java.lang.Object snapshotCopyManual;
        private final java.lang.Number snapshotCopyRetentionPeriod;
        private final java.lang.String snapshotIdentifier;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowVersionUpgrade = software.amazon.jsii.Kernel.get(this, "allowVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.aquaConfigurationStatus = software.amazon.jsii.Kernel.get(this, "aquaConfigurationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automatedSnapshotRetentionPeriod = software.amazon.jsii.Kernel.get(this, "automatedSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZoneRelocation = software.amazon.jsii.Kernel.get(this, "availabilityZoneRelocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZoneRelocationStatus = software.amazon.jsii.Kernel.get(this, "availabilityZoneRelocationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.classic = software.amazon.jsii.Kernel.get(this, "classic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterParameterGroupName = software.amazon.jsii.Kernel.get(this, "clusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterSecurityGroups = software.amazon.jsii.Kernel.get(this, "clusterSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.clusterSubnetGroupName = software.amazon.jsii.Kernel.get(this, "clusterSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterType = software.amazon.jsii.Kernel.get(this, "clusterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterVersion = software.amazon.jsii.Kernel.get(this, "clusterVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbName = software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deferMaintenance = software.amazon.jsii.Kernel.get(this, "deferMaintenance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deferMaintenanceDuration = software.amazon.jsii.Kernel.get(this, "deferMaintenanceDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.deferMaintenanceEndTime = software.amazon.jsii.Kernel.get(this, "deferMaintenanceEndTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deferMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "deferMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationRegion = software.amazon.jsii.Kernel.get(this, "destinationRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.elasticIp = software.amazon.jsii.Kernel.get(this, "elasticIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enhancedVpcRouting = software.amazon.jsii.Kernel.get(this, "enhancedVpcRouting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hsmClientCertificateIdentifier = software.amazon.jsii.Kernel.get(this, "hsmClientCertificateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hsmConfigurationIdentifier = software.amazon.jsii.Kernel.get(this, "hsmConfigurationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamRoles = software.amazon.jsii.Kernel.get(this, "iamRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingProperties = software.amazon.jsii.Kernel.get(this, "loggingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maintenanceTrackName = software.amazon.jsii.Kernel.get(this, "maintenanceTrackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.manualSnapshotRetentionPeriod = software.amazon.jsii.Kernel.get(this, "manualSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.masterUsername = software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserPassword = software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodeType = software.amazon.jsii.Kernel.get(this, "nodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.numberOfNodes = software.amazon.jsii.Kernel.get(this, "numberOfNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ownerAccount = software.amazon.jsii.Kernel.get(this, "ownerAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceAction = software.amazon.jsii.Kernel.get(this, "resourceAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.revisionTarget = software.amazon.jsii.Kernel.get(this, "revisionTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rotateEncryptionKey = software.amazon.jsii.Kernel.get(this, "rotateEncryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotClusterIdentifier = software.amazon.jsii.Kernel.get(this, "snapshotClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotCopyGrantName = software.amazon.jsii.Kernel.get(this, "snapshotCopyGrantName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotCopyManual = software.amazon.jsii.Kernel.get(this, "snapshotCopyManual", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotCopyRetentionPeriod = software.amazon.jsii.Kernel.get(this, "snapshotCopyRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.snapshotIdentifier = software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowVersionUpgrade = builder.allowVersionUpgrade;
            this.aquaConfigurationStatus = builder.aquaConfigurationStatus;
            this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
            this.availabilityZone = builder.availabilityZone;
            this.availabilityZoneRelocation = builder.availabilityZoneRelocation;
            this.availabilityZoneRelocationStatus = builder.availabilityZoneRelocationStatus;
            this.classic = builder.classic;
            this.clusterIdentifier = builder.clusterIdentifier;
            this.clusterParameterGroupName = builder.clusterParameterGroupName;
            this.clusterSecurityGroups = builder.clusterSecurityGroups;
            this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
            this.clusterType = java.util.Objects.requireNonNull(builder.clusterType, "clusterType is required");
            this.clusterVersion = builder.clusterVersion;
            this.dbName = java.util.Objects.requireNonNull(builder.dbName, "dbName is required");
            this.deferMaintenance = builder.deferMaintenance;
            this.deferMaintenanceDuration = builder.deferMaintenanceDuration;
            this.deferMaintenanceEndTime = builder.deferMaintenanceEndTime;
            this.deferMaintenanceStartTime = builder.deferMaintenanceStartTime;
            this.destinationRegion = builder.destinationRegion;
            this.elasticIp = builder.elasticIp;
            this.encrypted = builder.encrypted;
            this.enhancedVpcRouting = builder.enhancedVpcRouting;
            this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
            this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
            this.iamRoles = builder.iamRoles;
            this.kmsKeyId = builder.kmsKeyId;
            this.loggingProperties = builder.loggingProperties;
            this.maintenanceTrackName = builder.maintenanceTrackName;
            this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
            this.masterUsername = java.util.Objects.requireNonNull(builder.masterUsername, "masterUsername is required");
            this.masterUserPassword = java.util.Objects.requireNonNull(builder.masterUserPassword, "masterUserPassword is required");
            this.nodeType = java.util.Objects.requireNonNull(builder.nodeType, "nodeType is required");
            this.numberOfNodes = builder.numberOfNodes;
            this.ownerAccount = builder.ownerAccount;
            this.port = builder.port;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.publiclyAccessible = builder.publiclyAccessible;
            this.resourceAction = builder.resourceAction;
            this.revisionTarget = builder.revisionTarget;
            this.rotateEncryptionKey = builder.rotateEncryptionKey;
            this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
            this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
            this.snapshotCopyManual = builder.snapshotCopyManual;
            this.snapshotCopyRetentionPeriod = builder.snapshotCopyRetentionPeriod;
            this.snapshotIdentifier = builder.snapshotIdentifier;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        }

        @Override
        public final java.lang.Object getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        @Override
        public final java.lang.String getAquaConfigurationStatus() {
            return this.aquaConfigurationStatus;
        }

        @Override
        public final java.lang.Number getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getAvailabilityZoneRelocation() {
            return this.availabilityZoneRelocation;
        }

        @Override
        public final java.lang.String getAvailabilityZoneRelocationStatus() {
            return this.availabilityZoneRelocationStatus;
        }

        @Override
        public final java.lang.Object getClassic() {
            return this.classic;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.String getClusterParameterGroupName() {
            return this.clusterParameterGroupName;
        }

        @Override
        public final java.util.List<java.lang.String> getClusterSecurityGroups() {
            return this.clusterSecurityGroups;
        }

        @Override
        public final java.lang.String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final java.lang.String getClusterType() {
            return this.clusterType;
        }

        @Override
        public final java.lang.String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final java.lang.String getDbName() {
            return this.dbName;
        }

        @Override
        public final java.lang.Object getDeferMaintenance() {
            return this.deferMaintenance;
        }

        @Override
        public final java.lang.Number getDeferMaintenanceDuration() {
            return this.deferMaintenanceDuration;
        }

        @Override
        public final java.lang.String getDeferMaintenanceEndTime() {
            return this.deferMaintenanceEndTime;
        }

        @Override
        public final java.lang.String getDeferMaintenanceStartTime() {
            return this.deferMaintenanceStartTime;
        }

        @Override
        public final java.lang.String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final java.lang.String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final java.lang.Object getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final java.lang.Object getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final java.lang.String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final java.lang.String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final java.util.List<java.lang.String> getIamRoles() {
            return this.iamRoles;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getLoggingProperties() {
            return this.loggingProperties;
        }

        @Override
        public final java.lang.String getMaintenanceTrackName() {
            return this.maintenanceTrackName;
        }

        @Override
        public final java.lang.Number getManualSnapshotRetentionPeriod() {
            return this.manualSnapshotRetentionPeriod;
        }

        @Override
        public final java.lang.String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final java.lang.String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final java.lang.String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final java.lang.Number getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final java.lang.String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.Object getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final java.lang.String getResourceAction() {
            return this.resourceAction;
        }

        @Override
        public final java.lang.String getRevisionTarget() {
            return this.revisionTarget;
        }

        @Override
        public final java.lang.Object getRotateEncryptionKey() {
            return this.rotateEncryptionKey;
        }

        @Override
        public final java.lang.String getSnapshotClusterIdentifier() {
            return this.snapshotClusterIdentifier;
        }

        @Override
        public final java.lang.String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        @Override
        public final java.lang.Object getSnapshotCopyManual() {
            return this.snapshotCopyManual;
        }

        @Override
        public final java.lang.Number getSnapshotCopyRetentionPeriod() {
            return this.snapshotCopyRetentionPeriod;
        }

        @Override
        public final java.lang.String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowVersionUpgrade() != null) {
                data.set("allowVersionUpgrade", om.valueToTree(this.getAllowVersionUpgrade()));
            }
            if (this.getAquaConfigurationStatus() != null) {
                data.set("aquaConfigurationStatus", om.valueToTree(this.getAquaConfigurationStatus()));
            }
            if (this.getAutomatedSnapshotRetentionPeriod() != null) {
                data.set("automatedSnapshotRetentionPeriod", om.valueToTree(this.getAutomatedSnapshotRetentionPeriod()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getAvailabilityZoneRelocation() != null) {
                data.set("availabilityZoneRelocation", om.valueToTree(this.getAvailabilityZoneRelocation()));
            }
            if (this.getAvailabilityZoneRelocationStatus() != null) {
                data.set("availabilityZoneRelocationStatus", om.valueToTree(this.getAvailabilityZoneRelocationStatus()));
            }
            if (this.getClassic() != null) {
                data.set("classic", om.valueToTree(this.getClassic()));
            }
            if (this.getClusterIdentifier() != null) {
                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            }
            if (this.getClusterParameterGroupName() != null) {
                data.set("clusterParameterGroupName", om.valueToTree(this.getClusterParameterGroupName()));
            }
            if (this.getClusterSecurityGroups() != null) {
                data.set("clusterSecurityGroups", om.valueToTree(this.getClusterSecurityGroups()));
            }
            if (this.getClusterSubnetGroupName() != null) {
                data.set("clusterSubnetGroupName", om.valueToTree(this.getClusterSubnetGroupName()));
            }
            data.set("clusterType", om.valueToTree(this.getClusterType()));
            if (this.getClusterVersion() != null) {
                data.set("clusterVersion", om.valueToTree(this.getClusterVersion()));
            }
            data.set("dbName", om.valueToTree(this.getDbName()));
            if (this.getDeferMaintenance() != null) {
                data.set("deferMaintenance", om.valueToTree(this.getDeferMaintenance()));
            }
            if (this.getDeferMaintenanceDuration() != null) {
                data.set("deferMaintenanceDuration", om.valueToTree(this.getDeferMaintenanceDuration()));
            }
            if (this.getDeferMaintenanceEndTime() != null) {
                data.set("deferMaintenanceEndTime", om.valueToTree(this.getDeferMaintenanceEndTime()));
            }
            if (this.getDeferMaintenanceStartTime() != null) {
                data.set("deferMaintenanceStartTime", om.valueToTree(this.getDeferMaintenanceStartTime()));
            }
            if (this.getDestinationRegion() != null) {
                data.set("destinationRegion", om.valueToTree(this.getDestinationRegion()));
            }
            if (this.getElasticIp() != null) {
                data.set("elasticIp", om.valueToTree(this.getElasticIp()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getEnhancedVpcRouting() != null) {
                data.set("enhancedVpcRouting", om.valueToTree(this.getEnhancedVpcRouting()));
            }
            if (this.getHsmClientCertificateIdentifier() != null) {
                data.set("hsmClientCertificateIdentifier", om.valueToTree(this.getHsmClientCertificateIdentifier()));
            }
            if (this.getHsmConfigurationIdentifier() != null) {
                data.set("hsmConfigurationIdentifier", om.valueToTree(this.getHsmConfigurationIdentifier()));
            }
            if (this.getIamRoles() != null) {
                data.set("iamRoles", om.valueToTree(this.getIamRoles()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLoggingProperties() != null) {
                data.set("loggingProperties", om.valueToTree(this.getLoggingProperties()));
            }
            if (this.getMaintenanceTrackName() != null) {
                data.set("maintenanceTrackName", om.valueToTree(this.getMaintenanceTrackName()));
            }
            if (this.getManualSnapshotRetentionPeriod() != null) {
                data.set("manualSnapshotRetentionPeriod", om.valueToTree(this.getManualSnapshotRetentionPeriod()));
            }
            data.set("masterUsername", om.valueToTree(this.getMasterUsername()));
            data.set("masterUserPassword", om.valueToTree(this.getMasterUserPassword()));
            data.set("nodeType", om.valueToTree(this.getNodeType()));
            if (this.getNumberOfNodes() != null) {
                data.set("numberOfNodes", om.valueToTree(this.getNumberOfNodes()));
            }
            if (this.getOwnerAccount() != null) {
                data.set("ownerAccount", om.valueToTree(this.getOwnerAccount()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getResourceAction() != null) {
                data.set("resourceAction", om.valueToTree(this.getResourceAction()));
            }
            if (this.getRevisionTarget() != null) {
                data.set("revisionTarget", om.valueToTree(this.getRevisionTarget()));
            }
            if (this.getRotateEncryptionKey() != null) {
                data.set("rotateEncryptionKey", om.valueToTree(this.getRotateEncryptionKey()));
            }
            if (this.getSnapshotClusterIdentifier() != null) {
                data.set("snapshotClusterIdentifier", om.valueToTree(this.getSnapshotClusterIdentifier()));
            }
            if (this.getSnapshotCopyGrantName() != null) {
                data.set("snapshotCopyGrantName", om.valueToTree(this.getSnapshotCopyGrantName()));
            }
            if (this.getSnapshotCopyManual() != null) {
                data.set("snapshotCopyManual", om.valueToTree(this.getSnapshotCopyManual()));
            }
            if (this.getSnapshotCopyRetentionPeriod() != null) {
                data.set("snapshotCopyRetentionPeriod", om.valueToTree(this.getSnapshotCopyRetentionPeriod()));
            }
            if (this.getSnapshotIdentifier() != null) {
                data.set("snapshotIdentifier", om.valueToTree(this.getSnapshotIdentifier()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcSecurityGroupIds() != null) {
                data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (this.allowVersionUpgrade != null ? !this.allowVersionUpgrade.equals(that.allowVersionUpgrade) : that.allowVersionUpgrade != null) return false;
            if (this.aquaConfigurationStatus != null ? !this.aquaConfigurationStatus.equals(that.aquaConfigurationStatus) : that.aquaConfigurationStatus != null) return false;
            if (this.automatedSnapshotRetentionPeriod != null ? !this.automatedSnapshotRetentionPeriod.equals(that.automatedSnapshotRetentionPeriod) : that.automatedSnapshotRetentionPeriod != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.availabilityZoneRelocation != null ? !this.availabilityZoneRelocation.equals(that.availabilityZoneRelocation) : that.availabilityZoneRelocation != null) return false;
            if (this.availabilityZoneRelocationStatus != null ? !this.availabilityZoneRelocationStatus.equals(that.availabilityZoneRelocationStatus) : that.availabilityZoneRelocationStatus != null) return false;
            if (this.classic != null ? !this.classic.equals(that.classic) : that.classic != null) return false;
            if (this.clusterIdentifier != null ? !this.clusterIdentifier.equals(that.clusterIdentifier) : that.clusterIdentifier != null) return false;
            if (this.clusterParameterGroupName != null ? !this.clusterParameterGroupName.equals(that.clusterParameterGroupName) : that.clusterParameterGroupName != null) return false;
            if (this.clusterSecurityGroups != null ? !this.clusterSecurityGroups.equals(that.clusterSecurityGroups) : that.clusterSecurityGroups != null) return false;
            if (this.clusterSubnetGroupName != null ? !this.clusterSubnetGroupName.equals(that.clusterSubnetGroupName) : that.clusterSubnetGroupName != null) return false;
            if (!clusterType.equals(that.clusterType)) return false;
            if (this.clusterVersion != null ? !this.clusterVersion.equals(that.clusterVersion) : that.clusterVersion != null) return false;
            if (!dbName.equals(that.dbName)) return false;
            if (this.deferMaintenance != null ? !this.deferMaintenance.equals(that.deferMaintenance) : that.deferMaintenance != null) return false;
            if (this.deferMaintenanceDuration != null ? !this.deferMaintenanceDuration.equals(that.deferMaintenanceDuration) : that.deferMaintenanceDuration != null) return false;
            if (this.deferMaintenanceEndTime != null ? !this.deferMaintenanceEndTime.equals(that.deferMaintenanceEndTime) : that.deferMaintenanceEndTime != null) return false;
            if (this.deferMaintenanceStartTime != null ? !this.deferMaintenanceStartTime.equals(that.deferMaintenanceStartTime) : that.deferMaintenanceStartTime != null) return false;
            if (this.destinationRegion != null ? !this.destinationRegion.equals(that.destinationRegion) : that.destinationRegion != null) return false;
            if (this.elasticIp != null ? !this.elasticIp.equals(that.elasticIp) : that.elasticIp != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.enhancedVpcRouting != null ? !this.enhancedVpcRouting.equals(that.enhancedVpcRouting) : that.enhancedVpcRouting != null) return false;
            if (this.hsmClientCertificateIdentifier != null ? !this.hsmClientCertificateIdentifier.equals(that.hsmClientCertificateIdentifier) : that.hsmClientCertificateIdentifier != null) return false;
            if (this.hsmConfigurationIdentifier != null ? !this.hsmConfigurationIdentifier.equals(that.hsmConfigurationIdentifier) : that.hsmConfigurationIdentifier != null) return false;
            if (this.iamRoles != null ? !this.iamRoles.equals(that.iamRoles) : that.iamRoles != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.loggingProperties != null ? !this.loggingProperties.equals(that.loggingProperties) : that.loggingProperties != null) return false;
            if (this.maintenanceTrackName != null ? !this.maintenanceTrackName.equals(that.maintenanceTrackName) : that.maintenanceTrackName != null) return false;
            if (this.manualSnapshotRetentionPeriod != null ? !this.manualSnapshotRetentionPeriod.equals(that.manualSnapshotRetentionPeriod) : that.manualSnapshotRetentionPeriod != null) return false;
            if (!masterUsername.equals(that.masterUsername)) return false;
            if (!masterUserPassword.equals(that.masterUserPassword)) return false;
            if (!nodeType.equals(that.nodeType)) return false;
            if (this.numberOfNodes != null ? !this.numberOfNodes.equals(that.numberOfNodes) : that.numberOfNodes != null) return false;
            if (this.ownerAccount != null ? !this.ownerAccount.equals(that.ownerAccount) : that.ownerAccount != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            if (this.resourceAction != null ? !this.resourceAction.equals(that.resourceAction) : that.resourceAction != null) return false;
            if (this.revisionTarget != null ? !this.revisionTarget.equals(that.revisionTarget) : that.revisionTarget != null) return false;
            if (this.rotateEncryptionKey != null ? !this.rotateEncryptionKey.equals(that.rotateEncryptionKey) : that.rotateEncryptionKey != null) return false;
            if (this.snapshotClusterIdentifier != null ? !this.snapshotClusterIdentifier.equals(that.snapshotClusterIdentifier) : that.snapshotClusterIdentifier != null) return false;
            if (this.snapshotCopyGrantName != null ? !this.snapshotCopyGrantName.equals(that.snapshotCopyGrantName) : that.snapshotCopyGrantName != null) return false;
            if (this.snapshotCopyManual != null ? !this.snapshotCopyManual.equals(that.snapshotCopyManual) : that.snapshotCopyManual != null) return false;
            if (this.snapshotCopyRetentionPeriod != null ? !this.snapshotCopyRetentionPeriod.equals(that.snapshotCopyRetentionPeriod) : that.snapshotCopyRetentionPeriod != null) return false;
            if (this.snapshotIdentifier != null ? !this.snapshotIdentifier.equals(that.snapshotIdentifier) : that.snapshotIdentifier != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowVersionUpgrade != null ? this.allowVersionUpgrade.hashCode() : 0;
            result = 31 * result + (this.aquaConfigurationStatus != null ? this.aquaConfigurationStatus.hashCode() : 0);
            result = 31 * result + (this.automatedSnapshotRetentionPeriod != null ? this.automatedSnapshotRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.availabilityZoneRelocation != null ? this.availabilityZoneRelocation.hashCode() : 0);
            result = 31 * result + (this.availabilityZoneRelocationStatus != null ? this.availabilityZoneRelocationStatus.hashCode() : 0);
            result = 31 * result + (this.classic != null ? this.classic.hashCode() : 0);
            result = 31 * result + (this.clusterIdentifier != null ? this.clusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.clusterParameterGroupName != null ? this.clusterParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.clusterSecurityGroups != null ? this.clusterSecurityGroups.hashCode() : 0);
            result = 31 * result + (this.clusterSubnetGroupName != null ? this.clusterSubnetGroupName.hashCode() : 0);
            result = 31 * result + (this.clusterType.hashCode());
            result = 31 * result + (this.clusterVersion != null ? this.clusterVersion.hashCode() : 0);
            result = 31 * result + (this.dbName.hashCode());
            result = 31 * result + (this.deferMaintenance != null ? this.deferMaintenance.hashCode() : 0);
            result = 31 * result + (this.deferMaintenanceDuration != null ? this.deferMaintenanceDuration.hashCode() : 0);
            result = 31 * result + (this.deferMaintenanceEndTime != null ? this.deferMaintenanceEndTime.hashCode() : 0);
            result = 31 * result + (this.deferMaintenanceStartTime != null ? this.deferMaintenanceStartTime.hashCode() : 0);
            result = 31 * result + (this.destinationRegion != null ? this.destinationRegion.hashCode() : 0);
            result = 31 * result + (this.elasticIp != null ? this.elasticIp.hashCode() : 0);
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.enhancedVpcRouting != null ? this.enhancedVpcRouting.hashCode() : 0);
            result = 31 * result + (this.hsmClientCertificateIdentifier != null ? this.hsmClientCertificateIdentifier.hashCode() : 0);
            result = 31 * result + (this.hsmConfigurationIdentifier != null ? this.hsmConfigurationIdentifier.hashCode() : 0);
            result = 31 * result + (this.iamRoles != null ? this.iamRoles.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.loggingProperties != null ? this.loggingProperties.hashCode() : 0);
            result = 31 * result + (this.maintenanceTrackName != null ? this.maintenanceTrackName.hashCode() : 0);
            result = 31 * result + (this.manualSnapshotRetentionPeriod != null ? this.manualSnapshotRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.masterUsername.hashCode());
            result = 31 * result + (this.masterUserPassword.hashCode());
            result = 31 * result + (this.nodeType.hashCode());
            result = 31 * result + (this.numberOfNodes != null ? this.numberOfNodes.hashCode() : 0);
            result = 31 * result + (this.ownerAccount != null ? this.ownerAccount.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.resourceAction != null ? this.resourceAction.hashCode() : 0);
            result = 31 * result + (this.revisionTarget != null ? this.revisionTarget.hashCode() : 0);
            result = 31 * result + (this.rotateEncryptionKey != null ? this.rotateEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.snapshotClusterIdentifier != null ? this.snapshotClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.snapshotCopyGrantName != null ? this.snapshotCopyGrantName.hashCode() : 0);
            result = 31 * result + (this.snapshotCopyManual != null ? this.snapshotCopyManual.hashCode() : 0);
            result = 31 * result + (this.snapshotCopyRetentionPeriod != null ? this.snapshotCopyRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.snapshotIdentifier != null ? this.snapshotIdentifier.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
            return result;
        }
    }
}
