package software.amazon.awscdk.services.redshift;

/**
 * Properties for defining a `AWS::Redshift::EndpointAccess`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * CfnEndpointAccessProps cfnEndpointAccessProps = CfnEndpointAccessProps.builder()
 *         .endpointName("endpointName")
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         // the properties below are optional
 *         .clusterIdentifier("clusterIdentifier")
 *         .resourceOwner("resourceOwner")
 *         .subnetGroupName("subnetGroupName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:46.134Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.CfnEndpointAccessProps")
@software.amazon.jsii.Jsii.Proxy(CfnEndpointAccessProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEndpointAccessProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Redshift::EndpointAccess.ClusterIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterIdentifier() {
        return null;
    }

    /**
     * `AWS::Redshift::EndpointAccess.EndpointName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpointName();

    /**
     * `AWS::Redshift::EndpointAccess.ResourceOwner`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceOwner() {
        return null;
    }

    /**
     * `AWS::Redshift::EndpointAccess.SubnetGroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetGroupName() {
        return null;
    }

    /**
     * `AWS::Redshift::EndpointAccess.VpcSecurityGroupIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getVpcSecurityGroupIds();

    /**
     * @return a {@link Builder} of {@link CfnEndpointAccessProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEndpointAccessProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEndpointAccessProps> {
        java.lang.String clusterIdentifier;
        java.lang.String endpointName;
        java.lang.String resourceOwner;
        java.lang.String subnetGroupName;
        java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Sets the value of {@link CfnEndpointAccessProps#getClusterIdentifier}
         * @param clusterIdentifier `AWS::Redshift::EndpointAccess.ClusterIdentifier`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointAccessProps#getEndpointName}
         * @param endpointName `AWS::Redshift::EndpointAccess.EndpointName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(java.lang.String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointAccessProps#getResourceOwner}
         * @param resourceOwner `AWS::Redshift::EndpointAccess.ResourceOwner`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceOwner(java.lang.String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointAccessProps#getSubnetGroupName}
         * @param subnetGroupName `AWS::Redshift::EndpointAccess.SubnetGroupName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroupName(java.lang.String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointAccessProps#getVpcSecurityGroupIds}
         * @param vpcSecurityGroupIds `AWS::Redshift::EndpointAccess.VpcSecurityGroupIds`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointAccessProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEndpointAccessProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEndpointAccessProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointAccessProps {
        private final java.lang.String clusterIdentifier;
        private final java.lang.String endpointName;
        private final java.lang.String resourceOwner;
        private final java.lang.String subnetGroupName;
        private final java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceOwner = software.amazon.jsii.Kernel.get(this, "resourceOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetGroupName = software.amazon.jsii.Kernel.get(this, "subnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterIdentifier = builder.clusterIdentifier;
            this.endpointName = java.util.Objects.requireNonNull(builder.endpointName, "endpointName is required");
            this.resourceOwner = builder.resourceOwner;
            this.subnetGroupName = builder.subnetGroupName;
            this.vpcSecurityGroupIds = java.util.Objects.requireNonNull(builder.vpcSecurityGroupIds, "vpcSecurityGroupIds is required");
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final java.lang.String getResourceOwner() {
            return this.resourceOwner;
        }

        @Override
        public final java.lang.String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClusterIdentifier() != null) {
                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            }
            data.set("endpointName", om.valueToTree(this.getEndpointName()));
            if (this.getResourceOwner() != null) {
                data.set("resourceOwner", om.valueToTree(this.getResourceOwner()));
            }
            if (this.getSubnetGroupName() != null) {
                data.set("subnetGroupName", om.valueToTree(this.getSubnetGroupName()));
            }
            data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift.CfnEndpointAccessProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointAccessProps.Jsii$Proxy that = (CfnEndpointAccessProps.Jsii$Proxy) o;

            if (this.clusterIdentifier != null ? !this.clusterIdentifier.equals(that.clusterIdentifier) : that.clusterIdentifier != null) return false;
            if (!endpointName.equals(that.endpointName)) return false;
            if (this.resourceOwner != null ? !this.resourceOwner.equals(that.resourceOwner) : that.resourceOwner != null) return false;
            if (this.subnetGroupName != null ? !this.subnetGroupName.equals(that.subnetGroupName) : that.subnetGroupName != null) return false;
            return this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds);
        }

        @Override
        public final int hashCode() {
            int result = this.clusterIdentifier != null ? this.clusterIdentifier.hashCode() : 0;
            result = 31 * result + (this.endpointName.hashCode());
            result = 31 * result + (this.resourceOwner != null ? this.resourceOwner.hashCode() : 0);
            result = 31 * result + (this.subnetGroupName != null ? this.subnetGroupName.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroupIds.hashCode());
            return result;
        }
    }
}
