package software.amazon.awscdk.services.redshift;

/**
 * (experimental) A column in a Redshift table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * Column column = Column.builder()
 *         .dataType("dataType")
 *         .name("name")
 *         // the properties below are optional
 *         .distKey(false)
 *         .sortKey(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:01.932Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.Column")
@software.amazon.jsii.Jsii.Proxy(Column.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Column extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The data type of the column.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDataType();

    /**
     * (experimental) Boolean value that indicates whether the column is to be configured as DISTKEY.
     * <p>
     * Default: - column is not DISTKEY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDistKey() {
        return null;
    }

    /**
     * (experimental) The name of the column.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * (experimental) Boolean value that indicates whether the column is to be configured as SORTKEY.
     * <p>
     * Default: - column is not a SORTKEY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSortKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Column}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Column}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Column> {
        java.lang.String dataType;
        java.lang.Boolean distKey;
        java.lang.String name;
        java.lang.Boolean sortKey;

        /**
         * Sets the value of {@link Column#getDataType}
         * @param dataType The data type of the column. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataType(java.lang.String dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Sets the value of {@link Column#getDistKey}
         * @param distKey Boolean value that indicates whether the column is to be configured as DISTKEY.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder distKey(java.lang.Boolean distKey) {
            this.distKey = distKey;
            return this;
        }

        /**
         * Sets the value of {@link Column#getName}
         * @param name The name of the column. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link Column#getSortKey}
         * @param sortKey Boolean value that indicates whether the column is to be configured as SORTKEY.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sortKey(java.lang.Boolean sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Column}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Column build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Column}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Column {
        private final java.lang.String dataType;
        private final java.lang.Boolean distKey;
        private final java.lang.String name;
        private final java.lang.Boolean sortKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distKey = software.amazon.jsii.Kernel.get(this, "distKey", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sortKey = software.amazon.jsii.Kernel.get(this, "sortKey", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataType = java.util.Objects.requireNonNull(builder.dataType, "dataType is required");
            this.distKey = builder.distKey;
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.sortKey = builder.sortKey;
        }

        @Override
        public final java.lang.String getDataType() {
            return this.dataType;
        }

        @Override
        public final java.lang.Boolean getDistKey() {
            return this.distKey;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Boolean getSortKey() {
            return this.sortKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataType", om.valueToTree(this.getDataType()));
            if (this.getDistKey() != null) {
                data.set("distKey", om.valueToTree(this.getDistKey()));
            }
            data.set("name", om.valueToTree(this.getName()));
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift.Column"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Column.Jsii$Proxy that = (Column.Jsii$Proxy) o;

            if (!dataType.equals(that.dataType)) return false;
            if (this.distKey != null ? !this.distKey.equals(that.distKey) : that.distKey != null) return false;
            if (!name.equals(that.name)) return false;
            return this.sortKey != null ? this.sortKey.equals(that.sortKey) : that.sortKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataType.hashCode();
            result = 31 * result + (this.distKey != null ? this.distKey.hashCode() : 0);
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            return result;
        }
    }
}
