package software.amazon.awscdk.services.redshift;

/**
 * Properties for defining a `AWS::Redshift::ClusterSubnetGroup`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersubnetgroup.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:26:16.431Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnClusterSubnetGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Redshift::ClusterSubnetGroup.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersubnetgroup.html#cfn-redshift-clustersubnetgroup-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * `AWS::Redshift::ClusterSubnetGroup.SubnetIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersubnetgroup.html#cfn-redshift-clustersubnetgroup-subnetids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getSubnetIds();

    /**
     * `AWS::Redshift::ClusterSubnetGroup.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersubnetgroup.html#cfn-redshift-clustersubnetgroup-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnClusterSubnetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterSubnetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String description;
        private java.util.List<java.lang.String> subnetIds;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of Description
         * @param description `AWS::Redshift::ClusterSubnetGroup.Description`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of SubnetIds
         * @param subnetIds `AWS::Redshift::ClusterSubnetGroup.SubnetIds`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::Redshift::ClusterSubnetGroup.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterSubnetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnClusterSubnetGroupProps build() {
            return new Jsii$Proxy(description, subnetIds, tags);
        }
    }

    /**
     * An implementation for {@link CfnClusterSubnetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterSubnetGroupProps {
        private final java.lang.String description;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.subnetIds = this.jsiiGet("subnetIds", java.util.List.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String description, java.util.List<java.lang.String> subnetIds, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(description, "description is required");
            this.subnetIds = java.util.Objects.requireNonNull(subnetIds, "subnetIds is required");
            this.tags = tags;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("description", om.valueToTree(this.getDescription()));
            obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterSubnetGroupProps.Jsii$Proxy that = (CfnClusterSubnetGroupProps.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!subnetIds.equals(that.subnetIds)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.subnetIds.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
